/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.mission.TransportMission;
import org.w3c.dom.Element;

public class AIGoods
extends AIObject
implements Transportable {
    private static final Logger logger = Logger.getLogger(AIGoods.class.getName());
    public static final int IMPORTANT_DELIVERY = 110;
    public static final int FULL_DELIVERY = 100;
    public static final int TOOLS_FOR_COLONY_PRIORITY = 10;
    public static final int TOOLS_FOR_IMPROVEMENT = 10;
    public static final int TOOLS_FOR_PIONEER = 90;
    public static final int TOOLS_FOR_BUILDING = 100;
    private Goods goods;
    private Location destination;
    private int transportPriority;
    private AIUnit transport = null;

    public AIGoods(AIMain aiMain, Location location, GoodsType type, int amount, Location destination) {
        super(aiMain, AIGoods.getXMLElementTagName() + ":" + aiMain.getNextID());
        this.goods = new Goods(aiMain.getGame(), location, type, amount);
        this.destination = destination;
    }

    public AIGoods(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public AIGoods(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public AIGoods(AIMain aiMain, String id) {
        super(aiMain, id);
        this.uninitialized = true;
    }

    public void abortWish(Wish w) {
        if (this.destination == w.getDestination()) {
            this.destination = null;
        }
        if (w.getTransportable() == this) {
            w.dispose();
        }
    }

    public Location getTransportSource() {
        return this.goods.getLocation();
    }

    public Location getTransportDestination() {
        return this.destination;
    }

    public Locatable getTransportLocatable() {
        return this.getGoods();
    }

    public int getTransportPriority() {
        if (this.goods.getAmount() <= 100) {
            return this.goods.getAmount();
        }
        return this.transportPriority;
    }

    public void increaseTransportPriority() {
        ++this.transportPriority;
    }

    public AIUnit getTransport() {
        return this.transport;
    }

    public void dispose() {
        this.setTransport(null);
        if (this.destination != null) {
            if (this.destination instanceof Colony) {
                this.getAIMain().getAIColony((Colony)this.destination).removeAIGoods(this);
            } else if (!(this.destination instanceof Europe)) {
                logger.warning("Unknown type of destination: " + this.destination);
            }
        }
        super.dispose();
    }

    public void setTransport(AIUnit transport) {
        TransportMission tm;
        AIUnit oldTransport = this.transport;
        this.transport = transport;
        if (oldTransport != null && oldTransport.getMission() != null && oldTransport.getMission() instanceof TransportMission && (tm = (TransportMission)oldTransport.getMission()).isOnTransportList(this)) {
            tm.removeFromTransportList(this);
        }
        if (transport != null && transport.getMission() instanceof TransportMission && !((TransportMission)transport.getMission()).isOnTransportList(this)) {
            ((TransportMission)transport.getMission()).addToTransportList(this);
        }
    }

    public void setTransportPriority(int transportPriority) {
        this.transportPriority = transportPriority;
    }

    public Goods getGoods() {
        return this.goods;
    }

    public void setGoods(Goods goods) {
        if (goods == null) {
            throw new NullPointerException();
        }
        this.goods = goods;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIGoods.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        if (this.destination != null) {
            out.writeAttribute("destination", this.destination.getId());
        }
        out.writeAttribute("transportPriority", Integer.toString(this.transportPriority));
        if (this.transport != null) {
            if (this.getAIMain().getAIObject(this.transport.getId()) == null) {
                logger.warning("broken reference to transport");
            } else if (this.transport.getMission() != null && this.transport.getMission() instanceof TransportMission && !((TransportMission)this.transport.getMission()).isOnTransportList(this)) {
                logger.warning("We should not be on the transport list.");
            } else {
                out.writeAttribute("transport", this.transport.getId());
            }
        }
        this.goods.toXML(out);
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        String destinationStr = in.getAttributeValue(null, "destination");
        if (destinationStr != null) {
            this.destination = (Location)((Object)this.getAIMain().getFreeColGameObject(destinationStr));
            if (this.destination == null) {
                logger.warning("Could not find destination: " + destinationStr);
            }
        } else {
            this.destination = null;
        }
        this.transportPriority = Integer.parseInt(in.getAttributeValue(null, "transportPriority"));
        String transportStr = in.getAttributeValue(null, "transport");
        if (transportStr != null) {
            this.transport = (AIUnit)this.getAIMain().getAIObject(transportStr);
            if (this.transport == null) {
                this.transport = new AIUnit(this.getAIMain(), transportStr);
            }
        } else {
            this.transport = null;
        }
        in.nextTag();
        if (this.goods != null) {
            this.goods.readFromXML(in);
        } else {
            this.goods = new Goods(this.getAIMain().getGame(), in);
        }
        in.nextTag();
    }

    public String toString() {
        return "AIGoods@" + this.hashCode() + "[ " + this.goods + " /" + this.transportPriority + "]";
    }

    public static String getXMLElementTagName() {
        return "aiGoods";
    }
}

