/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.ColonyProfile;
import net.sf.freecol.server.ai.WorkLocationPlan;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonyPlan {
    private static final Logger logger = Logger.getLogger(ColonyPlan.class.getName());
    public static final int DOCKS_PRIORITY = 10;
    public static final int ARTILLERY_PRIORITY = 10;
    public static final int CHURCH_PRIORITY = 15;
    public static final int WAGON_TRAIN_PRIORITY = 20;
    public static final int SCHOOL_PRIORITY = 30;
    public static final int UPGRADE_PRIORITY = 50;
    public static final int CUSTOMS_HOUSE_PRIORITY = 60;
    public static final int TOWN_HALL_PRIORITY = 75;
    public static final int WAREHOUSE_PRIORITY = 90;
    public static final int BUILDING_PRIORITY = 120;
    private static final int MAX_LEVEL = 3;
    private static final int MIN_RAW_GOODS_THRESHOLD = 20;
    private Colony colony;
    private AIMain aiMain;
    private ArrayList<WorkLocationPlan> workLocationPlans = new ArrayList();
    private GoodsType primaryRawMaterial = null;
    private GoodsType secondaryRawMaterial = null;
    private ColonyProfile profile;

    public ColonyPlan(AIMain aiMain, Colony colony) {
        if (colony == null) {
            throw new IllegalArgumentException("Parameter 'colony' must not be 'null'.");
        }
        this.aiMain = aiMain;
        this.colony = colony;
        this.selectProfile();
    }

    public ColonyPlan(AIMain aiMain, Element element) {
        this.aiMain = aiMain;
        this.readFromXMLElement(element);
    }

    public List<WorkLocationPlan> getWorkLocationPlans() {
        return new ArrayList<WorkLocationPlan>(this.workLocationPlans);
    }

    public List<WorkLocationPlan> getSortedWorkLocationPlans() {
        List<WorkLocationPlan> workLocationPlans = this.getWorkLocationPlans();
        Collections.sort(workLocationPlans);
        return workLocationPlans;
    }

    public final ColonyProfile getProfile() {
        return this.profile;
    }

    public final void setProfile(ColonyProfile newProfile) {
        this.profile = newProfile;
    }

    public Iterator<BuildableType> getBuildable() {
        if (this.profile.getType() == ColonyProfile.ProfileType.OUTPOST) {
            List result = Collections.emptyList();
            return result.iterator();
        }
        ArrayList<Buildable> buildables = new ArrayList<Buildable>();
        ArrayList<BuildingType> docks = new ArrayList<BuildingType>();
        ArrayList<BuildingType> customs = new ArrayList<BuildingType>();
        ArrayList<BuildingType> builders = new ArrayList<BuildingType>();
        ArrayList<BuildingType> defence = new ArrayList<BuildingType>();
        ArrayList<BuildingType> military = new ArrayList<BuildingType>();
        ArrayList<BuildingType> schools = new ArrayList<BuildingType>();
        ArrayList<BuildingType> churches = new ArrayList<BuildingType>();
        ArrayList<BuildingType> townHalls = new ArrayList<BuildingType>();
        for (BuildingType type : this.colony.getSpecification().getBuildingTypeList()) {
            if (type.hasAbility("model.ability.produceInWater")) {
                docks.add(type);
            }
            if (type.hasAbility("model.ability.export")) {
                customs.add(type);
            }
            if (type.hasAbility("model.ability.teach")) {
                schools.add(type);
            }
            if (!type.getModifierSet("model.modifier.defence").isEmpty()) {
                defence.add(type);
            }
            if (type.getProducedGoodsType() == null) continue;
            GoodsType output = type.getProducedGoodsType();
            if (output.isBuildingMaterial()) {
                builders.add(type);
            }
            if (output.isMilitaryGoods()) {
                military.add(type);
            }
            if (output.isLibertyType()) {
                townHalls.add(type);
            }
            if (!output.isImmigrationType()) continue;
            churches.add(type);
        }
        ArrayList<UnitType> buildableDefenders = new ArrayList<UnitType>();
        UnitType bestWagon = null;
        for (UnitType unitType : this.colony.getSpecification().getUnitTypeList()) {
            if (unitType.hasAbility("model.ability.navalUnit") || !this.colony.canBuild(unitType)) continue;
            if (unitType.getDefence() > 1 && !unitType.getGoodsRequired().isEmpty()) {
                buildableDefenders.add(unitType);
            }
            if (!unitType.hasAbility("model.ability.carryGoods") || unitType.hasAbility("model.ability.navalUnit") || bestWagon != null && unitType.getSpace() <= bestWagon.getSpace()) continue;
            bestWagon = unitType;
        }
        int wagonTrains = 0;
        for (Unit unit : this.colony.getOwner().getUnits()) {
            if (!unit.hasAbility("model.ability.carryGoods") || unit.isNaval()) continue;
            ++wagonTrains;
        }
        if (!this.colony.isConnected() && bestWagon != null) {
            int disconnectedColonies = 0;
            for (Colony otherColony : this.colony.getOwner().getColonies()) {
                if (otherColony.isConnected()) continue;
                ++disconnectedColonies;
            }
            if (disconnectedColonies > wagonTrains) {
                buildables.add(new Buildable(bestWagon, 20 * (disconnectedColonies - wagonTrains)));
            }
        }
        if (!this.colony.hasAbility("model.ability.produceInWater")) {
            int potential = 0;
            block4: for (ColonyTile colonyTile : this.colony.getColonyTiles()) {
                Tile tile = colonyTile.getWorkTile();
                if (tile.isLand()) continue;
                for (AbstractGoods goods : tile.getSortedPotential()) {
                    if (!goods.getType().isFoodType()) continue;
                    potential += goods.getAmount();
                    continue block4;
                }
            }
            for (BuildingType buildingType : docks) {
                if (!this.colony.canBuild(buildingType)) continue;
                buildables.add(new Buildable(buildingType, potential * 10));
                break;
            }
        }
        for (WorkLocationPlan wlp : this.getSortedWorkLocationPlans()) {
            GoodsType outputType;
            if (!(wlp.getWorkLocation() instanceof Building)) continue;
            Building b = (Building)wlp.getWorkLocation();
            if (b.canBuildNext()) {
                buildables.add(new Buildable(b.getType().getUpgradesTo(), 50));
            }
            if ((outputType = b.getGoodsOutputType()) == null) continue;
            for (BuildingType otherType : this.colony.getSpecification().getBuildingTypeList()) {
                if (otherType.getModifierSet(outputType.getId()).isEmpty() || !this.colony.canBuild(otherType)) continue;
                int priority = this.colony.getBuilding(otherType) == null ? 100 : 50;
                buildables.add(new Buildable(otherType, priority));
            }
        }
        if (!this.colony.hasAbility("model.ability.export")) {
            for (BuildingType buildingType : customs) {
                if (!this.colony.canBuild(buildingType)) continue;
                buildables.add(new Buildable(buildingType, 60));
                break;
            }
        }
        for (BuildingType buildingType : builders) {
            if (!this.colony.canBuild(buildingType)) continue;
            int priority = 120;
            if (buildingType.getProducedGoodsType() != null && buildingType.getProducedGoodsType().isMilitaryGoods()) {
                priority /= 2;
            }
            buildables.add(new Buildable(buildingType, priority));
        }
        Building building = this.colony.getWarehouse();
        if (building.canBuildNext()) {
            int priority = this.colony.getGoodsContainer().hasReachedCapacity(this.colony.getWarehouseCapacity()) ? 180 : 90;
            buildables.add(new Buildable(building.getType().getUpgradesTo(), priority));
        } else if (bestWagon != null && wagonTrains < 4 * this.colony.getOwner().getColonies().size()) {
            buildables.add(new Buildable(bestWagon, 20));
        }
        for (BuildingType buildingType : defence) {
            if (!this.colony.canBuild(buildingType)) continue;
            int priority = this.colony.getBuilding(buildingType) == null || this.profile.getType() == ColonyProfile.ProfileType.LARGE || this.profile.getType() == ColonyProfile.ProfileType.CAPITAL ? 100 : 50;
            buildables.add(new Buildable(buildingType, priority));
        }
        for (BuildingType buildingType : military) {
            if (!this.colony.canBuild(buildingType)) continue;
            if (this.colony.getBuilding(buildingType) == null && (buildingType.getConsumedGoodsType() == null || buildingType.getConsumedGoodsType().isFarmed())) {
                buildables.add(new Buildable(buildingType, 50));
                continue;
            }
            buildables.add(new Buildable(buildingType, 25));
        }
        if (this.aiMain.getAIColony(this.colony).isBadlyDefended()) {
            for (UnitType unitType : buildableDefenders) {
                if (!this.colony.canBuild(unitType)) continue;
                int priority = this.profile.getType() == ColonyProfile.ProfileType.LARGE || this.profile.getType() == ColonyProfile.ProfileType.CAPITAL ? 20 : 10;
                buildables.add(new Buildable(unitType, priority));
                break;
            }
        }
        if (this.profile.getType() != ColonyProfile.ProfileType.SMALL) {
            for (BuildingType buildingType : schools) {
                if (!this.colony.canBuild(buildingType)) continue;
                int priority = 30;
                if (this.colony.getBuilding(buildingType) != null) {
                    if (this.profile.getType() == ColonyProfile.ProfileType.MEDIUM) {
                        priority /= 2;
                    }
                    if (buildingType.getUpgradesTo() == null && this.profile.getType() != ColonyProfile.ProfileType.CAPITAL) continue;
                }
                buildables.add(new Buildable(buildingType, priority));
            }
        }
        for (BuildingType buildingType : townHalls) {
            if (!this.colony.canBuild(buildingType)) continue;
            int priority = this.colony.getBuilding(buildingType) == null ? 150 : 75;
            buildables.add(new Buildable(buildingType, priority));
        }
        for (BuildingType buildingType : churches) {
            if (!this.colony.canBuild(buildingType)) continue;
            int priority = this.colony.getBuilding(buildingType) == null ? 30 : 15;
            buildables.add(new Buildable(buildingType, priority));
        }
        Collections.sort(buildables);
        ArrayList<BuildableType> result = new ArrayList<BuildableType>();
        HashSet<BuildableType> found = new HashSet<BuildableType>();
        for (Buildable buildable : buildables) {
            if (found.contains(buildable.type)) continue;
            result.add(buildable.type);
            found.add(buildable.type);
        }
        return result.iterator();
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public Game getGame() {
        return this.aiMain.getGame();
    }

    public void create() {
        Tile t;
        WorkLocationPlan wlp;
        Iterator<WorkLocationPlan> wlpIterator2;
        WorkLocationPlan wlp2;
        WorkLocationPlan wlp3;
        boolean buildingRawMatReq;
        this.workLocationPlans.clear();
        if (this.profile.getType() == ColonyProfile.ProfileType.OUTPOST) {
            ColonyTile productionTile;
            GoodsType goodsType = this.profile.getPreferredProduction().get(0);
            if (goodsType != null && (productionTile = this.getBestTileToProduce(goodsType)) != null) {
                this.workLocationPlans.add(new WorkLocationPlan(this.getAIMain(), productionTile, goodsType));
            }
            return;
        }
        GoodsType bells = this.colony.getSpecification().getGoodsType("model.goods.bells");
        GoodsType food = this.colony.getSpecification().getGoodsType("model.goods.grain");
        GoodsType lumber = this.colony.getSpecification().getGoodsType("model.goods.lumber");
        GoodsType muskets = this.colony.getSpecification().getGoodsType("model.goods.muskets");
        GoodsType ore = this.colony.getSpecification().getGoodsType("model.goods.ore");
        GoodsType silver = this.colony.getSpecification().getGoodsType("model.goods.silver");
        Building townHall = this.colony.getBuildingForProducing(bells);
        for (ColonyTile ct : this.colony.getColonyTiles()) {
            GoodsType goodsType;
            if (ct.isColonyCenterTile() || ct.getWorkTile().getOwningSettlement() != null && ct.getWorkTile().getOwningSettlement() != this.colony || (goodsType = this.getBestGoodsToProduce(ct.getWorkTile())) == null) continue;
            WorkLocationPlan wlp4 = new WorkLocationPlan(this.getAIMain(), ct, goodsType);
            this.workLocationPlans.add(wlp4);
        }
        GoodsType buildingReq = null;
        GoodsType buildingRawMat = null;
        Building buildingReqProducer = null;
        GoodsType hammersType = this.colony.getSpecification().getGoodsType("model.goods.hammers");
        GoodsType lumberType = this.colony.getSpecification().getGoodsType("model.goods.lumber");
        GoodsType oreType = this.colony.getSpecification().getGoodsType("model.goods.ore");
        buildingReq = this.getBuildingReqGoods();
        if (buildingReq != null) {
            buildingRawMat = buildingReq == hammersType ? lumberType : oreType;
            buildingReqProducer = this.colony.getBuildingForProducing(buildingReq);
        }
        boolean bl = buildingRawMatReq = buildingRawMat != null && this.colony.getGoodsCount(buildingRawMat) < 20 && this.getProductionOf(buildingRawMat) <= 0;
        if (buildingRawMatReq) {
            WorkLocationPlan bestChoice = null;
            int highestPotential = 0;
            for (WorkLocationPlan wlp5 : this.workLocationPlans) {
                if (!(wlp5.getWorkLocation() instanceof ColonyTile) || ((ColonyTile)wlp5.getWorkLocation()).getWorkTile().potential(buildingRawMat, null) <= highestPotential) continue;
                highestPotential = ((ColonyTile)wlp5.getWorkLocation()).getWorkTile().potential(buildingRawMat, null);
                bestChoice = wlp5;
            }
            if (highestPotential > 0) {
                assert (bestChoice != null);
                bestChoice.setGoodsType(buildingRawMat);
            }
        }
        this.primaryRawMaterial = null;
        this.secondaryRawMaterial = null;
        int primaryRawMaterialProduction = 0;
        int secondaryRawMaterialProduction = 0;
        List<GoodsType> goodsTypeList = this.colony.getSpecification().getGoodsTypeList();
        for (GoodsType goodsType : goodsTypeList) {
            if (goodsType.getProducedMaterial() == null && !goodsType.isFoodType() || goodsType.getProducedMaterial() == hammersType) continue;
            if (this.getProductionOf(goodsType) > primaryRawMaterialProduction) {
                this.secondaryRawMaterial = this.primaryRawMaterial;
                secondaryRawMaterialProduction = primaryRawMaterialProduction;
                this.primaryRawMaterial = goodsType;
                primaryRawMaterialProduction = this.getProductionOf(goodsType);
                continue;
            }
            if (this.getProductionOf(goodsType) <= secondaryRawMaterialProduction) continue;
            this.secondaryRawMaterial = goodsType;
            secondaryRawMaterialProduction = this.getProductionOf(goodsType);
        }
        Iterator<WorkLocationPlan> wlpIterator = this.workLocationPlans.iterator();
        while (wlpIterator.hasNext()) {
            wlp3 = wlpIterator.next();
            if (!(wlp3.getWorkLocation() instanceof ColonyTile) || wlp3.getGoodsType() == this.primaryRawMaterial || wlp3.getGoodsType() == this.secondaryRawMaterial || wlp3.getGoodsType() == lumber || wlp3.getGoodsType() == ore || wlp3.getGoodsType() == silver) continue;
            if (((ColonyTile)wlp3.getWorkLocation()).getWorkTile().potential(food, null) <= 2) {
                if (wlp3.getGoodsType() == null) {
                    wlpIterator.remove();
                    continue;
                }
                if (wlp3.getProductionOf(wlp3.getGoodsType()) > 2) continue;
                wlpIterator.remove();
                continue;
            }
            wlp3.setGoodsType(food);
        }
        if (buildingReq != null && (this.getProductionOf(buildingRawMat) > 0 || this.colony.getGoodsCount(buildingRawMat) > 0)) {
            wlp3 = new WorkLocationPlan(this.getAIMain(), this.colony.getBuildingForProducing(buildingReq), buildingReq);
            this.workLocationPlans.add(wlp3);
        }
        WorkLocationPlan townHallWlp = new WorkLocationPlan(this.getAIMain(), townHall, bells);
        this.workLocationPlans.add(townHallWlp);
        if (this.primaryRawMaterial != null) {
            GoodsType producedGoods = this.primaryRawMaterial.getProducedMaterial();
            Building b = this.colony.getBuildingForProducing(producedGoods);
            if (producedGoods != null && b != null) {
                wlp2 = new WorkLocationPlan(this.getAIMain(), b, producedGoods);
                this.workLocationPlans.add(wlp2);
            }
        }
        if (this.secondaryRawMaterial != null && this.needsFood() && this.secondaryRawMaterial.isNewWorldGoodsType()) {
            wlpIterator2 = this.workLocationPlans.iterator();
            while (wlpIterator2.hasNext()) {
                wlp = wlpIterator2.next();
                if (!(wlp.getWorkLocation() instanceof ColonyTile) || wlp.getGoodsType() != this.secondaryRawMaterial) continue;
                t = ((ColonyTile)wlp.getWorkLocation()).getWorkTile();
                if (t.getMaximumPotential(food, null) > 2) {
                    wlp.setGoodsType(food);
                    continue;
                }
                wlpIterator2.remove();
            }
        }
        if (this.needsFood()) {
            wlpIterator2 = this.workLocationPlans.iterator();
            while (wlpIterator2.hasNext() && this.needsFood()) {
                wlp = wlpIterator2.next();
                if (!(wlp.getWorkLocation() instanceof ColonyTile) || wlp.getGoodsType() != this.primaryRawMaterial) continue;
                t = ((ColonyTile)wlp.getWorkLocation()).getWorkTile();
                if (t.getMaximumPotential(food, null) > 2) {
                    wlp.setGoodsType(food);
                    continue;
                }
                wlpIterator2.remove();
            }
        }
        if (this.needsFood()) {
            wlpIterator2 = this.workLocationPlans.iterator();
            while (wlpIterator2.hasNext() && this.needsFood()) {
                Building b;
                wlp = wlpIterator2.next();
                if (!(wlp.getWorkLocation() instanceof Building) || (b = (Building)wlp.getWorkLocation()) == buildingReqProducer || b == townHall) continue;
                wlpIterator2.remove();
            }
        }
        GoodsType buildMatToGo = buildingReq;
        if (this.colony.getGoodsCount(buildingRawMat) > 0) {
            buildMatToGo = buildingRawMat;
        }
        if (this.needsFood()) {
            Iterator<WorkLocationPlan> wlpIterator22 = this.workLocationPlans.iterator();
            while (wlpIterator22.hasNext() && this.needsFood()) {
                wlp2 = wlpIterator22.next();
                if (!(wlp2.getWorkLocation() instanceof ColonyTile) || wlp2.getGoodsType() != buildMatToGo) continue;
                wlpIterator22.remove();
            }
            if (this.needsFood()) {
                buildMatToGo = buildMatToGo == buildingRawMat ? buildingReq : buildingRawMat;
                wlpIterator22 = this.workLocationPlans.iterator();
                while (wlpIterator22.hasNext() && this.needsFood()) {
                    wlp2 = wlpIterator22.next();
                    if (!(wlp2.getWorkLocation() instanceof ColonyTile) || wlp2.getGoodsType() != buildMatToGo) continue;
                    wlpIterator22.remove();
                }
            }
        }
        if (this.getFoodProduction() < this.getNextFoodConsumption()) {
            return;
        }
        int primaryWorkers = 1;
        int secondaryWorkers = 0;
        int builders = 1;
        int gunsmiths = 0;
        boolean colonistAdded = true;
        while (colonistAdded) {
            Building b;
            WorkLocationPlan wlp6;
            Building b2;
            GoodsType producedGoods;
            boolean blacksmithAdded = false;
            if (this.getFoodProduction() >= this.getNextFoodConsumption() && this.secondaryRawMaterial != null && 12 * secondaryWorkers + 6 <= this.getProductionOf(this.secondaryRawMaterial) && secondaryWorkers <= 3) {
                producedGoods = this.secondaryRawMaterial.getProducedMaterial();
                b2 = this.colony.getBuildingForProducing(producedGoods);
                if (producedGoods != null && b2 != null) {
                    wlp6 = new WorkLocationPlan(this.getAIMain(), b2, producedGoods);
                    this.workLocationPlans.add(wlp6);
                    colonistAdded = true;
                    ++secondaryWorkers;
                    if (this.secondaryRawMaterial == ore) {
                        blacksmithAdded = true;
                    }
                }
            }
            if (this.getFoodProduction() >= this.getNextFoodConsumption() && this.primaryRawMaterial != null && 12 * primaryWorkers + 6 <= this.getProductionOf(this.primaryRawMaterial) && primaryWorkers <= 3) {
                producedGoods = this.primaryRawMaterial.getProducedMaterial();
                b2 = this.colony.getBuildingForProducing(producedGoods);
                if (producedGoods != null && b2 != null) {
                    wlp6 = new WorkLocationPlan(this.getAIMain(), b2, producedGoods);
                    this.workLocationPlans.add(wlp6);
                    colonistAdded = true;
                    ++primaryWorkers;
                    if (this.primaryRawMaterial == ore) {
                        blacksmithAdded = true;
                    }
                }
            }
            if (blacksmithAdded && this.getFoodProduction() >= this.getNextFoodConsumption() && gunsmiths < 3 && (b = this.colony.getBuildingForProducing(muskets)) != null) {
                WorkLocationPlan wlp7 = new WorkLocationPlan(this.getAIMain(), b, muskets);
                this.workLocationPlans.add(wlp7);
                colonistAdded = true;
                ++gunsmiths;
            }
            if (this.getFoodProduction() >= this.getNextFoodConsumption() && buildingReq != null && buildingReqProducer != null && buildingReqProducer.getProduction() * builders <= this.getProductionOf(buildingRawMat) && buildingReqProducer.getUnitCapacity() < builders) {
                WorkLocationPlan wlp8 = new WorkLocationPlan(this.getAIMain(), buildingReqProducer, buildingReq);
                this.workLocationPlans.add(wlp8);
                colonistAdded = true;
                ++builders;
            }
            colonistAdded = false;
        }
    }

    private int getFoodConsumption() {
        return this.workLocationPlans.size() * this.colony.getOwner().getMaximumFoodConsumption();
    }

    private int getNextFoodConsumption() {
        return (this.workLocationPlans.size() + 1) * this.colony.getOwner().getMaximumFoodConsumption();
    }

    private boolean needsFood() {
        return this.getFoodProduction() < this.getFoodConsumption();
    }

    public int getProductionOf(GoodsType goodsType) {
        int amount = 0;
        for (WorkLocationPlan wlp : this.getWorkLocationPlans()) {
            amount += wlp.getProductionOf(goodsType);
        }
        if (this.colony.getTile().getType().isPrimaryGoodsType(goodsType) || this.colony.getTile().getType().isSecondaryGoodsType(goodsType)) {
            amount += this.colony.getTile().getMaximumPotential(goodsType, null);
        }
        return amount;
    }

    public int getFoodProduction() {
        int amount = 0;
        for (GoodsType foodType : this.colony.getSpecification().getFoodGoodsTypeList()) {
            amount += this.getProductionOf(foodType);
        }
        return amount;
    }

    private GoodsType getBestGoodsToProduce(Tile t) {
        if (t.hasResource()) {
            return t.getTileItemContainer().getResource().getBestGoodsType();
        }
        List<AbstractGoods> sortedPotentials = t.getSortedPotential();
        if (sortedPotentials.isEmpty()) {
            return null;
        }
        return sortedPotentials.get(0).getType();
    }

    private ColonyTile getBestTileToProduce(GoodsType goodsType) {
        int bestProduction = -1;
        ColonyTile bestTile = null;
        for (ColonyTile ct : this.colony.getColonyTiles()) {
            Tile tile = ct.getWorkTile();
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement() != this.colony || ct.isColonyCenterTile()) continue;
            int production = tile.potential(goodsType, null);
            if (bestTile != null && bestProduction >= production) continue;
            bestTile = ct;
            bestProduction = production;
        }
        if (bestProduction > 0) {
            return bestTile;
        }
        return null;
    }

    public Production getBestProduction(UnitType unitType) {
        Market market = this.colony.getOwner().getMarket();
        Production bestProduction = null;
        int value = -1;
        for (ColonyTile ct : this.colony.getColonyTiles()) {
            Tile tile = ct.getWorkTile();
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement() != this.colony || ct.isColonyCenterTile()) continue;
            for (GoodsType goodsType : this.colony.getSpecification().getFarmedGoodsTypeList()) {
                int production = market.getSalePrice(goodsType, tile.potential(goodsType, unitType));
                if (bestProduction != null && value >= production) continue;
                value = production;
                bestProduction = new Production(ct, goodsType);
            }
        }
        return bestProduction;
    }

    public void adjustProductionAndManufacture() {
        ArrayList<GoodsType> rawMatList = new ArrayList<GoodsType>();
        GoodsType hammersType = this.colony.getSpecification().getGoodsType("model.goods.hammers");
        GoodsType lumberType = this.colony.getSpecification().getGoodsType("model.goods.lumber");
        GoodsType oreType = this.colony.getSpecification().getGoodsType("model.goods.ore");
        if (this.getBuildingReqGoods() == hammersType) {
            rawMatList.add(lumberType);
        }
        rawMatList.add(oreType);
        if (this.primaryRawMaterial != null && this.primaryRawMaterial != lumberType && this.primaryRawMaterial != oreType && !this.primaryRawMaterial.isFoodType()) {
            rawMatList.add(this.primaryRawMaterial);
        }
        if (this.secondaryRawMaterial != null && this.secondaryRawMaterial != lumberType && this.secondaryRawMaterial != oreType && !this.secondaryRawMaterial.isFoodType()) {
            rawMatList.add(this.secondaryRawMaterial);
        }
        for (GoodsType rawMat : rawMatList) {
            GoodsType producedGoods = rawMat.getProducedMaterial();
            if (producedGoods == null) continue;
            this.adjustProductionAndManufactureFor(rawMat, producedGoods);
        }
    }

    public void adjustProductionAndManufactureFor(GoodsType rawMat, GoodsType producedGoods) {
        Unit u;
        Building factory = this.colony.getBuildingForProducing(producedGoods);
        if (factory == null) {
            return;
        }
        ArrayList<Unit> producers = new ArrayList<Unit>();
        int stockRawMat = this.colony.getGoodsCount(rawMat);
        for (ColonyTile t : this.colony.getColonyTiles()) {
            if (t.isColonyCenterTile() || (u = t.getUnit()) == null || u.getWorkType() != rawMat) continue;
            producers.add(u);
        }
        if (producers.size() == 0) {
            return;
        }
        Comparator<Unit> comp = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int prodU2;
                GoodsType goodsType = u1.getWorkType();
                int prodU1 = ((ColonyTile)u1.getLocation()).getProductionOf(u1, goodsType);
                if (prodU1 > (prodU2 = ((ColonyTile)u2.getLocation()).getProductionOf(u2, goodsType))) {
                    return 1;
                }
                if (prodU1 < prodU2) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(producers, comp);
        Iterator iter = new ArrayList(producers).iterator();
        while (iter.hasNext()) {
            if (stockRawMat < 50 && producers.size() < 2) {
                return;
            }
            if (factory.isFull()) {
                return;
            }
            u = (Unit)iter.next();
            if (!factory.canAdd(u.getType())) continue;
            int rawProd = this.colony.getNetProductionOf(rawMat) - u.getWorkTile().getProductionOf(u, rawMat);
            int mfnProd = this.colony.getNetProductionOf(producedGoods) + factory.getAdditionalProductionNextTurn(u);
            if (stockRawMat < 50 && rawProd < mfnProd) {
                return;
            }
            u.setLocation(factory);
            u.setWorkType(producedGoods);
            producers.remove(u);
        }
    }

    public GoodsType getBuildingReqGoods() {
        BuildableType currBuild = this.colony.getCurrentlyBuilding();
        if (currBuild == null) {
            return null;
        }
        GoodsType hammersType = this.colony.getSpecification().getGoodsType("model.goods.hammers");
        GoodsType toolsType = this.colony.getSpecification().getGoodsType("model.goods.tools");
        if (this.colony.getGoodsCount(hammersType) < currBuild.getAmountRequiredOf(hammersType)) {
            return hammersType;
        }
        return toolsType;
    }

    public GoodsType getPrimaryRawMaterial() {
        return this.primaryRawMaterial;
    }

    public GoodsType getSecondaryRawMaterial() {
        return this.secondaryRawMaterial;
    }

    public Colony getColony() {
        return this.colony;
    }

    private void selectProfile() {
        ArrayList<GoodsType> preferredProduction = new ArrayList<GoodsType>();
        preferredProduction.addAll(this.getGame().getSpecification().getFoodGoodsTypeList());
        preferredProduction.addAll(this.getGame().getSpecification().getLibertyGoodsTypeList());
        ColonyProfile.ProfileType type = ColonyProfile.ProfileType.SMALL;
        int size = this.colony.getUnitCount();
        if (size > 8) {
            type = ColonyProfile.ProfileType.LARGE;
        } else if (size > 12) {
            type = ColonyProfile.ProfileType.CAPITAL;
        }
        this.profile = new ColonyProfile(type, preferredProduction);
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(ColonyPlan.getXMLElementTagName());
        element.setAttribute("ID", this.colony.getId());
        return element;
    }

    public void readFromXMLElement(Element element) {
        this.colony = (Colony)this.getAIMain().getFreeColGameObject(element.getAttribute("ID"));
        this.selectProfile();
    }

    public static String getXMLElementTagName() {
        return "colonyPlan";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ColonyPlan for " + this.colony.getName() + " " + this.colony.getTile().getPosition());
        sb.append("\n\nPROFILE:\n");
        sb.append(this.profile.getType().toString());
        sb.append("\n");
        for (GoodsType goodsType : this.profile.getPreferredProduction()) {
            sb.append(goodsType.getNameKey());
            sb.append("\n");
        }
        sb.append("\n\nWORK LOCATIONS:\n");
        for (WorkLocationPlan p : this.getSortedWorkLocationPlans()) {
            sb.append(p.getGoodsType().getNameKey() + " (" + p.getWorkLocation() + ")\n");
        }
        sb.append("\n\nBUILD QUEUE:\n");
        Iterator<BuildableType> it = this.getBuildable();
        while (it.hasNext()) {
            BuildableType b = it.next();
            sb.append(b.getNameKey());
            sb.append('\n');
        }
        return sb.toString();
    }

    public class Production {
        ColonyTile colonyTile;
        GoodsType goodsType;

        public Production(ColonyTile ct, GoodsType gt) {
            this.colonyTile = ct;
            this.goodsType = gt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Buildable
    implements Comparable<Buildable> {
        BuildableType type;
        int priority;

        public Buildable(BuildableType type, int priority) {
            this.type = type;
            this.priority = priority;
        }

        @Override
        public int compareTo(Buildable other) {
            return other.priority - this.priority;
        }
    }
}

