/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class REFAIPlayer
extends EuropeanAIPlayer {
    private static final Logger logger = Logger.getLogger(REFAIPlayer.class.getName());

    public REFAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player);
    }

    public REFAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element);
    }

    public REFAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
    }

    public void startWorking() {
        Player player = this.getPlayer();
        logger.finest("Entering method startWorking: " + player + ", year " + this.getGame().getTurn());
        if (!player.isWorkForREF()) {
            logger.warning("No work for REF: " + player);
            return;
        }
        super.startWorking();
    }

    public Tile initialize(boolean teleport) {
        GoalDecider gd;
        AIUnit aiUnit = null;
        for (AIUnit aiu : this.getAIUnits()) {
            if (aiu.getUnit().isNaval() || !aiu.getUnit().isOffensiveUnit()) continue;
            aiUnit = aiu;
            break;
        }
        if (aiUnit == null) {
            logger.warning("New REF has no army?!?");
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Settlement target = null;
        int bestScore = Integer.MIN_VALUE;
        Player player = this.getPlayer();
        for (Player p : player.getRebels()) {
            for (Colony c : p.getColonies()) {
                int score;
                if (!c.isConnected() || (score = this.getUnitSeekAndDestroyMissionValue(unit, c.getTile(), Integer.MAX_VALUE)) <= bestScore) continue;
                bestScore = score;
                target = c;
            }
        }
        if (target == null) {
            logger.warning("Rebels have no connected colonies?!?");
            return null;
        }
        Tile tile = target.getTile();
        AIMain aiMain = this.getAIMain();
        for (AIUnit aiu : this.getAIUnits()) {
            if (aiu.getUnit().isNaval()) continue;
            aiu.setMission(new UnitSeekAndDestroyMission(aiMain, aiu, target));
        }
        for (AIUnit aiu : this.getAIUnits()) {
            Unit ship;
            if (!aiu.getUnit().isNaval() || (ship = aiu.getUnit()).getUnitCount() <= 0) continue;
            TransportMission tm = new TransportMission(aiMain, aiu);
            for (Unit u : ship.getUnitList()) {
                tm.addToTransportList(aiMain.getAIUnit(u));
            }
            aiu.setMission(tm);
        }
        Map map = this.getGame().getMap();
        PathNode path = map.search(unit, tile, gd = new GoalDecider(){
            private PathNode goal = null;

            public PathNode getGoal() {
                return this.goal;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode pathNode) {
                if (!pathNode.getTile().isEmpty()) {
                    return false;
                }
                for (Tile t : pathNode.getTile().getSurroundingTiles(1)) {
                    if (!t.isConnected() || !t.isEmpty()) continue;
                    this.goal = pathNode;
                    return true;
                }
                return false;
            }
        }, 10, null);
        if (path == null) {
            logger.warning("Can not find suitable REF landing site for: " + target);
            return null;
        }
        tile = path.getTile();
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (!t.isConnected() || !t.isEmpty()) continue;
            tile = t;
            break;
        }
        if (teleport) {
            return tile;
        }
        if (unit.getLocation() instanceof Unit) {
            path = map.findPathToEurope((Unit)unit.getLocation(), tile);
            if (path == null) {
                logger.warning("Can not find path to Europe from: " + tile);
                return null;
            }
            return path.getLastNode().getTile();
        }
        logger.warning("REF land unit not aboard a ship: " + unit);
        return null;
    }

    public int getDefendColonyMissionValue(Unit unit, Colony colony, int turns) {
        int value = super.getDefendColonyMissionValue(unit, colony, turns);
        return this.getColonyDefenders(colony) > 0 ? 0 : value;
    }

    public int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        int value = super.getUnitSeekAndDestroyMissionValue(unit, newTile, turns);
        if (value <= 0) {
            return value;
        }
        Settlement settlement = newTile.getSettlement();
        Unit defender = newTile.getDefendingUnit(unit);
        if (settlement == null) {
            if (unit.getOwner().getNumberOfSettlements() <= 0) {
                return Integer.MIN_VALUE;
            }
            if (this.alreadySeeking(defender)) {
                return Integer.MIN_VALUE;
            }
            value /= 2;
        } else if (settlement.isConnected()) {
            value += 1000;
        }
        return value;
    }

    private boolean alreadySeeking(Unit unit) {
        for (AIUnit au : this.getAIUnits()) {
            Location target;
            Mission m = au.getMission();
            if (m == null || !(m instanceof UnitSeekAndDestroyMission) || (target = ((UnitSeekAndDestroyMission)m).getTarget()) == null || !(target instanceof Unit) || (Unit)target != unit) continue;
            return true;
        }
        return false;
    }

    public void giveNormalMissions() {
        for (AIUnit aiu : this.getAIUnits()) {
            Unit u = aiu.getUnit();
            if (u.isNaval() || aiu.hasMission() || !u.isOffensiveUnit()) continue;
            this.giveMilitaryMission(aiu);
        }
        super.giveNormalMissions();
    }
}

