/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.ValuedAIObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkLocationPlan
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(WorkLocationPlan.class.getName());
    private WorkLocation workLocation;
    private int priority;
    private GoodsType goodsType;

    public WorkLocationPlan(AIMain aiMain, WorkLocation workLocation, GoodsType goodsType) {
        super(aiMain);
        this.workLocation = workLocation;
        this.goodsType = goodsType;
        this.setValue(this.getProductionOf(goodsType));
    }

    public WorkLocationPlan(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
        this.setValue(this.getProductionOf(this.goodsType));
    }

    public TileImprovementPlan createTileImprovementPlan() {
        return this.updateTileImprovementPlan(null);
    }

    public TileImprovementPlan updateTileImprovementPlan(TileImprovementPlan tip) {
        if (this.workLocation instanceof ColonyTile) {
            Tile tile = ((ColonyTile)this.workLocation).getWorkTile();
            if (tip != null && tip.getTarget() != tile) {
                throw new IllegalArgumentException("The given TileImprovementPlan was not created for this Tile.");
            }
            TileImprovementType impType = WorkLocationPlan.findBestTileImprovementType(tile, this.goodsType);
            if (impType != null) {
                int value = WorkLocationPlan.getImprovementValue(tile, this.goodsType, impType);
                if (tip == null) {
                    return new TileImprovementPlan(this.getAIMain(), tile, impType, value);
                }
                tip.setType(impType);
                tip.setValue(value);
                return tip;
            }
        }
        return null;
    }

    public static int getImprovementValue(Tile tile, GoodsType goodsType, TileImprovementType improvementType) {
        int value = 0;
        if (goodsType.isFarmed()) {
            TileType newTileType = improvementType.getChange(tile.getType());
            if (newTileType == null) {
                int production = tile.potential(goodsType, null);
                if (production > 0) {
                    float change = improvementType.getFeatureContainer().applyModifier(production, goodsType.getId());
                    value = (int)(change - (float)production);
                }
            } else {
                int change;
                value = change = newTileType.getProductionOf(goodsType, null) - tile.getType().getProductionOf(goodsType, null);
            }
        }
        return value;
    }

    public static TileImprovementType findBestTileImprovementType(Tile tile, GoodsType goodsType) {
        int bestValue = 0;
        TileImprovementType bestType = null;
        for (TileImprovementType impType : tile.getSpecification().getTileImprovementTypeList()) {
            int value;
            if (impType.isNatural() || !impType.isTileTypeAllowed(tile.getType()) || tile.findTileImprovementType(impType) != null || (value = WorkLocationPlan.getImprovementValue(tile, goodsType, impType)) <= bestValue) continue;
            bestValue = value;
            bestType = impType;
        }
        return bestType;
    }

    public WorkLocation getWorkLocation() {
        return this.workLocation;
    }

    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == null || goodsType != this.goodsType) {
            return 0;
        }
        if (this.workLocation instanceof ColonyTile) {
            if (!goodsType.isFarmed()) {
                return 0;
            }
            ColonyTile ct = (ColonyTile)this.workLocation;
            Tile t = ct.getWorkTile();
            UnitType expertUnitType = this.getAIMain().getGame().getSpecification().getExpertForProducing(goodsType);
            int base = t.getMaximumPotential(goodsType, expertUnitType);
            if (t.isLand() && base != 0) {
                ++base;
            }
            if (base == 0) {
                return 0;
            }
            base = (int)expertUnitType.getFeatureContainer().applyModifier(base, goodsType.getId());
            return Math.max(base, 1);
        }
        if (goodsType.isFarmed()) {
            return 0;
        }
        if (goodsType == this.getAIMain().getGame().getSpecification().getGoodsType("model.goods.hammers")) {
            return 16;
        }
        if (goodsType == this.getAIMain().getGame().getSpecification().getGoodsType("model.goods.bells")) {
            return 12;
        }
        if (goodsType == this.getAIMain().getGame().getSpecification().getGoodsType("model.goods.crosses")) {
            return 10;
        }
        return this.workLocation.getColony().getOwner().getMarket().getSalePrice(goodsType, 1);
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public void setGoodsType(GoodsType goodsType) {
        this.goodsType = goodsType;
        this.setValue(this.getProductionOf(goodsType));
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(WorkLocationPlan.getXMLElementTagName());
        element.setAttribute("ID", this.workLocation.getId());
        element.setAttribute("priority", Integer.toString(this.priority));
        element.setAttribute("goodsType", this.goodsType.getId());
        return element;
    }

    public void readFromXMLElement(Element element) {
        this.workLocation = (WorkLocation)this.getAIMain().getFreeColGameObject(element.getAttribute("ID"));
        this.priority = Integer.parseInt(element.getAttribute("priority"));
        this.goodsType = this.getAIMain().getGame().getSpecification().getGoodsType(element.getAttribute("goodsType"));
    }

    public static String getXMLElementTagName() {
        return "workLocationPlan";
    }
}

