/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class PrivateerMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PrivateerMission.class.getName());
    private PrivateerMissionState state = PrivateerMissionState.HUNTING;
    private Location nearestPort = null;
    private Tile target = null;
    private boolean valid = true;

    public PrivateerMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        Unit unit = aiUnit.getUnit();
        logger.finest("Assigning PrivateerMission to unit=" + unit + " at " + unit.getTile());
    }

    public PrivateerMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public PrivateerMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        logger.finest("Entering doMission");
        Unit unit = this.getUnit();
        while (this.isValid() && unit.getMovesLeft() > 0) {
            if (unit.isAtSea()) {
                unit.setMovesLeft(0);
                return;
            }
            switch (this.state) {
                case HUNTING: {
                    this.hunt4Target(connection);
                    break;
                }
                case TRANSPORTING: {
                    this.gotoNearestPort(connection);
                }
            }
        }
    }

    private void hunt4Target(Connection connection) {
        Unit unit = this.getUnit();
        if (unit.getLocation() instanceof Europe) {
            this.moveUnitToAmerica();
            unit.setMovesLeft(0);
            return;
        }
        logger.finest("Privateer (" + unit.getId() + ") at " + unit.getTile() + " hunting");
        if (unit.getGoodsCount() > 0) {
            this.state = PrivateerMissionState.TRANSPORTING;
            return;
        }
        boolean MAX_TURNS_TO_TARGET = true;
        PathNode pathToTarget = this.findTarget(1);
        if (pathToTarget != null) {
            this.target = pathToTarget.getLastNode().getTile();
            logger.finest("Privateer (" + unit.getId() + ") at " + unit.getTile() + " found target at " + this.target);
            pathToTarget = unit.findPath(this.target);
            Map.Direction direction = this.moveTowards(pathToTarget);
            if (direction == null) {
                logger.finest("Ending privateer (" + unit.getId() + ") turn, moves=" + unit.getMovesLeft());
                unit.setMovesLeft(0);
                return;
            }
            if (unit.getMoveType(direction) == Unit.MoveType.ATTACK_UNIT) {
                logger.finest("Privateer (" + unit.getId() + ") at " + unit.getTile() + " attacking target");
                AIMessage.askAttack(this.getAIUnit(), direction);
            }
        } else {
            this.target = null;
            logger.finest("Privateer at " + unit.getTile() + " without target, wandering");
            this.moveRandomly(connection);
        }
        unit.setMovesLeft(0);
    }

    private void gotoNearestPort(Connection connection) {
        Unit unit = this.getUnit();
        if (this.isUnitInPort()) {
            this.dumpCargoInPort(connection);
            this.state = PrivateerMissionState.HUNTING;
            return;
        }
        PathNode path = this.getValidPathForNearestPort();
        if (path == null) {
            this.findNearestPort();
            if (this.nearestPort == null) {
                logger.finest("Failed to find port for goods");
                this.valid = false;
                return;
            }
            path = this.getValidPathForNearestPort();
            if (path == null) {
                logger.finest("Failed to deliver goods to " + this.nearestPort + ", no path");
                this.valid = false;
                return;
            }
        }
        boolean moveToEurope = this.nearestPort instanceof Europe;
        Map.Direction direction = this.moveTowards(path);
        if (direction == null) {
            unit.setMovesLeft(0);
            return;
        }
        if (moveToEurope && unit.getMoveType(direction) == Unit.MoveType.MOVE_HIGH_SEAS) {
            this.moveUnitToEurope();
            unit.setMovesLeft(0);
            return;
        }
        if (unit.getMoveType(direction) == Unit.MoveType.MOVE) {
            Map.Position unitPos = unit.getTile().getPosition();
            Map.Position ColPos = unitPos.getAdjacent(direction);
            Colony colony = this.getGame().getMap().getTile(ColPos).getColony();
            if (colony == this.nearestPort) {
                AIMessage.askMove(this.getAIUnit(), direction);
                return;
            }
            String errMsg = "Privateer (" + unit.getId() + ") with PrivateerMission trying to enter settlement";
            throw new IllegalStateException(errMsg);
        }
        unit.setMovesLeft(0);
    }

    private PathNode getValidPathForNearestPort() {
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        if (this.nearestPort == null) {
            return null;
        }
        if (this.nearestPort instanceof Europe) {
            if (player.getEurope() == null) {
                this.nearestPort = null;
                return null;
            }
            return unit.findPathToEurope();
        }
        Colony nearestColony = (Colony)this.nearestPort;
        if (nearestColony == null || nearestColony.isDisposed() || nearestColony.getOwner() != player) {
            this.nearestPort = null;
            return null;
        }
        return unit.findPath(nearestColony.getTile());
    }

    private void findNearestPort() {
        this.nearestPort = null;
        Unit unit = this.getUnit();
        PathNode path = this.findNearestColony(unit);
        if (path != null) {
            this.nearestPort = path.getLastNode().getTile().getColony();
        } else {
            Europe europe = unit.getOwner().getEurope();
            if (europe != null) {
                this.nearestPort = europe;
            }
        }
    }

    private boolean isUnitInPort() {
        if (this.nearestPort == null) {
            return false;
        }
        Unit unit = this.getUnit();
        if (this.nearestPort instanceof Europe) {
            return unit.getLocation() == this.nearestPort;
        }
        return unit.getTile() == this.nearestPort.getTile();
    }

    private void dumpCargoInPort(Connection connection) {
        logger.finest("Dumping goods");
        Unit unit = this.getUnit();
        boolean inEurope = unit.getLocation() instanceof Europe;
        ArrayList<Goods> goodsLst = new ArrayList<Goods>(unit.getGoodsList());
        for (Goods goods : goodsLst) {
            if (inEurope) {
                logger.finest("Before dumping: money=" + unit.getOwner().getGold());
                this.sellCargoInEurope(goods);
                logger.finest("After dumping: money=" + unit.getOwner().getGold());
                continue;
            }
            Colony colony = unit.getTile().getColony();
            logger.finest("Before dumping: " + colony.getGoodsCount(goods.getType()) + " " + goods.getType());
            this.unloadCargoInColony(goods);
            logger.finest("After dumping: " + colony.getGoodsCount(goods.getType()) + " " + goods.getType());
        }
        for (Unit u : unit.getUnitList()) {
            this.unitLeavesShip(this.getAIMain().getAIUnit(u));
        }
    }

    public static boolean isValid(AIUnit aiUnit) {
        Unit unit = aiUnit.getUnit();
        return Mission.isValid(aiUnit) && unit.isCarrier() && unit.isOffensiveUnit() && unit.hasAbility("model.ability.piracy") && unit.getGoodsCount() == 0 && unit.getUnitCount() == 0;
    }

    public boolean isValid() {
        return super.isValid() && this.valid && PrivateerMission.isValid(this.getAIUnit());
    }

    public String getDebuggingInfo() {
        Unit targetUnit;
        StringBuffer sb = new StringBuffer("State: " + this.state.name());
        if (this.state == PrivateerMissionState.HUNTING && this.target != null && (targetUnit = this.target.getDefendingUnit(this.getUnit())) != null) {
            String coord = " (" + this.target.getX() + "," + this.target.getY() + ")";
            sb.append(" target=" + targetUnit + coord);
        }
        return sb.toString();
    }

    public static int getModifierValueForTarget(CombatModel combatModel, Unit attacker, Unit defender) {
        int modifier = 100;
        modifier += defender.getGoodsCount() * 200;
        modifier += defender.getUnitCount() * 100;
        if (defender.isOffensiveUnit()) {
            modifier = (int)((float)modifier - combatModel.getDefencePower(attacker, defender) * 100.0f);
        }
        return modifier;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, PrivateerMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("state", this.state.toString());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.state = PrivateerMissionState.valueOf(in.getAttributeValue(null, "state"));
    }

    public static String getXMLElementTagName() {
        return "privateerMission";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PrivateerMissionState {
        HUNTING,
        TRANSPORTING;

    }
}

