/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.logging.Logger;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TransactionSession;

public class TaxSession
extends TransactionSession {
    private static final Logger logger = Logger.getLogger(TaxSession.class.getName());
    private ServerPlayer serverPlayer;
    private int tax;
    private Goods goods;
    private boolean accepted;

    public TaxSession(Monarch monarch, ServerPlayer serverPlayer) {
        super(TaxSession.makeSessionKey(TaxSession.class, monarch, serverPlayer));
        this.serverPlayer = serverPlayer;
        this.tax = 0;
        this.goods = null;
        this.accepted = false;
    }

    public void complete(ChangeSet cs) {
        this.serverPlayer.csRaiseTax(this.tax, this.goods, this.accepted, cs);
        super.complete(cs);
    }

    public int getTax() {
        return this.tax;
    }

    public void setTax(int tax) {
        this.tax = tax;
    }

    public Goods getGoods() {
        return this.goods;
    }

    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    public boolean getAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }
}

