/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.freecol.client.gui.i18n.Relation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule {
    List<List<Relation>> conditions = new ArrayList<List<Relation>>();

    public Rule(String input) {
        this.parse(input);
    }

    public void add(List<Relation> condition) {
        this.conditions.add(condition);
    }

    public boolean matches(double number) {
        block0: for (List<Relation> andCondition : this.conditions) {
            for (Relation relation : andCondition) {
                if (relation.matches(number)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public void parse(String input) {
        StringTokenizer st = new StringTokenizer(input.toLowerCase(Locale.US), " .");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("or".equals(token)) {
                this.conditions.add(this.parseCondition(tokens));
                tokens.clear();
                continue;
            }
            tokens.add(token);
        }
        this.conditions.add(this.parseCondition(tokens));
    }

    private List<Relation> parseCondition(List<String> input) {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (String token : input) {
            if ("and".equals(token)) {
                result.add(new Relation(tokens));
                tokens.clear();
                continue;
            }
            tokens.add(token);
        }
        result.add(new Relation(tokens));
        return result;
    }

    public String toString() {
        String result = new String();
        for (List<Relation> andCondition : this.conditions) {
            String condition = new String();
            for (Relation relation : andCondition) {
                condition = condition + " and " + relation.toString();
            }
            result = result + " or " + condition.substring(5);
        }
        return result.substring(4);
    }
}

