/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.action.SelectableAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;

public abstract class FreeColMenuBar
extends JMenuBar {
    private static final Logger logger = Logger.getLogger(FreeColMenuBar.class.getName());
    protected final FreeColClient freeColClient;
    protected ActionManager am;
    protected GUI gui;

    protected FreeColMenuBar(FreeColClient f, GUI gui) {
        this.setOpaque(false);
        this.freeColClient = f;
        this.gui = gui;
        this.am = f.getActionManager();
        this.setBorder(FreeColImageBorder.imageBorder);
    }

    public abstract void reset();

    protected JMenuItem getMenuItem(String actionID) {
        JMenuItem rtn = null;
        FreeColAction action = this.am.getFreeColAction(actionID);
        if (action != null) {
            rtn = new JMenuItem();
            rtn.setAction(action);
            rtn.setOpaque(false);
            if (action.getMnemonic() != FreeColAction.NO_MNEMONIC) {
                rtn.addMenuKeyListener(action.getMenuKeyListener());
            }
        } else {
            logger.finest("Could not create menu item. [" + actionID + "] not found.");
        }
        return rtn;
    }

    protected JMenuItem getMenuItem(String actionID, ActionListener actionListener) {
        JMenuItem rtn = this.getMenuItem(actionID);
        rtn.addActionListener(actionListener);
        return rtn;
    }

    protected JCheckBoxMenuItem getCheckBoxMenuItem(String actionID) {
        JCheckBoxMenuItem rtn = null;
        FreeColAction action = this.am.getFreeColAction(actionID);
        if (action != null) {
            rtn = new JCheckBoxMenuItem();
            rtn.setAction(action);
            rtn.setOpaque(false);
            rtn.setSelected(((SelectableAction)this.am.getFreeColAction(actionID)).isSelected());
        } else {
            logger.finest("Could not create menu item. [" + actionID + "] not found.");
        }
        return rtn;
    }

    protected JRadioButtonMenuItem getRadioButtonMenuItem(String actionID, ButtonGroup group) {
        JRadioButtonMenuItem rtn = null;
        FreeColAction action = this.am.getFreeColAction(actionID);
        if (action != null) {
            rtn = new JRadioButtonMenuItem();
            rtn.setAction(action);
            rtn.setOpaque(false);
            rtn.setSelected(((SelectableAction)this.am.getFreeColAction(actionID)).isSelected());
            group.add(rtn);
        } else {
            logger.finest("Could not create menu item. [" + actionID + "] not found.");
        }
        return rtn;
    }

    public void update() {
        this.repaint();
    }

    public void setEnabled(boolean enabled) {
        this.update();
    }

    protected void buildColopediaMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.colopedia"));
        menu.setOpaque(false);
        menu.setMnemonic(67);
        for (ColopediaAction.PanelType type : ColopediaAction.PanelType.values()) {
            menu.add(this.getMenuItem("colopediaAction." + (Object)((Object)type)));
        }
        menu.addSeparator();
        menu.add(this.getMenuItem("aboutAction"));
        this.add(menu);
    }

    public void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            super.paintComponent(g);
        } else {
            ImageLibrary.drawTiledImage("background.FreeColMenuBar", g, this, this.getInsets());
        }
    }
}

