/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.FatherDetailPanel;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.FoundingFather;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChooseFoundingFatherDialog
extends FreeColDialog<FoundingFather>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ChooseFoundingFatherDialog.class.getName());
    private final JTabbedPane tb;
    private final List<FoundingFather> possibleFathers;

    public ChooseFoundingFatherDialog(FreeColClient freeColClient, GUI gui, List<FoundingFather> possibleFoundingFathers) {
        super(freeColClient, gui);
        this.possibleFathers = possibleFoundingFathers;
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "align center"));
        this.setFocusCycleRoot(false);
        this.tb = new JTabbedPane(1);
        FatherDetailPanel details = new FatherDetailPanel(this.getFreeColClient(), gui, new ColopediaPanel(this.getFreeColClient(), gui));
        boolean hasSelectedTab = false;
        for (int index = 0; index < possibleFoundingFathers.size(); ++index) {
            FoundingFather father = possibleFoundingFathers.get(index);
            JPanel panel = new JPanel();
            details.buildDetail(father, panel);
            panel.validate();
            this.tb.addTab(Messages.message(father.getTypeKey()), panel);
        }
        this.tb.setSelectedIndex(0);
        JButton helpButton = new JButton(this.getFreeColClient().getActionManager().getFreeColAction("colopediaAction.FATHERS"));
        helpButton.setText(Messages.message("help"));
        this.add(ChooseFoundingFatherDialog.getDefaultHeader(Messages.message("foundingFatherDialog.nominate")));
        this.add((Component)this.tb, "width 100%");
        this.add((Component)this.okButton, "newline 20, split 2, tag ok");
        this.add((Component)helpButton, "tag help");
        this.setSize(this.tb.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.tb.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.setResponse(this.possibleFathers.get(this.tb.getSelectedIndex()));
    }
}

