/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.OptionsDialog;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public final class DifficultyDialog
extends OptionsDialog
implements ItemListener {
    private static final Logger logger = Logger.getLogger(DifficultyDialog.class.getName());
    private static final String EDIT = "EDIT";
    private JButton edit = new JButton(Messages.message("edit"));
    private String DEFAULT_LEVEL = "model.difficulty.medium";
    private String CUSTOM_LEVEL = "model.difficulty.custom";
    private Specification specification;
    private final JComboBox difficultyBox = new JComboBox();

    public DifficultyDialog(FreeColClient freeColClient, GUI gui, OptionGroup level) {
        super(freeColClient, gui, false);
        this.difficultyBox.setRenderer(new BoxRenderer());
        this.specification = this.getSpecification();
        this.difficultyBox.addItem(level.getId());
        this.difficultyBox.setEnabled(false);
        this.initialize(level, Messages.message("difficulty"), this.difficultyBox);
    }

    public DifficultyDialog(FreeColClient freeColClient, GUI gui, Specification specification) {
        super(freeColClient, gui, true);
        this.difficultyBox.setRenderer(new BoxRenderer());
        this.specification = specification;
        boolean customized = this.loadCustomOptions();
        OptionGroup group = specification.getDifficultyLevel(customized ? this.CUSTOM_LEVEL : this.DEFAULT_LEVEL);
        if (group == null) {
            group = specification.getDifficultyLevels().get(0);
        }
        for (OptionGroup level : specification.getDifficultyLevels()) {
            String id = level.getId();
            this.difficultyBox.addItem(id);
        }
        this.difficultyBox.setSelectedItem(group.getId());
        this.edit.setActionCommand(EDIT);
        this.edit.addActionListener(this);
        this.edit.setEnabled(!this.CUSTOM_LEVEL.equals(group.getId()));
        this.getButtons().add(this.edit);
        this.save.setEnabled(this.CUSTOM_LEVEL.equals(group.getId()));
        this.difficultyBox.addItemListener(this);
        this.initialize(group, Messages.message("difficulty"), this.difficultyBox);
    }

    protected boolean isGroupEditable() {
        return super.isGroupEditable() && this.CUSTOM_LEVEL.equals(this.getGroup().getId());
    }

    public boolean isEditable() {
        return super.isEditable() && this.CUSTOM_LEVEL.equals(this.getGroup().getId());
    }

    public String getOptionGroupId() {
        return this.CUSTOM_LEVEL;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (EDIT.equals(command)) {
            OptionGroup custom = this.specification.getOptionGroup(this.CUSTOM_LEVEL);
            custom.setValue(this.getGroup());
            this.difficultyBox.setSelectedItem(this.CUSTOM_LEVEL);
        } else if ("LOAD".equals(command)) {
            File loadFile = this.getGUI().showLoadDialog(FreeCol.getOptionsDirectory(), filters);
            if (loadFile != null) {
                this.load(loadFile);
                this.difficultyBox.setSelectedItem(this.CUSTOM_LEVEL);
            }
        } else {
            super.actionPerformed(event);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        String id = (String)this.difficultyBox.getSelectedItem();
        this.edit.setEnabled(!this.CUSTOM_LEVEL.equals(id));
        this.save.setEnabled(this.CUSTOM_LEVEL.equals(id));
        this.updateUI(this.specification.getOptionGroup(id));
    }

    public String getDefaultFileName() {
        return "custom.xml";
    }

    private class BoxRenderer
    extends FreeColComboBoxRenderer {
        private BoxRenderer() {
        }

        public void setLabelValues(JLabel c, Object value) {
            c.setText(Messages.message((String)value));
        }
    }
}

