/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Unit;

public final class EuropePanel
extends FreeColPanel {
    private static Logger logger = Logger.getLogger(EuropePanel.class.getName());
    private final DestinationPanel toAmericaPanel;
    private final DestinationPanel toEuropePanel;
    private final InPortPanel inPortPanel;
    private final DocksPanel docksPanel;
    private final EuropeCargoPanel cargoPanel;
    private final MarketPanel marketPanel;
    private final TransactionLog log;
    private final DefaultTransferHandler defaultTransferHandler;
    private final MouseListener pressListener;
    private Europe europe;
    private UnitLabel selectedUnitLabel;
    private JButton exitButton;
    private JLabel header = EuropePanel.getDefaultHeader("");

    public EuropePanel(FreeColClient freeColClient, GUI gui, Canvas canvas) {
        super(freeColClient, gui);
        this.setFocusCycleRoot(true);
        this.exitButton = new EuropeButton(Messages.message("close"), 27, EuropeAction.EXIT.toString(), this);
        EuropeButton trainButton = new EuropeButton(Messages.message("train"), 84, EuropeAction.TRAIN.toString(), this);
        EuropeButton purchaseButton = new EuropeButton(Messages.message("purchase"), 80, EuropeAction.PURCHASE.toString(), this);
        EuropeButton recruitButton = new EuropeButton(Messages.message("recruit"), 82, EuropeAction.RECRUIT.toString(), this);
        EuropeButton unloadButton = new EuropeButton(Messages.message("unload"), 85, EuropeAction.UNLOAD.toString(), this);
        EuropeButton sailButton = new EuropeButton(Messages.message("sail"), 83, EuropeAction.SAIL.toString(), this);
        this.toAmericaPanel = new DestinationPanel();
        this.toEuropePanel = new DestinationPanel();
        this.inPortPanel = new InPortPanel();
        this.cargoPanel = new EuropeCargoPanel(freeColClient, this.getGUI());
        this.cargoPanel.setParentPanel(this);
        this.docksPanel = new DocksPanel();
        this.marketPanel = new MarketPanel(this);
        this.log = new TransactionLog();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributes, 2);
        StyleConstants.setBold(attributes, true);
        this.log.setParagraphAttributes(attributes, true);
        this.defaultTransferHandler = new DefaultTransferHandler(freeColClient, this.getGUI(), this);
        this.toAmericaPanel.setTransferHandler(this.defaultTransferHandler);
        this.toEuropePanel.setTransferHandler(this.defaultTransferHandler);
        this.inPortPanel.setTransferHandler(this.defaultTransferHandler);
        this.cargoPanel.setTransferHandler(this.defaultTransferHandler);
        this.docksPanel.setTransferHandler(this.defaultTransferHandler);
        this.marketPanel.setTransferHandler(this.defaultTransferHandler);
        this.pressListener = new DragListener(freeColClient, gui, this);
        DropListener releaseListener = new DropListener();
        this.toAmericaPanel.addMouseListener(releaseListener);
        this.toEuropePanel.addMouseListener(releaseListener);
        this.inPortPanel.addMouseListener(releaseListener);
        this.cargoPanel.addMouseListener(releaseListener);
        this.docksPanel.addMouseListener(releaseListener);
        this.marketPanel.addMouseListener(releaseListener);
        this.toAmericaPanel.setLayout(new GridLayout(1, 0));
        this.toEuropePanel.setLayout(new GridLayout(1, 0));
        this.inPortPanel.setLayout(new GridLayout(1, 0));
        this.cargoPanel.setLayout(new GridLayout(1, 0));
        this.docksPanel.setLayout(new GridLayout(0, 5));
        JScrollPane toAmericaScroll = new JScrollPane(this.toAmericaPanel, 21, 30);
        toAmericaScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane toEuropeScroll = new JScrollPane(this.toEuropePanel, 21, 30);
        toEuropeScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane inPortScroll = new JScrollPane(this.inPortPanel, 21, 30);
        inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        cargoScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane docksScroll = new JScrollPane(this.docksPanel, 20, 31);
        docksScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane marketScroll = new JScrollPane(this.marketPanel, 21, 30);
        JScrollPane logScroll = new JScrollPane(this.log, 20, 31);
        logScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.toAmericaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("goingToAmerica")));
        this.toEuropePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("goingToEurope")));
        this.docksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("docks")));
        this.inPortPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("inPort")));
        this.marketPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.log.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("sales")));
        toAmericaScroll.getViewport().setOpaque(false);
        this.toAmericaPanel.setOpaque(false);
        toEuropeScroll.getViewport().setOpaque(false);
        this.toEuropePanel.setOpaque(false);
        inPortScroll.getViewport().setOpaque(false);
        this.inPortPanel.setOpaque(false);
        cargoScroll.getViewport().setOpaque(false);
        this.cargoPanel.setOpaque(false);
        docksScroll.getViewport().setOpaque(false);
        this.docksPanel.setOpaque(false);
        marketScroll.getViewport().setOpaque(false);
        this.marketPanel.setOpaque(false);
        logScroll.getViewport().setOpaque(false);
        this.log.setOpaque(false);
        this.setLayout((LayoutManager)new MigLayout("wrap 3, insets 20, fill", "[380:][380:][150:200:]"));
        if (canvas.getHeight() > 750) {
            this.add((Component)this.header, "span, center");
        }
        this.add((Component)toAmericaScroll, "sg, height 124:, grow");
        this.add((Component)toEuropeScroll, "sg, height 124:, grow");
        this.add((Component)logScroll, "spany 3, grow");
        this.add((Component)inPortScroll, "sg, height 124:, grow");
        this.add((Component)docksScroll, "spany 2, grow");
        this.add((Component)cargoScroll, "height 100:, grow");
        this.add((Component)marketScroll, "span, grow");
        this.add((Component)recruitButton, "span, split 6");
        this.add(purchaseButton);
        this.add(trainButton);
        this.add(unloadButton);
        this.add(sailButton);
        this.add((Component)this.exitButton, "tag ok");
        this.selectedUnitLabel = null;
        this.addMouseListener(new MouseAdapter(){});
        this.restoreSavedSize(1000, canvas.getHeight() > 750 ? 700 : 600);
    }

    public void requestFocus() {
        this.exitButton.requestFocus();
    }

    public void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public final CargoPanel getCargoPanel() {
        return this.cargoPanel;
    }

    public Unit getSelectedUnit() {
        return this.selectedUnitLabel == null ? null : this.selectedUnitLabel.getUnit();
    }

    public void setSelectedUnit(Unit unit) {
        UnitLabel unitLabel = null;
        if (unit != null) {
            Component[] components = this.inPortPanel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof UnitLabel) || ((UnitLabel)components[i]).getUnit() != unit) continue;
                unitLabel = (UnitLabel)components[i];
                break;
            }
        }
        this.setSelectedUnitLabel(unitLabel);
    }

    public UnitLabel getSelectedUnitLabel() {
        return this.selectedUnitLabel;
    }

    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
            }
            this.selectedUnitLabel = unitLabel;
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
            }
        }
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    public void initialize(Europe europe, Game game) {
        this.europe = europe;
        this.header.setText(Messages.message(europe.getNameKey()));
        this.toAmericaPanel.initialize(this.getGame().getMap());
        this.toEuropePanel.initialize(this.getMyPlayer().getEurope());
        this.cargoPanel.initialize();
        this.inPortPanel.initialize();
        this.marketPanel.initialize();
        this.docksPanel.initialize();
        this.log.initialize();
    }

    public void cleanup() {
        this.log.cleanup();
        this.docksPanel.cleanup();
        this.marketPanel.cleanup();
        this.inPortPanel.cleanup();
        this.cargoPanel.cleanup();
        this.toEuropePanel.cleanup();
        this.toAmericaPanel.cleanup();
    }

    private void exitAction() {
        this.cleanup();
        this.getGUI().removeFromCanvas(this);
        this.getController().nextModelMessage();
    }

    private void unloadAction() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                if (this.getMyPlayer().canTrade(goods)) {
                    this.getController().sellGoods(goods);
                    continue;
                }
                this.getController().payArrears(goods.getType());
            }
            Iterator<Unit> unitIterator = unit.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit newUnit = unitIterator.next();
                this.getController().leaveShip(newUnit);
            }
            this.cargoPanel.update();
            this.docksPanel.update();
        }
        this.requestFocus();
    }

    private void sailAction() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isNaval()) {
            UnitLabel unitLabel = this.getSelectedUnitLabel();
            this.toAmericaPanel.add((Component)unitLabel, true);
        }
        this.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        EuropeAction act = EuropeAction.valueOf(command);
        this.getGUI().showEuropeDialog(act);
        switch (act) {
            case EXIT: {
                this.exitAction();
                break;
            }
            case RECRUIT: 
            case PURCHASE: 
            case TRAIN: {
                this.requestFocus();
                break;
            }
            case UNLOAD: {
                this.unloadAction();
                break;
            }
            case SAIL: {
                this.sailAction();
                break;
            }
            default: {
                logger.warning("Invalid action command: " + command);
            }
        }
    }

    public class EuropeButton
    extends JButton {
        public EuropeButton(String text, int keyEvent, String command, ActionListener listener) {
            this.setOpaque(true);
            this.setText(text);
            this.setActionCommand(command);
            this.addActionListener(listener);
            ComponentInputMap closeInputMap = new ComponentInputMap(this);
            ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(keyEvent, 0, false), "pressed");
            ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(keyEvent, 0, true), "released");
            SwingUtilities.replaceUIInputMap(this, 2, closeInputMap);
            FreeColPanel.enterPressesWhenFocused(this);
        }
    }

    public class TransactionLog
    extends JTextPane
    implements TransactionListener {
        public TransactionLog() {
            this.setEditable(false);
        }

        public void initialize() {
            EuropePanel.this.getMyPlayer().getMarket().addTransactionListener(this);
            this.setText("");
        }

        public void cleanup() {
            EuropePanel.this.getMyPlayer().getMarket().removeTransactionListener(this);
        }

        public void logPurchase(GoodsType goodsType, int amount, int price) {
            int total = amount * price;
            String text = Messages.message(StringTemplate.template("transaction.purchase").add("%goods%", goodsType.getNameKey()).addAmount("%amount%", amount).addAmount("%gold%", price)) + "\n" + Messages.message(StringTemplate.template("transaction.price").addAmount("%gold%", total));
            this.add(text);
        }

        public void logSale(GoodsType goodsType, int amount, int price, int tax) {
            int totalBeforeTax = amount * price;
            int totalTax = totalBeforeTax * tax / 100;
            int totalAfterTax = totalBeforeTax - totalTax;
            String text = Messages.message(StringTemplate.template("transaction.sale").add("%goods%", goodsType.getNameKey()).addAmount("%amount%", amount).addAmount("%gold%", price)) + "\n" + Messages.message(StringTemplate.template("transaction.price").addAmount("%gold%", totalBeforeTax)) + "\n" + Messages.message(StringTemplate.template("transaction.tax").addAmount("%tax%", tax).addAmount("%gold%", totalTax)) + "\n" + Messages.message(StringTemplate.template("transaction.net").addAmount("%gold%", totalAfterTax));
            this.add(text);
        }

        private void add(String text) {
            StyledDocument doc = this.getStyledDocument();
            try {
                if (doc.getLength() > 0) {
                    text = "\n\n" + text;
                }
                doc.insertString(doc.getLength(), text, null);
            }
            catch (Exception e) {
                logger.warning("Failed to update transaction log: " + e.toString());
            }
        }
    }

    public final class MarketPanel
    extends JPanel {
        private final EuropePanel europePanel;

        public MarketPanel(EuropePanel europePanel2) {
            this.europePanel = europePanel2;
            this.setLayout(new GridLayout(2, 8));
        }

        public void initialize() {
            this.removeAll();
            List<GoodsType> goodsTypes = EuropePanel.this.getSpecification().getGoodsTypeList();
            Market market = EuropePanel.this.getMyPlayer().getMarket();
            for (GoodsType goodsType : goodsTypes) {
                if (!goodsType.isStorable()) continue;
                MarketLabel marketLabel = new MarketLabel(goodsType, market, EuropePanel.this.getGUI());
                marketLabel.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                marketLabel.addMouseListener(EuropePanel.this.pressListener);
                this.add(marketLabel);
            }
        }

        public void cleanup() {
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component dropped on this MarketPanel.");
                    return null;
                }
                Goods goods = ((GoodsLabel)comp).getGoods();
                if (EuropePanel.this.getMyPlayer().canTrade(goods)) {
                    EuropePanel.this.getController().sellGoods(goods);
                } else {
                    switch (EuropePanel.this.getGUI().showBoycottedGoodsDialog(goods, EuropePanel.this.europe)) {
                        case PAY_ARREARS: {
                            EuropePanel.this.getController().payArrears(goods.getType());
                            break;
                        }
                        case DUMP_CARGO: {
                            EuropePanel.this.getController().unloadCargo(goods, true);
                            break;
                        }
                    }
                }
                EuropePanel.this.cargoPanel.revalidate();
                this.revalidate();
                EuropePanel.this.getController().nextModelMessage();
            }
            this.europePanel.refresh();
            return comp;
        }

        public void remove(Component comp) {
        }
    }

    public final class DocksPanel
    extends JPanel
    implements PropertyChangeListener {
        public void initialize() {
            this.setLayout((LayoutManager)new MigLayout("wrap 6"));
            this.addPropertyChangeListeners();
            this.update();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
        }

        public void update() {
            this.removeAll();
            List<Unit> units = EuropePanel.this.europe.getUnitList();
            for (Unit unit : units) {
                if (unit.isNaval()) continue;
                UnitLabel unitLabel = new UnitLabel(EuropePanel.this.getFreeColClient(), unit, EuropePanel.this.getGUI());
                unitLabel.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                unitLabel.addMouseListener(EuropePanel.this.pressListener);
                this.add(unitLabel);
            }
            this.revalidate();
            this.repaint();
        }

        public Component add(Component comp, boolean editState) {
            Component c = this.add(comp);
            this.update();
            return c;
        }

        public void remove(Component comp) {
            this.update();
        }

        public void addPropertyChangeListeners() {
            EuropePanel.this.europe.addPropertyChangeListener(this);
        }

        public void removePropertyChangeListeners() {
            EuropePanel.this.europe.removePropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            logger.finest("Europe-docks change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
            this.update();
        }
    }

    public final class InPortPanel
    extends JPanel
    implements PropertyChangeListener {
        public void initialize() {
            this.addPropertyChangeListeners();
            this.update();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
        }

        public void update() {
            this.removeAll();
            UnitLabel lastCarrier = null;
            UnitLabel prevCarrier = null;
            for (Unit unit : EuropePanel.this.europe.getUnitList()) {
                if (!unit.isNaval() || unit.getState() != Unit.UnitState.ACTIVE && unit.getState() != Unit.UnitState.SENTRY) continue;
                UnitLabel unitLabel = new UnitLabel(EuropePanel.this.getFreeColClient(), unit, EuropePanel.this.getGUI());
                unitLabel.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                unitLabel.addMouseListener(EuropePanel.this.pressListener);
                this.add(unitLabel);
                lastCarrier = unitLabel;
                if (EuropePanel.this.getSelectedUnit() != unit) continue;
                prevCarrier = unitLabel;
            }
            EuropePanel.this.setSelectedUnitLabel(prevCarrier != null ? prevCarrier : (lastCarrier != null ? lastCarrier : null));
        }

        public void addPropertyChangeListeners() {
            EuropePanel.this.europe.addPropertyChangeListener(this);
        }

        public void removePropertyChangeListeners() {
            EuropePanel.this.europe.removePropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            logger.finest("Europe-port change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
            this.update();
        }
    }

    public final class DestinationPanel
    extends JPanel {
        private Location destination;

        public void initialize(Location destination) {
            this.destination = destination;
            this.update();
        }

        public void cleanup() {
        }

        public void update() {
            this.removeAll();
            HighSeas highSeas = EuropePanel.this.getMyPlayer().getHighSeas();
            if (highSeas != null) {
                for (Unit unit : highSeas.getUnitList()) {
                    boolean belongs;
                    if (this.destination instanceof Europe) {
                        belongs = unit.getDestination() == this.destination;
                    } else if (this.destination instanceof Map) {
                        belongs = unit.getDestination() == this.destination || unit.getDestination() != null && unit.getDestination().getTile() != null && unit.getDestination().getTile().getMap() == this.destination;
                    } else {
                        logger.warning("Bogus DestinationPanel location: " + (FreeColGameObject)((Object)this.destination) + " for unit: " + unit);
                        belongs = false;
                    }
                    if (!belongs) continue;
                    UnitLabel unitLabel = new UnitLabel(EuropePanel.this.getFreeColClient(), unit, EuropePanel.this.getGUI());
                    unitLabel.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                    unitLabel.addMouseListener(EuropePanel.this.pressListener);
                    this.add(unitLabel);
                }
            }
            StringTemplate t = StringTemplate.template("sailingTo").addStringTemplate("%location%", this.destination.getLocationNameFor(EuropePanel.this.getMyPlayer()));
            ((TitledBorder)this.getBorder()).setTitle(Messages.message(t));
            this.revalidate();
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                boolean leave;
                if (!(comp instanceof UnitLabel)) {
                    logger.warning("Invalid component dropped on this DestinationPanel.");
                    return null;
                }
                Unit unit = ((UnitLabel)comp).getUnit();
                Location dest = this.destination;
                if (unit.isInEurope() && (dest = EuropePanel.this.getGUI().showSelectDestinationDialog(unit)) == null) {
                    return null;
                }
                ClientOptions co = EuropePanel.this.getClientOptions();
                if (!co.getBoolean("model.option.autoloadEmigrants") && unit.isInEurope() && !(this.destination instanceof Europe) && EuropePanel.this.docksPanel.getComponentCount() > 0 && unit.getSpaceLeft() > 0 && !(leave = EuropePanel.this.getGUI().showConfirmDialog(null, StringTemplate.template("europe.leaveColonists").addStringTemplate("%newWorld%", this.destination.getLocationNameFor(unit.getOwner())), "yes", "no"))) {
                    return null;
                }
                comp.getParent().remove(comp);
                EuropePanel.this.getController().moveTo(unit, dest);
                EuropePanel.this.inPortPanel.update();
                EuropePanel.this.docksPanel.update();
            }
            Component c = this.add(comp);
            this.revalidate();
            EuropePanel.this.refresh();
            return c;
        }
    }

    public final class EuropeCargoPanel
    extends CargoPanel {
        public EuropeCargoPanel(FreeColClient freeColClient, GUI gui) {
            super(freeColClient, gui, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EuropeAction {
        EXIT,
        RECRUIT,
        PURCHASE,
        TRAIN,
        UNLOAD,
        SAIL;

    }
}

