/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeColPanel
extends JPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(FreeColPanel.class.getName());
    protected static final String OK = "OK";
    protected static final String HELP = "HELP";
    public static final Insets emptyMargin = new Insets(0, 0, 0, 0);
    private static final int cancelKeyCode = 27;
    protected static final DecimalFormat modifierFormat = new DecimalFormat("0.00");
    protected static final Font defaultFont = ResourceManager.getFont("NormalFont", 13.0f);
    protected static final Font smallHeaderFont = ResourceManager.getFont("HeaderFont", 24.0f);
    protected static final Font mediumHeaderFont = ResourceManager.getFont("HeaderFont", 36.0f);
    protected static final Font bigHeaderFont = ResourceManager.getFont("HeaderFont", 48.0f);
    protected static final int COLUMNS = 20;
    protected static final int margin = 3;
    protected static final Color WARNING_COLOR = ResourceManager.getColor("lookAndFeel.warning.color");
    protected static final Color LINK_COLOR = ResourceManager.getColor("lookAndFeel.link.color");
    protected static final Color BORDER_COLOR = ResourceManager.getColor("lookAndFeel.border.color");
    public static final Border TOPCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border CELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border LEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border TOPLEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    protected boolean editable = true;
    protected JButton okButton = new JButton(Messages.message("ok"));
    private FreeColClient freeColClient;
    private GUI gui;
    protected static StyleContext styleContext = new StyleContext();

    public static void enterPressesWhenFocused(JButton button) {
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    public static JTextPane getDefaultTextPane() {
        return FreeColPanel.getDefaultTextPane(null);
    }

    public static JTextPane getDefaultTextPane(String text) {
        DefaultStyledDocument document = new DefaultStyledDocument(styleContext){

            public Font getFont(AttributeSet attr) {
                Font font = ResourceManager.getFont(StyleConstants.getFontFamily(attr), StyleConstants.getFontSize(attr));
                if (font == null) {
                    return super.getFont(attr);
                }
                int fontStyle = 0;
                if (StyleConstants.isBold(attr)) {
                    fontStyle |= 1;
                }
                if (StyleConstants.isItalic(attr)) {
                    fontStyle |= 2;
                }
                return fontStyle == 0 ? font : font.deriveFont(fontStyle);
            }
        };
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setLogicalStyle(styleContext.getStyle("regular"));
        textPane.setText(text);
        return textPane;
    }

    public static JButton getLinkButton(String text, Icon icon, String action) {
        JButton button = new JButton(text, icon);
        button.setMargin(emptyMargin);
        button.setOpaque(false);
        button.setForeground(LINK_COLOR);
        button.setAlignmentY(0.8f);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setActionCommand(action);
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    public static final DecimalFormat getModifierFormat() {
        return modifierFormat;
    }

    protected static JLabel getDefaultHeader(String text) {
        JLabel header = new JLabel(text, 0);
        header.setFont(bigHeaderFont);
        header.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        return header;
    }

    protected static JTextArea getDefaultTextArea(String text) {
        return FreeColPanel.getDefaultTextArea(text, 20);
    }

    protected static JTextArea getDefaultTextArea(String text, int columns) {
        JTextArea textArea = new JTextArea(text);
        textArea.setColumns(columns);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setFont(defaultFont);
        textArea.setSize(textArea.getPreferredSize());
        return textArea;
    }

    public FreeColPanel(FreeColClient freeColClient, GUI gui) {
        this(freeColClient, gui, new FlowLayout());
    }

    public FreeColPanel(FreeColClient freeColClient, GUI gui, LayoutManager layout) {
        super(layout);
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.setFocusCycleRoot(true);
        this.setBorder(FreeColImageBorder.imageBorder);
        this.addMouseListener(new MouseAdapter(){});
        this.okButton.setActionCommand(OK);
        this.okButton.addActionListener(this);
        FreeColPanel.enterPressesWhenFocused(this.okButton);
        this.setCancelComponent(this.okButton);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(OK)) {
            this.getGUI().removeFromCanvas(this);
        }
    }

    public void addClosingCallback(final Runnable runnable) {
        final FreeColPanel fcp = this;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if ("closing".equals(e.getPropertyName())) {
                    runnable.run();
                    fcp.removePropertyChangeListener(this);
                }
            }
        });
    }

    public Point getSavedPosition() {
        try {
            return new Point(this.getInteger(".x"), this.getInteger(".y"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void notifyClose() {
        this.firePropertyChange("closing", false, true);
        Container frame = SwingUtilities.getAncestorOfClass(JInternalFrame.class, this);
        if (frame != null && this.getClientOptions() != null && this.getClientOptions().getBoolean("model.option.rememberPanelPositions")) {
            this.saveInteger(".x", frame.getLocation().x);
            this.saveInteger(".y", frame.getLocation().y);
        }
        this.saveSize();
    }

    @Override
    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void setCancelComponent(AbstractButton cancelButton) {
        if (cancelButton == null) {
            throw new NullPointerException();
        }
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "release");
        Action cancelAction = cancelButton.getAction();
        this.getActionMap().put("release", cancelAction);
    }

    protected JButton createColonyButton(Colony colony) {
        JButton button = FreeColPanel.getLinkButton(colony.getName(), null, colony.getId());
        button.addActionListener(this);
        return button;
    }

    protected final Canvas getCanvas() {
        return this.gui.getCanvas();
    }

    protected ClientOptions getClientOptions() {
        return this.freeColClient == null ? null : this.freeColClient.getClientOptions();
    }

    protected InGameController getController() {
        return this.freeColClient.getInGameController();
    }

    protected Map<String, Turn> getElectionTurns() {
        HashMap<String, Turn> result = new HashMap<String, Turn>();
        if (!this.getMyPlayer().getFathers().isEmpty()) {
            for (HistoryEvent event : this.getMyPlayer().getHistory()) {
                if (event.getEventType() != HistoryEvent.EventType.FOUNDING_FATHER) continue;
                result.put(event.getReplacement("%father%").getId(), event.getTurn());
            }
        }
        return result;
    }

    protected FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    protected Game getGame() {
        return this.freeColClient.getGame();
    }

    protected GUI getGUI() {
        return this.gui;
    }

    protected ImageLibrary getLibrary() {
        return this.gui.getImageLibrary();
    }

    protected Player getMyPlayer() {
        return this.freeColClient.getMyPlayer();
    }

    protected final Dimension getSavedSize() {
        try {
            return new Dimension(this.getInteger(".w"), this.getInteger(".h"));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<Colony> getSortedColonies() {
        return this.freeColClient.getClientOptions().getSortedColonies(this.getMyPlayer());
    }

    protected Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    protected boolean isEditable() {
        return this.editable;
    }

    protected JLabel localizedLabel(String key) {
        return new JLabel(Messages.message(key));
    }

    protected JLabel localizedLabel(StringTemplate template) {
        return new JLabel(Messages.message(template));
    }

    protected void restoreSavedSize(Dimension d) {
        Dimension size = this.getSavedSize();
        if (size == null) {
            size = d;
            this.saveSize(size);
        }
        if (!this.getPreferredSize().equals(size)) {
            this.setPreferredSize(size);
        }
    }

    protected void restoreSavedSize(int w, int h) {
        this.restoreSavedSize(new Dimension(w, h));
    }

    protected void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    protected Set<Modifier> sortModifiers(Set<Modifier> result) {
        EnumMap modifierMap = new EnumMap(Modifier.Type.class);
        for (Modifier.Type type : Modifier.Type.values()) {
            modifierMap.put(type, new ArrayList());
        }
        for (Modifier modifier : result) {
            ((List)modifierMap.get((Object)modifier.getType())).add(modifier);
        }
        LinkedHashSet<Modifier> sortedResult = new LinkedHashSet<Modifier>();
        for (Modifier.Type type : Modifier.Type.values()) {
            sortedResult.addAll((Collection)modifierMap.get((Object)type));
        }
        return sortedResult;
    }

    private int getInteger(String key) {
        return this.freeColClient.getClientOptions().getInteger(this.getClass().getName() + key);
    }

    private void saveInteger(String key, int value) {
        if (this.freeColClient != null && this.freeColClient.getClientOptions() != null) {
            Option o = this.freeColClient.getClientOptions().getOption(this.getClass().getName() + key);
            if (o == null) {
                IntegerOption io = new IntegerOption(this.getClass().getName() + key);
                io.setValue(value);
                this.freeColClient.getClientOptions().add(io);
            } else if (o instanceof IntegerOption) {
                ((IntegerOption)o).setValue(value);
            }
        }
    }

    private void saveSize() {
        this.saveSize(this.getSize());
    }

    private void saveSize(Dimension size) {
        this.saveInteger(".w", size.width);
        this.saveInteger(".h", size.height);
    }

    static {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = styleContext.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(regular, "NormalFont");
        StyleConstants.setFontSize(regular, 13);
        Style buttonStyle = styleContext.addStyle("button", regular);
        StyleConstants.setForeground(buttonStyle, LINK_COLOR);
        Style right = styleContext.addStyle("right", regular);
        StyleConstants.setAlignment(right, 2);
    }
}

