/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;

public final class ReportReligiousPanel
extends ReportPanel {
    public ReportReligiousPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, Messages.message("reportReligionAction.name"));
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 5, gap 20 20", "", ""));
        Player player = this.getMyPlayer();
        this.reportPanel.add(new JLabel(Messages.message("crosses")));
        GoodsType crosses = this.getSpecification().getGoodsType("model.goods.crosses");
        FreeColProgressBar progressBar = new FreeColProgressBar(this.getGUI(), crosses);
        this.reportPanel.add((Component)progressBar, "span");
        List<Colony> colonies = this.getSortedColonies();
        int production = 0;
        for (Colony colony : colonies) {
            Building building = colony.getBuildingForProducing(crosses);
            this.reportPanel.add((Component)this.createColonyButton(colony), "split 2, flowy, align center");
            this.reportPanel.add(new BuildingPanel(this.getFreeColClient(), building, this.getGUI()));
            production += colony.getNetProductionOf(crosses);
        }
        progressBar.update(0, player.getImmigrationRequired(), player.getImmigration(), production);
    }
}

