/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RiverStylePanel
extends FreeColDialog<Integer> {
    private static final Logger logger = Logger.getLogger(RiverStylePanel.class.getName());
    private static final int CANCEL = -1;
    private static final int DELETE = 0;

    public RiverStylePanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
        this.setLayout(new BorderLayout());
        JPanel stylesPanel = new JPanel(new GridLayout(9, 9));
        JButton deleteButton = new JButton(new ImageIcon(this.getLibrary().getMiscImage("delete.image", 0.5)));
        deleteButton.setActionCommand(String.valueOf(0));
        deleteButton.addActionListener(this);
        stylesPanel.add(deleteButton);
        for (int index = 1; index < 81; ++index) {
            JButton riverButton = new JButton(new ImageIcon(this.getLibrary().getRiverImage(index, 0.5)));
            riverButton.setActionCommand(String.valueOf(index));
            riverButton.addActionListener(this);
            stylesPanel.add(riverButton);
        }
        this.add((Component)stylesPanel, "Center");
        JButton cancelButton = new JButton(Messages.message("cancel"));
        cancelButton.setActionCommand(String.valueOf(-1));
        cancelButton.addActionListener(this);
        cancelButton.setMnemonic('C');
        this.add((Component)cancelButton, "South");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int style = Integer.parseInt(event.getActionCommand());
        this.setResponse(new Integer(style));
    }
}

