/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.TileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainDetailPanel
extends ColopediaGameObjectTypePanel<TileType> {
    public TerrainDetailPanel(FreeColClient freeColClient, GUI gui, ColopediaPanel colopediaPanel) {
        super(freeColClient, gui, colopediaPanel, ColopediaAction.PanelType.TERRAIN.toString(), 0.25);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        for (TileType t : this.getSpecification().getTileTypeList()) {
            ImageIcon icon = new ImageIcon(this.getLibrary().getCompoundTerrainImage(t, this.getScale()));
            node.add(this.buildItem(t, icon));
        }
        root.add(node);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        TileType tileType = this.getSpecification().getTileType(id);
        panel.setLayout((LayoutManager)new MigLayout("wrap 4, gap 20"));
        String movementCost = String.valueOf(tileType.getBasicMoveCost() / 3);
        String defenseBonus = Messages.message("none");
        Set<Modifier> defenceModifiers = tileType.getDefenceBonus();
        if (!defenceModifiers.isEmpty()) {
            defenseBonus = this.getModifierAsString(defenceModifiers.iterator().next());
        }
        JLabel nameLabel = this.localizedLabel(tileType.getNameKey());
        nameLabel.setFont(smallHeaderFont);
        panel.add((Component)nameLabel, "span, align center");
        panel.add((Component)this.localizedLabel("colopedia.terrain.terrainImage"), "spany 3");
        Image terrainImage = this.getLibrary().getCompoundTerrainImage(tileType, 1.0);
        panel.add((Component)new JLabel(new ImageIcon(terrainImage)), "spany 3");
        List<ResourceType> resourceList = tileType.getResourceTypeList();
        if (resourceList.size() > 0) {
            panel.add(this.localizedLabel("colopedia.terrain.resource"));
            if (resourceList.size() > 1) {
                panel.add((Component)this.getResourceButton(resourceList.get(0)), "split " + resourceList.size());
                for (int index = 1; index < resourceList.size(); ++index) {
                    panel.add(this.getResourceButton(resourceList.get(index)));
                }
            } else {
                panel.add(this.getResourceButton(resourceList.get(0)));
            }
        } else {
            panel.add((Component)new JLabel(), "wrap");
        }
        panel.add(this.localizedLabel("colopedia.terrain.movementCost"));
        panel.add(new JLabel(movementCost));
        panel.add(this.localizedLabel("colopedia.terrain.defenseBonus"));
        panel.add(new JLabel(defenseBonus));
        panel.add(this.localizedLabel("colopedia.terrain.production"));
        List<AbstractGoods> production = tileType.getProduction();
        if (production.size() > 0) {
            AbstractGoods goods = production.get(0);
            if (production.size() > 1) {
                panel.add((Component)this.getGoodsButton(goods.getType(), goods.getAmount()), "span, split " + production.size());
                for (int index = 1; index < production.size(); ++index) {
                    goods = production.get(index);
                    panel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
                }
            } else {
                panel.add((Component)this.getGoodsButton(goods.getType(), goods.getAmount()), "span");
            }
        } else {
            panel.add((Component)new JLabel(), "wrap");
        }
        panel.add(this.localizedLabel("colopedia.terrain.description"));
        panel.add((Component)TerrainDetailPanel.getDefaultTextArea(Messages.message(tileType.getDescriptionKey()), 20), "span, growx");
    }
}

