/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import net.sf.freecol.client.gui.action.ActionManager;

public final class UnitButton
extends JButton {
    private String actionId;
    private ActionManager am;

    public UnitButton(ActionManager am, String actionId) {
        super(am.getFreeColAction(actionId));
        this.actionId = actionId;
        this.am = am;
    }

    public void refreshAction() {
        this.setAction(null);
        this.setAction(this.am.getFreeColAction(this.actionId));
    }

    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        if (a != null) {
            this.setRolloverEnabled(true);
            Icon bi = (Icon)a.getValue("BUTTON_IMAGE");
            this.setIcon(bi);
            this.setRolloverIcon((Icon)a.getValue("BUTTON_ROLLOVER_IMAGE"));
            this.setPressedIcon((Icon)a.getValue("BUTTON_PRESSED_IMAGE"));
            this.setDisabledIcon((Icon)a.getValue("BUTTON_DISABLED_IMAGE"));
            this.setToolTipText((String)a.getValue("Name"));
            this.setText(null);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            if (bi == null) {
                throw new IllegalArgumentException("The given action is missing \"BUTTON_IMAGE\".");
            }
            this.setSize(bi.getIconWidth(), bi.getIconHeight());
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new UnitButtonActionPropertyChangeListener(this);
    }

    private static class UnitButtonActionPropertyChangeListener
    implements PropertyChangeListener {
        private AbstractButton button;

        UnitButtonActionPropertyChangeListener(AbstractButton button) {
            this.button = button;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name") || e.getPropertyName().equals("ShortDescription")) {
                String text = (String)e.getNewValue();
                this.button.setToolTipText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
                this.button.repaint();
            } else if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setIcon(icon);
                this.button.repaint();
            } else if (e.getPropertyName().equals("BUTTON_IMAGE")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setIcon(icon);
                this.button.repaint();
            } else if (e.getPropertyName().equals("BUTTON_ROLLOVER_IMAGE")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setRolloverIcon(icon);
                this.button.repaint();
            } else if (e.getPropertyName().equals("BUTTON_PRESSED_IMAGE")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setPressedIcon(icon);
                this.button.repaint();
            } else if (e.getPropertyName().equals("BUTTON_DISABLED_IMAGE")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setDisabledIcon(icon);
                this.button.repaint();
            } else if (e.getPropertyName().equals("MnemonicKey")) {
                Integer mn = (Integer)e.getNewValue();
                this.button.setMnemonic(mn);
                this.button.repaint();
            } else if (e.getPropertyName().equals("ActionCommandKey")) {
                this.button.setActionCommand((String)e.getNewValue());
            }
        }
    }
}

