/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WarehouseDialog
extends FreeColDialog<Boolean> {
    private static final Logger logger = Logger.getLogger(WarehouseDialog.class.getName());
    private final JPanel warehouseDialog = new JPanel((LayoutManager)new MigLayout("wrap 4"));

    public WarehouseDialog(FreeColClient freeColClient, GUI gui, Colony colony) {
        super(freeColClient, gui);
        this.warehouseDialog.setOpaque(false);
        JScrollPane scrollPane = new JScrollPane(this.warehouseDialog, 20, 30);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.setCancelComponent(this.cancelButton);
        this.setLayout((LayoutManager)new MigLayout("fill, wrap 1", "", ""));
        this.add((Component)WarehouseDialog.getDefaultHeader(Messages.message("warehouseDialog.name")), "align center");
        this.add((Component)scrollPane, "grow");
        this.add((Component)this.okButton, "newline 20, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            this.warehouseDialog.add(new WarehouseGoodsPanel(colony, goodsType));
        }
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.setResponse(Boolean.TRUE);
            for (Component c : this.warehouseDialog.getComponents()) {
                if (!(c instanceof WarehouseGoodsPanel)) continue;
                ((WarehouseGoodsPanel)c).saveSettings();
            }
        } else if ("CANCEL".equals(command)) {
            this.getGUI().removeFromCanvas(this);
            this.setResponse(Boolean.FALSE);
        } else {
            logger.warning("Invalid ActionCommand: " + command);
        }
    }

    public class WarehouseGoodsPanel
    extends JPanel {
        private final Colony colony;
        private final GoodsType goodsType;
        private final JCheckBox export;
        private final JSpinner lowLevel;
        private final JSpinner highLevel;
        private final JSpinner exportLevel;

        public WarehouseGoodsPanel(Colony colony, GoodsType goodsType) {
            this.colony = colony;
            this.goodsType = goodsType;
            this.setLayout((LayoutManager)new MigLayout("wrap 2", "", ""));
            this.setOpaque(false);
            String goodsName = Messages.message(goodsType.getNameKey());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(goodsName), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
            ExportData exportData = colony.getExportData(goodsType);
            Goods goods = new Goods(colony.getGame(), colony, goodsType, colony.getGoodsContainer().getGoodsCount(goodsType));
            GoodsLabel goodsLabel = new GoodsLabel(goods, WarehouseDialog.this.getGUI());
            goodsLabel.setHorizontalAlignment(10);
            this.add((Component)goodsLabel, "span 1 2");
            SpinnerNumberModel lowLevelModel = new SpinnerNumberModel(exportData.getLowLevel(), 0, 100, 1);
            this.lowLevel = new JSpinner(lowLevelModel);
            this.lowLevel.setToolTipText(Messages.message("warehouseDialog.lowLevel.shortDescription"));
            this.add(this.lowLevel);
            SpinnerNumberModel highLevelModel = new SpinnerNumberModel(exportData.getHighLevel(), 0, 100, 1);
            this.highLevel = new JSpinner(highLevelModel);
            this.highLevel.setToolTipText(Messages.message("warehouseDialog.highLevel.shortDescription"));
            this.add(this.highLevel);
            this.export = new JCheckBox(Messages.message("warehouseDialog.export"), exportData.isExported());
            this.export.setToolTipText(Messages.message("warehouseDialog.export.shortDescription"));
            if (!colony.hasAbility("model.ability.export")) {
                this.export.setEnabled(false);
            }
            this.add(this.export);
            SpinnerNumberModel exportLevelModel = new SpinnerNumberModel(exportData.getExportLevel(), 0, colony.getWarehouseCapacity(), 1);
            this.exportLevel = new JSpinner(exportLevelModel);
            this.exportLevel.setToolTipText(Messages.message("warehouseDialog.exportLevel.shortDescription"));
            this.add(this.exportLevel);
            this.setSize(this.getPreferredSize());
        }

        public void saveSettings() {
            int lowLevelValue = ((SpinnerNumberModel)this.lowLevel.getModel()).getNumber().intValue();
            int highLevelValue = ((SpinnerNumberModel)this.highLevel.getModel()).getNumber().intValue();
            int exportLevelValue = ((SpinnerNumberModel)this.exportLevel.getModel()).getNumber().intValue();
            ExportData exportData = this.colony.getExportData(this.goodsType);
            boolean changed = this.export.isSelected() != exportData.isExported() || lowLevelValue != exportData.getLowLevel() || highLevelValue != exportData.getHighLevel() || exportLevelValue != exportData.getExportLevel();
            exportData.setExported(this.export.isSelected());
            exportData.setLowLevel(lowLevelValue);
            exportData.setHighLevel(highLevelValue);
            exportData.setExportLevel(exportLevelValue);
            if (changed) {
                WarehouseDialog.this.getController().setGoodsLevels(this.colony, this.goodsType);
            }
        }

        public String getUIClassID() {
            return "WarehouseGoodsPanelUI";
        }
    }
}

