/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.sound;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.PercentageOption;

public class SoundPlayer {
    private static Logger logger = Logger.getLogger(SoundPlayer.class.getName());
    private Mixer mixer;
    private int volume;
    private SoundPlayerThread soundPlayerThread;

    public SoundPlayer(AudioMixerOption mixerOption, PercentageOption volumeOption) {
        this.setMixer(mixerOption.getValue());
        if (this.mixer == null) {
            throw new IllegalStateException("Mixer unavailable.");
        }
        mixerOption.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SoundPlayer.this.setMixer((AudioMixerOption.MixerWrapper)e.getNewValue());
            }
        });
        this.setVolume(volumeOption.getValue());
        volumeOption.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SoundPlayer.this.setVolume((Integer)e.getNewValue());
            }
        });
        this.soundPlayerThread = new SoundPlayerThread();
        this.soundPlayerThread.start();
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    private void setMixer(AudioMixerOption.MixerWrapper mw) {
        try {
            this.mixer = AudioSystem.getMixer(mw.getMixerInfo());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not set mixer", e);
            this.mixer = null;
        }
    }

    public int getVolume() {
        return this.volume;
    }

    private void setVolume(int volume) {
        this.volume = volume;
    }

    public void playOnce(File file) {
        if (this.getMixer() == null) {
            return;
        }
        this.soundPlayerThread.add(file);
        this.soundPlayerThread.awaken();
    }

    public void stop() {
        this.soundPlayerThread.stopPlaying();
        this.soundPlayerThread.awaken();
    }

    private class SoundPlayerThread
    extends Thread {
        private final List<File> playList;
        private boolean playDone;

        public SoundPlayerThread() {
            super("FreeColClient:SoundPlayer");
            this.playList = new ArrayList<File>();
            this.playDone = true;
        }

        private synchronized void awaken() {
            this.notify();
        }

        private synchronized void goToSleep() throws InterruptedException {
            this.wait();
        }

        public synchronized boolean keepPlaying() {
            return !this.playDone;
        }

        public synchronized void startPlaying() {
            this.playDone = false;
        }

        public synchronized void stopPlaying() {
            this.playDone = true;
        }

        public synchronized void add(File file) {
            this.playList.add(file);
        }

        public void run() {
            while (true) {
                if (this.playList.isEmpty()) {
                    try {
                        this.goToSleep();
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                this.playSound(this.playList.remove(0));
            }
        }

        private void sleep(int t) {
            try {
                Thread.sleep(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void setVolume(SourceDataLine line, int vol) {
            try {
                FloatControl control = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                if (control != null) {
                    float gain = vol <= 0 ? control.getMinimum() : (vol >= 100 ? control.getMaximum() : 20.0f * (float)Math.log10(0.01f * (float)vol));
                    control.setValue(gain);
                    logger.finest("Using volume " + vol + "%, gain = " + gain);
                } else {
                    logger.warning("No master gain control, unable to change the volume.");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not set volume", e);
            }
        }

        private SourceDataLine openLine(AudioFormat audioFormat) {
            SourceDataLine line = null;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                line = (SourceDataLine)SoundPlayer.this.mixer.getLine(info);
                line.open(audioFormat);
                line.start();
                this.setVolume(line, SoundPlayer.this.volume);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Can not open SourceDataLine", e);
            }
            return line;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean playSound(File file) {
            AudioInputStream in;
            BufferedInputStream bis;
            try {
                bis = new BufferedInputStream(new FileInputStream(file));
                bis.mark(1000);
                bis.skip(1L);
                bis.reset();
            }
            catch (FileNotFoundException e) {
                logger.warning("Could not find audio file: " + file.getName());
                return false;
            }
            catch (IOException e) {
                logger.warning("Could not prepare stream for: " + file.getName());
                return false;
            }
            try {
                in = AudioSystem.getAudioInputStream(bis);
            }
            catch (Exception e) {
                logger.warning("Could not get audio input stream for: " + file.getName());
                return false;
            }
            boolean ret = false;
            AudioFormat baseFormat = in.getFormat();
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), baseFormat.isBigEndian());
            AudioInputStream din = AudioSystem.getAudioInputStream(decodedFormat, in);
            if (din == null) {
                logger.warning("Can not get decoded audio input stream");
            } else {
                SourceDataLine line = this.openLine(decodedFormat);
                if (line != null) {
                    try {
                        this.startPlaying();
                        this.rawplay(din, line);
                        ret = true;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Error playing: " + file.getName(), e);
                    }
                    finally {
                        this.stopPlaying();
                        line.drain();
                        line.stop();
                        line.close();
                    }
                }
            }
            try {
                if (din != null) {
                    din.close();
                }
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return ret;
        }

        private void rawplay(AudioInputStream din, SourceDataLine lin) throws IOException {
            int read;
            byte[] data = new byte[8192];
            while (this.keepPlaying() && (read = din.read(data, 0, data.length)) >= 0) {
                if (read > 0) {
                    lin.write(data, 0, read);
                    continue;
                }
                this.sleep(50);
            }
        }
    }
}

