/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColTcFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mods {
    private static final Logger logger = Logger.getLogger(Mods.class.getName());
    private static final Map<String, FreeColModFile> allMods = new HashMap<String, FreeColModFile>();
    public static final FileFilter MOD_FILTER = new FileFilter(){

        public boolean accept(File f) {
            String name = f.getName();
            if (name.startsWith(".")) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            for (String ending : FreeColModFile.FILE_ENDINGS) {
                if (!name.endsWith(ending)) continue;
                return true;
            }
            return false;
        }
    };

    public static FreeColModFile getModFile(File file) {
        try {
            return new FreeColModFile(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static FreeColModFile getModFile(String id) {
        return allMods.get(id);
    }

    private static void getDirectoryMods(File directory) {
        if (directory != null && directory.isDirectory()) {
            for (File f : directory.listFiles(MOD_FILTER)) {
                FreeColModFile fcmf = Mods.getModFile(f);
                if (fcmf != null) {
                    allMods.put(fcmf.getId(), fcmf);
                    continue;
                }
                logger.warning("Failed to load mod from: " + f.getName());
            }
        }
    }

    public static Collection<FreeColModFile> getAllMods() {
        return allMods.values();
    }

    public static List<FreeColTcFile> getRuleSets() {
        ArrayList<FreeColTcFile> result = new ArrayList<FreeColTcFile>();
        File directory = FreeColTcFile.getRulesDirectory();
        for (File dir : directory.listFiles()) {
            File modDescription;
            if (!dir.isDirectory() || !(modDescription = new File(dir, "mod.xml")).exists()) continue;
            try {
                result.add(new FreeColTcFile(dir));
            }
            catch (IOException e) {
                logger.warning("Failed to create rule set " + dir);
            }
        }
        return result;
    }

    static {
        Mods.getDirectoryMods(FreeCol.getUserModsDirectory());
        Mods.getDirectoryMods(FreeCol.getStandardModsDirectory());
    }
}

