/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;

public class ColonyWas {
    private static final Logger logger = Logger.getLogger(ColonyWas.class.getName());
    private Colony colony;
    private int population;
    private int productionBonus;
    private List<BuildableType> buildQueue;

    public ColonyWas(Colony colony) {
        this.colony = colony;
        this.population = colony.getUnitCount();
        this.productionBonus = colony.getProductionBonus();
        this.buildQueue = new ArrayList<BuildableType>(colony.getBuildQueue());
        if (colony.getGoodsContainer() != null) {
            colony.getGoodsContainer().saveState();
        }
    }

    public void fireChanges() {
        List<BuildableType> newBuildQueue;
        int newProductionBonus;
        int newPopulation = this.colony.getUnitCount();
        if (newPopulation != this.population) {
            String pc = Colony.ColonyChangeEvent.POPULATION_CHANGE.toString();
            this.colony.firePropertyChange(pc, this.population, newPopulation);
        }
        if ((newProductionBonus = this.colony.getProductionBonus()) != this.productionBonus) {
            String pc = Colony.ColonyChangeEvent.BONUS_CHANGE.toString();
            this.colony.firePropertyChange(pc, this.productionBonus, newProductionBonus);
        }
        if (!((Object)(newBuildQueue = this.colony.getBuildQueue())).equals(this.buildQueue)) {
            String pc = Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString();
            this.colony.firePropertyChange(pc, this.buildQueue, newBuildQueue);
        }
        if (this.colony.getGoodsContainer() != null) {
            this.colony.getGoodsContainer().fireChanges();
        }
    }
}

