/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentType
extends BuildableType {
    public static final EquipmentType[] NO_EQUIPMENT = new EquipmentType[0];
    private int maximumCount = 1;
    private int combatLossPriority;
    private String captureEquipmentId = null;
    private boolean captureEquipmentByIndians = false;
    private Unit.Role role;
    private boolean militaryEquipment;
    private List<String> compatibleEquipment = new ArrayList<String>();

    public EquipmentType(String id, Specification specification) {
        super(id, specification);
    }

    public final int getMaximumCount() {
        return this.maximumCount;
    }

    public final void setMaximumCount(int newMaximumCount) {
        this.maximumCount = newMaximumCount;
    }

    public final Unit.Role getRole() {
        return this.role;
    }

    public final void setRole(Unit.Role newRole) {
        this.role = newRole;
    }

    public final int getCombatLossPriority() {
        return this.combatLossPriority;
    }

    public final void setCombatLossPriority(int newCombatLossPriority) {
        this.combatLossPriority = newCombatLossPriority;
    }

    public boolean canBeCaptured() {
        return this.combatLossPriority > 0;
    }

    public EquipmentType getCaptureEquipment(boolean byIndians) {
        return this.captureEquipmentId != null && byIndians == this.captureEquipmentByIndians ? this.getSpecification().getEquipmentType(this.captureEquipmentId) : this;
    }

    public Map<String, Boolean> getUnitAbilitiesRequired() {
        return this.getAbilitiesRequired();
    }

    public boolean isCompatibleWith(EquipmentType otherType) {
        if (this.getId().equals(otherType.getId())) {
            return true;
        }
        return this.compatibleEquipment.contains(otherType.getId()) && otherType.compatibleEquipment.contains(this.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compatibleEquipment == null ? 0 : ((Object)this.compatibleEquipment).hashCode());
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EquipmentType other = (EquipmentType)obj;
        if (this.compatibleEquipment == null ? other.compatibleEquipment != null : !((Object)this.compatibleEquipment).equals(other.compatibleEquipment)) {
            return false;
        }
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public final boolean isMilitaryEquipment() {
        return this.militaryEquipment;
    }

    public final void setMilitaryEquipment(boolean newMilitaryEquipment) {
        this.militaryEquipment = newMilitaryEquipment;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, EquipmentType.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("maximum-count", Integer.toString(this.maximumCount));
        out.writeAttribute("combat-loss-priority", Integer.toString(this.combatLossPriority));
        out.writeAttribute("role", this.role.toString().toLowerCase(Locale.US));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (String compatible : this.compatibleEquipment) {
            out.writeStartElement("compatible-equipment");
            out.writeAttribute("id", compatible);
            out.writeEndElement();
        }
        if (this.captureEquipmentId != null) {
            out.writeStartElement("capture-equipment");
            out.writeAttribute("id", this.captureEquipmentId);
            out.writeAttribute("by-indians", Boolean.toString(this.captureEquipmentByIndians));
            out.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.maximumCount = this.getAttribute(in, "maximum-count", 1);
        this.combatLossPriority = this.getAttribute(in, "combat-loss-priority", -1);
        String roleString = this.getAttribute(in, "role", "default");
        this.role = Enum.valueOf(Unit.Role.class, roleString.toUpperCase(Locale.US));
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        super.readChildren(in);
        for (Modifier modifier : this.getFeatureContainer().getModifiers()) {
            if (!modifier.getId().equals("model.modifier.offence") && !modifier.getId().equals("model.modifier.defence")) continue;
            this.militaryEquipment = true;
            for (AbstractGoods goods : this.getGoodsRequired()) {
                goods.getType().setMilitaryGoods(true);
            }
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String nodeName = in.getLocalName();
        if ("required-location-ability".equals(nodeName)) {
            String abilityId = in.getAttributeValue(null, "id");
            boolean value = EquipmentType.getAttribute(in, "value", true);
            this.getAbilitiesRequired().put(abilityId, value);
            this.getSpecification().addAbility(abilityId);
            in.nextTag();
        } else if ("compatible-equipment".equals(nodeName)) {
            String equipmentId = in.getAttributeValue(null, "id");
            this.compatibleEquipment.add(equipmentId);
            in.nextTag();
        } else if ("capture-equipment".equals(nodeName)) {
            this.captureEquipmentId = in.getAttributeValue(null, "id");
            this.captureEquipmentByIndians = EquipmentType.getAttribute(in, "by-indians", false);
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "equipment-type";
    }
}

