/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;

public class Europe
extends UnitLocation
implements Ownable,
Named {
    private static final Logger logger = Logger.getLogger(Europe.class.getName());
    private static final int RECRUIT_PRICE_INITIAL = 200;
    private static final int LOWER_CAP_INITIAL = 80;
    public static final String UNIT_CHANGE = "unitChange";
    private UnitType[] recruitables = new UnitType[]{null, null, null};
    public static final int RECRUIT_COUNT = 3;
    protected Map<UnitType, Integer> unitPrices = new HashMap<UnitType, Integer>();
    private int recruitPrice;
    private int recruitLowerCap;
    private Player owner;
    private FeatureContainer featureContainer;

    protected Europe() {
    }

    protected Europe(Game game, Player owner) {
        super(game);
        this.owner = owner;
        this.recruitPrice = 200;
        this.recruitLowerCap = 80;
    }

    public Europe(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Europe(Game game, String id) {
        super(game, id);
    }

    public boolean hasAbility(String id) {
        return this.featureContainer.hasAbility(id);
    }

    public FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    protected void setFeatureContainer(FeatureContainer container) {
        this.featureContainer = container;
    }

    public boolean hasCarrierWithSpace(int space) {
        for (Unit u : this.getUnitList()) {
            if (!u.isCarrier() || u.isUnderRepair() || u.getSpaceLeft() < space) continue;
            return true;
        }
        return false;
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        for (AbstractGoods requiredGoods : equipmentType.getGoodsRequired()) {
            GoodsType goodsType = requiredGoods.getType();
            if (this.getOwner().canTrade(goodsType) && this.getOwner().checkGold(this.getOwner().getMarket().getBidPrice(goodsType, requiredGoods.getAmount()))) continue;
            return false;
        }
        return true;
    }

    public boolean recruitablesDiffer() {
        return !this.recruitables[0].equals(this.recruitables[1]) || !this.recruitables[0].equals(this.recruitables[2]);
    }

    public UnitType getRecruitable(int slot) {
        if (slot >= 0 && slot < 3) {
            return this.recruitables[slot];
        }
        throw new IllegalArgumentException("Wrong recruitement slot: " + slot);
    }

    public void setRecruitable(int slot, UnitType type) {
        if (slot >= 0 && slot < 3) {
            this.recruitables[slot] = type;
        } else {
            logger.warning("setRecruitable: invalid slot(" + slot + ") given.");
        }
    }

    public boolean add(Locatable locatable) {
        boolean result = super.add(locatable);
        if (result && locatable instanceof Unit) {
            Unit unit;
            unit.setState((unit = (Unit)locatable).canCarryUnits() ? Unit.UnitState.ACTIVE : Unit.UnitState.SENTRY);
        }
        return result;
    }

    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Goods) {
            return true;
        }
        return super.canAdd(locatable);
    }

    public int getUnitPrice(UnitType unitType) {
        Integer price = this.unitPrices.get(unitType);
        if (price != null) {
            return price;
        }
        return unitType.getPrice();
    }

    public int getRecruitPrice() {
        int required = this.owner.getImmigrationRequired();
        int immigration = this.owner.getImmigration();
        int difference = Math.max(required - immigration, 0);
        return Math.max(this.recruitPrice * difference / required, this.recruitLowerCap);
    }

    public void increaseRecruitmentDifficulty() {
        Specification spec = this.getSpecification();
        this.recruitPrice += spec.getIntegerOption("model.option.recruitPriceIncrease").getValue().intValue();
        this.recruitLowerCap += spec.getIntegerOption("model.option.lowerCapIncrease").getValue().intValue();
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    public StringTemplate getLocationName() {
        return StringTemplate.key(this.getNameKey());
    }

    public String getNameKey() {
        return this.getOwner().getEuropeNameKey();
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Europe.getXMLElementTagName());
        super.writeAttributes(out);
        for (int index = 0; index < this.recruitables.length; ++index) {
            if (this.recruitables[index] == null) continue;
            out.writeAttribute("recruit" + index, this.recruitables[index].getId());
        }
        out.writeAttribute("recruitPrice", Integer.toString(this.recruitPrice));
        out.writeAttribute("recruitLowerCap", Integer.toString(this.recruitLowerCap));
        out.writeAttribute("owner", this.owner.getId());
        for (Map.Entry<UnitType, Integer> entry : this.unitPrices.entrySet()) {
            out.writeStartElement("unitPrice");
            out.writeAttribute("unitType", entry.getKey().getId());
            out.writeAttribute("price", entry.getValue().toString());
            out.writeEndElement();
        }
        super.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        Specification spec = this.getSpecification();
        if (this.featureContainer == null) {
            this.featureContainer = new FeatureContainer();
            this.featureContainer.addAbility(new Ability("model.ability.dressMissionary"));
        }
        for (int index = 0; index < this.recruitables.length; ++index) {
            String unitTypeId = in.getAttributeValue(null, "recruit" + index);
            if (unitTypeId == null) continue;
            this.recruitables[index] = spec.getUnitType(unitTypeId);
        }
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        this.recruitPrice = this.getAttribute(in, "recruitPrice", 200);
        this.recruitLowerCap = this.getAttribute(in, "recruitLowerCap", 80);
        this.unitPrices.clear();
        this.readChildren(in);
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (in.getLocalName().equals("units")) {
            while (in.nextTag() != 2) {
                if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                Unit unit = this.updateFreeColGameObject(in, Unit.class);
                if (unit.getLocation() == null) {
                    unit.setLocationNoUpdate(this);
                }
                this.add(unit);
            }
        } else if (in.getLocalName().equals("unitPrice")) {
            String unitTypeId = in.getAttributeValue(null, "unitType");
            Integer price = new Integer(in.getAttributeValue(null, "price"));
            this.unitPrices.put(this.getSpecification().getUnitType(unitTypeId), price);
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public String toString() {
        return "Europe";
    }

    public static String getXMLElementTagName() {
        return "europe";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MigrationType {
        NORMAL,
        RECRUIT,
        FOUNTAIN;

    }
}

