/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.MapGeneratorOptions;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game
extends FreeColGameObject {
    public static final String CIBOLA_TAG = "cibola";
    private static final Logger logger = Logger.getLogger(Game.class.getName());
    private UUID uuid = UUID.randomUUID();
    private Player unknownEnemy;
    protected List<Player> players = new ArrayList<Player>();
    private Map map;
    protected Player currentPlayer = null;
    protected Player viewOwner = null;
    protected HashMap<String, WeakReference<FreeColGameObject>> freeColGameObjects = new HashMap(10000);
    protected int nextId = 1;
    private Turn turn = new Turn(1);
    private NationOptions nationOptions;
    private boolean spanishSuccession = false;
    protected FreeColGameObjectListener freeColGameObjectListener;
    private List<String> citiesOfCibola = null;
    protected CombatModel combatModel;
    private Specification specification;

    protected Game(Specification specification) {
        super(null);
        this.specification = specification;
    }

    protected Game(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public Game(XMLStreamReader in, String viewOwnerUsername) throws XMLStreamException {
        super(null, in);
        this.combatModel = new SimpleCombatModel();
        this.readFromXML(in);
        this.viewOwner = this.getPlayerByName(viewOwnerUsername);
        this.setFreeColGameObject(this.getId(), this);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Player getUnknownEnemy() {
        return this.unknownEnemy;
    }

    public void setUnknownEnemy(Player player) {
        this.unknownEnemy = player;
    }

    public final List<Nation> getVacantNations() {
        ArrayList<Nation> result = new ArrayList<Nation>();
        for (Map.Entry<Nation, NationOptions.NationState> entry : this.nationOptions.getNations().entrySet()) {
            if (entry.getValue() != NationOptions.NationState.AVAILABLE) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Player getViewOwner() {
        return this.viewOwner;
    }

    public Settlement getSettlement(String name) {
        for (Player p : this.getPlayers()) {
            for (Settlement s : p.getSettlements()) {
                if (!name.equals(s.getName())) continue;
                return s;
            }
        }
        return null;
    }

    public Turn getTurn() {
        return this.turn;
    }

    public void setTurn(Turn newTurn) {
        this.turn = newTurn;
    }

    public final CombatModel getCombatModel() {
        return this.combatModel;
    }

    public final void setCombatModel(CombatModel newCombatModel) {
        this.combatModel = newCombatModel;
    }

    public final OptionGroup getDifficultyLevel() {
        return this.specification.getDifficultyLevel();
    }

    public void addPlayer(Player player) {
        if (player.isAI() || this.canAddNewPlayer()) {
            this.players.add(player);
            Nation nation = this.getSpecification().getNation(player.getNationID());
            this.nationOptions.getNations().put(nation, NationOptions.NationState.NOT_AVAILABLE);
            if (this.currentPlayer == null) {
                this.currentPlayer = player;
            }
        } else {
            logger.warning("Game already full, but tried to add: " + player.getName());
        }
    }

    public void removePlayer(Player player) {
        boolean updateCurrentPlayer = this.currentPlayer == player;
        this.players.remove(this.players.indexOf(player));
        Nation nation = this.getSpecification().getNation(player.getNationID());
        this.nationOptions.getNations().put(nation, NationOptions.NationState.AVAILABLE);
        player.dispose();
        if (updateCurrentPlayer) {
            this.currentPlayer = this.getFirstPlayer();
        }
    }

    public void setFreeColGameObject(String id, FreeColGameObject freeColGameObject) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("Parameter 'id' must not be 'null' or empty string.");
        }
        if (freeColGameObject == null) {
            throw new IllegalArgumentException("Parameter 'freeColGameObject' must not be 'null'.");
        }
        WeakReference<FreeColGameObject> wr = new WeakReference<FreeColGameObject>(freeColGameObject);
        FreeColGameObject old = this.getFreeColGameObjectSafely(id);
        if (old != null) {
            throw new IllegalArgumentException("Replacing FreeColGameObject " + id + ": " + old.getClass() + " with " + freeColGameObject.getClass());
        }
        this.freeColGameObjects.put(id, wr);
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.setFreeColGameObject(id, freeColGameObject);
        }
    }

    public void setFreeColGameObjectListener(FreeColGameObjectListener freeColGameObjectListener) {
        this.freeColGameObjectListener = freeColGameObjectListener;
    }

    public FreeColGameObjectListener getFreeColGameObjectListener() {
        return this.freeColGameObjectListener;
    }

    public FreeColGameObject getFreeColGameObject(String id) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("Parameter 'id' must not be null or empty string.");
        }
        return this.getFreeColGameObjectSafely(id);
    }

    public FreeColGameObject getFreeColGameObjectSafely(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        WeakReference<FreeColGameObject> ro = this.freeColGameObjects.get(id);
        if (ro != null) {
            FreeColGameObject o = (FreeColGameObject)ro.get();
            if (o != null) {
                return o;
            }
            this.freeColGameObjects.remove(id);
        }
        return null;
    }

    public FreeColGameObject removeFreeColGameObject(String id) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("Parameter 'id' must not be null or empty string.");
        }
        FreeColGameObject o = this.getFreeColGameObjectSafely(id);
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.removeFreeColGameObject(id);
        }
        this.freeColGameObjects.remove(id);
        return o;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
        for (Player player : this.getPlayers()) {
            if (player.getHighSeas() == null) continue;
            player.getHighSeas().addDestination(map);
        }
    }

    public final NationOptions getNationOptions() {
        return this.nationOptions;
    }

    public final void setNationOptions(NationOptions newNationOptions) {
        this.nationOptions = newNationOptions;
    }

    public Nation getVacantNation() {
        for (Map.Entry<Nation, NationOptions.NationState> entry : this.nationOptions.getNations().entrySet()) {
            if (entry.getValue() != NationOptions.NationState.AVAILABLE) continue;
            return entry.getKey();
        }
        return null;
    }

    public Player getPlayer(String nationID) {
        Iterator<Player> playerIterator = this.getPlayerIterator();
        while (playerIterator.hasNext()) {
            Player player = playerIterator.next();
            if (!player.getNationID().equals(nationID)) continue;
            return player;
        }
        return null;
    }

    public void setCurrentPlayer(Player newCp) {
        if (newCp != null) {
            if (this.currentPlayer != null) {
                this.currentPlayer.removeModelMessages();
                this.currentPlayer.invalidateCanSeeTiles();
            }
        } else {
            logger.info("Current player set to 'null'.");
        }
        this.currentPlayer = newCp;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public Player getNextPlayer() {
        return this.getPlayerAfter(this.currentPlayer);
    }

    public Player getPlayerAfter(Player beforePlayer) {
        if (this.players.size() == 0) {
            return null;
        }
        int index = this.players.indexOf(beforePlayer) + 1;
        if (index >= this.players.size()) {
            index = 0;
        }
        Player player;
        while ((player = this.players.get(index)).isDead()) {
            if (++index < this.players.size()) continue;
            index = 0;
        }
        return player;
    }

    public Player getFirstPlayer() {
        if (this.players.isEmpty()) {
            return null;
        }
        return this.players.get(0);
    }

    public Iterator<FreeColGameObject> getFreeColGameObjectIterator() {
        return new Iterator<FreeColGameObject>(){
            final Iterator<Map.Entry<String, WeakReference<FreeColGameObject>>> it;
            FreeColGameObject nextValue;
            {
                this.it = Game.this.freeColGameObjects.entrySet().iterator();
                this.nextValue = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nextValue == null) {
                    if (!this.it.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, WeakReference<FreeColGameObject>> entry = this.it.next();
                    WeakReference<FreeColGameObject> wr = entry.getValue();
                    FreeColGameObject o = (FreeColGameObject)wr.get();
                    if (o == null) {
                        String id = entry.getKey();
                        if (Game.this.freeColGameObjectListener != null) {
                            Game.this.freeColGameObjectListener.removeFreeColGameObject(id);
                        }
                        this.it.remove();
                        continue;
                    }
                    this.nextValue = o;
                }
                return this.nextValue != null;
            }

            @Override
            public FreeColGameObject next() {
                this.hasNext();
                FreeColGameObject o = this.nextValue;
                this.nextValue = null;
                return o;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Player getPlayerByName(String name) {
        Iterator<Player> playerIterator = this.getPlayerIterator();
        while (playerIterator.hasNext()) {
            Player player = playerIterator.next();
            if (!player.getName().equals(name)) continue;
            return player;
        }
        return null;
    }

    public boolean playerNameInUse(String username) {
        for (Player player : this.players) {
            if (!player.getName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public Iterator<Player> getPlayerIterator() {
        return this.players.iterator();
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public int getNumberOfPlayers() {
        return this.players.size();
    }

    public List<Player> getLiveEuropeanPlayers() {
        ArrayList<Player> europeans = new ArrayList<Player>();
        for (Player player : this.players) {
            if (!player.isEuropean() || player.isDead()) continue;
            europeans.add(player);
        }
        return europeans;
    }

    public boolean canAddNewPlayer() {
        return this.getVacantNation() != null;
    }

    public boolean isAllPlayersReadyToLaunch() {
        for (Player player : this.players) {
            if (player.isReady()) continue;
            return false;
        }
        return true;
    }

    public final boolean getSpanishSuccession() {
        return this.spanishSuccession;
    }

    public final void setSpanishSuccession(boolean newSpanishSuccession) {
        this.spanishSuccession = newSpanishSuccession;
    }

    public boolean checkIntegrity() {
        ArrayList<String> brokenObjects = new ArrayList<String>();
        boolean ok = true;
        Iterator<FreeColGameObject> iterator = this.getFreeColGameObjectIterator();
        while (iterator.hasNext()) {
            FreeColGameObject fgo = iterator.next();
            if (!fgo.isUninitialized()) continue;
            brokenObjects.add(fgo.getId());
            logger.warning("Uninitialized object: " + fgo.getId() + " (" + fgo.getClass() + ")");
            ok = false;
        }
        if (ok) {
            logger.info("Game integrity ok.");
        } else {
            logger.warning("Game integrity test failed.");
            this.fixIntegrity(brokenObjects);
        }
        return ok;
    }

    private boolean fixIntegrity(List<String> list) {
        for (Player player : this.getPlayers()) {
            for (Unit unit : player.getUnits()) {
                if (unit.getOwner() != null) continue;
                logger.warning("Fixing " + unit.getId() + ": owner missing");
                unit.setOwner(player);
            }
        }
        return false;
    }

    public OptionGroup getMapGeneratorOptions() {
        return this.specification.getOptionGroup("mapGeneratorOptions");
    }

    private void initializeCitiesOfCibola() {
        this.citiesOfCibola = new ArrayList<String>();
        for (int index = 0; index < 7; ++index) {
            this.citiesOfCibola.add("lostCityRumour.cityName." + index);
        }
        Collections.shuffle(this.citiesOfCibola);
    }

    public String getCityOfCibola() {
        if (this.citiesOfCibola == null) {
            this.initializeCitiesOfCibola();
        }
        return this.citiesOfCibola.size() == 0 ? null : this.citiesOfCibola.remove(0);
    }

    public FreeColGameObject getMessageSource(ModelMessage message) {
        return this.getFreeColGameObjectSafely(message.getSourceId());
    }

    public FreeColObject getMessageDisplay(ModelMessage message) {
        FreeColObject o;
        String id = message.getDisplayId();
        if (id == null) {
            id = message.getSourceId();
        }
        if ((o = this.getFreeColGameObjectSafely(id)) == null) {
            try {
                o = this.getSpecification().getType(id);
            }
            catch (Exception e) {
                o = null;
            }
        }
        return o;
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    public java.util.Map<String, String> getStatistics() {
        HashMap<String, String> stats = new HashMap<String, String>();
        System.gc();
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        stats.put("freeMemory", Long.toString(free));
        stats.put("totalMemory", Long.toString(total));
        stats.put("maxMemory", Long.toString(max));
        HashMap<String, Long> objStats = new HashMap<String, Long>();
        long disposed = 0L;
        Iterator<FreeColGameObject> iter = this.getFreeColGameObjectIterator();
        while (iter.hasNext()) {
            Long count;
            FreeColGameObject obj = iter.next();
            String className = obj.getClass().getSimpleName();
            if (objStats.containsKey(className)) {
                Long l = count = (Long)objStats.get(className);
                Long l2 = count = Long.valueOf(count + 1L);
                objStats.put(className, count);
            } else {
                count = new Long(1L);
                objStats.put(className, count);
            }
            if (!obj.isDisposed()) continue;
            ++disposed;
        }
        stats.put("disposed", Long.toString(disposed));
        for (String k : objStats.keySet()) {
            stats.put(k, Long.toString((Long)objStats.get(k)));
        }
        return stats;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Game.getXMLElementTagName());
        if (toSavedGame && !showAll) {
            throw new IllegalArgumentException("showAll must be set to true when toSavedGame is true.");
        }
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("UUID", this.getUUID().toString());
        out.writeAttribute("turn", Integer.toString(this.getTurn().getNumber()));
        out.writeAttribute("spanishSuccession", Boolean.toString(this.spanishSuccession));
        this.writeAttribute(out, "currentPlayer", this.currentPlayer);
        if (toSavedGame) {
            out.writeAttribute("nextID", Integer.toString(this.nextId));
        }
        this.specification.toXMLImpl(out);
        if (this.citiesOfCibola == null) {
            this.initializeCitiesOfCibola();
        }
        for (String cityName : this.citiesOfCibola) {
            out.writeStartElement(CIBOLA_TAG);
            out.writeAttribute("id", cityName);
            out.writeEndElement();
        }
        this.nationOptions.toXML(out);
        Iterator<Player> playerIterator = this.getPlayerIterator();
        while (playerIterator.hasNext()) {
            Player p = playerIterator.next();
            p.toXML(out, player, showAll, toSavedGame);
        }
        Player enemy = this.getUnknownEnemy();
        if (enemy != null) {
            enemy.toXML(out, player, showAll, toSavedGame);
        }
        if (this.map != null) {
            this.map.toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String currentPlayerStr;
        this.setId(in.getAttributeValue(null, "ID"));
        String hs = in.getAttributeValue(null, "UUID");
        if (hs != null) {
            this.uuid = UUID.fromString(hs);
        }
        this.turn = new Turn(this.getAttribute(in, "turn", 1));
        this.setSpanishSuccession(Game.getAttribute(in, "spanishSuccession", false));
        String nextIDStr = in.getAttributeValue(null, "nextID");
        if (nextIDStr != null) {
            this.nextId = Integer.parseInt(nextIDStr);
        }
        if ((currentPlayerStr = in.getAttributeValue(null, "currentPlayer")) != null) {
            this.currentPlayer = (Player)this.getFreeColGameObject(currentPlayerStr);
            if (this.currentPlayer == null) {
                this.currentPlayer = new Player(this, currentPlayerStr);
                this.players.add(this.currentPlayer);
            }
        } else {
            this.currentPlayer = null;
        }
        this.citiesOfCibola = new ArrayList<String>(7);
        OptionGroup gameOptions = null;
        OptionGroup mapGeneratorOptions = null;
        while (in.nextTag() != 2) {
            String tagName = in.getLocalName();
            logger.finest("Found tag " + tagName);
            if (tagName.equals("gameOptions") || tagName.equals("game-options")) {
                gameOptions = new OptionGroup(this.specification);
                gameOptions.readFromXML(in);
                continue;
            }
            if (tagName.equals(NationOptions.getXMLElementTagName())) {
                if (this.nationOptions == null) {
                    this.nationOptions = new NationOptions(this.specification, NationOptions.Advantages.SELECTABLE);
                }
                this.nationOptions.readFromXML(in);
                continue;
            }
            if (tagName.equals(Player.getXMLElementTagName())) {
                Player player = (Player)this.getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (player == null) {
                    player = new Player(this, in);
                    if (player.isUnknownEnemy()) {
                        this.setUnknownEnemy(player);
                        continue;
                    }
                    this.players.add(player);
                    continue;
                }
                player.readFromXML(in);
                continue;
            }
            if (tagName.equals(Map.getXMLElementTagName())) {
                String mapId = in.getAttributeValue(null, "ID");
                this.map = (Map)this.getFreeColGameObject(mapId);
                if (this.map == null) {
                    this.map = new Map(this, mapId);
                }
                this.map.readFromXML(in);
                continue;
            }
            if (tagName.equals(ModelMessage.getXMLElementTagName())) {
                ModelMessage m = new ModelMessage();
                m.readFromXML(in);
                String owner = m.getOwnerId();
                if (owner == null) continue;
                Player player = (Player)this.getFreeColGameObjectSafely(owner);
                player.addModelMessage(m);
                continue;
            }
            if (tagName.equals("citiesOfCibola")) {
                this.citiesOfCibola = this.readFromListElement("citiesOfCibola", in, String.class);
                continue;
            }
            if (tagName.equals(CIBOLA_TAG)) {
                this.citiesOfCibola.add(in.getAttributeValue(null, "id"));
                in.nextTag();
                continue;
            }
            if (OptionGroup.getXMLElementTagName().equals(tagName) || "difficultyLevel".equals(tagName)) {
                OptionGroup difficultyLevel = new OptionGroup(this.specification);
                difficultyLevel.readFromXML(in);
                continue;
            }
            if (MapGeneratorOptions.getXMLElementTagName().equals(tagName)) {
                mapGeneratorOptions = new OptionGroup(this.specification);
                mapGeneratorOptions.readFromXML(in);
                continue;
            }
            if (Specification.getXMLElementTagName().equals(tagName)) {
                Specification spec = new Specification();
                spec.readFromXMLImpl(in);
                if (this.specification != null) continue;
                this.specification = spec;
                this.specification.clean();
                continue;
            }
            logger.warning("Unknown tag: " + tagName + " loading game");
            in.nextTag();
        }
        if (!in.getLocalName().equals(Game.getXMLElementTagName())) {
            logger.warning("Error parsing xml: expecting closing tag </" + Game.getXMLElementTagName() + "> " + "found instead: " + in.getLocalName());
        }
        if (gameOptions != null) {
            this.addOldOptions(gameOptions);
        }
        if (mapGeneratorOptions != null) {
            this.addOldOptions(mapGeneratorOptions);
        }
    }

    private void addOldOptions(OptionGroup group) {
        Iterator<Option> iterator = group.iterator();
        while (iterator.hasNext()) {
            AbstractOption option;
            Option opt = iterator.next();
            if (opt instanceof IntegerOption) {
                option = (IntegerOption)opt;
                if (this.specification.hasOption(option.getId())) {
                    this.specification.getIntegerOption(option.getId()).setValue(((IntegerOption)option).getValue());
                    continue;
                }
                this.specification.addAbstractOption(option);
                continue;
            }
            if (!(opt instanceof BooleanOption)) continue;
            option = (BooleanOption)opt;
            if (this.specification.hasOption(option.getId())) {
                this.specification.getBooleanOption(option.getId()).setValue(((BooleanOption)option).getValue());
                continue;
            }
            this.specification.addAbstractOption(option);
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "game";
    }
}

