/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoodsType
extends FreeColGameObjectType {
    private boolean isFarmed;
    private boolean isFood;
    private boolean ignoreLimit;
    private boolean newWorldGoods;
    private boolean buildingMaterial;
    private boolean militaryGoods;
    private boolean tradeGoods;
    private boolean storable;
    private GoodsType madeFrom;
    private GoodsType makes;
    private GoodsType storedAs;
    private int initialAmount;
    private int initialPrice;
    private int priceDiff;
    private int breedingNumber = Integer.MAX_VALUE;
    private int price = Integer.MAX_VALUE;

    public GoodsType(String id, Specification specification) {
        super(id, specification);
    }

    public StringTemplate getLabel(boolean sellable) {
        return StringTemplate.key(this.getNameKey());
    }

    public boolean isRawMaterial() {
        return this.makes != null;
    }

    public boolean isRefined() {
        return this.madeFrom != null;
    }

    public GoodsType getRawMaterial() {
        return this.madeFrom;
    }

    public GoodsType getProducedMaterial() {
        return this.makes;
    }

    public boolean isFarmed() {
        return this.isFarmed;
    }

    public boolean limitIgnored() {
        return this.ignoreLimit;
    }

    public boolean isNewWorldGoodsType() {
        return this.newWorldGoods;
    }

    public boolean isNewWorldLuxuryType() {
        return this.madeFrom != null && this.madeFrom.isNewWorldGoodsType();
    }

    public final String getWorkingAsKey() {
        return this.getId() + ".workingAs";
    }

    public boolean isImmigrationType() {
        return !this.getModifierSet("model.modifier.immigration").isEmpty();
    }

    public boolean isLibertyType() {
        return !this.getModifierSet("model.modifier.liberty").isEmpty();
    }

    public boolean isStorable() {
        return this.storable;
    }

    public boolean isStoredAs() {
        return this.storedAs != null;
    }

    public GoodsType getStoredAs() {
        if (this.storedAs == null) {
            return this;
        }
        return this.storedAs;
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }

    public int getInitialSellPrice() {
        return this.initialPrice;
    }

    public int getInitialBuyPrice() {
        return this.initialPrice + this.priceDiff;
    }

    public int getPriceDifference() {
        return this.priceDiff;
    }

    public boolean isFoodType() {
        return this.isFood;
    }

    public GoodsType outputType() {
        return this.makes;
    }

    public GoodsType inputType() {
        return this.madeFrom;
    }

    public boolean isBuildingMaterial() {
        return this.buildingMaterial;
    }

    public void setBuildingMaterial(boolean newBuildingMaterial) {
        this.buildingMaterial = newBuildingMaterial;
    }

    public List<GoodsType> getProductionChain() {
        ArrayList<GoodsType> result = new ArrayList<GoodsType>();
        GoodsType currentGoods = this;
        while (currentGoods != null) {
            result.add(0, currentGoods);
            currentGoods = currentGoods.madeFrom;
        }
        return result;
    }

    public boolean isRawBuildingMaterial() {
        if (this.madeFrom != null) {
            return false;
        }
        GoodsType refinedType = this.makes;
        while (refinedType != null) {
            if (refinedType.isBuildingMaterial()) {
                return true;
            }
            refinedType = refinedType.makes;
        }
        return false;
    }

    public boolean isMilitaryGoods() {
        return this.militaryGoods;
    }

    public void setMilitaryGoods(boolean newMilitaryGoods) {
        this.militaryGoods = newMilitaryGoods;
    }

    public boolean isTradeGoods() {
        return this.tradeGoods;
    }

    public boolean isLibertyGoodsType() {
        return this.getFeatureContainer().containsModifierKey("model.modifier.liberty");
    }

    public boolean isImmigrationGoodsType() {
        return this.getFeatureContainer().containsModifierKey("model.modifier.immigration");
    }

    public int getBreedingNumber() {
        return this.breedingNumber;
    }

    public void setBreedingNumber(int newBreedingNumber) {
        this.breedingNumber = newBreedingNumber;
    }

    public boolean isBreedable() {
        return this.breedingNumber != Integer.MAX_VALUE;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int newPrice) {
        this.price = newPrice;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, GoodsType.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("is-farmed", Boolean.toString(this.isFarmed));
        out.writeAttribute("is-food", Boolean.toString(this.isFood));
        out.writeAttribute("ignore-limit", Boolean.toString(this.ignoreLimit));
        out.writeAttribute("new-world-goods", Boolean.toString(this.newWorldGoods));
        out.writeAttribute("trade-goods", Boolean.toString(this.tradeGoods));
        out.writeAttribute("storable", Boolean.toString(this.storable));
        if (this.breedingNumber != Integer.MAX_VALUE) {
            out.writeAttribute("breeding-number", Integer.toString(this.breedingNumber));
        }
        if (this.price != Integer.MAX_VALUE) {
            out.writeAttribute("price", Integer.toString(this.price));
        }
        if (this.madeFrom != null) {
            out.writeAttribute("made-from", this.madeFrom.getId());
        }
        if (this.storedAs != null) {
            out.writeAttribute("stored-as", this.storedAs.getId());
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.initialAmount > 0) {
            out.writeStartElement("market");
            out.writeAttribute("initial-amount", Integer.toString(this.initialAmount));
            out.writeAttribute("initial-price", Integer.toString(this.initialPrice));
            out.writeAttribute("price-difference", Integer.toString(this.priceDiff));
            out.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.isFarmed = GoodsType.getAttribute(in, "is-farmed", false);
        this.isFood = GoodsType.getAttribute(in, "is-food", false);
        this.ignoreLimit = GoodsType.getAttribute(in, "ignore-limit", false);
        this.newWorldGoods = GoodsType.getAttribute(in, "new-world-goods", false);
        this.tradeGoods = GoodsType.getAttribute(in, "trade-goods", false);
        this.breedingNumber = this.getAttribute(in, "breeding-number", Integer.MAX_VALUE);
        this.price = this.getAttribute(in, "price", Integer.MAX_VALUE);
        this.madeFrom = this.getSpecification().getType(in, "made-from", GoodsType.class, null);
        if (this.madeFrom != null) {
            this.madeFrom.makes = this;
        }
        this.storable = GoodsType.getAttribute(in, "storable", true);
        this.storedAs = this.getSpecification().getType(in, "stored-as", GoodsType.class, null);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if ("market".equals(childName)) {
            this.initialAmount = Integer.parseInt(in.getAttributeValue(null, "initial-amount"));
            this.initialPrice = this.getAttribute(in, "initial-price", 1);
            this.priceDiff = this.getAttribute(in, "price-difference", 1);
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "goods-type";
    }
}

