/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;

public class HistoryEvent
extends StringTemplate {
    private Turn turn;
    private EventType eventType;

    public HistoryEvent() {
    }

    public HistoryEvent(Turn turn, EventType eventType) {
        super("model.history." + eventType.toString(), StringTemplate.TemplateType.TEMPLATE);
        this.turn = turn;
        this.eventType = eventType;
    }

    public final Turn getTurn() {
        return this.turn;
    }

    public final void setTurn(Turn newInt) {
        this.turn = newInt;
    }

    public final EventType getEventType() {
        return this.eventType;
    }

    public final void setEventType(EventType newEventType) {
        this.eventType = newEventType;
    }

    public HistoryEvent add(String key, String value) {
        super.add(key, value);
        return this;
    }

    public HistoryEvent addName(String key, String value) {
        super.addName(key, value);
        return this;
    }

    public HistoryEvent addAmount(String key, int amount) {
        super.addAmount(key, amount);
        return this;
    }

    public HistoryEvent addStringTemplate(String key, StringTemplate template) {
        super.addStringTemplate(key, template);
        return this;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, HistoryEvent.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("turn", Integer.toString(this.turn.getNumber()));
        out.writeAttribute("eventType", this.eventType.toString());
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.turn = new Turn(Integer.parseInt(in.getAttributeValue(null, "turn")));
        String eventString = in.getAttributeValue(null, "eventType");
        if (eventString == null) {
            eventString = in.getAttributeValue(null, "type");
        }
        if ("".equals(this.getId())) {
            this.setId("model.history." + eventString);
        }
        super.readChildren(in);
        this.eventType = Enum.valueOf(EventType.class, eventString);
    }

    public String toString() {
        return this.eventType.toString() + " (" + this.turn.getYear() + ") [" + super.toString() + "]";
    }

    public static String getXMLElementTagName() {
        return "historyEvent";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        DISCOVER_NEW_WORLD,
        DISCOVER_REGION,
        MEET_NATION,
        CITY_OF_GOLD,
        FOUND_COLONY,
        ABANDON_COLONY,
        CONQUER_COLONY,
        COLONY_DESTROYED,
        COLONY_CONQUERED,
        DESTROY_SETTLEMENT,
        DESTROY_NATION,
        NATION_DESTROYED,
        FOUNDING_FATHER,
        DECLARE_INDEPENDENCE,
        INDEPENDENCE,
        SPANISH_SUCCESSION;

    }
}

