/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndianSettlement
extends Settlement {
    private static final Logger logger = Logger.getLogger(IndianSettlement.class.getName());
    public static final int TALES_RADIUS = 6;
    public static final String OWNED_UNITS_TAG_NAME = "ownedUnits";
    public static final String IS_VISITED_TAG_NAME = "isVisited";
    public static final String ALARM_TAG_NAME = "alarm";
    public static final String MISSIONARY_TAG_NAME = "missionary";
    public static final String WANTED_GOODS_TAG_NAME = "wantedGoods";
    public static final int TRADE_MINIMUM_SIZE = 20;
    public static final int TRADE_MINIMUM_PRICE = 3;
    public static final int GOODS_BASE_PRICE = 12;
    public static final int KEEP_RAW_MATERIAL = 50;
    protected UnitType learnableSkill = null;
    protected GoodsType[] wantedGoods = new GoodsType[]{null, null, null};
    protected Set<Player> spokenTo = new HashSet<Player>();
    protected ArrayList<Unit> ownedUnits = new ArrayList();
    protected Unit missionary = null;
    protected int convertProgress = 0;
    protected int lastTribute = 0;
    private Map<Player, Tension> alarm = new HashMap<Player, Tension>();
    private final Comparator<GoodsType> wantedGoodsComparator = new Comparator<GoodsType>(){

        @Override
        public int compare(GoodsType goodsType1, GoodsType goodsType2) {
            return IndianSettlement.this.getNormalGoodsPriceToBuy(goodsType2, 100) - IndianSettlement.this.getNormalGoodsPriceToBuy(goodsType1, 100);
        }
    };
    private final Comparator<Goods> exportGoodsComparator = new Comparator<Goods>(){

        @Override
        public int compare(Goods goods1, Goods goods2) {
            GoodsType t1 = goods1.getType();
            GoodsType t2 = goods2.getType();
            int cmp = (t2.isNewWorldGoodsType() ? 1 : 0) - (t1.isNewWorldGoodsType() ? 1 : 0);
            if (cmp == 0) {
                int a1 = Math.min(goods2.getAmount(), 100);
                int a2 = Math.min(goods1.getAmount(), 100);
                cmp = IndianSettlement.this.getPriceToSell(t2, a2) - IndianSettlement.this.getPriceToSell(t1, a1);
                if (cmp == 0) {
                    cmp = a2 - a1;
                }
            }
            return cmp;
        }
    };

    protected IndianSettlement() {
    }

    protected IndianSettlement(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public IndianSettlement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public IndianSettlement(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getNameFor(Player player) {
        return this.hasContactedSettlement(player) ? this.getName() : "indianSettlement.nameUnknown";
    }

    @Override
    public String getImageKey() {
        return this.getOwner().getNationID() + (this.isCapital() ? ".capital" : ".settlement") + (this.getMissionary() == null ? "" : ".mission") + ".image";
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.name(this.getName());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return StringTemplate.name(this.getNameFor(player));
    }

    public int getLastTribute() {
        return this.lastTribute;
    }

    public void setLastTribute(int lastTribute) {
        this.lastTribute = lastTribute;
    }

    public Tension getAlarm(Player player) {
        return this.alarm.get(player);
    }

    public void setAlarm(Player player, Tension newAlarm) {
        if (player != null && player != this.owner) {
            this.alarm.put(player, newAlarm);
        }
    }

    public void removeAlarm(Player player) {
        if (player != null) {
            this.alarm.remove(player);
        }
    }

    protected boolean changeAlarm(Player player, int amount) {
        Tension alarm = this.getAlarm(player);
        Tension.Level oldLevel = alarm.getLevel();
        alarm.modify(amount);
        return oldLevel != alarm.getLevel();
    }

    public String getShortAlarmLevelMessageId(Player player) {
        return !player.hasContacted(this.owner) ? "tension.wary" : (this.hasContactedSettlement(player) ? this.getAlarm(player).getKey() : "indianSettlement.tensionUnknown");
    }

    public String getAlarmLevelMessageId(Player player) {
        Tension alarm = this.hasContactedSettlement(player) ? this.getAlarm(player) : new Tension(0);
        return "indianSettlement.alarm." + alarm.getKey();
    }

    public boolean hasContactedSettlement(Player player) {
        return this.getAlarm(player) != null;
    }

    public boolean makeContactSettlement(Player player) {
        if (!this.hasContactedSettlement(player)) {
            this.setAlarm(player, new Tension(this.owner.getTension(player).getValue()));
            return true;
        }
        return false;
    }

    @Override
    public boolean propagateAlarm(Player player, int addToAlarm) {
        if (this.hasContactedSettlement(player)) {
            return this.changeAlarm(player, addToAlarm);
        }
        return false;
    }

    public boolean hasSpokenToChief() {
        Iterator<Player> playerIterator = this.spokenTo.iterator();
        while (playerIterator.hasNext()) {
            if (!playerIterator.next().isEuropean()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpokenToChief(Player player) {
        return this.spokenTo.contains(player);
    }

    public void setSpokenToChief(Player player) {
        if (!this.hasSpokenToChief(player)) {
            this.makeContactSettlement(player);
            this.spokenTo.add(player);
        }
    }

    public boolean allowContact(Unit unit) {
        return unit.getOwner().hasContacted(this.owner) || !unit.isNaval() || unit.getGoodsCount() > 0;
    }

    public void addOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        if (!this.ownedUnits.contains(unit)) {
            this.ownedUnits.add(unit);
        }
    }

    public List<Unit> getOwnedUnits() {
        return new ArrayList<Unit>(this.ownedUnits);
    }

    public Iterator<Unit> getOwnedUnitsIterator() {
        return this.ownedUnits.iterator();
    }

    public boolean removeOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        return this.ownedUnits.remove(unit);
    }

    public UnitType getLearnableSkill() {
        return this.learnableSkill;
    }

    public Unit getMissionary() {
        return this.missionary;
    }

    public void setMissionary(Unit missionary) {
        this.missionary = missionary;
    }

    public void changeMissionary(Unit missionary) {
        this.setMissionary(missionary);
        this.getTile().updatePlayerExploredTiles();
        if (missionary != null) {
            this.getTile().updatePlayerExploredTile(missionary.getOwner(), true);
        }
    }

    public Unit getMissionary(Player player) {
        return this.missionary == null || this.missionary.getOwner() != player ? null : this.missionary;
    }

    public int getConvertProgress() {
        return this.convertProgress;
    }

    public void setConvertProgress(int progress) {
        this.convertProgress = progress;
    }

    public GoodsType[] getWantedGoods() {
        return this.wantedGoods;
    }

    public void setWantedGoods(int index, GoodsType type) {
        if (0 <= index && index < this.wantedGoods.length) {
            this.wantedGoods[index] = type;
        }
    }

    public void setLearnableSkill(UnitType skill) {
        this.learnableSkill = skill;
    }

    @Override
    public boolean add(Locatable locatable) {
        Unit indian;
        boolean result = super.add(locatable);
        if (result && locatable instanceof Unit && (indian = (Unit)locatable).getIndianSettlement() == null) {
            indian.setIndianSettlement(this);
        }
        return result;
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : this.getUnitList()) {
            float unitPower;
            if (!Unit.betterDefender(defender, defencePower, nextUnit, unitPower = attacker.getGame().getCombatModel().getDefencePower(attacker, nextUnit))) continue;
            defender = nextUnit;
            defencePower = unitPower;
        }
        return defender;
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        return this.getType().getPlunderRange(attacker);
    }

    @Override
    public int getGoodsCapacity() {
        return this.getType().getWarehouseCapacity();
    }

    public int getPriceToBuy(Goods goods) {
        return this.getPriceToBuy(goods.getType(), goods.getAmount());
    }

    public int getPriceToBuy(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Amount > 100");
        }
        int price = 0;
        if (type.isMilitaryGoods()) {
            price = this.getMilitaryGoodsPriceToBuy(type, amount);
        }
        if (price == 0) {
            price = this.getNormalGoodsPriceToBuy(type, amount);
        }
        int wantedBase = 100;
        int wantedBonus = type == this.wantedGoods[0] ? 150 : (type == this.wantedGoods[1] ? 125 : (type == this.wantedGoods[2] ? 110 : 100));
        price = wantedBonus * price / 100;
        logger.finest("Full price(" + amount + " " + type + ")" + " -> " + price);
        return price;
    }

    private int getNormalGoodsPriceToBuy(GoodsType type, int amount) {
        int tradeGoodsAdd = 20;
        int capacity = this.getGoodsCapacity();
        int current = this.getGoodsCount(type);
        GoodsType rawType = type.getRawMaterial();
        if (rawType != null) {
            int rawProduction = this.getMaximumProduction(rawType);
            int add = rawProduction < 5 ? 10 * rawProduction : (rawProduction < 10 ? 5 * rawProduction + 25 : (rawProduction < 20 ? 2 * rawProduction + 55 : 100));
            add = add * Math.max(0, capacity - current) / capacity;
            current += add;
        } else if (type.isTradeGoods()) {
            current += 20;
        }
        int retain = Math.min(this.getWantedGoodsAmount(type), capacity);
        int valued = retain <= current ? 0 : Math.min(amount, retain - current);
        int unitPrice = (12 + this.getType().getTradeBonus()) * Math.max(0, capacity - current) / capacity;
        if (type.isFarmed() || type.isRawBuildingMaterial()) {
            unitPrice /= 2;
        }
        int price = unitPrice < 0 ? 0 : valued * unitPrice;
        logger.finest("Normal price(" + amount + " " + type + ")" + " valued=" + valued + " current=" + this.getGoodsCount(type) + " + " + (current - this.getGoodsCount(type)) + " unitPrice=" + unitPrice + " -> " + price);
        return price;
    }

    protected int getWantedGoodsAmount(GoodsType type) {
        Specification spec = this.getSpecification();
        if (type.isMilitaryGoods()) {
            int need = 0;
            int toArm = 0;
            if (type == spec.getGoodsType("model.goods.muskets")) {
                for (Unit u : this.ownedUnits) {
                    if (u.isArmed()) continue;
                    ++need;
                }
                toArm = spec.getEquipmentType("model.equipment.indian.muskets").getAmountRequiredOf(type);
            } else if (type == spec.getGoodsType("model.goods.horses")) {
                for (Unit u : this.ownedUnits) {
                    if (u.isMounted()) continue;
                    ++need;
                }
                toArm = spec.getEquipmentType("model.equipment.indian.horses").getAmountRequiredOf(type);
            }
            return need * toArm;
        }
        int consumption = this.getConsumptionOf(type);
        if (type == spec.getPrimaryFoodType()) {
            return Math.max(40, consumption * 3);
        }
        if (type.isTradeGoods() || type.isNewWorldLuxuryType() || type.isRefined()) {
            return Math.max(80, consumption * 20);
        }
        return 2 * this.getUnitCount();
    }

    private int getMilitaryGoodsPriceToBuy(GoodsType type, int amount) {
        int full = 12 + this.getType().getTradeBonus();
        int required = this.getWantedGoodsAmount(type);
        if (required == 0) {
            return 0;
        }
        int valued = Math.max(0, required - this.getGoodsCount(type));
        int price = valued > amount / 2 ? full * amount : valued * full + this.getNormalGoodsPriceToBuy(type, amount - valued);
        logger.finest("Military price(" + amount + " " + type + ")" + " valued=" + valued + " -> " + price);
        return price;
    }

    public int getPriceToSell(Goods goods) {
        return this.getPriceToSell(goods.getType(), goods.getAmount());
    }

    public int getPriceToSell(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Amount > 100");
        }
        int full = 12 + this.getType().getTradeBonus();
        int price = amount + Math.max(0, 11 * this.getPriceToBuy(type, amount) / 10);
        if (type.isMilitaryGoods()) {
            price = Math.max(price, amount * full * 2);
        } else if (type.isTradeGoods()) {
            price = Math.max(price, 150 * amount * full / 100);
        }
        return price;
    }

    public boolean willSell(GoodsType type) {
        return !type.isTradeGoods();
    }

    public List<Goods> getSellGoods(int limit, Unit unit) {
        ArrayList<Goods> result = new ArrayList<Goods>();
        List<Goods> settlementGoods = this.getCompactGoods();
        Collections.sort(settlementGoods, this.exportGoodsComparator);
        int count = 0;
        for (Goods goods : settlementGoods) {
            if (!this.willSell(goods.getType())) continue;
            int amount = goods.getAmount();
            int retain = this.getWantedGoodsAmount(goods.getType());
            if (retain >= amount) continue;
            if ((amount -= retain) > 100) {
                amount = 100;
            }
            if (unit != null) {
                amount = Math.round(FeatureContainer.applyModifierSet(amount, this.getGame().getTurn(), unit.getModifierSet("model.modifier.tradeVolumePenalty")));
            }
            if (amount < 20) continue;
            result.add(new Goods(this.getGame(), this, goods.getType(), amount));
            if (++count < limit) continue;
            break;
        }
        return result;
    }

    public void tradeGoodsWithSetlement(IndianSettlement settlement) {
        GoodsType armsType = this.getSpecification().getGoodsType("model.goods.muskets");
        GoodsType horsesType = this.getSpecification().getGoodsType("model.goods.horses");
        ArrayList<GoodsType> goodsToTrade = new ArrayList<GoodsType>();
        goodsToTrade.add(armsType);
        goodsToTrade.add(horsesType);
        for (GoodsType goods : goodsToTrade) {
            int goodsInStock = this.getGoodsCount(goods);
            if (goodsInStock <= 50) continue;
            int goodsTraded = goodsInStock / 2;
            settlement.addGoods(goods, goodsTraded);
            this.removeGoods(goods, goodsTraded);
        }
    }

    public int getMaximumProduction(GoodsType goodsType) {
        int amount = 0;
        for (Tile workTile : this.getTile().getSurroundingTiles(this.getRadius())) {
            if (workTile.getOwningSettlement() != null && workTile.getOwningSettlement() != this) continue;
            amount += workTile.potential(goodsType, null);
        }
        return amount;
    }

    public void updateWantedGoods() {
        ArrayList<GoodsType> goodsTypes = new ArrayList<GoodsType>(this.getSpecification().getGoodsTypeList());
        Collections.sort(goodsTypes, this.wantedGoodsComparator);
        int wantedIndex = 0;
        for (GoodsType goodsType : goodsTypes) {
            if (goodsType.isMilitaryGoods() || !goodsType.isStorable()) continue;
            if (this.getNormalGoodsPriceToBuy(goodsType, 100) <= 300 || wantedIndex >= this.wantedGoods.length) break;
            this.wantedGoods[wantedIndex] = goodsType;
            ++wantedIndex;
        }
        while (wantedIndex < this.wantedGoods.length) {
            this.wantedGoods[wantedIndex] = null;
            ++wantedIndex;
        }
    }

    private GoodsType goodsToMake() {
        GoodsType wantGoods = null;
        int wantAmount = -1;
        for (GoodsType g : this.getSpecification().getGoodsTypeList()) {
            int diff;
            GoodsType produced;
            if (!g.isRawMaterial() || (produced = g.getProducedMaterial()) == null || !produced.isStorable() || this.getGoodsCount(g) <= this.getWantedGoodsAmount(g) || (diff = this.getWantedGoodsAmount(produced) - this.getGoodsCount(produced)) <= wantAmount) continue;
            wantGoods = produced;
            wantAmount = diff;
        }
        return wantGoods;
    }

    @Override
    public int getProductionOf(GoodsType type) {
        if (type.isRefined()) {
            if (type != this.goodsToMake()) {
                return 0;
            }
            return this.getUnitCount();
        }
        int potential = 0;
        int tiles = 1;
        for (Tile workTile : this.getOwnedTiles()) {
            if (workTile == this.getTile() || workTile.isOccupied()) continue;
            potential += workTile.potential(type, null);
            ++tiles;
        }
        if (tiles > this.getUnitCount()) {
            potential = (int)((float)potential * ((float)this.getUnitCount() / (float)tiles));
        }
        return potential += this.getTile().potential(type, null);
    }

    @Override
    public int getSoL() {
        return 0;
    }

    public boolean checkForNewMissionaryConvert() {
        if (this.missionary != null && this.getGame().getViewOwner() == null) {
            int increment = 8;
            if (this.missionary.hasAbility("model.ability.expertMissionary")) {
                increment = 13;
            }
            this.convertProgress += (increment += 2 * this.getAlarm(this.missionary.getOwner()).getValue() / 100);
            if (this.convertProgress >= 100 && this.getUnitCount() > 2) {
                this.convertProgress = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        while (this.ownedUnits.size() > 0) {
            this.ownedUnits.remove(0).setIndianSettlement(null);
        }
        return super.disposeList();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        PlayerExploredTile pet;
        boolean full = showAll || toSavedGame || player == this.getOwner();
        PlayerExploredTile playerExploredTile = pet = player == null ? null : this.getTile().getPlayerExploredTile(player);
        if (toSavedGame && !showAll) {
            logger.warning("toSavedGame is true, but showAll is false");
        }
        out.writeStartElement(IndianSettlement.getXMLElementTagName());
        super.writeAttributes(out);
        if (full) {
            out.writeAttribute("lastTribute", Integer.toString(this.lastTribute));
            out.writeAttribute("convertProgress", Integer.toString(this.convertProgress));
            this.writeAttribute(out, "learnableSkill", this.learnableSkill);
            for (int i = 0; i < this.wantedGoods.length; ++i) {
                if (this.wantedGoods[i] == null) continue;
                String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
                out.writeAttribute(tag, this.wantedGoods[i].getId());
            }
        } else if (pet != null) {
            this.writeAttribute(out, "learnableSkill", pet.getSkill());
            GoodsType[] wanted = pet.getWantedGoods();
            int j = 0;
            for (int i = 0; i < wanted.length; ++i) {
                if (wanted[i] == null) continue;
                String tag = WANTED_GOODS_TAG_NAME + Integer.toString(j);
                out.writeAttribute(tag, wanted[i].getId());
                ++j;
            }
        }
        this.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (showAll || toSavedGame || player == this.getOwner()) {
            for (Player player2 : this.spokenTo) {
                out.writeStartElement(IS_VISITED_TAG_NAME);
                out.writeAttribute("player", player2.getId());
                out.writeEndElement();
            }
            for (Map.Entry entry : this.alarm.entrySet()) {
                out.writeStartElement(ALARM_TAG_NAME);
                out.writeAttribute("player", ((Player)entry.getKey()).getId());
                out.writeAttribute("value", String.valueOf(((Tension)entry.getValue()).getValue()));
                out.writeEndElement();
            }
            if (this.missionary != null) {
                out.writeStartElement(MISSIONARY_TAG_NAME);
                this.missionary.toXML(out, player, showAll, toSavedGame);
                out.writeEndElement();
            }
            for (Unit unit : this.ownedUnits) {
                out.writeStartElement(OWNED_UNITS_TAG_NAME);
                out.writeAttribute("ID", unit.getId());
                out.writeEndElement();
            }
            super.writeChildren(out, player, showAll, toSavedGame);
        } else {
            PlayerExploredTile pet = this.getTile().getPlayerExploredTile(player);
            if (pet != null) {
                if (this.hasSpokenToChief(player)) {
                    out.writeStartElement(IS_VISITED_TAG_NAME);
                    out.writeAttribute("player", player.getId());
                    out.writeEndElement();
                }
                if (this.getAlarm(player) != null) {
                    out.writeStartElement(ALARM_TAG_NAME);
                    out.writeAttribute("player", player.getId());
                    out.writeAttribute("value", String.valueOf(this.getAlarm(player).getValue()));
                    out.writeEndElement();
                }
                if (pet.getMissionary() != null) {
                    out.writeStartElement(MISSIONARY_TAG_NAME);
                    pet.getMissionary().toXML(out, player, showAll, toSavedGame);
                    out.writeEndElement();
                }
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.owner.addSettlement(this);
        this.ownedUnits.clear();
        for (int i = 0; i < this.wantedGoods.length; ++i) {
            String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
            String wantedGoodsId = this.getAttribute(in, tag, null);
            this.wantedGoods[i] = wantedGoodsId == null ? null : this.getSpecification().getGoodsType(wantedGoodsId);
        }
        this.convertProgress = this.getAttribute(in, "convertProgress", 0);
        this.lastTribute = this.getAttribute(in, "lastTribute", 0);
        this.learnableSkill = this.getSpecification().getType(in, "learnableSkill", UnitType.class, null);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.spokenTo.clear();
        this.alarm = new HashMap<Player, Tension>();
        this.missionary = null;
        this.ownedUnits.clear();
        super.readChildren(in);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (IS_VISITED_TAG_NAME.equals(in.getLocalName())) {
            Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
            this.spokenTo.add(player);
            in.nextTag();
        } else if (ALARM_TAG_NAME.equals(in.getLocalName())) {
            Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
            this.alarm.put(player, new Tension(this.getAttribute(in, "value", 0)));
            in.nextTag();
        } else if (WANTED_GOODS_TAG_NAME.equals(in.getLocalName())) {
            String[] wantedGoodsID = this.readFromArrayElement(WANTED_GOODS_TAG_NAME, in, new String[0]);
            for (int i = 0; i < this.wantedGoods.length; ++i) {
                String goodsId = i < wantedGoodsID.length ? wantedGoodsID[i] : null;
                this.wantedGoods[i] = goodsId == null || "".equals(goodsId) ? null : this.getSpecification().getGoodsType(goodsId);
            }
        } else if (MISSIONARY_TAG_NAME.equals(in.getLocalName())) {
            in.nextTag();
            this.missionary = this.updateFreeColGameObject(in, Unit.class);
            this.missionary.setLocationNoUpdate(this);
            in.nextTag();
        } else if ("units".equals(in.getLocalName())) {
            while (in.nextTag() != 2) {
                if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                Unit unit = this.updateFreeColGameObject(in, Unit.class);
                if (unit.getLocation() != this) {
                    logger.warning("fixing unit location");
                    unit.setLocation(this);
                }
                this.add(unit);
            }
        } else if (OWNED_UNITS_TAG_NAME.equals(in.getLocalName())) {
            Unit unit = this.getFreeColGameObject(in, "ID", Unit.class);
            if (unit.getOwner() != null && !this.owner.owns(unit)) {
                logger.warning("Error in savegame: unit " + unit.getId() + " does not belong to settlement " + this.getId());
            } else {
                this.ownedUnits.add(unit);
                this.owner.setUnit(unit);
            }
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.getName());
        s.append(" at (").append(this.tile.getX());
        s.append(",").append(this.tile.getY()).append(")");
        return s.toString();
    }

    public static String getXMLElementTagName() {
        return "indianSettlement";
    }
}

