/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Locale;

public class Tension {
    public static final int TENSION_MIN = 0;
    public static final int TENSION_MAX = Level.access$000(Level.HATEFUL) + 100;
    public static final int DELTA = 10;
    public static final int TENSION_ADD_MINOR = 100;
    public static final int TENSION_ADD_NORMAL = 200;
    public static final int TENSION_ADD_MAJOR = 300;
    public static final int TENSION_ADD_LAND_TAKEN = 200;
    public static final int TENSION_ADD_UNIT_DESTROYED = 400;
    public static final int TENSION_ADD_SETTLEMENT_ATTACKED = 500;
    public static final int TENSION_ADD_CAPITAL_ATTACKED = 600;
    public static final int TENSION_ADD_WAR_INCITER = 250;
    public static final int CONTACT_MODIFIER = 0;
    public static final int ALLIANCE_MODIFIER = -500;
    public static final int DROP_ALLIANCE_MODIFIER = 200;
    public static final int PEACE_TREATY_MODIFIER = -250;
    public static final int CEASE_FIRE_MODIFIER = -250;
    public static final int WAR_MODIFIER = Level.access$000(Level.HATEFUL);
    public static final int RESUME_WAR_MODIFIER = 750;
    public static final int SURRENDERED = (Level.access$000(Level.CONTENT) + Level.access$000(Level.HAPPY)) / 2;
    private int value;

    public Tension() {
        this.setValue(Level.HAPPY.getLimit());
    }

    public Tension(int newTension) {
        this.setValue(newTension);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        this.value = newValue < 0 ? 0 : (newValue > TENSION_MAX ? TENSION_MAX : newValue);
    }

    public Level getLevel() {
        for (Level level : Level.values()) {
            if (this.value > level.getLimit()) continue;
            return level;
        }
        return Level.HATEFUL;
    }

    public void modify(int newTension) {
        this.setValue(this.value + newTension);
    }

    public String getKey() {
        return this.toString().toLowerCase(Locale.US);
    }

    public String toString() {
        return this.getLevel().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        HAPPY(100),
        CONTENT(600),
        DISPLEASED(700),
        ANGRY(800),
        HATEFUL(1000);

        private int limit;

        private Level(int limit) {
            this.limit = limit;
        }

        public int getLimit() {
            return this.limit;
        }

        static /* synthetic */ int access$000(Level x0) {
            return x0.limit;
        }
    }
}

