/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.mission.Mission;
import org.w3c.dom.Element;

public abstract class AbstractMission
extends FreeColGameObject
implements Mission {
    private Unit unit;
    private int repeatCount = 1;
    private int turnCount;

    public final Unit getUnit() {
        return this.unit;
    }

    public AbstractMission(Game game) {
        super(game);
    }

    public AbstractMission(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public AbstractMission(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public AbstractMission(Game game, String id) {
        super(game, id);
    }

    public final void setUnit(Unit newUnit) {
        this.unit = newUnit;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public final void setRepeatCount(int newRepeatCount) {
        this.repeatCount = newRepeatCount;
    }

    public final int getTurnCount() {
        return this.turnCount;
    }

    public final void setTurnCount(int newTurnCount) {
        this.turnCount = newTurnCount;
    }

    public boolean isValid() {
        return this.unit != null && !this.unit.isDisposed() && this.repeatCount > 0;
    }

    public static boolean isValidFor(Unit unit) {
        return false;
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        this.toXML(out, AbstractMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("unit", this.unit.getId());
        out.writeAttribute("turnCount", Integer.toString(this.turnCount));
        out.writeAttribute("repeatCount", Integer.toString(this.repeatCount));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.unit = this.getFreeColGameObject(in, "unit", Unit.class);
        this.turnCount = this.getAttribute(in, "turnCount", 0);
        this.repeatCount = this.getAttribute(in, "repeatCount", 1);
    }
}

