/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.mission.AbstractMission;
import net.sf.freecol.common.model.mission.Mission;
import org.w3c.dom.Element;

public class GoToMission
extends AbstractMission {
    private int blockedCount;
    private Location destination;

    public GoToMission(Game game) {
        super(game);
    }

    public GoToMission(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public GoToMission(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public GoToMission(Game game, String id) {
        super(game, id);
    }

    public final Location getDestination() {
        return this.destination;
    }

    public final void setDestination(Location newDestination) {
        this.destination = newDestination;
    }

    public final int getBlockedCount() {
        return this.blockedCount;
    }

    public final void setBlockedCount(int newBlockedCount) {
        this.blockedCount = newBlockedCount;
    }

    public Mission.MissionState doMission() {
        return Mission.MissionState.OK;
    }

    public boolean isValid() {
        return super.isValid() && this.destination != null && this.destination.canAdd(this.getUnit());
    }

    public static boolean isValidFor(Unit unit) {
        return unit.getInitialMovesLeft() > 0;
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("destination", this.destination.getId());
        out.writeAttribute("blockedCount", Integer.toString(this.blockedCount));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.destination = this.newLocation(in.getAttributeValue(null, "destination"));
        this.blockedCount = this.getAttribute(in, "blockedCount", 0);
    }

    public static String getXMLElementTagName() {
        return "goToMission";
    }
}

