/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.mission.AbstractMission;
import net.sf.freecol.common.model.mission.Mission;
import org.w3c.dom.Element;

public class ImprovementMission
extends AbstractMission {
    private TileImprovement improvement;

    public ImprovementMission(Game game) {
        super(game);
    }

    public ImprovementMission(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public ImprovementMission(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public ImprovementMission(Game game, String id) {
        super(game, id);
    }

    public final TileImprovement getImprovement() {
        return this.improvement;
    }

    public final void setImprovement(TileImprovement newImprovement) {
        this.improvement = newImprovement;
    }

    public Mission.MissionState doMission() {
        int work = this.getUnit().hasAbility("model.ability.expertPioneer") ? 2 : 1;
        this.setTurnCount(this.getTurnCount() - work);
        this.getUnit().setMovesLeft(0);
        return this.getTurnCount() <= 0 ? Mission.MissionState.COMPLETED : Mission.MissionState.OK;
    }

    public boolean isValid() {
        return super.isValid() && this.improvement != null && this.improvement.isWorkerAllowed(this.getUnit());
    }

    public static boolean isValidFor(Unit unit) {
        for (TileImprovementType type : unit.getGame().getSpecification().getTileImprovementTypeList()) {
            if (!type.isWorkerAllowed(unit)) continue;
            return true;
        }
        return false;
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("improvement", this.improvement.getId());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.improvement = this.getFreeColGameObject(in, "improvement", TileImprovement.class);
    }

    public static String getXMLElementTagName() {
        return "improvementMission";
    }
}

