/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class AttackMessage
extends DOMMessage {
    private String unitId;
    private String directionString;

    public AttackMessage(Unit unit, Map.Direction direction) {
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public AttackMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Tile oldTile = unit.getTile();
        if (oldTile == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, this.directionString);
        Tile tile = oldTile.getNeighbourOrNull(direction);
        if (tile == null) {
            return DOMMessage.clientError("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.unitId);
        }
        Unit.MoveType moveType = unit.getMoveType(direction);
        if ((moveType != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT && moveType != Unit.MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT || unit.getRole() != Unit.Role.SCOUT) && !moveType.isAttack()) {
            return DOMMessage.clientError("Illegal attack move for: " + this.unitId + " type: " + (Object)((Object)moveType) + " from: " + unit.getLocation().getId() + " to: " + tile.getId());
        }
        Unit defender = tile.getDefendingUnit(unit);
        if (defender == null) {
            return DOMMessage.clientError("Could not find defender in tile: " + tile.getId() + " from: " + unit.getLocation().getId());
        }
        return server.getInGameController().combat(serverPlayer, unit, defender, null);
    }

    public Element toXMLElement() {
        Element result = AttackMessage.createNewRootElement(AttackMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("direction", this.directionString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "attack";
    }
}

