/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class DeliverGiftMessage
extends DOMMessage {
    private String unitId;
    private String settlementId;
    private Goods goods;

    public DeliverGiftMessage(Unit unit, Settlement settlement, Goods goods) {
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.goods = goods;
    }

    public DeliverGiftMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.goods = new Goods(game, DOMMessage.getChildElement(element, Goods.getXMLElementTagName()));
    }

    public Unit getUnit() {
        try {
            return (Unit)this.goods.getGame().getFreeColGameObject(this.unitId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Settlement getSettlement() {
        try {
            return (Settlement)this.goods.getGame().getFreeColGameObject(this.settlementId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Goods getGoods() {
        return this.goods;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Settlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            settlement = server.getAdjacentSettlementSafely(this.settlementId, unit);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.goods.getLocation() != unit) {
            return DOMMessage.createError("server.trade.noGoods", "deliverGift of non-existent goods");
        }
        return server.getInGameController().deliverGiftToSettlement(serverPlayer, unit, settlement, this.goods);
    }

    public Element toXMLElement() {
        Element result = DeliverGiftMessage.createNewRootElement(DeliverGiftMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("settlement", this.settlementId);
        result.appendChild(this.goods.toXMLElement(null, result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "deliverGift";
    }
}

