/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class DemandTributeMessage
extends DOMMessage {
    private String unitId;
    private String directionString;

    public DemandTributeMessage(Unit unit, Map.Direction direction) {
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public DemandTributeMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        if (!unit.isArmed() && unit.getRole() != Unit.Role.SCOUT) {
            return DOMMessage.clientError("Unit is neither armed nor a scout: " + this.unitId);
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, this.directionString);
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile == null) {
            return DOMMessage.clientError("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.unitId);
        }
        IndianSettlement is = tile.getIndianSettlement();
        if (is == null) {
            return DOMMessage.clientError("There is no native settlement at: " + tile.getId());
        }
        Unit.MoveType type = unit.getMoveType(tile);
        if (type != Unit.MoveType.ATTACK_SETTLEMENT && type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT) {
            return DOMMessage.clientError("Unable to demand tribute at: " + is.getName() + ": " + type.whyIllegal());
        }
        return server.getInGameController().demandTribute(serverPlayer, unit, is);
    }

    public Element toXMLElement() {
        Element result = DemandTributeMessage.createNewRootElement(DemandTributeMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("direction", this.directionString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "demandTribute";
    }
}

