/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LootCargoMessage
extends DOMMessage {
    private String winnerId;
    private String loserId;
    private List<Goods> goods;

    public LootCargoMessage(Unit winner, String loserId, List<Goods> goods) {
        this.winnerId = winner.getId();
        this.loserId = loserId;
        this.goods = goods == null ? null : new ArrayList<Goods>(goods);
    }

    public LootCargoMessage(Game game, Element element) {
        this.winnerId = element.getAttribute("winner");
        this.loserId = element.getAttribute("loser");
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            this.goods = null;
        } else {
            this.goods = new ArrayList<Goods>();
            for (int i = 0; i < children.getLength(); ++i) {
                this.goods.add(new Goods(game, (Element)children.item(i)));
            }
        }
    }

    public Unit getUnit(Game game) {
        FreeColGameObject o = game.getFreeColGameObjectSafely(this.winnerId);
        return o instanceof Unit ? (Unit)o : null;
    }

    public String getDefenderId() {
        return this.loserId;
    }

    public List<Goods> getGoods() {
        return this.goods;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit winner;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            winner = server.getUnitSafely(this.winnerId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().lootCargo(serverPlayer, winner, this.loserId, this.goods);
    }

    @Override
    public Element toXMLElement() {
        Element result = LootCargoMessage.createNewRootElement(LootCargoMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("winner", this.winnerId);
        result.setAttribute("loser", this.loserId);
        if (this.goods != null) {
            for (Goods g : this.goods) {
                result.appendChild(g.toXMLElement(null, doc, true, true));
            }
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "lootCargo";
    }
}

