/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class NewRegionNameMessage
extends DOMMessage {
    private String regionId;
    private String tileId;
    private String newRegionName;

    public NewRegionNameMessage(Region region, Tile tile, String newRegionName) {
        this.regionId = region.getId();
        this.tileId = tile.getId();
        this.newRegionName = newRegionName;
    }

    public NewRegionNameMessage(Game game, Element element) {
        this.regionId = element.getAttribute("region");
        this.tileId = element.getAttribute("tile");
        this.newRegionName = element.getAttribute("newRegionName");
    }

    public Region getRegion(Game game) {
        FreeColGameObject o = game.getFreeColGameObjectSafely(this.regionId);
        return o instanceof Region ? (Region)o : null;
    }

    public Tile getTile(Game game) {
        FreeColGameObject o = game.getFreeColGameObjectSafely(this.tileId);
        return o instanceof Tile ? (Tile)o : null;
    }

    public String getNewRegionName() {
        return this.newRegionName;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerGame game = server.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Tile tile = this.getTile(game);
        if (!tile.isExploredBy(player)) {
            return DOMMessage.clientError("Can not claim discovery in unexplored tile: " + this.tileId);
        }
        Region region = tile.getDiscoverableRegion();
        if (region == null) {
            return DOMMessage.clientError("No discoverable region in: " + this.tileId);
        }
        if (region.isPacific()) {
            return DOMMessage.clientError("Can not rename the Pacific!");
        }
        if (!region.getId().equals(this.regionId)) {
            return DOMMessage.clientError("Region mismatch, " + region.getId() + " != " + this.regionId);
        }
        return server.getInGameController().setNewRegionName(serverPlayer, region, this.newRegionName);
    }

    public Element toXMLElement() {
        Element result = NewRegionNameMessage.createNewRootElement(NewRegionNameMessage.getXMLElementTagName());
        result.setAttribute("region", this.regionId);
        result.setAttribute("tile", this.tileId);
        result.setAttribute("newRegionName", this.newRegionName);
        return result;
    }

    public static String getXMLElementTagName() {
        return "newRegionName";
    }
}

