/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class PayArrearsMessage
extends DOMMessage {
    private String goodsTypeId;

    public PayArrearsMessage(GoodsType type) {
        this.goodsTypeId = type.getId();
    }

    public PayArrearsMessage(Game game, Element element) {
        this.goodsTypeId = element.getAttribute("goodsType");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        GoodsType goodsType = server.getSpecification().getGoodsType(this.goodsTypeId);
        return server.getInGameController().payArrears(serverPlayer, goodsType);
    }

    public Element toXMLElement() {
        Element result = PayArrearsMessage.createNewRootElement(PayArrearsMessage.getXMLElementTagName());
        result.setAttribute("goodsType", this.goodsTypeId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "payArrears";
    }
}

