/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class RenameMessage
extends DOMMessage {
    private String id;
    private String newName;

    public RenameMessage(FreeColGameObject object, String newName) {
        this.id = object.getId();
        this.newName = newName;
    }

    public RenameMessage(Game game, Element element) {
        this.id = element.getAttribute("nameable");
        this.newName = element.getAttribute("name");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Nameable object = (Nameable)((Object)player.getGame().getFreeColGameObject(this.id));
        if (object == null) {
            return DOMMessage.clientError("Tried to rename an object with id " + this.id + " which could not be found.");
        }
        if (!(object instanceof Ownable) || ((Ownable)((Object)object)).getOwner() != serverPlayer) {
            return DOMMessage.clientError("Not the owner of nameable: " + this.id);
        }
        return server.getInGameController().renameObject(serverPlayer, object, this.newName);
    }

    public Element toXMLElement() {
        Element result = RenameMessage.createNewRootElement(RenameMessage.getXMLElementTagName());
        result.setAttribute("nameable", this.id);
        result.setAttribute("name", this.newName);
        return result;
    }

    public static String getXMLElementTagName() {
        return "rename";
    }
}

