/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SellMessage
extends DOMMessage {
    private String unitId;
    private String settlementId;
    private Goods goods;
    private String goldString;

    public SellMessage(Unit unit, Settlement settlement, Goods goods, int gold) {
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.goods = goods;
        this.goldString = Integer.toString(gold);
    }

    public SellMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.goods = new Goods(game, DOMMessage.getChildElement(element, Goods.getXMLElementTagName()));
        this.goldString = element.getAttribute("gold");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int gold;
        IndianSettlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
            settlement = server.getAdjacentIndianSettlementSafely(this.settlementId, unit);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.goods.getLocation() != unit) {
            return DOMMessage.createError("server.trade.noGoods", "Goods " + this.goods.getId() + " is not with unit " + this.unitId);
        }
        try {
            gold = Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad gold: " + this.goldString);
        }
        return server.getInGameController().sellToSettlement(serverPlayer, unit, settlement, this.goods, gold);
    }

    public Element toXMLElement() {
        Element result = SellMessage.createNewRootElement(SellMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("settlement", this.settlementId);
        result.appendChild(this.goods.toXMLElement(null, result.getOwnerDocument()));
        result.setAttribute("gold", this.goldString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "sell";
    }
}

