/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitTypeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractUnitOption
extends AbstractOption<AbstractUnit> {
    private static Logger logger = Logger.getLogger(AbstractUnitOption.class.getName());
    private static final UnitTypeOption.TypeSelector DEFAULT_SELECTOR = UnitTypeOption.TypeSelector.UNITS;
    private AbstractUnit value;
    private UnitTypeOption unitType;
    private StringOption role;
    private IntegerOption number;

    public AbstractUnitOption(String id) {
        super(id);
    }

    public AbstractUnitOption(Specification specification) {
        super(specification);
    }

    public AbstractUnitOption(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public AbstractUnitOption clone() {
        AbstractUnitOption result = new AbstractUnitOption(this.getId());
        result.setValues(this);
        if (this.getValue() != null) {
            result.setValue(this.getValue().clone());
        }
        result.unitType = this.unitType.clone();
        result.role = this.role.clone();
        result.number = this.number.clone();
        return result;
    }

    @Override
    public AbstractUnit getValue() {
        return this.value;
    }

    @Override
    public void setValue(AbstractUnit value) {
        AbstractUnit oldValue = this.value;
        this.value = value;
        if ((value != null || oldValue != null) && !value.equals(oldValue) && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    public final UnitTypeOption getUnitType() {
        return this.unitType;
    }

    public final void setUnitType(UnitTypeOption newUnitType) {
        this.unitType = newUnitType;
    }

    public final StringOption getRole() {
        return this.role;
    }

    public final void setRole(StringOption newRole) {
        this.role = newRole;
    }

    public final IntegerOption getNumber() {
        return this.number;
    }

    public final void setNumber(IntegerOption newNumber) {
        this.number = newNumber;
    }

    @Override
    public void generateChoices() {
        this.unitType.generateChoices();
        ArrayList<String> roles = new ArrayList<String>();
        for (Unit.Role r : Unit.Role.values()) {
            roles.add(r.getId());
        }
        this.role.setChoices(roles);
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AbstractUnitOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        this.unitType.toXML(out, "unitType");
        this.role.toXML(out, "role");
        this.number.toXMLImpl(out, "number");
        out.writeEndElement();
    }

    @Override
    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "id"));
        this.number = new IntegerOption(this.getId() + ".number", this.getSpecification());
        this.unitType = new UnitTypeOption(this.getId() + ".unitType", this.getSpecification());
        this.role = new StringOption(this.getId() + ".role", this.getSpecification());
        while (in.nextTag() != 2) {
            String tag = in.getLocalName();
            if ("number".equals(tag)) {
                this.number.readFromXMLImpl(in);
                continue;
            }
            if ("unitType".equals(tag)) {
                this.unitType.readFromXMLImpl(in);
                continue;
            }
            if (!"role".equals(tag)) continue;
            this.role.readFromXMLImpl(in);
        }
        if (this.unitType.getValue() != null && this.role.getValue() != null && this.number.getValue() != null) {
            this.setValue(new AbstractUnit(this.unitType.getValue(), Unit.Role.valueOf(this.role.getValue()), (int)this.number.getValue()));
        } else {
            this.setValue(null);
        }
    }

    public static String getXMLElementTagName() {
        return "unitOption";
    }

    @Override
    public String toString() {
        return this.getId() + " <" + this.value.toString() + ">";
    }
}

