/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOption
extends AbstractOption<File> {
    private static Logger logger = Logger.getLogger(FileOption.class.getName());
    private File value = null;

    public FileOption(Specification specification) {
        super(specification);
    }

    @Override
    public FileOption clone() {
        FileOption result = new FileOption(this.getSpecification());
        result.setValues(this);
        return result;
    }

    @Override
    public File getValue() {
        return this.value;
    }

    @Override
    public void setValue(File value) {
        File oldValue = this.value;
        this.value = value;
        if (value != oldValue) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.value = valueString != null ? new File(valueString) : (defaultValueString != null ? new File(defaultValueString) : null);
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, FileOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.value != null) {
            out.writeAttribute("value", this.value.getAbsolutePath());
        }
    }

    public static String getXMLElementTagName() {
        return "fileOption";
    }
}

