/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AIPlayer
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIPlayer.class.getName());
    public static final int MAX_DISTANCE_TO_BRING_GIFT = 5;
    public static final int MAX_NUMBER_OF_GIFTS_BEING_DELIVERED = 1;
    public static final int MAX_DISTANCE_TO_MAKE_DEMANDS = 5;
    public static final int MAX_NUMBER_OF_DEMANDS = 1;
    private ServerPlayer player;
    private Random aiRandom = null;
    private Connection debuggingConnection;
    private List<AIUnit> aiUnits = new ArrayList<AIUnit>();

    public AIPlayer(AIMain aiMain, String id) {
        super(aiMain, id);
        this.aiRandom = new Random(aiMain.getRandomSeed("Seed for " + id));
    }

    public Player getPlayer() {
        return this.player;
    }

    protected void setPlayer(ServerPlayer p) {
        this.player = p;
    }

    @Override
    public String getId() {
        return this.player.getId();
    }

    public Random getAIRandom() {
        return this.aiRandom;
    }

    protected String getAIAdvantage() {
        String prefix = "model.nationType.";
        String id = this.player == null || this.player.getNationType() == null ? "" : this.player.getNationType().getId();
        return id.startsWith("model.nationType.") ? id.substring("model.nationType.".length()) : "";
    }

    public Connection getConnection() {
        if (this.debuggingConnection != null) {
            return this.debuggingConnection;
        }
        return ((DummyConnection)this.player.getConnection()).getOtherConnection();
    }

    public void setDebuggingConnection(Connection debuggingConnection) {
        this.debuggingConnection = debuggingConnection;
    }

    protected void clearAIUnits() {
        this.aiUnits.clear();
    }

    private void createAIUnits() {
        this.clearAIUnits();
        for (Unit u : this.getPlayer().getUnits()) {
            AIUnit a = this.getAIUnit(u);
            if (a != null) {
                this.aiUnits.add(a);
                continue;
            }
            logger.warning("Could not find the AIUnit for: " + u + " (" + u.getId() + ")");
        }
    }

    protected AIColony getAIColony(Colony colony) {
        return this.getAIMain().getAIColony(colony);
    }

    protected List<AIColony> getAIColonies() {
        ArrayList<AIColony> ac = new ArrayList<AIColony>();
        for (Colony colony : this.getPlayer().getColonies()) {
            AIColony a = this.getAIColony(colony);
            if (a != null) {
                ac.add(a);
                continue;
            }
            logger.warning("Could not find the AIColony for: " + colony);
        }
        return ac;
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected List<AIUnit> getAIUnits() {
        if (this.aiUnits.size() == 0) {
            this.createAIUnits();
        }
        return new ArrayList<AIUnit>(this.aiUnits);
    }

    protected Iterator<AIUnit> getAIUnitIterator() {
        if (this.aiUnits.size() == 0) {
            this.createAIUnits();
        }
        return this.aiUnits.iterator();
    }

    protected Player.Stance determineStance(Player other) {
        Player player = this.getPlayer();
        Player.Stance newStance = other.getREFPlayer() == player && other.getPlayerType() == Player.PlayerType.REBEL ? Player.Stance.WAR : player.getStance(other).getStanceFromTension(player.getTension(other));
        if (newStance != player.getStance(other)) {
            this.getAIMain().getFreeColServer().getInGameController().changeStance(player, newStance, other, true);
        }
        return player.getStance(other);
    }

    public abstract void startWorking();

    public boolean indianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return false;
    }

    public abstract boolean acceptDiplomaticTrade(DiplomaticTrade var1);

    public abstract void registerSellGoods(Goods var1);

    public abstract int buyProposition(Unit var1, Settlement var2, Goods var3, int var4);

    public abstract int sellProposition(Unit var1, Settlement var2, Goods var3, int var4);

    public boolean acceptTax(int tax) {
        return false;
    }

    public boolean acceptMercenaries() {
        return false;
    }

    protected void determineStances() {
        logger.finest("Entering method determineStances");
        Player player = this.getPlayer();
        for (Player p : this.getGame().getPlayers()) {
            if (p == player || p.isDead()) continue;
            this.determineStance(p);
        }
    }

    private void abortUnitMission(AIUnit aiU, String why) {
        aiU.abortMission(why);
        Unit unit = aiU.getUnit();
        Tile tile = unit.getTile();
        if (!unit.isCarrier() && !unit.isOnCarrier() && tile != null && tile.getColony() == null) {
            for (Tile t : tile.getSurroundingTiles(1)) {
                for (Unit u : t.getUnitList()) {
                    if (u.getOwner() != unit.getOwner() || !u.isCarrier() || !u.canCarryUnits() || u.getSpaceLeft() < unit.getSpaceTaken() || unit.getMovesLeft() <= 0) continue;
                    AIMessage.askEmbark(this.getAIMain().getAIUnit(u), unit, tile.getDirection(t));
                    return;
                }
            }
        }
    }

    protected void abortInvalidMissions() {
        for (AIUnit au : this.getAIUnits()) {
            Mission mission = au.getMission();
            if (mission == null || mission.isValid()) continue;
            this.abortUnitMission(au, "invalid");
        }
    }

    protected void abortInvalidAndOneTimeMissions() {
        for (AIUnit au : this.getAIUnits()) {
            Mission mission = au.getMission();
            if (mission == null) continue;
            if (!mission.isValid()) {
                this.abortUnitMission(au, "invalid");
                continue;
            }
            if (!mission.isOneTime()) continue;
            this.abortUnitMission(au, "one-time");
        }
    }

    protected void doMissions() {
        logger.finest("Entering method doMissions");
        for (AIUnit au : this.getAIUnits()) {
            if (!au.hasMission() || !au.getMission().isValid() || au.getUnit().isOnCarrier()) continue;
            try {
                au.doMission(this.getConnection());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "doMissions failed", e);
            }
        }
    }

    public boolean isTargetValidForSeekAndDestroy(Unit attacker, Tile tile) {
        Player defenderPlayer;
        Player attackerPlayer = attacker.getOwner();
        if (attacker == null) {
            return false;
        }
        Settlement settlement = tile.getSettlement();
        Unit defender = tile.getDefendingUnit(attacker);
        Player player = settlement != null ? settlement.getOwner() : (defenderPlayer = defender != null ? defender.getOwner() : null);
        if (defenderPlayer == null) {
            return false;
        }
        if (attackerPlayer == defenderPlayer) {
            return false;
        }
        boolean atWar = attackerPlayer.atWarWith(defenderPlayer);
        if (attackerPlayer.isEuropean() ? !atWar : attackerPlayer.isIndian() && !atWar && attackerPlayer.getTension(defenderPlayer).getLevel().compareTo(Tension.Level.CONTENT) <= 0) {
            return false;
        }
        return !(attacker.isNaval() ? settlement != null || !defender.isNaval() || defender.getTile().isLand() : defender != null && !defender.getTile().isLand());
    }

    public FoundingFather selectFoundingFather(List<FoundingFather> ffs) {
        return null;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIPlayer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setPlayer((ServerPlayer)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }
}

