/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class BuildColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(BuildColonyMission.class.getName());
    private Tile target;
    private int colonyValue;

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, Tile target, int colonyValue) {
        super(aiMain, aiUnit);
        this.target = target;
        this.colonyValue = colonyValue;
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        if (!this.getUnit().isColonist()) {
            logger.warning("Only colonists can build a new Colony.");
            throw new IllegalArgumentException("Only colonists can build a new Colony.");
        }
    }

    public BuildColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public BuildColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public Tile getTarget() {
        return this.target;
    }

    public void doMission(Connection connection) {
        Map.Direction r;
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        if (!this.isValid()) {
            return;
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return;
        }
        if (!(tile == this.target || (r = this.moveTowards(this.target)) != null && this.moveButDontAttack(r))) {
            return;
        }
        if (unit.canBuildColony() && tile == this.target && unit.getMovesLeft() > 0) {
            if (this.target.getOwner() != null) {
                if (player.owns(this.target)) {
                    Colony colony = (Colony)this.target.getOwningSettlement();
                    if (colony != null && colony.getColonyTile(this.target) != null) {
                        colony.getColonyTile(this.target).relocateWorkers();
                    }
                } else {
                    int price = player.getLandPrice(this.target);
                    if (price < 0) {
                        this.target = null;
                        return;
                    }
                    if (price > 0 && !player.checkGold(price) && Utils.randomInt(logger, "Cheat gold", this.getAIRandom(), 4) == 0) {
                        player.modifyGold(price);
                    }
                    if (!AIMessage.askClaimLand(connection, this.target, null, player.checkGold(price) ? price : -1) || !player.owns(this.target)) {
                        this.target = null;
                        return;
                    }
                }
            }
            if (AIMessage.askBuildColony(this.getAIUnit(), "") && this.target.getSettlement() != null) {
                AIColony aiColony = this.getAIMain().getAIColony(this.target.getColony());
                this.getAIUnit().setMission(new WorkInsideColonyMission(this.getAIMain(), this.getAIUnit(), aiColony));
            } else {
                logger.warning("Could not build an AI colony on tile " + this.target.getPosition().toString());
            }
        }
    }

    public Tile getTransportDestination() {
        if (this.target == null) {
            return (this.getUnit().isOnCarrier() ? (Unit)this.getUnit().getLocation() : this.getUnit()).getFullEntryLocation();
        }
        if (this.getUnit().isOnCarrier()) {
            return this.target;
        }
        if (this.getUnit().getLocation().getTile() == this.target) {
            return null;
        }
        if (this.getUnit().getTile() == null) {
            return this.target;
        }
        if (this.getUnit().findPath(this.target) == null) {
            return this.target;
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public static Tile findColonyLocation(Unit unit) {
        Game game = unit.getGame();
        Map map = game.getMap();
        Player player = unit.getOwner();
        Tile startTile = null;
        Unit carrier = null;
        if (unit.isOnCarrier()) {
            carrier = (Unit)unit.getLocation();
            startTile = carrier.getTile();
        } else {
            startTile = unit.isInEurope() || unit.isAtSea() ? unit.getFullEntryLocation() : unit.getTile();
        }
        if (startTile == null) {
            logger.warning("findColonyLocation failed, unit " + unit.getId() + " not on the map");
            return null;
        }
        Tile bestTile = null;
        float bestValue = 0.0f;
        Map.CircleIterator it = map.getCircleIterator(startTile.getPosition(), true, 20);
        block3: while (it.hasNext()) {
            float value;
            Tile tile = map.getTile((Map.Position)it.next());
            if (!tile.isLand() || map.isPolar(tile)) continue;
            switch (player.canClaimToFoundSettlementReason(tile)) {
                case NONE: 
                case NATIVES: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            int val = unit.getOwner().getColonyValue(tile);
            if (val <= 0) continue;
            float len = 1.0f;
            if (tile != startTile) {
                PathNode path = unit.findPath(startTile, tile, carrier);
                if (path == null) continue;
                len += (float)path.getTotalTurns();
            }
            if (!((value = (float)val / len) > bestValue)) continue;
            bestValue = value;
            bestTile = tile;
        }
        logger.finest("findColonyLocation(" + unit.getId() + ") found tile: " + bestTile);
        return bestTile;
    }

    public boolean isValid() {
        return super.isValid() && this.target != null && this.target.getSettlement() == null && this.colonyValue <= this.getUnit().getOwner().getColonyValue(this.target);
    }

    public String getDebuggingInfo() {
        String targetName = this.target != null ? this.target.getPosition().toString() : "unassigned";
        return targetName + " " + this.colonyValue;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, BuildColonyMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, "target", this.target);
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String targetStr = in.getAttributeValue(null, "target");
        this.target = targetStr != null ? (Tile)this.getGame().getFreeColGameObject(targetStr) : null;
    }

    public static String getXMLElementTagName() {
        return "buildColonyMission";
    }
}

