/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class IdleAtColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IdleAtColonyMission.class.getName());

    public IdleAtColonyMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public IdleAtColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public IdleAtColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public Location getTransportDestination() {
        Unit unit = this.getUnit();
        if (unit.getTile() == null || unit.getTile().getSettlement() != null) {
            return null;
        }
        PathNode path = this.findNearestOtherSettlement(unit);
        Tile target = path == null ? null : path.getLastNode().getTile();
        return target != null && this.shouldTakeTransportToTile(target) ? target : null;
    }

    public boolean isOneTime() {
        return true;
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        Tile tile = unit.getTile();
        if (tile == null) {
            return;
        }
        if (tile.getSettlement() != null) {
            logger.finest("Unit " + unit.getId() + " idle at settlement: " + tile.getSettlement().getId());
            return;
        }
        PathNode path = this.findNearestOtherSettlement(unit);
        if (path != null) {
            Map.Direction r = this.moveTowards(path);
            if (r == null || !this.moveButDontAttack(r)) {
                return;
            }
        } else {
            this.moveRandomly();
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, IdleAtColonyMission.getXMLElementTagName());
    }

    public static String getXMLElementTagName() {
        return "idleAtColonyMission";
    }
}

