/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class PioneeringMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PioneeringMission.class.getName());
    private static final int MAX_TURNS = 10;
    private TileImprovementPlan tileImprovementPlan = null;
    private Colony colonyWithTools = null;

    public PioneeringMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        if (!this.hasTools()) {
            this.colonyWithTools = PioneeringMission.findColonyWithTools(aiUnit);
        }
        this.tileImprovementPlan = PioneeringMission.findTileImprovementPlan(aiUnit);
        this.tileImprovementPlan.setPioneer(aiUnit);
        logger.finest("AI pioneer starts with plan " + this.tileImprovementPlan + "/" + this.tileImprovementPlan.getTarget() + ": " + aiUnit.getUnit());
    }

    public PioneeringMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public PioneeringMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public TileImprovementPlan getTileImprovementPlan() {
        return this.tileImprovementPlan;
    }

    public void setTileImprovementPlan(TileImprovementPlan tip) {
        this.tileImprovementPlan = tip;
    }

    private void abandonTileImprovementPlan() {
        if (this.tileImprovementPlan != null) {
            if (this.tileImprovementPlan.getPioneer() == this.getAIUnit()) {
                this.tileImprovementPlan.setPioneer(null);
            }
            this.tileImprovementPlan = null;
        }
    }

    public void dispose() {
        this.abandonTileImprovementPlan();
        super.dispose();
    }

    private EuropeanAIPlayer getEuropeanAIPlayer() {
        return (EuropeanAIPlayer)this.getAIMain().getAIPlayer(this.getUnit().getOwner());
    }

    private static boolean hasTools(AIUnit aiUnit) {
        return aiUnit.getUnit().hasAbility("model.ability.improveTerrain");
    }

    private boolean hasTools() {
        return PioneeringMission.hasTools(this.getAIUnit());
    }

    private static boolean checkColonyForTools(AIUnit aiUnit, Colony colony) {
        return colony != null && !colony.isDisposed() && colony.getOwner() == aiUnit.getUnit().getOwner() && colony.canProvideEquipment(Unit.Role.PIONEER.getRoleEquipment(colony.getSpecification()));
    }

    public static Colony findColonyWithTools(final AIUnit aiUnit) {
        Unit unit = aiUnit.getUnit();
        if (unit == null || unit.isDisposed()) {
            return null;
        }
        Tile startTile = PioneeringMission.getPathStartTile(unit);
        if (startTile == null) {
            return null;
        }
        if (PioneeringMission.checkColonyForTools(aiUnit, startTile.getColony())) {
            return startTile.getColony();
        }
        GoalDecider equipDecider = new GoalDecider(){
            private PathNode best = null;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode path) {
                Colony colony = path.getTile().getColony();
                if (PioneeringMission.checkColonyForTools(aiUnit, colony)) {
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
        PathNode path = unit.search(startTile, equipDecider, CostDeciders.avoidIllegal(), 10, unit.isOnCarrier() ? (Unit)unit.getLocation() : null);
        return path == null ? null : path.getLastNode().getTile().getColony();
    }

    private static boolean validateTileImprovementPlan(TileImprovementPlan tip, EuropeanAIPlayer aiPlayer) {
        if (tip == null) {
            return false;
        }
        Tile target = tip.getTarget();
        if (target == null) {
            logger.warning("Removing targetless TileImprovementPlan");
            aiPlayer.removeTileImprovementPlan(tip);
            tip.dispose();
            return false;
        }
        if (target.hasImprovement(tip.getType())) {
            logger.finest("Removing obsolete TileImprovementPlan");
            aiPlayer.removeTileImprovementPlan(tip);
            tip.dispose();
            return false;
        }
        if (tip.getPioneer() != null && (tip.getPioneer().getUnit() == null || tip.getPioneer().getUnit().isDisposed())) {
            logger.warning("Clearing broken pioneer for TileImprovementPlan");
            tip.setPioneer(null);
        }
        return true;
    }

    private boolean checkTileImprovementPlan(TileImprovementPlan tip) {
        return PioneeringMission.validateTileImprovementPlan(tip, this.getEuropeanAIPlayer());
    }

    public static TileImprovementPlan findTileImprovementPlan(AIUnit aiUnit) {
        Unit unit = aiUnit.getUnit();
        if (unit == null || unit.isDisposed()) {
            return null;
        }
        Tile startTile = PioneeringMission.getPathStartTile(unit);
        if (startTile == null) {
            return null;
        }
        final HashMap<Tile, TileImprovementPlan> tipMap = new HashMap<Tile, TileImprovementPlan>();
        EuropeanAIPlayer aiPlayer = (EuropeanAIPlayer)aiUnit.getAIMain().getAIPlayer(unit.getOwner());
        for (TileImprovementPlan tip : aiPlayer.getTileImprovementPlans()) {
            if (!PioneeringMission.validateTileImprovementPlan(tip, aiPlayer)) continue;
            if (tip.getPioneer() == aiUnit) {
                return tip;
            }
            if (tip.getPioneer() != null) continue;
            if (startTile == tip.getTarget()) {
                return tip;
            }
            TileImprovementPlan other = (TileImprovementPlan)tipMap.get(tip.getTarget());
            if (other != null && other.getValue() >= tip.getValue()) continue;
            tipMap.put(tip.getTarget(), tip);
        }
        GoalDecider tipDecider = new GoalDecider(){
            private PathNode best = null;
            private int bestValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode path) {
                int value;
                TileImprovementPlan tip = (TileImprovementPlan)tipMap.get(path.getTile());
                if (tip != null && (value = tip.getValue() - 5 * path.getTotalTurns()) > this.bestValue) {
                    this.bestValue = value;
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
        if (tipMap.get(startTile) != null) {
            return (TileImprovementPlan)tipMap.get(startTile);
        }
        PathNode path = tipMap.isEmpty() ? null : unit.search(startTile, tipDecider, CostDeciders.avoidIllegal(), 10, unit.isOnCarrier() ? (Unit)unit.getLocation() : null);
        return path == null ? null : (TileImprovementPlan)tipMap.get(path.getLastNode().getTile());
    }

    public Location getTransportDestination() {
        Tile target = this.hasTools() ? (!this.checkTileImprovementPlan(this.tileImprovementPlan) ? null : this.tileImprovementPlan.getTarget()) : (!PioneeringMission.checkColonyForTools(this.getAIUnit(), this.colonyWithTools) ? null : this.colonyWithTools.getTile());
        return this.shouldTakeTransportToTile(target) ? target : null;
    }

    public boolean isValid() {
        return super.isValid() && this.getUnit().isPerson() && this.checkTileImprovementPlan(this.tileImprovementPlan) && (this.hasTools() || PioneeringMission.checkColonyForTools(this.getAIUnit(), this.colonyWithTools));
    }

    public static boolean isValid(AIUnit aiUnit) {
        return Mission.isValid(aiUnit) && aiUnit.getUnit().isPerson() && PioneeringMission.findTileImprovementPlan(aiUnit) != null && (PioneeringMission.hasTools(aiUnit) || PioneeringMission.findColonyWithTools(aiUnit) != null);
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        if (unit.getTile() == null) {
            logger.finest("AI pioneer waiting to go to" + this.getTransportDestination() + ": " + unit);
            return;
        }
        if (!this.hasTools()) {
            if (this.colonyWithTools != null && !PioneeringMission.checkColonyForTools(this.getAIUnit(), this.colonyWithTools)) {
                this.colonyWithTools = null;
            }
            if (this.colonyWithTools == null) {
                this.colonyWithTools = PioneeringMission.findColonyWithTools(this.getAIUnit());
            }
            if (this.colonyWithTools == null) {
                this.abandonTileImprovementPlan();
                logger.finest("AI pioneer can not find equipment: " + unit);
                return;
            }
            if (unit.getTile() != this.colonyWithTools.getTile()) {
                PathNode path = unit.findPath(this.colonyWithTools.getTile());
                if (path == null) {
                    if (unit.isOnCarrier()) {
                        logger.finest("AI pioneer in transit to " + this.colonyWithTools.getName() + ": " + unit);
                        return;
                    }
                    this.abandonTileImprovementPlan();
                    logger.finest("AI pioneer can not find path to " + this.colonyWithTools.getName() + ": " + unit);
                    this.colonyWithTools = null;
                    return;
                }
                Map.Direction direction = this.moveTowards(path);
                if (direction != null && !this.moveButDontAttack(direction)) {
                    this.abandonTileImprovementPlan();
                    logger.finest("AI pioneer died en route to " + this.colonyWithTools.getName() + ": " + unit);
                    return;
                }
                if (unit.getTile() != this.colonyWithTools.getTile()) {
                    unit.setMovesLeft(0);
                    logger.finest("AI pioneer at " + unit.getTile() + " en route to " + this.colonyWithTools.getName() + ": " + unit);
                    return;
                }
            }
            this.getAIUnit().equipForRole(Unit.Role.PIONEER, false);
            if (!this.hasTools()) {
                this.abandonTileImprovementPlan();
                logger.finest("AI pioneer reached " + this.colonyWithTools.getName() + " but could not equip: " + unit);
                return;
            }
            logger.finest("AI pioneer reached " + this.colonyWithTools.getName() + " and equips: " + unit);
            this.colonyWithTools = null;
        }
        Player player = unit.getOwner();
        EuropeanAIPlayer aiPlayer = this.getEuropeanAIPlayer();
        if (this.tileImprovementPlan != null && !PioneeringMission.validateTileImprovementPlan(this.tileImprovementPlan, aiPlayer)) {
            this.tileImprovementPlan = null;
        }
        if (this.tileImprovementPlan == null) {
            AIUnit aiu = this.getAIUnit();
            this.tileImprovementPlan = PioneeringMission.findTileImprovementPlan(aiu);
            if (this.tileImprovementPlan == null) {
                logger.finest("AI pioneer could not find an improvement: " + unit);
                return;
            }
            this.tileImprovementPlan.setPioneer(aiu);
        }
        Tile target = this.tileImprovementPlan.getTarget();
        if (unit.getTile() != target) {
            PathNode path = unit.findPath(target);
            if (path == null) {
                if (unit.isOnCarrier()) {
                    logger.finest("AI pioneer in transit to " + target + ": " + unit);
                } else {
                    logger.finest("AI pioneer can not get from " + unit.getTile() + " to " + target + ": " + unit);
                }
                return;
            }
            Map.Direction direction = this.moveTowards(path);
            if (direction != null && !this.moveButDontAttack(direction)) {
                this.abandonTileImprovementPlan();
                logger.finest("AI pioneer died en route to " + target + ": " + unit);
                return;
            }
            if (unit.getTile() != target) {
                logger.finest("AI pioneer at " + unit.getTile() + " en route to " + target + ": " + unit);
                unit.setMovesLeft(0);
                return;
            }
        }
        if (!player.owns(target)) {
            boolean fail = false;
            int price = player.getLandPrice(target);
            if (price < 0) {
                fail = true;
            } else {
                if (price > 0 && !player.checkGold(price)) {
                    price = -1;
                }
                if (!AIMessage.askClaimLand(aiPlayer.getConnection(), target, null, price) || !player.owns(target)) {
                    fail = true;
                }
            }
            if (fail) {
                aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
                this.tileImprovementPlan.dispose();
                this.tileImprovementPlan = null;
                logger.finest("AI pioneer can not claim land at " + target + ": " + unit);
                return;
            }
        }
        if (unit.getState() == Unit.UnitState.IMPROVING) {
            unit.setMovesLeft(0);
            logger.finest("AI pioneer improving " + this.tileImprovementPlan.getType() + ": " + unit);
        } else if (unit.checkSetState(Unit.UnitState.IMPROVING)) {
            if (AIMessage.askChangeWorkImprovementType(this.getAIUnit(), this.tileImprovementPlan.getType())) {
                logger.finest("AI pioneer began improvement " + this.tileImprovementPlan.getType() + " at target " + target + ": " + unit);
            } else {
                aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
                this.tileImprovementPlan.dispose();
                this.tileImprovementPlan = null;
                logger.finest("AI pioneer failed to improve " + target + ": " + unit);
            }
        } else {
            logger.finest("AI pioneer waiting to improve at " + target.getId() + ": " + unit);
        }
    }

    public String getDebuggingInfo() {
        if (this.hasTools()) {
            if (this.tileImprovementPlan == null) {
                return "No target";
            }
            String action = this.tileImprovementPlan.getType().getNameKey();
            return this.tileImprovementPlan.getTarget().getPosition().toString() + " " + action;
        }
        if (this.colonyWithTools == null) {
            return "No target";
        }
        return "Getting tools from " + this.colonyWithTools.getName();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, PioneeringMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, "tileImprovementPlan", this.tileImprovementPlan);
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String tileImprovementPlanStr = in.getAttributeValue(null, "tileImprovementPlan");
        if (tileImprovementPlanStr != null) {
            this.tileImprovementPlan = (TileImprovementPlan)this.getAIMain().getAIObject(tileImprovementPlanStr);
            if (this.tileImprovementPlan == null) {
                this.tileImprovementPlan = new TileImprovementPlan(this.getAIMain(), tileImprovementPlanStr);
            }
        } else {
            this.tileImprovementPlan = null;
        }
    }

    public static String getXMLElementTagName() {
        return "pioneeringMission";
    }
}

