/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.GoodsForSaleMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.REFAIPlayer;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.model.DiplomacySession;
import net.sf.freecol.server.model.LootSession;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.TradeSession;
import net.sf.freecol.server.model.TransactionSession;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameController
extends Controller {
    private static Logger logger = Logger.getLogger(InGameController.class.getName());
    public static final int ALARM_NEW_MISSIONARY = -100;
    public static final int SCORE_INDEPENDENCE_DECLARED = 100;
    public static final int SCORE_INDEPENDENCE_GRANTED = 1000;
    private final Random random;
    private int debugOnlyAITurns = 0;
    private Monarch.MonarchAction debugMonarchAction = null;
    private ServerPlayer debugMonarchPlayer = null;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private static final List<FutureQuery> outstandingQueries = new ArrayList<FutureQuery>();

    public InGameController(FreeColServer freeColServer, Random random) {
        super(freeColServer);
        this.random = random;
    }

    public int getSkippedTurns() {
        return FreeCol.isInDebugMode() ? this.debugOnlyAITurns : -1;
    }

    public void setSkippedTurns(int turns) {
        if (FreeCol.isInDebugMode()) {
            this.debugOnlyAITurns = turns;
        }
    }

    public void setMonarchAction(Player player, Monarch.MonarchAction action) {
        if (FreeCol.isInDebugMode()) {
            this.debugMonarchPlayer = (ServerPlayer)player;
            this.debugMonarchAction = action;
        }
    }

    public int stepRandom() {
        return Utils.randomInt(logger, "step random", this.random, 100);
    }

    public void yearlyGoodsAdjust(ServerPlayer serverPlayer) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csYearlyGoodsAdjust(this.random, cs);
        this.sendElement(serverPlayer, cs);
    }

    public void addFoundingFather(ServerPlayer serverPlayer, FoundingFather father) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csAddFoundingFather(father, this.random, cs);
        this.sendElement(serverPlayer, cs);
    }

    public void changeStance(Player player, Player.Stance stance, Player otherPlayer, boolean symmetric) {
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ChangeSet cs = new ChangeSet();
        if (serverPlayer.csChangeStance(stance, otherPlayer, symmetric, cs)) {
            this.sendToAll(cs);
        }
    }

    public NationSummary getNationSummary(ServerPlayer serverPlayer, Player player) {
        return new NationSummary(player, serverPlayer);
    }

    public void moveGoods(Goods goods, Location loc) throws IllegalStateException {
        Location oldLoc = goods.getLocation();
        if (oldLoc == null) {
            throw new IllegalStateException("Goods in null location.");
        }
        if (loc != null) {
            if (loc instanceof Unit) {
                if (((Unit)loc).isInEurope()) {
                    if (!(oldLoc instanceof Unit) || !((Unit)oldLoc).isInEurope()) {
                        throw new IllegalStateException("Goods and carrier not both in Europe.");
                    }
                } else {
                    if (loc.getTile() == null) {
                        throw new IllegalStateException("Carrier not on the map.");
                    }
                    if (!(oldLoc instanceof Settlement) && loc.getTile() != oldLoc.getTile()) {
                        throw new IllegalStateException("Goods and carrier not co-located.");
                    }
                }
            } else if (!(loc instanceof IndianSettlement)) {
                if (loc instanceof Colony) {
                    if (!(oldLoc instanceof Unit && ((Unit)oldLoc).getOwner() != ((Colony)loc).getOwner() || loc.getTile() == oldLoc.getTile())) {
                        throw new IllegalStateException("Goods and carrier not both in Colony.");
                    }
                } else if (loc.getGoodsContainer() == null) {
                    throw new IllegalStateException("New location with null GoodsContainer.");
                }
            }
        }
        oldLoc.getGoodsContainer().saveState();
        if (loc != null) {
            loc.getGoodsContainer().saveState();
        }
        oldLoc.remove(goods);
        goods.setLocation(null);
        if (loc != null) {
            loc.add(goods);
            goods.setLocation(loc);
        }
    }

    public ServerPlayer createREFPlayer(ServerPlayer serverPlayer) {
        Nation refNation = serverPlayer.getNation().getRefNation();
        Monarch monarch = serverPlayer.getMonarch();
        ServerPlayer refPlayer = this.getFreeColServer().addAIPlayer(refNation);
        refPlayer.setEntryLocation(null);
        Player.makeContact(serverPlayer, refPlayer);
        List<Unit> landUnits = refPlayer.createUnits(monarch.getREFLandUnits());
        List<Unit> navalUnits = refPlayer.createUnits(monarch.getREFNavalUnits());
        ArrayList<Unit> unitsList = new ArrayList<Unit>();
        unitsList.addAll(navalUnits);
        unitsList.addAll(landUnits);
        Collections.shuffle(navalUnits, this.random);
        Collections.shuffle(landUnits, this.random);
        for (Unit unit : landUnits) {
            for (Unit carrier : navalUnits) {
                if (unit.getSpaceTaken() > carrier.getSpaceLeft()) continue;
                unit.setLocation(carrier);
            }
        }
        for (Unit u : navalUnits) {
            u.setWorkLeft(1);
            u.setDestination(this.getGame().getMap());
            u.setLocation(u.getOwner().getHighSeas());
        }
        return refPlayer;
    }

    private Future<DOMMessage> askFuture(ServerPlayer serverPlayer, DOMMessage question, DOMMessageHandler handler) {
        DOMMessageCallable callable = new DOMMessageCallable(serverPlayer.getConnection(), this.getGame(), question, handler);
        return this.executor.submit(callable);
    }

    public void resolveOutstandingQueries() {
        while (!outstandingQueries.isEmpty()) {
            FutureQuery fq = outstandingQueries.remove(0);
            if (fq.future.isDone()) continue;
            if (fq.runnable != null) {
                fq.runnable.run();
            }
            fq.future.cancel(true);
        }
    }

    private void askThisTurn(ServerPlayer serverPlayer, DOMMessage message, DOMMessageHandler handler, Runnable runnable) {
        new FutureQuery(this.askFuture(serverPlayer, message, handler), runnable);
    }

    private DOMMessage askTimeout(ServerPlayer serverPlayer, DOMMessage request) {
        DOMMessage reply;
        Future<DOMMessage> future = this.askFuture(serverPlayer, request, new DOMMessageHandler(){

            public DOMMessage handle(DOMMessage message) {
                return message;
            }
        });
        try {
            boolean single = this.getFreeColServer().isSingleplayer();
            reply = future.get(FreeCol.getFreeColTimeout(single), TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            this.sendElement(serverPlayer, new ChangeSet().addTrivial(ChangeSet.See.only(serverPlayer), "closeMenus", ChangeSet.ChangePriority.CHANGE_NORMAL, new String[0]));
            reply = null;
        }
        catch (Exception e) {
            reply = null;
            logger.log(Level.WARNING, "Exception completing future", e);
        }
        return reply;
    }

    private List<ServerPlayer> getOtherPlayers(ServerPlayer ... serverPlayers) {
        ArrayList<ServerPlayer> result = new ArrayList<ServerPlayer>();
        block0: for (Player otherPlayer : this.getGame().getPlayers()) {
            ServerPlayer enemyPlayer = (ServerPlayer)otherPlayer;
            if (!enemyPlayer.isConnected()) continue;
            for (ServerPlayer exclude : serverPlayers) {
                if (enemyPlayer == exclude) continue block0;
            }
            result.add(enemyPlayer);
        }
        return result;
    }

    private void sendToAll(ChangeSet cs) {
        this.sendToList(this.getOtherPlayers(new ServerPlayer[0]), cs);
    }

    private void sendToOthers(ServerPlayer serverPlayer, ChangeSet cs) {
        this.sendToList(this.getOtherPlayers(serverPlayer), cs);
    }

    private void sendToOthers(ServerPlayer serverPlayer, Element element) {
        this.sendToList(this.getOtherPlayers(serverPlayer), element);
    }

    private void sendToList(List<ServerPlayer> serverPlayers, ChangeSet cs) {
        for (ServerPlayer s : serverPlayers) {
            this.sendElement(s, cs);
        }
    }

    private void sendToList(List<ServerPlayer> serverPlayers, Element element) {
        if (element != null) {
            for (ServerPlayer s : serverPlayers) {
                this.askElement(s, element);
            }
        }
    }

    private void sendElement(ServerPlayer serverPlayer, ChangeSet cs) {
        this.askElement(serverPlayer, cs.build(serverPlayer));
    }

    private Element askElement(ServerPlayer serverPlayer, Element request) {
        Element reply;
        Connection connection = serverPlayer.getConnection();
        if (request == null || connection == null) {
            return null;
        }
        try {
            reply = connection.askDumping(request);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send \"" + request.getTagName() + "\"-message.", e);
            reply = null;
        }
        return reply;
    }

    private void csSpeakToChief(ServerPlayer serverPlayer, IndianSettlement is, boolean scout, ChangeSet cs) {
        serverPlayer.csContact((ServerPlayer)is.getOwner(), null, cs);
        is.makeContactSettlement(serverPlayer);
        if (scout || this.getGame().getSpecification().getBooleanOption("model.option.settlementActionsContactChief").getValue().booleanValue()) {
            is.setSpokenToChief(serverPlayer);
        }
    }

    public Element endTurn(ServerPlayer serverPlayer) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerGame game = this.getGame();
        ServerPlayer player = (ServerPlayer)game.getCurrentPlayer();
        if (serverPlayer != player) {
            throw new IllegalArgumentException("It is not " + serverPlayer.getName() + "'s turn, it is " + (player == null ? "noone" : player.getName()) + "'s!");
        }
        while (true) {
            player.clearModelMessages();
            Player winner = game.checkForWinner();
            if (!(winner == null || freeColServer.isSingleplayer() && winner.isAI())) {
                ChangeSet cs = new ChangeSet();
                cs.addTrivial(ChangeSet.See.all(), "gameEnded", ChangeSet.ChangePriority.CHANGE_NORMAL, "winner", winner.getId());
                this.sendToOthers(serverPlayer, cs);
                return cs.build(serverPlayer);
            }
            boolean human = false;
            for (Player p : game.getPlayers()) {
                if (p.isDead() || p.isAI() || !((ServerPlayer)p).isConnected()) continue;
                human = true;
                break;
            }
            if (!human) {
                game.setCurrentPlayer(null);
                return null;
            }
            ChangeSet cs = new ChangeSet();
            if (player.isAI() && player.isEuropean()) {
                for (Colony c : player.getColonies()) {
                    cs.add(ChangeSet.See.perhaps().except(player), c);
                }
            }
            this.resolveOutstandingQueries();
            if (game.isNextPlayerInNewTurn()) {
                game.csNewTurn(this.random, cs);
                if (this.debugOnlyAITurns > 0 && --this.debugOnlyAITurns <= 0 && FreeCol.getDebugRunTurns() > 0) {
                    FreeCol.completeDebugRun();
                }
            }
            if ((player = (ServerPlayer)game.getNextPlayer()) == null) {
                return DOMMessage.clientError("Can not get next player");
            }
            if (player.checkForDeath()) {
                player.csWithdraw(cs);
                this.sendToAll(cs);
                logger.info(player.getNation() + " is dead.");
                continue;
            }
            if (player.isREF() && player.checkForREFDefeat()) {
                for (Player p : player.getRebels()) {
                    this.csGiveIndependence(player, (ServerPlayer)p, cs);
                }
                player.csWithdraw(cs);
                this.sendToAll(cs);
                logger.info(player.getNation() + " is defeated.");
                continue;
            }
            game.setCurrentPlayer(player);
            if (player.isREF() && player.getEntryLocation() == null) {
                Iterator<FreeColGameObject> i$;
                boolean teleport;
                REFAIPlayer refAIPlayer = (REFAIPlayer)freeColServer.getAIPlayer(player);
                Tile entry = refAIPlayer.initialize(teleport = this.getGame().getSpecification().getBoolean("model.option.teleportREF"));
                if (entry == null && (i$ = player.getRebels().iterator()).hasNext()) {
                    Player p = i$.next();
                    entry = p.getEntryLocation().getTile();
                }
                player.setEntryLocation(entry);
                logger.info(player.getName() + " will appear at " + entry);
                if (teleport) {
                    i$ = player.getUnits().iterator();
                    while (i$.hasNext()) {
                        Unit u = (Unit)i$.next();
                        if (!u.isNaval()) continue;
                        u.setLocation(entry);
                        u.setWorkLeft(-1);
                        u.setState(Unit.UnitState.ACTIVE);
                    }
                    cs.add(ChangeSet.See.perhaps(), entry);
                }
            }
            player.csStartTurn(this.random, cs);
            this.nextFoundingFather(player);
            cs.addTrivial(ChangeSet.See.all(), "setCurrentPlayer", ChangeSet.ChangePriority.CHANGE_LATE, "player", player.getId());
            Monarch monarch = player.getMonarch();
            if (monarch != null) {
                Monarch.MonarchAction action = null;
                if (this.debugMonarchAction != null && player == this.debugMonarchPlayer) {
                    action = this.debugMonarchAction;
                    this.debugMonarchAction = null;
                    this.debugMonarchPlayer = null;
                    logger.finest("Debug monarch action: " + (Object)((Object)action));
                } else {
                    action = (Monarch.MonarchAction)((Object)RandomChoice.getWeightedRandom(logger, "Choose monarch action", this.random, monarch.getActionChoices()));
                }
                if (action != null) {
                    if (monarch.actionIsValid(action)) {
                        logger.finest("Monarch action: " + (Object)((Object)action));
                        this.csMonarchAction(player, action, cs);
                    } else {
                        logger.finest("Skipping invalid monarch action: " + (Object)((Object)action));
                    }
                }
            }
            this.sendToOthers(serverPlayer, cs);
            if (player.isAI() || player.isConnected() && this.debugOnlyAITurns <= 0) {
                return cs.build(serverPlayer);
            }
            this.sendElement(serverPlayer, cs);
        }
    }

    private void nextFoundingFather(final ServerPlayer serverPlayer) {
        List<FoundingFather> ffs;
        if (!serverPlayer.canRecruitFoundingFather()) {
            return;
        }
        if (serverPlayer.getOfferedFathers().isEmpty()) {
            serverPlayer.setOfferedFathers(serverPlayer.getRandomFoundingFathers(this.random));
        }
        if ((ffs = serverPlayer.getOfferedFathers()).isEmpty()) {
            return;
        }
        this.askThisTurn(serverPlayer, new ChooseFoundingFatherMessage(ffs), new DOMMessageHandler(){

            public DOMMessage handle(DOMMessage request) {
                ChooseFoundingFatherMessage message = (ChooseFoundingFatherMessage)request;
                FoundingFather ff = message.getResult();
                if (ff == null) {
                    logger.warning("No founding father selected");
                } else if (!ffs.contains(ff)) {
                    logger.warning("Invalid founding father: " + ff.getId());
                } else {
                    serverPlayer.setCurrentFather(ff);
                    serverPlayer.clearOfferedFathers();
                    logger.info("Selected founding father: " + ff);
                }
                return null;
            }
        }, null);
    }

    private void csGiveIndependence(ServerPlayer serverPlayer, ServerPlayer independent, ChangeSet cs) {
        serverPlayer.csChangeStance(Player.Stance.PEACE, independent, true, cs);
        independent.setPlayerType(Player.PlayerType.INDEPENDENT);
        ServerGame game = this.getGame();
        Turn turn = game.getTurn();
        independent.modifyScore(1000 - turn.getNumber());
        independent.setTax(0);
        independent.reinitialiseMarket();
        cs.addGlobalHistory(game, new HistoryEvent(turn, HistoryEvent.EventType.INDEPENDENCE));
        cs.addMessage(ChangeSet.See.only(independent), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.independence", independent).addStringTemplate("%ref%", serverPlayer.getNationName()));
        ArrayList<Unit> surrenderUnits = new ArrayList<Unit>();
        for (Unit u : serverPlayer.getUnits()) {
            if (u.isNaval()) continue;
            surrenderUnits.add(u);
        }
        if (surrenderUnits.size() > 0) {
            for (Unit u : surrenderUnits) {
                UnitType downgrade = u.getTypeChange(UnitTypeChange.ChangeType.CAPTURE, independent);
                if (downgrade != null) {
                    u.setType(downgrade);
                }
                u.setOwner(independent);
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), u);
            }
            cs.addMessage(ChangeSet.See.only(independent), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.independence.unitsAcquired", independent).addStringTemplate("%units%", this.unitTemplate(", ", surrenderUnits)));
        }
        cs.addPartial(ChangeSet.See.all().except(independent), independent, "playerType");
        cs.addMessage(ChangeSet.See.all().except(independent), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.player.independence.announce", independent).addStringTemplate("%nation%", independent.getNationName()).addStringTemplate("%ref%", serverPlayer.getNationName()));
        cs.add(ChangeSet.See.only(independent), independent);
    }

    private StringTemplate unitTemplate(String base, List<Unit> units) {
        StringTemplate template = StringTemplate.label(base);
        for (Unit u : units) {
            template.addStringTemplate(u.getLabel());
        }
        return template;
    }

    private StringTemplate abstractUnitTemplate(String base, List<AbstractUnit> units) {
        StringTemplate template = StringTemplate.label(base);
        Specification spec = this.getGame().getSpecification();
        for (AbstractUnit au : units) {
            template.addStringTemplate(au.getLabel(spec));
        }
        return template;
    }

    private String getNonPlayerNation() {
        int nations = Nation.EUROPEAN_NATIONS.length;
        int start = Utils.randomInt(logger, "Random nation", this.random, nations);
        for (int index = 0; index < nations; ++index) {
            String nationId = "model.nation." + Nation.EUROPEAN_NATIONS[(start + index) % nations];
            if (this.getGame().getPlayer(nationId) != null) continue;
            return nationId + ".name";
        }
        return "";
    }

    private void raiseTax(ServerPlayer serverPlayer, int taxRaise, Goods goods, boolean result) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csRaiseTax(taxRaise, goods, result, cs);
        this.sendElement(serverPlayer, cs);
    }

    private void csMonarchAction(final ServerPlayer serverPlayer, Monarch.MonarchAction action, ChangeSet cs) {
        Monarch monarch = serverPlayer.getMonarch();
        boolean valid = monarch.actionIsValid(action);
        if (!valid) {
            return;
        }
        String messageId = "model.monarch.action." + action.toString();
        switch (action) {
            case NO_ACTION: {
                break;
            }
            case RAISE_TAX_WAR: 
            case RAISE_TAX_ACT: {
                final int taxRaise = monarch.raiseTax(this.random);
                final Goods goods = serverPlayer.getMostValuableGoods();
                if (goods == null) {
                    logger.finest("Ignoring tax raise, no goods to boycott.");
                    break;
                }
                StringTemplate template = StringTemplate.template("model.monarch.action." + action.toString()).addStringTemplate("%goods%", goods.getType().getLabel(true)).addAmount("%amount%", taxRaise);
                if (action == Monarch.MonarchAction.RAISE_TAX_WAR) {
                    template = template.add("%nation%", this.getNonPlayerNation());
                } else if (action == Monarch.MonarchAction.RAISE_TAX_ACT) {
                    template = template.addAmount("%number%", Utils.randomInt(logger, "Tax act goods", this.random, 6)).addName("%newWorld%", serverPlayer.getNewLandName());
                }
                MonarchActionMessage message = new MonarchActionMessage(action, template);
                message.setTax(taxRaise);
                this.askThisTurn(serverPlayer, message, new DOMMessageHandler(){

                    public DOMMessage handle(DOMMessage message) {
                        boolean result = message instanceof MonarchActionMessage ? ((MonarchActionMessage)message).getResult() : false;
                        InGameController.this.raiseTax(serverPlayer, taxRaise, goods, result);
                        return null;
                    }
                }, new Runnable(){

                    public void run() {
                        InGameController.this.raiseTax(serverPlayer, taxRaise, goods, false);
                    }
                });
                break;
            }
            case LOWER_TAX_WAR: 
            case LOWER_TAX_OTHER: {
                int oldTax = serverPlayer.getTax();
                int taxLower = monarch.lowerTax(this.random);
                serverPlayer.csSetTax(taxLower, cs);
                StringTemplate template = StringTemplate.template(messageId).addAmount("%difference%", oldTax - taxLower).addAmount("%newTax%", taxLower);
                template = action == Monarch.MonarchAction.LOWER_TAX_WAR ? template.add("%nation%", this.getNonPlayerNation()) : template.addAmount("%number%", Utils.randomInt(logger, "Lower tax reason", this.random, 5));
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, template));
                break;
            }
            case WAIVE_TAX: {
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_NORMAL, new MonarchActionMessage(action, StringTemplate.template(messageId)));
                break;
            }
            case ADD_TO_REF: {
                AbstractUnit refAdditions = monarch.chooseForREF(this.random);
                if (refAdditions == null) break;
                monarch.addToREF(refAdditions);
                StringTemplate template = StringTemplate.template(messageId).addAmount("%number%", refAdditions.getNumber()).add("%unit%", refAdditions.getUnitType(this.getGame().getSpecification()).getNameKey());
                cs.add(ChangeSet.See.only(serverPlayer), monarch);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, template));
                break;
            }
            case DECLARE_WAR: {
                List<Player> enemies = monarch.collectPotentialEnemies();
                if (enemies.isEmpty()) break;
                Player enemy = Utils.getRandomMember(logger, "Choose enemy", enemies, this.random);
                serverPlayer.csChangeStance(Player.Stance.WAR, enemy, true, cs);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, StringTemplate.template(messageId).addStringTemplate("%nation%", enemy.getNationName())));
                break;
            }
            case SUPPORT_LAND: 
            case SUPPORT_SEA: {
                boolean sea = action == Monarch.MonarchAction.SUPPORT_SEA;
                List<AbstractUnit> support = monarch.getSupport(this.random, sea);
                if (support.isEmpty()) break;
                serverPlayer.createUnits(support);
                cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.getEurope());
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new MonarchActionMessage(action, StringTemplate.template(messageId).addStringTemplate("%addition%", this.abstractUnitTemplate(", ", support))));
                break;
            }
            case OFFER_MERCENARIES: {
                final List<AbstractUnit> mercenaries = monarch.getMercenaries(this.random);
                if (mercenaries.isEmpty()) break;
                final int mercPrice = serverPlayer.priceMercenaries(mercenaries);
                MonarchActionMessage message = new MonarchActionMessage(Monarch.MonarchAction.OFFER_MERCENARIES, StringTemplate.template("model.monarch.action.OFFER_MERCENARIES").addAmount("%gold%", mercPrice).addStringTemplate("%mercenaries%", this.abstractUnitTemplate(", ", mercenaries)));
                this.askThisTurn(serverPlayer, message, new DOMMessageHandler(){

                    public DOMMessage handle(DOMMessage message) {
                        boolean result;
                        boolean bl = result = message instanceof MonarchActionMessage ? ((MonarchActionMessage)message).getResult() : false;
                        if (result) {
                            ChangeSet cs = new ChangeSet();
                            serverPlayer.csAddMercenaries(mercenaries, mercPrice, cs);
                            InGameController.this.sendElement(serverPlayer, cs);
                        }
                        return null;
                    }
                }, null);
                break;
            }
            default: {
                logger.warning("Bogus action: " + (Object)((Object)action));
            }
        }
    }

    public Element checkHighScore(ServerPlayer serverPlayer) {
        FreeColServer freeColServer = this.getFreeColServer();
        boolean highScore = freeColServer.newHighScore(serverPlayer);
        if (highScore) {
            try {
                freeColServer.saveHighScores();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to save high scores", e);
                highScore = false;
            }
        }
        ChangeSet cs = new ChangeSet();
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "highScore", Boolean.toString(highScore));
        return cs.build(serverPlayer);
    }

    public Element retire(ServerPlayer serverPlayer) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csWithdraw(cs);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element continuePlaying(ServerPlayer serverPlayer) {
        ServerGame game = this.getGame();
        Element reply = null;
        if (!this.getFreeColServer().isSingleplayer()) {
            logger.warning("Can not continue playing in multiplayer!");
        } else if (serverPlayer != game.checkForWinner()) {
            logger.warning("Can not continue playing, as " + serverPlayer.getName() + " has not won the game!");
        } else {
            Specification spec = game.getSpecification();
            spec.getBooleanOption("model.option.victoryDefeatREF").setValue(false);
            spec.getBooleanOption("model.option.victoryDefeatEuropeans").setValue(false);
            spec.getBooleanOption("model.option.victoryDefeatHumans").setValue(false);
            reply = this.endTurn((ServerPlayer)game.getCurrentPlayer());
        }
        return reply;
    }

    public Element cashInTreasureTrain(ServerPlayer serverPlayer, Unit unit) {
        String messageId;
        int cashInAmount;
        ChangeSet cs = new ChangeSet();
        int fullAmount = unit.getTreasureAmount();
        if (serverPlayer.getPlayerType() == Player.PlayerType.COLONIAL) {
            cashInAmount = (fullAmount - unit.getTransportFee()) * (100 - serverPlayer.getTax()) / 100;
            messageId = "model.unit.cashInTreasureTrain.colonial";
        } else {
            cashInAmount = fullAmount;
            messageId = "model.unit.cashInTreasureTrain.independent";
        }
        serverPlayer.modifyGold(cashInAmount);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(messageId, serverPlayer, (FreeColObject)unit).addAmount("%amount%", fullAmount).addAmount("%cashInAmount%", cashInAmount));
        messageId = serverPlayer.getPlayerType() == Player.PlayerType.REBEL || serverPlayer.getPlayerType() == Player.PlayerType.INDEPENDENT ? "model.unit.cashInTreasureTrain.other.independent" : "model.unit.cashInTreasureTrain.other.colonial";
        cs.addMessage(ChangeSet.See.all().except(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, serverPlayer).addAmount("%amount%", fullAmount).addStringTemplate("%nation%", serverPlayer.getNationName()));
        cs.add(ChangeSet.See.only(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
        cs.addDispose(ChangeSet.See.only(serverPlayer), null, unit);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element declareIndependence(ServerPlayer serverPlayer, String nationName, String countryName) {
        ChangeSet cs = new ChangeSet();
        StringTemplate oldNation = serverPlayer.getNationName();
        serverPlayer.setIndependentNationName(nationName);
        serverPlayer.setNewLandName(countryName);
        serverPlayer.setPlayerType(Player.PlayerType.REBEL);
        serverPlayer.getFeatureContainer().addAbility(new Ability("model.ability.independenceDeclared"));
        serverPlayer.modifyScore(100);
        Turn turn = this.getGame().getTurn();
        cs.addGlobalHistory(this.getGame(), new HistoryEvent(turn, HistoryEvent.EventType.DECLARE_INDEPENDENCE));
        serverPlayer.clearModelMessages();
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "warOfIndependence.independenceDeclared", serverPlayer));
        Europe europe = serverPlayer.getEurope();
        StringTemplate seized = StringTemplate.label(", ");
        for (Unit u : europe.getUnitList()) {
            seized.addStringTemplate(u.getLabel());
        }
        if (!seized.getReplacements().isEmpty()) {
            cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.player.independence.unitsSeized", serverPlayer).addStringTemplate("%units%", seized));
        }
        HashMap<UnitType, UnitType> upgrades = new HashMap<UnitType, UnitType>();
        Specification spec = this.getGame().getSpecification();
        for (UnitType unitType : spec.getUnitTypeList()) {
            UnitType upgrade = unitType.getTargetType(UnitTypeChange.ChangeType.INDEPENDENCE, serverPlayer);
            if (upgrade == null) continue;
            upgrades.put(unitType, upgrade);
        }
        for (Colony colony : serverPlayer.getColonies()) {
            int sol = colony.getSoL();
            if (sol <= 50) continue;
            HashMap<UnitType, ArrayList<Unit>> unitMap = new HashMap<UnitType, ArrayList<Unit>>();
            List<Unit> allUnits = colony.getTile().getUnitList();
            allUnits.addAll(colony.getUnitList());
            for (Unit unit : allUnits) {
                if (!upgrades.containsKey(unit.getType())) continue;
                ArrayList<Unit> unitList = (ArrayList<Unit>)unitMap.get(unit.getType());
                if (unitList == null) {
                    unitList = new ArrayList<Unit>();
                    unitMap.put(unit.getType(), unitList);
                }
                unitList.add(unit);
            }
            for (Map.Entry entry : unitMap.entrySet()) {
                Unit unit;
                int limit = (((List)entry.getValue()).size() + 2) * (sol - 50) / 100;
                if (limit <= 0) continue;
                for (int index = 0; index < limit && (unit = (Unit)((List)entry.getValue()).get(index)) != null; ++index) {
                    unit.setType((UnitType)upgrades.get(entry.getKey()));
                    cs.add(ChangeSet.See.only(serverPlayer), unit);
                }
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.player.continentalArmyMuster", serverPlayer, colony).addName("%colony%", colony.getName()).addAmount("%number%", limit).add("%oldUnit%", ((UnitType)entry.getKey()).getNameKey()).add("%unit%", ((UnitType)upgrades.get(entry.getKey())).getNameKey()));
            }
        }
        ServerPlayer refPlayer = this.createREFPlayer(serverPlayer);
        serverPlayer.getHighSeas().removeDestination(europe);
        cs.addDispose(ChangeSet.See.only(serverPlayer), null, europe);
        serverPlayer.setEurope(null);
        serverPlayer.setMonarch(null);
        cs.addPartial(ChangeSet.See.all().except(serverPlayer), serverPlayer, "playerType", "independentNationName", "newLandName");
        cs.addMessage(ChangeSet.See.all().except(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.announce", serverPlayer).addStringTemplate("%oldNation%", oldNation).addStringTemplate("%newNation%", serverPlayer.getNationName()).add("%ruler%", serverPlayer.getRulerNameKey()));
        cs.add(ChangeSet.See.only(serverPlayer), serverPlayer);
        serverPlayer.csChangeStance(Player.Stance.WAR, refPlayer, true, cs);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element renameObject(ServerPlayer serverPlayer, Nameable object, String newName) {
        ChangeSet cs = new ChangeSet();
        object.setName(newName);
        FreeColGameObject fcgo = (FreeColGameObject)((Object)object);
        cs.addPartial(ChangeSet.See.all(), fcgo, "name");
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element getTransaction(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        TradeSession session = TransactionSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            if (unit.getMovesLeft() <= 0) {
                return DOMMessage.clientError("Unit " + unit.getId() + " has no moves left.");
            }
            session = new TradeSession(unit, settlement);
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        }
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "canBuy", Boolean.toString(session.getBuy()));
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "canSell", Boolean.toString(session.getSell()));
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "canGift", Boolean.toString(session.getGift()));
        return cs.build(serverPlayer);
    }

    public Element closeTransaction(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("No such transaction session.");
        }
        ChangeSet cs = new ChangeSet();
        if (!session.getActionTaken()) {
            unit.setMovesLeft(session.getMovesLeft());
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        }
        session.complete(cs);
        return cs.build(serverPlayer);
    }

    public Element getGoodsForSale(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        List<Goods> sellGoods = null;
        if (settlement instanceof IndianSettlement) {
            IndianSettlement indianSettlement = (IndianSettlement)settlement;
            AIPlayer aiPlayer = this.getFreeColServer().getAIPlayer(indianSettlement.getOwner());
            sellGoods = indianSettlement.getSellGoods(3, unit);
            for (Goods goods : sellGoods) {
                aiPlayer.registerSellGoods(goods);
            }
        } else {
            return DOMMessage.clientError("Bogus settlement");
        }
        return new GoodsForSaleMessage(unit, settlement, sellGoods).toXMLElement();
    }

    public Element buyProposition(ServerPlayer serverPlayer, Unit unit, Settlement settlement, Goods goods, int price) {
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Proposing to buy without opening a transaction session?!");
        }
        if (!session.getBuy()) {
            return DOMMessage.clientError("Proposing to buy in a session where buying is not allowed.");
        }
        ChangeSet cs = new ChangeSet();
        if (settlement instanceof IndianSettlement) {
            this.csSpeakToChief(serverPlayer, (IndianSettlement)settlement, false, cs);
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int gold = ai.buyProposition(unit, settlement, goods, price);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(gold));
        return cs.build(serverPlayer);
    }

    public Element sellProposition(ServerPlayer serverPlayer, Unit unit, Settlement settlement, Goods goods, int price) {
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Proposing to sell without opening a transaction session");
        }
        if (!session.getSell()) {
            return DOMMessage.clientError("Proposing to sell in a session where selling is not allowed.");
        }
        ChangeSet cs = new ChangeSet();
        if (settlement instanceof IndianSettlement) {
            this.csSpeakToChief(serverPlayer, (IndianSettlement)settlement, false, cs);
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int gold = ai.sellProposition(unit, settlement, goods, price);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(gold));
        return cs.build(serverPlayer);
    }

    public Element buyGoods(ServerPlayer serverPlayer, Unit unit, GoodsType type, int amount) {
        if (!serverPlayer.canTrade(type, Market.Access.EUROPE)) {
            return DOMMessage.clientError("Can not trade boycotted goods");
        }
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = unit.getGoodsContainer();
        container.saveState();
        serverPlayer.buy(container, type, amount, this.random);
        serverPlayer.csFlushMarket(type, cs);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), container);
        return cs.build(serverPlayer);
    }

    public Element sellGoods(ServerPlayer serverPlayer, Unit unit, GoodsType type, int amount) {
        if (!serverPlayer.canTrade(type, Market.Access.EUROPE)) {
            return DOMMessage.clientError("Can not trade boycotted goods");
        }
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = unit.getGoodsContainer();
        container.saveState();
        serverPlayer.sell(container, type, amount, this.random);
        serverPlayer.csFlushMarket(type, cs);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), container);
        return cs.build(serverPlayer);
    }

    public Element emigrate(ServerPlayer serverPlayer, int slot, Europe.MigrationType type) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csEmigrate(slot, type, this.random, cs);
        return cs.build(serverPlayer);
    }

    public Element move(ServerPlayer serverPlayer, Unit unit, Tile newTile) {
        ChangeSet cs = new ChangeSet();
        ((ServerUnit)unit).csMove(newTile, this.random, cs);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element declineMounds(ServerPlayer serverPlayer, Tile tile) {
        tile.removeLostCityRumour();
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.perhaps(), tile);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element setNewLandName(ServerPlayer serverPlayer, Unit unit, String name, ServerPlayer welcomer, int camps, boolean accept) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.setNewLandName(name);
        if (welcomer != null) {
            if (accept) {
                Tile tile = unit.getTile();
                tile.changeOwnership(serverPlayer, null);
                cs.add(ChangeSet.See.perhaps(), tile);
            } else {
                cs.add(ChangeSet.See.only(null).perhaps(serverPlayer), welcomer.modifyTension(serverPlayer, 300));
            }
        }
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "newLandName");
        Turn turn = serverPlayer.getGame().getTurn();
        cs.addHistory(serverPlayer, new HistoryEvent(turn, HistoryEvent.EventType.DISCOVER_NEW_WORLD).addName("%name%", name));
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element setNewRegionName(ServerPlayer serverPlayer, Region region, String name) {
        ChangeSet cs = new ChangeSet();
        cs.addRegion(serverPlayer, region, name);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element moveTo(ServerPlayer serverPlayer, Unit unit, Location destination) {
        ChangeSet cs = new ChangeSet();
        HighSeas highSeas = serverPlayer.getHighSeas();
        Location current = unit.getDestination();
        boolean others = false;
        boolean invalid = false;
        if (destination instanceof Europe) {
            if (!highSeas.getDestinations().contains(destination)) {
                return DOMMessage.clientError("HighSeas does not connect to: " + ((FreeColGameObject)((Object)destination)).getId());
            }
            if (unit.getLocation() == highSeas) {
                if (!(current instanceof Europe)) {
                    unit.setWorkLeft(unit.getSailTurns() - unit.getWorkLeft() + 1);
                }
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), unit, highSeas);
            } else if (unit.getTile() != null) {
                Tile tile = unit.getTile();
                unit.setEntryLocation(tile);
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                cs.addDisappear(serverPlayer, tile, unit);
                cs.add(ChangeSet.See.only(serverPlayer), tile, highSeas);
                others = true;
            } else {
                invalid = true;
            }
        } else if (destination instanceof Map) {
            if (!highSeas.getDestinations().contains(destination)) {
                return DOMMessage.clientError("HighSeas does not connect to: " + ((FreeColGameObject)((Object)destination)).getId());
            }
            if (unit.getLocation() == highSeas) {
                if (current != destination && (current == null || current.getTile() == null || current.getTile().getMap() != destination)) {
                    unit.setWorkLeft(unit.getSailTurns() - unit.getWorkLeft() + 1);
                }
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), highSeas);
            } else if (unit.getLocation() instanceof Europe) {
                Europe europe = (Europe)unit.getLocation();
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                cs.add(ChangeSet.See.only(serverPlayer), europe, highSeas);
            } else {
                invalid = true;
            }
        } else if (destination instanceof Settlement) {
            Tile tile = destination.getTile();
            if (!highSeas.getDestinations().contains(tile.getMap())) {
                return DOMMessage.clientError("HighSeas does not connect to: " + ((FreeColGameObject)((Object)destination)).getId());
            }
            if (unit.getLocation() == highSeas) {
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), highSeas);
            } else if (unit.getLocation() instanceof Europe) {
                Europe europe = (Europe)unit.getLocation();
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                cs.add(ChangeSet.See.only(serverPlayer), europe, highSeas);
            } else {
                invalid = true;
            }
        } else {
            return DOMMessage.clientError("Bogus moveTo destination: " + ((FreeColGameObject)((Object)destination)).getId());
        }
        if (invalid) {
            return DOMMessage.clientError("Invalid moveTo: unit=" + unit.getId() + " from=" + ((FreeColGameObject)((Object)unit.getLocation())).getId() + " to=" + ((FreeColGameObject)((Object)destination)).getId());
        }
        if (others) {
            this.sendToOthers(serverPlayer, cs);
        }
        return cs.build(serverPlayer);
    }

    public Element embarkUnit(ServerPlayer serverPlayer, Unit unit, Unit carrier) {
        if (unit.isNaval()) {
            return DOMMessage.clientError("Naval unit " + unit.getId() + " can not embark.");
        }
        if (carrier.getSpaceLeft() < unit.getSpaceTaken()) {
            return DOMMessage.clientError("No space available for unit " + unit.getId() + " to embark.");
        }
        ChangeSet cs = new ChangeSet();
        Location oldLocation = unit.getLocation();
        unit.setLocation(carrier);
        unit.setMovesLeft(0);
        cs.add(ChangeSet.See.only(serverPlayer), (FreeColGameObject)((Object)oldLocation));
        if (carrier.getLocation() != oldLocation) {
            cs.add(ChangeSet.See.only(serverPlayer), carrier);
        }
        if (oldLocation instanceof Tile) {
            cs.addMove(ChangeSet.See.only(serverPlayer), unit, (Tile)oldLocation, carrier.getTile());
            cs.addDisappear(serverPlayer, (Tile)oldLocation, unit);
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element disembarkUnit(ServerPlayer serverPlayer, Unit unit) {
        if (unit.isNaval()) {
            return DOMMessage.clientError("Naval unit " + unit.getId() + " can not disembark.");
        }
        if (!(unit.getLocation() instanceof Unit)) {
            return DOMMessage.clientError("Unit " + unit.getId() + " is not embarked.");
        }
        ChangeSet cs = new ChangeSet();
        Unit carrier = (Unit)unit.getLocation();
        Location newLocation = carrier.getLocation();
        List<Tile> newTiles = newLocation.getTile() == null ? null : ((ServerUnit)unit).collectNewTiles(newLocation.getTile());
        unit.setLocation(newLocation);
        unit.setMovesLeft(0);
        cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)newLocation));
        if (newTiles != null) {
            serverPlayer.csSeeNewTiles(newTiles, cs);
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element combat(ServerPlayer attackerPlayer, FreeColGameObject attacker, FreeColGameObject defender, List<CombatModel.CombatResult> crs) {
        ChangeSet cs = new ChangeSet();
        try {
            attackerPlayer.csCombat(attacker, defender, crs, this.random, cs);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Combat FAIL", e);
            return DOMMessage.clientError(e.getMessage());
        }
        this.sendToOthers(attackerPlayer, cs);
        return cs.build(attackerPlayer);
    }

    public Element askLearnSkill(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        ChangeSet cs = new ChangeSet();
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        Tile tile = settlement.getTile();
        tile.updatePlayerExploredTile(serverPlayer, true);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        return cs.build(serverPlayer);
    }

    public Element learnFromIndianSettlement(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        UnitType skill = settlement.getLearnableSkill();
        if (skill == null) {
            return DOMMessage.clientError("No skill to learn at " + settlement.getName());
        }
        if (!unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            return DOMMessage.clientError("Unit " + unit.toString() + " can not learn skill " + skill + " at " + settlement.getName());
        }
        ChangeSet cs = new ChangeSet();
        unit.setMovesLeft(0);
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        switch (settlement.getAlarm(serverPlayer).getLevel()) {
            case HATEFUL: {
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
                cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
                break;
            }
            case ANGRY: {
                cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
                break;
            }
            default: {
                unit.setType(skill);
                if (settlement.isCapital() || settlement.getMissionary(serverPlayer) != null && this.getGame().getSpecification().getBoolean("model.option.enhancedMissionaries")) break;
                settlement.setLearnableSkill(null);
            }
        }
        Tile tile = settlement.getTile();
        tile.updatePlayerExploredTile(serverPlayer, true);
        cs.add(ChangeSet.See.only(serverPlayer), unit, tile);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element demandTribute(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        ModelMessage m;
        ChangeSet cs = new ChangeSet();
        int TURNS_PER_TRIBUTE = 5;
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        Player indianPlayer = settlement.getOwner();
        int gold = 0;
        int year = this.getGame().getTurn().getNumber();
        RandomRange gifts = settlement.getType().getGifts(unit);
        if (settlement.getLastTribute() + 5 < year && gifts != null) {
            switch (indianPlayer.getTension(serverPlayer).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    gold = Math.min(gifts.getAmount("Tribute", this.random, true) / 10, 100);
                    break;
                }
                case DISPLEASED: {
                    gold = Math.min(gifts.getAmount("Tribute", this.random, true) / 20, 100);
                    break;
                }
                default: {
                    gold = 0;
                }
            }
        }
        cs.add(ChangeSet.See.only(serverPlayer), ((ServerIndianSettlement)settlement).modifyAlarm(serverPlayer, 200));
        settlement.setLastTribute(year);
        if (gold > 0) {
            indianPlayer.modifyGold(-gold);
            serverPlayer.modifyGold(gold);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
            m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "scoutSettlement.tributeAgree", unit, settlement).addAmount("%amount%", gold);
        } else {
            m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "scoutSettlement.tributeDisagree", unit, settlement);
        }
        cs.addMessage(ChangeSet.See.only(serverPlayer), m);
        Tile tile = settlement.getTile();
        tile.updatePlayerExploredTile(serverPlayer, true);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        return cs.build(serverPlayer);
    }

    public Element scoutIndianSettlement(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        String result;
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        boolean tileDirty = settlement.makeContactSettlement(serverPlayer);
        Tension tension = settlement.getAlarm(serverPlayer);
        if (tension.getLevel() == Tension.Level.HATEFUL) {
            cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
            cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
            result = "die";
        } else {
            int radius = unit.getLineOfSight();
            UnitType skill = settlement.getLearnableSkill();
            if (settlement.hasSpokenToChief()) {
                result = "nothing";
            } else if (skill != null && skill.hasAbility("model.ability.expertScout") && unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
                unit.setType(settlement.getLearnableSkill());
                result = "expert";
            } else {
                int gold;
                RandomRange gifts = settlement.getType().getGifts(unit);
                int n = gold = gifts == null ? 0 : gifts.getAmount("Base beads amount", this.random, true);
                if (gold <= 0 || Utils.randomInt(logger, "Tales", this.random, 3) == 0) {
                    radius = Math.max(radius, 6);
                    result = "tales";
                } else {
                    if (unit.hasAbility("model.ability.expertScout")) {
                        gold = gold * 11 / 10;
                    }
                    serverPlayer.modifyGold(gold);
                    settlement.getOwner().modifyGold(-gold);
                    result = "beads";
                }
            }
            this.csSpeakToChief(serverPlayer, settlement, true, cs);
            tileDirty = true;
            for (Tile t : tile.getSurroundingTiles(radius)) {
                if (serverPlayer.canSee(t) || !t.isLand() && !t.isCoast()) continue;
                serverPlayer.setExplored(t);
                cs.add(ChangeSet.See.only(serverPlayer), t);
            }
            unit.setMovesLeft(0);
            if ("expert".equals(result)) {
                cs.add(ChangeSet.See.perhaps(), unit);
            } else {
                cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
                if ("beads".equals(result)) {
                    cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
                }
            }
        }
        if (tileDirty) {
            tile.updatePlayerExploredTile(serverPlayer, true);
            cs.add(ChangeSet.See.only(serverPlayer), tile);
        }
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "result", result);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element denounceMission(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        ChangeSet cs = new ChangeSet();
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        Unit missionary = settlement.getMissionary();
        if (missionary == null) {
            return DOMMessage.clientError("Denouncing null missionary");
        }
        ServerPlayer enemy = (ServerPlayer)missionary.getOwner();
        double denounce = Utils.randomDouble(logger, "Denounce base", this.random) * (double)enemy.getImmigration() / (double)(serverPlayer.getImmigration() + 1);
        if (missionary.hasAbility("model.ability.expertMissionary")) {
            denounce += 0.2;
        }
        if (unit.hasAbility("model.ability.expertMissionary")) {
            denounce -= 0.2;
        }
        if (denounce < 0.5) {
            return this.establishMission(serverPlayer, unit, settlement);
        }
        Player owner = settlement.getOwner();
        cs.add(ChangeSet.See.only(serverPlayer), settlement);
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.mission.noDenounce", serverPlayer, unit).addStringTemplate("%nation%", owner.getNationName()));
        cs.addMessage(ChangeSet.See.only(enemy), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.mission.enemyDenounce", enemy, settlement).addStringTemplate("%enemy%", serverPlayer.getNationName()).addName("%settlement%", settlement.getNameFor(enemy)).addStringTemplate("%nation%", owner.getNationName()));
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
        cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element establishMission(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement) {
        ChangeSet cs = new ChangeSet();
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        Unit missionary = settlement.getMissionary();
        if (missionary != null) {
            ServerPlayer enemy = (ServerPlayer)missionary.getOwner();
            enemy.csKillMissionary(settlement, cs);
        }
        switch (settlement.getAlarm(serverPlayer).getLevel()) {
            case HATEFUL: 
            case ANGRY: {
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
                cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
                break;
            }
            case HAPPY: 
            case CONTENT: 
            case DISPLEASED: {
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), unit.getTile());
                unit.setLocation(null);
                unit.setMovesLeft(0);
                cs.add(ChangeSet.See.only(serverPlayer), unit);
                settlement.changeMissionary(unit);
                settlement.setConvertProgress(0);
                List<FreeColGameObject> modifiedSettlements = ((ServerIndianSettlement)settlement).modifyAlarm(serverPlayer, -100);
                modifiedSettlements.remove(settlement);
                if (modifiedSettlements.isEmpty()) break;
                cs.add(ChangeSet.See.only(serverPlayer), modifiedSettlements);
            }
        }
        Tile tile = settlement.getTile();
        tile.updatePlayerExploredTile(serverPlayer, true);
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), tile);
        String messageId = "indianSettlement.mission." + settlement.getAlarm(serverPlayer).getKey();
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, serverPlayer, unit).addStringTemplate("%nation%", settlement.getOwner().getNationName()));
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element incite(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement, Player enemy, int gold) {
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        tile.updatePlayerExploredTile(serverPlayer, true);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        ServerPlayer enemyPlayer = (ServerPlayer)enemy;
        Player nativePlayer = settlement.getOwner();
        int payingValue = nativePlayer.getTension(serverPlayer).getValue();
        int targetValue = nativePlayer.getTension(enemyPlayer).getValue();
        int goldToPay = payingValue > targetValue ? 10000 : 5000;
        goldToPay += 20 * (payingValue - targetValue);
        goldToPay = Math.max(goldToPay, 650);
        if (gold < 0) {
            cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(goldToPay));
        } else if (gold < goldToPay || !serverPlayer.checkGold(gold)) {
            cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.inciteGoldFail", serverPlayer, settlement).addStringTemplate("%player%", enemyPlayer.getNationName()).addAmount("%amount%", goldToPay));
            cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", "0");
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        } else {
            cs.add(ChangeSet.See.only(null).perhaps(enemyPlayer), nativePlayer.modifyTension(enemyPlayer, Tension.WAR_MODIFIER));
            cs.add(ChangeSet.See.only(null).perhaps(serverPlayer), enemyPlayer.modifyTension(serverPlayer, 250));
            cs.addAttribute(ChangeSet.See.only(serverPlayer), "gold", Integer.toString(gold));
            serverPlayer.modifyGold(-gold);
            nativePlayer.modifyGold(gold);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element setDestination(ServerPlayer serverPlayer, Unit unit, Location destination) {
        if (unit.getTradeRoute() != null) {
            unit.setTradeRoute(null);
        }
        unit.setDestination(destination);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element updateCurrentStop(ServerPlayer serverPlayer, Unit unit) {
        int current = unit.validateCurrentStop();
        if (current < 0) {
            unit.setTradeRoute(null);
            return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
        }
        List<TradeRoute.Stop> stops = unit.getTradeRoute().getStops();
        int next = current;
        while (true) {
            if (++next >= stops.size()) {
                next = 0;
            }
            if (next == current) {
                return null;
            }
            TradeRoute.Stop nextStop = stops.get(next);
            if (((ServerUnit)unit).hasWorkAtStop(nextStop)) break;
            logger.finest("Unit " + unit + " in trade route " + unit.getTradeRoute().getName() + " found no work at stop: " + (FreeColGameObject)((Object)nextStop.getLocation()));
        }
        unit.setCurrentStop(next);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element buyFromSettlement(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement, Goods goods, int amount) {
        ChangeSet cs = new ChangeSet();
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        TradeSession session = TradeSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Trying to buy without opening a transaction session");
        }
        if (!session.getBuy()) {
            return DOMMessage.clientError("Trying to buy in a session where buying is not allowed.");
        }
        if (unit.getSpaceLeft() <= 0) {
            return DOMMessage.clientError("Unit is full, unable to buy.");
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int returnGold = ai.buyProposition(unit, settlement, goods, amount);
        if (returnGold != amount) {
            return DOMMessage.clientError("This was not the price we agreed upon! Cheater?");
        }
        if (!serverPlayer.checkGold(amount)) {
            return DOMMessage.clientError("Insufficient gold to buy.");
        }
        this.moveGoods(goods, unit);
        cs.add(ChangeSet.See.perhaps(), unit);
        Player settlementPlayer = settlement.getOwner();
        Tile tile = settlement.getTile();
        settlement.updateWantedGoods();
        settlementPlayer.modifyGold(amount);
        serverPlayer.modifyGold(-amount);
        cs.add(ChangeSet.See.only(serverPlayer), ((ServerIndianSettlement)settlement).modifyAlarm(serverPlayer, -amount / 50));
        tile.updatePlayerExploredTile(serverPlayer, true);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        session.setBuy();
        logger.finest(serverPlayer.getName() + " " + unit + " buys " + goods + " at " + settlement.getName() + " for " + amount);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element sellToSettlement(ServerPlayer serverPlayer, Unit unit, IndianSettlement settlement, Goods goods, int amount) {
        ChangeSet cs = new ChangeSet();
        this.csSpeakToChief(serverPlayer, settlement, false, cs);
        TradeSession session = TransactionSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Trying to sell without opening a transaction session");
        }
        if (!session.getSell()) {
            return DOMMessage.clientError("Trying to sell in a session where selling is not allowed.");
        }
        AIPlayer ai = this.getFreeColServer().getAIPlayer(settlement.getOwner());
        int returnGold = ai.sellProposition(unit, settlement, goods, amount);
        if (returnGold != amount) {
            return DOMMessage.clientError("This was not the price we agreed upon! Cheater?");
        }
        this.moveGoods(goods, settlement);
        cs.add(ChangeSet.See.perhaps(), unit);
        Player settlementPlayer = settlement.getOwner();
        settlementPlayer.modifyGold(-amount);
        serverPlayer.modifyGold(amount);
        cs.add(ChangeSet.See.only(serverPlayer), ((ServerIndianSettlement)settlement).modifyAlarm(serverPlayer, -amount / 500));
        Tile tile = settlement.getTile();
        settlement.updateWantedGoods();
        tile.updatePlayerExploredTile(serverPlayer, true);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        session.setSell();
        cs.addSale(serverPlayer, settlement, goods.getType(), Math.round((float)amount / (float)goods.getAmount()));
        logger.finest(serverPlayer.getName() + " " + unit + " sells " + goods + " at " + settlement.getName() + " for " + amount);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element deliverGiftToSettlement(ServerPlayer serverPlayer, Unit unit, Settlement settlement, Goods goods) {
        TradeSession session = TransactionSession.lookup(TradeSession.class, unit, settlement);
        if (session == null) {
            return DOMMessage.clientError("Trying to deliver gift without opening a session");
        }
        if (!session.getGift()) {
            return DOMMessage.clientError("Trying to deliver gift in a session where gift giving is not allowed: " + unit + " " + settlement + " " + session);
        }
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        this.moveGoods(goods, settlement);
        cs.add(ChangeSet.See.perhaps(), unit);
        if (settlement instanceof IndianSettlement) {
            IndianSettlement is = (IndianSettlement)settlement;
            this.csSpeakToChief(serverPlayer, is, false, cs);
            cs.add(ChangeSet.See.only(serverPlayer), ((ServerIndianSettlement)is).modifyAlarm(serverPlayer, -is.getPriceToBuy(goods) / 50));
            is.updateWantedGoods();
            tile.updatePlayerExploredTile(serverPlayer, true);
            cs.add(ChangeSet.See.only(serverPlayer), tile);
        }
        session.setGift();
        ModelMessage m = new ModelMessage(ModelMessage.MessageType.GIFT_GOODS, "model.unit.gift", settlement, goods.getType()).addStringTemplate("%player%", serverPlayer.getNationName()).add("%type%", goods.getNameKey()).addAmount("%amount%", goods.getAmount()).addName("%settlement%", settlement.getName());
        cs.addMessage(ChangeSet.See.only(serverPlayer), m);
        ServerPlayer receiver = (ServerPlayer)settlement.getOwner();
        if (receiver.isConnected() && settlement instanceof Colony) {
            cs.add(ChangeSet.See.only(receiver), unit);
            cs.add(ChangeSet.See.only(receiver), settlement);
            cs.addMessage(ChangeSet.See.only(receiver), m);
        }
        logger.info("Gift delivered by unit: " + unit.getId() + " to settlement: " + settlement.getName());
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element loadCargo(ServerPlayer serverPlayer, Unit unit, Goods goods) {
        ChangeSet cs = new ChangeSet();
        Location oldLocation = goods.getLocation();
        goods.adjustAmount();
        this.moveGoods(goods, unit);
        boolean moved = false;
        if (unit.getInitialMovesLeft() != unit.getMovesLeft()) {
            unit.setMovesLeft(0);
            moved = true;
        }
        Unit oldUnit = null;
        if (oldLocation instanceof Unit) {
            oldUnit = (Unit)oldLocation;
            if (oldUnit.getInitialMovesLeft() != oldUnit.getMovesLeft()) {
                oldUnit.setMovesLeft(0);
            } else {
                oldUnit = null;
            }
        }
        if (unit.getSettlement() != null) {
            cs.add(ChangeSet.See.only(serverPlayer), oldLocation.getGoodsContainer());
            cs.add(ChangeSet.See.only(serverPlayer), unit.getGoodsContainer());
            if (moved) {
                cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
            }
            if (oldUnit != null) {
                cs.addPartial(ChangeSet.See.only(serverPlayer), oldUnit, "movesLeft");
            }
        } else {
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)unit.getLocation()));
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element unloadCargo(ServerPlayer serverPlayer, Unit unit, Goods goods) {
        Settlement loc;
        ChangeSet cs = new ChangeSet();
        Settlement settlement = null;
        if (unit.isInEurope()) {
            loc = null;
        } else {
            if (unit.getTile() == null) {
                return DOMMessage.clientError("Unit not on the map.");
            }
            loc = unit.getSettlement() != null ? (settlement = unit.getTile().getSettlement()) : null;
        }
        goods.adjustAmount();
        this.moveGoods(goods, loc);
        boolean moved = false;
        if (unit.getInitialMovesLeft() != unit.getMovesLeft()) {
            unit.setMovesLeft(0);
            moved = true;
        }
        if (settlement != null) {
            cs.add(ChangeSet.See.only(serverPlayer), settlement.getGoodsContainer());
            cs.add(ChangeSet.See.only(serverPlayer), unit.getGoodsContainer());
            if (moved) {
                cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
            }
        } else {
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)unit.getLocation()));
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element clearSpeciality(ServerPlayer serverPlayer, Unit unit) {
        UnitType newType = unit.getTypeChange(UnitTypeChange.ChangeType.CLEAR_SKILL, serverPlayer);
        if (newType == null) {
            return DOMMessage.clientError("Can not clear unit speciality: " + unit.getId());
        }
        if (unit.getStudent() != null) {
            return DOMMessage.clientError("Can not clear speciality of a teacher.");
        }
        unit.setType(newType);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element disbandUnit(ServerPlayer serverPlayer, Unit unit) {
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
        cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), unit.getLocation(), unit);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element buildSettlement(ServerPlayer serverPlayer, Unit unit, String name) {
        Settlement settlement;
        ChangeSet cs = new ChangeSet();
        Game game = serverPlayer.getGame();
        Tile tile = unit.getTile();
        if ("".equals(name) && "".equals(name = serverPlayer.getSettlementName())) {
            serverPlayer.installSettlementNames(Messages.getSettlementNames(serverPlayer), this.random);
            name = serverPlayer.getSettlementName();
        }
        if (serverPlayer.isEuropean()) {
            settlement = new ServerColony(game, serverPlayer, name, tile);
            serverPlayer.addSettlement(settlement);
            settlement.placeSettlement(serverPlayer.isAI());
        } else {
            IndianNationType nationType = (IndianNationType)serverPlayer.getNationType();
            UnitType skill = (UnitType)RandomChoice.getWeightedRandom(logger, "Choose skill", this.random, nationType.generateSkillsForTile(tile));
            if (skill == null) {
                List<UnitType> scouts = this.getGame().getSpecification().getUnitTypesWithAbility("model.ability.expertScout");
                skill = Utils.getRandomMember(logger, "Choose scout", scouts, this.random);
            }
            settlement = new ServerIndianSettlement(game, serverPlayer, name, tile, false, skill, new HashSet<Player>(), null);
            serverPlayer.addSettlement(settlement);
            settlement.placeSettlement(true);
        }
        ((ServerUnit)unit).csRemoveEquipment(settlement, new HashSet<EquipmentType>(unit.getEquipment().keySet()), 0, this.random, cs);
        unit.setLocation(settlement);
        unit.setMovesLeft(0);
        ArrayList<FreeColGameObject> tiles = new ArrayList<FreeColGameObject>();
        tiles.addAll(settlement.getOwnedTiles());
        cs.add(ChangeSet.See.perhaps(), tiles);
        cs.addHistory(serverPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.FOUND_COLONY).addName("%colony%", settlement.getName()));
        if (settlement.getLineOfSight() > unit.getLineOfSight()) {
            tiles.clear();
            for (Tile t : tile.getSurroundingTiles(unit.getLineOfSight() + 1, settlement.getLineOfSight())) {
                if (tiles.contains(t)) continue;
                tiles.add(t);
            }
            cs.add(ChangeSet.See.only(serverPlayer), tiles);
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element joinColony(ServerPlayer serverPlayer, Unit unit, Colony colony) {
        ChangeSet cs = new ChangeSet();
        List<Tile> ownedTiles = colony.getOwnedTiles();
        Tile tile = colony.getTile();
        unit.setLocation(colony);
        unit.setMovesLeft(0);
        ((ServerUnit)unit).csRemoveEquipment(colony, new HashSet<EquipmentType>(unit.getEquipment().keySet()), 0, this.random, cs);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        for (Tile t : tile.getSurroundingTiles(colony.getRadius())) {
            if (t.getOwningSettlement() != colony || ownedTiles.contains(t)) continue;
            cs.add(ChangeSet.See.perhaps(), t);
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element abandonSettlement(ServerPlayer serverPlayer, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        for (Tile t : settlement.getOwnedTiles()) {
            if (t == settlement.getTile()) continue;
            cs.add(ChangeSet.See.perhaps(), t);
        }
        if (settlement instanceof Colony) {
            cs.addHistory(serverPlayer, new HistoryEvent(this.getGame().getTurn(), HistoryEvent.EventType.ABANDON_COLONY).addName("%colony%", settlement.getName()));
        }
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), settlement.getTile());
        cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), settlement.getTile(), settlement);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element claimLand(ServerPlayer serverPlayer, Tile tile, Settlement settlement, int price) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csClaimLand(tile, settlement, price, cs);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    private void csAcceptTrade(Unit unit, Settlement settlement, DiplomaticTrade agreement, ChangeSet cs) {
        ServerPlayer srcPlayer = (ServerPlayer)agreement.getSender();
        ServerPlayer dstPlayer = (ServerPlayer)agreement.getRecipient();
        for (TradeItem tradeItem : agreement.getTradeItems()) {
            Unit newUnit;
            Goods goods;
            int gold;
            Colony colony;
            if (!tradeItem.isValid()) {
                logger.warning("Trade with invalid tradeItem: " + tradeItem.toString());
                continue;
            }
            ServerPlayer source = (ServerPlayer)tradeItem.getSource();
            if (source != srcPlayer && source != dstPlayer) {
                logger.warning("Trade with invalid source: " + (source == null ? "null" : source.getId()));
                continue;
            }
            ServerPlayer dest = (ServerPlayer)tradeItem.getDestination();
            if (dest != srcPlayer && dest != dstPlayer) {
                logger.warning("Trade with invalid destination: " + (dest == null ? "null" : dest.getId()));
                continue;
            }
            Player.Stance stance = tradeItem.getStance();
            if (stance != null && !source.csChangeStance(stance, dest, true, cs)) {
                logger.warning("Stance trade failure");
            }
            if ((colony = tradeItem.getColony()) != null) {
                ServerPlayer former = (ServerPlayer)colony.getOwner();
                colony.changeOwner(dest);
                ArrayList<FreeColGameObject> tiles = new ArrayList<FreeColGameObject>();
                tiles.addAll(colony.getOwnedTiles());
                cs.add(ChangeSet.See.perhaps().always(former), tiles);
            }
            if ((gold = tradeItem.getGold()) > 0) {
                source.modifyGold(-gold);
                dest.modifyGold(gold);
                cs.addPartial(ChangeSet.See.only(source), source, "gold", "score");
                cs.addPartial(ChangeSet.See.only(dest), dest, "gold", "score");
            }
            if ((goods = tradeItem.getGoods()) != null) {
                this.moveGoods(goods, settlement);
                cs.add(ChangeSet.See.only(source), unit);
                cs.add(ChangeSet.See.only(dest), settlement.getGoodsContainer());
            }
            if ((newUnit = tradeItem.getUnit()) == null) continue;
            ServerPlayer former = (ServerPlayer)newUnit.getOwner();
            unit.setOwner(dest);
            cs.add(ChangeSet.See.perhaps().always(former), newUnit);
        }
    }

    public Element diplomaticTrade(ServerPlayer serverPlayer, Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        DiplomaticTrade theirAgreement;
        ChangeSet cs = new ChangeSet();
        ServerPlayer otherPlayer = (ServerPlayer)settlement.getOwner();
        DiplomacySession session = TransactionSession.lookup(DiplomacySession.class, unit, settlement);
        Player.makeContact(serverPlayer, otherPlayer);
        DiplomaticTrade.TradeStatus status = agreement.getStatus();
        switch (status) {
            case PROPOSE_TRADE: {
                if (session == null) {
                    Unit.MoveType type = unit.getMoveType(settlement.getTile());
                    if (type != Unit.MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT) {
                        return DOMMessage.clientError("Unable to enter " + settlement.getId() + ": " + type.whyIllegal());
                    }
                    session = new DiplomacySession(unit, settlement);
                    unit.setMovesLeft(0);
                    cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
                }
                session.setAgreement(agreement);
                break;
            }
            case ACCEPT_TRADE: {
                if (session == null) {
                    return DOMMessage.clientError("Accept-trade with no session");
                }
                agreement = session.getAgreement();
                agreement.setStatus(status);
                this.csAcceptTrade(unit, settlement, agreement, cs);
                break;
            }
            case REJECT_TRADE: {
                if (session == null) {
                    return DOMMessage.clientError("Reject-trade with no session");
                }
                agreement = session.getAgreement();
                agreement.setStatus(status);
                break;
            }
            default: {
                return DOMMessage.clientError("Bogus trade status: " + (Object)((Object)status));
            }
        }
        DOMMessage reply = this.askTimeout(otherPlayer, new DiplomacyMessage(unit, settlement, agreement));
        DiplomaticTrade diplomaticTrade = theirAgreement = reply instanceof DiplomacyMessage ? ((DiplomacyMessage)reply).getAgreement() : null;
        if (status != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) {
            session.complete(cs);
            this.sendToOthers(serverPlayer, cs);
            return cs.build(serverPlayer);
        }
        status = theirAgreement == null ? DiplomaticTrade.TradeStatus.REJECT_TRADE : theirAgreement.getStatus();
        switch (status) {
            case PROPOSE_TRADE: {
                agreement = theirAgreement;
                session.setAgreement(agreement);
                break;
            }
            case ACCEPT_TRADE: {
                agreement.setStatus(status);
                this.csAcceptTrade(unit, settlement, agreement, cs);
                session.complete(cs);
                break;
            }
            case REJECT_TRADE: {
                agreement.setStatus(status);
                session.complete(cs);
                break;
            }
            default: {
                logger.warning("Bogus trade status: " + (Object)((Object)status));
            }
        }
        this.sendToAll(cs);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new DiplomacyMessage(unit, settlement, agreement)).build(serverPlayer);
    }

    public Element spySettlement(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        cs.addSpy(ChangeSet.See.only(serverPlayer), settlement);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft");
        return cs.build(serverPlayer);
    }

    public Element work(ServerPlayer serverPlayer, Unit unit, WorkLocation workLocation) {
        UnitType oldType;
        UnitTypeChange change;
        Tile tile;
        ChangeSet cs = new ChangeSet();
        Colony colony = workLocation.getColony();
        colony.getGoodsContainer().saveState();
        if (workLocation instanceof ColonyTile && (tile = ((ColonyTile)workLocation).getWorkTile()).getOwningSettlement() != colony) {
            serverPlayer.csClaimLand(tile, colony, 0, cs);
        }
        if (!unit.getEquipment().isEmpty()) {
            ((ServerUnit)unit).csRemoveEquipment(colony, new HashSet<EquipmentType>(unit.getEquipment().keySet()), 0, this.random, cs);
        }
        if ((change = (oldType = unit.getType()).getUnitTypeChange(UnitTypeChange.ChangeType.ENTER_COLONY, unit.getOwner())) != null) {
            unit.setType(change.getNewUnitType());
        }
        unit.setLocation(workLocation);
        cs.add(ChangeSet.See.perhaps(), colony.getTile());
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element lootCargo(ServerPlayer serverPlayer, Unit winner, String loserId, List<Goods> loot) {
        LootSession session = TransactionSession.lookup(LootSession.class, winner.getId(), loserId);
        if (session == null) {
            return DOMMessage.clientError("Bogus looting!");
        }
        if (winner.getSpaceLeft() == 0) {
            return DOMMessage.clientError("No space to loot to: " + winner.getId());
        }
        ChangeSet cs = new ChangeSet();
        List<Goods> available = session.getCapture();
        if (loot == null) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new LootCargoMessage(winner, loserId, available));
        } else {
            for (Goods g : loot) {
                if (!available.contains(g)) {
                    return DOMMessage.clientError("Invalid loot: " + g.toString());
                }
                available.remove(g);
                if (!winner.canAdd(g)) {
                    return DOMMessage.clientError("Loot failed: " + g.toString());
                }
                winner.add(g);
            }
            session.complete(cs);
            cs.add(ChangeSet.See.perhaps(), winner);
            this.sendToOthers(serverPlayer, cs);
        }
        return cs.build(serverPlayer);
    }

    public Element payArrears(ServerPlayer serverPlayer, GoodsType type) {
        int arrears = serverPlayer.getArrears(type);
        if (arrears <= 0) {
            return DOMMessage.clientError("No arrears for pay for: " + type.getId());
        }
        if (!serverPlayer.checkGold(arrears)) {
            return DOMMessage.clientError("Not enough gold to pay arrears for: " + type.getId());
        }
        ChangeSet cs = new ChangeSet();
        Market market = serverPlayer.getMarket();
        serverPlayer.modifyGold(-arrears);
        market.setArrears(type, 0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), market.getMarketData(type));
        return cs.build(serverPlayer);
    }

    public Element equipUnit(ServerPlayer serverPlayer, Unit unit, EquipmentType type, int amount) {
        Settlement settlement = unit.getTile() == null ? null : unit.getSettlement();
        GoodsContainer container = null;
        boolean tileDirty = false;
        if (unit.isInEurope()) {
            for (AbstractGoods goods : type.getGoodsRequired()) {
                GoodsType goodsType = goods.getType();
                if (serverPlayer.canTrade(goodsType)) continue;
                return DOMMessage.clientError("No equip of " + type.getId() + " due to boycott of " + goodsType.getId());
            }
            container = new GoodsContainer((Game)this.getGame(), serverPlayer.getEurope());
        } else if (settlement != null) {
            if (unit.getLocation() instanceof WorkLocation) {
                unit.setLocation(settlement.getTile());
                tileDirty = true;
            }
            settlement.getGoodsContainer().saveState();
        }
        ChangeSet cs = new ChangeSet();
        ArrayList<EquipmentType> remove = null;
        if (amount > 0) {
            for (AbstractGoods goods : type.getGoodsRequired()) {
                GoodsType goodsType = goods.getType();
                int n = amount * goods.getAmount();
                if (unit.isInEurope()) {
                    try {
                        serverPlayer.buy(container, goodsType, n, this.random);
                        serverPlayer.csFlushMarket(goodsType, cs);
                        continue;
                    }
                    catch (IllegalStateException e) {
                        return DOMMessage.clientError(e.getMessage());
                    }
                }
                if (settlement == null) continue;
                if (settlement.getGoodsCount(goodsType) < n) {
                    return DOMMessage.clientError("Failed to equip: " + unit.getId() + " not enough " + goodsType + " in settlement " + settlement.getId());
                }
                settlement.removeGoods(goodsType, n);
            }
            remove = unit.changeEquipment(type, amount);
            amount = 0;
        } else if (amount < 0) {
            remove = new ArrayList<EquipmentType>();
            remove.add(type);
            amount = -amount;
        } else {
            return null;
        }
        ((ServerUnit)unit).csRemoveEquipment(settlement, remove, amount, this.random, cs);
        if (unit.getInitialMovesLeft() != unit.getMovesLeft()) {
            unit.setMovesLeft(0);
        }
        if (unit.isInEurope()) {
            cs.add(ChangeSet.See.only(serverPlayer), unit);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        } else if (settlement != null) {
            if (tileDirty) {
                cs.add(ChangeSet.See.perhaps(), settlement.getTile());
            } else {
                cs.add(ChangeSet.See.only(serverPlayer), unit, settlement.getGoodsContainer());
            }
        }
        return cs.build(serverPlayer);
    }

    public Element payForBuilding(ServerPlayer serverPlayer, Colony colony) {
        BuildableType build = colony.getCurrentlyBuilding();
        if (build == null) {
            return DOMMessage.clientError("Colony " + colony.getId() + " is not building anything!");
        }
        HashMap<GoodsType, Integer> required = colony.getGoodsForBuilding(build);
        int price = colony.priceGoodsForBuilding(required);
        if (!serverPlayer.checkGold(price)) {
            return DOMMessage.clientError("Insufficient funds to pay for build.");
        }
        int savedGold = serverPlayer.modifyGold(-price);
        serverPlayer.modifyGold(price);
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = colony.getGoodsContainer();
        container.saveState();
        for (GoodsType type : required.keySet()) {
            int amount = required.get(type);
            if (type.isStorable()) {
                serverPlayer.buy(container, type, amount, this.random);
                serverPlayer.csFlushMarket(type, cs);
                continue;
            }
            container.addGoods(type, amount);
        }
        colony.invalidateCache();
        serverPlayer.setGold(savedGold);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), container);
        return cs.build(serverPlayer);
    }

    public Element indianDemand(ServerPlayer serverPlayer, Unit unit, Colony colony, Goods goods, int gold) {
        ServerPlayer victim = (ServerPlayer)colony.getOwner();
        int difficulty = this.getGame().getSpecification().getIntegerOption("model.option.nativeDemands").getValue();
        ChangeSet cs = new ChangeSet();
        DOMMessage reply = this.askTimeout(victim, new IndianDemandMessage(unit, colony, goods, gold));
        boolean result = reply instanceof IndianDemandMessage ? ((IndianDemandMessage)reply).getResult() : false;
        logger.info(serverPlayer.getName() + " unit " + unit + " demands " + goods + " goods and " + gold + " gold " + " from " + colony.getName() + " accepted: " + result);
        IndianDemandMessage message = new IndianDemandMessage(unit, colony, goods, gold);
        message.setResult(result);
        cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_NORMAL, message);
        if (result) {
            if (goods != null) {
                GoodsContainer colonyContainer = colony.getGoodsContainer();
                colonyContainer.saveState();
                GoodsContainer unitContainer = unit.getGoodsContainer();
                unitContainer.saveState();
                this.moveGoods(goods, unit);
                cs.add(ChangeSet.See.only(victim), colonyContainer);
            }
            if (gold > 0) {
                victim.modifyGold(-gold);
                serverPlayer.modifyGold(gold);
                cs.addPartial(ChangeSet.See.only(victim), victim, "gold");
            }
            cs.add(ChangeSet.See.only(null).perhaps(victim), serverPlayer.modifyTension(victim, -(5 - difficulty) * 50));
        }
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element trainUnitInEurope(ServerPlayer serverPlayer, UnitType type) {
        Europe europe = serverPlayer.getEurope();
        if (europe == null) {
            return DOMMessage.clientError("No Europe to train in.");
        }
        int price = europe.getUnitPrice(type);
        if (price <= 0) {
            return DOMMessage.clientError("Bogus price: " + price);
        }
        if (!serverPlayer.checkGold(price)) {
            return DOMMessage.clientError("Not enough gold to train " + type);
        }
        new ServerUnit(this.getGame(), europe, serverPlayer, type);
        serverPlayer.modifyGold(-price);
        ((ServerEurope)europe).increasePrice(type, price);
        ChangeSet cs = new ChangeSet();
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
        cs.add(ChangeSet.See.only(serverPlayer), europe);
        return cs.build(serverPlayer);
    }

    public Element setBuildQueue(ServerPlayer serverPlayer, Colony colony, List<BuildableType> queue) {
        colony.setBuildQueue(queue);
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.only(serverPlayer), colony);
        return cs.build(serverPlayer);
    }

    public Element setGoodsLevels(ServerPlayer serverPlayer, Colony colony, ExportData exportData) {
        colony.setExportData(exportData);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), colony).build(serverPlayer);
    }

    public Element putOutsideColony(ServerPlayer serverPlayer, Unit unit) {
        Tile tile = unit.getTile();
        Colony colony = unit.getColony();
        unit.setLocation(tile);
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.add(ChangeSet.See.perhaps().except(serverPlayer), colony);
        return cs.build(serverPlayer);
    }

    public Element changeWorkType(ServerPlayer serverPlayer, Unit unit, GoodsType type) {
        if (unit.getWorkType() != type) {
            unit.setExperience(0);
            unit.setWorkType(type);
        }
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element changeWorkImprovementType(ServerPlayer serverPlayer, Unit unit, TileImprovementType type) {
        Tile tile = unit.getTile();
        TileImprovement improvement = tile.findTileImprovementType(type);
        if (improvement == null) {
            improvement = new TileImprovement(this.getGame(), tile, type);
            tile.add(improvement);
        }
        unit.setWorkImprovement(improvement);
        unit.setState(Unit.UnitState.IMPROVING);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), tile).build(serverPlayer);
    }

    public Element changeState(ServerPlayer serverPlayer, Unit unit, Unit.UnitState state) {
        ChangeSet cs = new ChangeSet();
        if (state == Unit.UnitState.FORTIFYING) {
            ServerColony colony;
            Tile tile = unit.getTile();
            ServerColony serverColony = colony = tile.getOwningSettlement() instanceof Colony ? (ServerColony)tile.getOwningSettlement() : null;
            if (colony != null && colony.getOwner() != unit.getOwner() && colony.isTileInUse(tile)) {
                colony.csEvictUser(unit, cs);
            }
        }
        unit.setState(state);
        cs.add(ChangeSet.See.perhaps(), unit.getTile());
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    public Element assignTeacher(ServerPlayer serverPlayer, Unit student, Unit teacher) {
        Unit oldStudent = teacher.getStudent();
        Unit oldTeacher = student.getTeacher();
        ChangeSet cs = new ChangeSet();
        if (oldTeacher != null) {
            oldTeacher.setStudent(null);
            cs.add(ChangeSet.See.only(serverPlayer), oldTeacher);
        }
        if (oldStudent != null) {
            oldStudent.setTeacher(null);
            cs.add(ChangeSet.See.only(serverPlayer), oldStudent);
        }
        teacher.setStudent(student);
        teacher.setWorkType(null);
        student.setTeacher(teacher);
        cs.add(ChangeSet.See.only(serverPlayer), student, teacher);
        return cs.build(serverPlayer);
    }

    public Element assignTradeRoute(ServerPlayer serverPlayer, Unit unit, TradeRoute tradeRoute) {
        unit.setTradeRoute(tradeRoute);
        unit.setDestination(null);
        if (tradeRoute != null) {
            List<TradeRoute.Stop> stops = tradeRoute.getStops();
            int found = -1;
            for (int i = 0; i < stops.size(); ++i) {
                if (unit.getLocation() != stops.get(i).getLocation()) continue;
                found = i;
                break;
            }
            if (found < 0) {
                found = 0;
            }
            unit.setCurrentStop(found);
        }
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit).build(serverPlayer);
    }

    public Element setTradeRoutes(ServerPlayer serverPlayer, List<TradeRoute> routes) {
        serverPlayer.setTradeRoutes(routes);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), serverPlayer).build(serverPlayer);
    }

    public Element getNewTradeRoute(ServerPlayer serverPlayer) {
        ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>(serverPlayer.getTradeRoutes());
        TradeRoute route = new TradeRoute(this.getGame(), "", serverPlayer);
        routes.add(route);
        serverPlayer.setTradeRoutes(routes);
        return new ChangeSet().addTradeRoute(serverPlayer, route).build(serverPlayer);
    }

    public Element getREFUnits(ServerPlayer serverPlayer) {
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        List<Object> units = new ArrayList();
        UnitType defaultType = spec.getDefaultUnitType();
        if (serverPlayer.getMonarch() == null) {
            ServerPlayer REFPlayer = (ServerPlayer)serverPlayer.getREFPlayer();
            HashMap unitHash = new HashMap();
            for (Unit unit : REFPlayer.getUnits()) {
                Unit.Role role;
                Integer count;
                EnumMap<Unit.Role, Integer> roleMap;
                if (!unit.isOffensiveUnit()) continue;
                UnitType unitType = defaultType;
                if (unit.getType().getOffence() > 0 || unit.hasAbility("model.ability.expertSoldier")) {
                    unitType = unit.getType();
                }
                if ((roleMap = (EnumMap<Unit.Role, Integer>)unitHash.get(unitType)) == null) {
                    roleMap = new EnumMap<Unit.Role, Integer>(Unit.Role.class);
                }
                if ((count = (Integer)roleMap.get((Object)(role = unit.getRole()))) == null) {
                    roleMap.put(role, new Integer(1));
                } else {
                    roleMap.put(role, new Integer(count + 1));
                }
                unitHash.put(unitType, roleMap);
            }
            for (Map.Entry entry : unitHash.entrySet()) {
                for (Map.Entry roleEntry : ((EnumMap)entry.getValue()).entrySet()) {
                    units.add(new AbstractUnit((UnitType)entry.getKey(), (Unit.Role)((Object)roleEntry.getKey()), (int)((Integer)roleEntry.getValue())));
                }
            }
        } else {
            units = serverPlayer.getMonarch().getREF();
        }
        ChangeSet cs = new ChangeSet();
        cs.addTrivial(ChangeSet.See.only(serverPlayer), "getREFUnits", ChangeSet.ChangePriority.CHANGE_NORMAL, new String[0]);
        Element reply = cs.build(serverPlayer);
        for (AbstractUnit abstractUnit : units) {
            reply.appendChild(abstractUnit.toXMLElement(serverPlayer, reply.getOwnerDocument()));
        }
        return reply;
    }

    public Element getHighScores(ServerPlayer serverPlayer) {
        ChangeSet cs = new ChangeSet();
        cs.addTrivial(ChangeSet.See.only(serverPlayer), "getHighScores", ChangeSet.ChangePriority.CHANGE_NORMAL, new String[0]);
        Element reply = cs.build(serverPlayer);
        for (HighScore score : this.getFreeColServer().getHighScores()) {
            reply.appendChild(score.toXMLElement(serverPlayer, reply.getOwnerDocument()));
        }
        return reply;
    }

    public Element chat(ServerPlayer serverPlayer, String message, boolean pri) {
        this.sendToOthers(serverPlayer, new ChatMessage(serverPlayer, message, false).toXMLElement());
        return null;
    }

    public Element getStatistics(ServerPlayer serverPlayer) {
        java.util.Map<String, String> stats = this.getGame().getStatistics();
        stats.putAll(this.getFreeColServer().getAIMain().getAIStatistics());
        ArrayList<String> all = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>(stats.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            all.add(k);
            all.add(stats.get(k));
        }
        ChangeSet cs = new ChangeSet();
        cs.addTrivial(ChangeSet.See.only(serverPlayer), "statistics", ChangeSet.ChangePriority.CHANGE_NORMAL, all.toArray(new String[0]));
        return cs.build(serverPlayer);
    }

    public Element enterRevengeMode(ServerPlayer serverPlayer) {
        if (!this.getFreeColServer().isSingleplayer()) {
            return DOMMessage.clientError("Can not enter revenge mode, as this is not a single player game.");
        }
        ServerGame game = this.getGame();
        List<UnitType> undeads = game.getSpecification().getUnitTypesWithAbility("model.ability.undead");
        ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
        ArrayList<UnitType> landUnits = new ArrayList<UnitType>();
        for (UnitType undead : undeads) {
            if (undead.hasAbility("model.ability.navalUnit")) {
                navalUnits.add(undead);
                continue;
            }
            if (!undead.hasAbility("model.ability.multipleAttacks")) continue;
            landUnits.add(undead);
        }
        if (navalUnits.size() == 0 || landUnits.size() == 0) {
            return DOMMessage.clientError("Can not enter revenge mode, because we can not find the undead units.");
        }
        ChangeSet cs = new ChangeSet();
        UnitType navalType = (UnitType)navalUnits.get(Utils.randomInt(logger, "Choose undead navy", this.random, navalUnits.size()));
        Tile start = ((Tile)serverPlayer.getEntryLocation()).getSafeTile(serverPlayer, this.random);
        ServerUnit theFlyingDutchman = new ServerUnit(game, start, serverPlayer, navalType);
        UnitType landType = (UnitType)landUnits.get(Utils.randomInt(logger, "Choose undead army", this.random, landUnits.size()));
        new ServerUnit(game, theFlyingDutchman, serverPlayer, landType);
        serverPlayer.setDead(false);
        serverPlayer.setPlayerType(Player.PlayerType.UNDEAD);
        for (Player p : game.getPlayers()) {
            if (serverPlayer == (ServerPlayer)p || !serverPlayer.hasContacted(p)) continue;
            serverPlayer.csChangeStance(Player.Stance.WAR, p, true, cs);
        }
        cs.add(ChangeSet.See.all(), serverPlayer);
        cs.add(ChangeSet.See.perhaps(), start);
        this.sendToOthers(serverPlayer, cs);
        return cs.build(serverPlayer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FutureQuery {
        public Future<DOMMessage> future;
        public Runnable runnable;

        public FutureQuery(Future<DOMMessage> future, Runnable runnable) {
            this.future = future;
            this.runnable = runnable;
            outstandingQueries.add(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DOMMessageCallable
    implements Callable<DOMMessage> {
        private Connection connection;
        private Game game;
        private DOMMessage message;
        private DOMMessageHandler handler;

        public DOMMessageCallable(Connection connection, Game game, DOMMessage message, DOMMessageHandler handler) {
            this.connection = connection;
            this.game = game;
            this.message = message;
            this.handler = handler;
        }

        @Override
        public DOMMessage call() {
            DOMMessage message;
            Element reply;
            try {
                reply = this.connection.askDumping(this.message.toXMLElement());
            }
            catch (IOException e) {
                return null;
            }
            if (reply == null) {
                return null;
            }
            String tag = reply.getTagName();
            tag = "net.sf.freecol.common.networking." + tag.substring(0, 1).toUpperCase() + tag.substring(1) + "Message";
            Class[] types = new Class[]{Game.class, Element.class};
            Object[] params = new Object[]{this.game, reply};
            try {
                message = (DOMMessage)Introspector.instantiate(tag, types, params);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Instantiation fail", e);
                message = null;
            }
            return message == null ? null : this.handler.handle(message);
        }
    }

    private static interface DOMMessageHandler {
        public DOMMessage handle(DOMMessage var1);
    }
}

