/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public final class PreGameController
extends Controller {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());

    public PreGameController(FreeColServer freeColServer) {
        super(freeColServer);
    }

    public void startGame() throws FreeColException {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerGame game = freeColServer.getGame();
        Specification spec = game.getSpecification();
        MapGenerator mapGenerator = freeColServer.getMapGenerator();
        AIMain aiMain = new AIMain(freeColServer);
        freeColServer.setAIMain(aiMain);
        game.setFreeColGameObjectListener(aiMain);
        game.setUnknownEnemy(new ServerPlayer(game, "unknown enemy", false, null, null, null));
        HashSet<Map.Entry<Nation, NationOptions.NationState>> entries = new HashSet<Map.Entry<Nation, NationOptions.NationState>>(game.getNationOptions().getNations().entrySet());
        for (Map.Entry entry : entries) {
            if (entry.getValue() == NationOptions.NationState.NOT_AVAILABLE || game.getPlayer(((Nation)entry.getKey()).getId()) != null) continue;
            freeColServer.addAIPlayer((Nation)entry.getKey());
        }
        Collections.sort(game.getPlayers(), Player.playerComparator);
        OptionGroup gameOptions = spec.getOptionGroup("gameOptions");
        Element element = gameOptions.toXMLElement(DOMMessage.createNewRootElement("oldGameOptions").getOwnerDocument());
        mapGenerator.createMap(game);
        gameOptions.readFromXMLElement(element);
        Random random = this.getFreeColServer().getServerRandom();
        for (Player player : game.getPlayers()) {
            ((ServerPlayer)player).startGame(random);
            if (!player.isIndian()) continue;
            for (Player other : game.getPlayers()) {
                if (other == player || !other.isIndian()) continue;
                player.setStance(other, Player.Stance.PEACE);
            }
        }
        for (Player player : game.getPlayers()) {
            if (player.isAI()) continue;
            Connection conn = ((ServerPlayer)player).getConnection();
            try {
                XMLStreamWriter out = conn.send();
                out.writeStartElement("updateGame");
                game.toXML(out, player, false, false);
                out.writeEndElement();
                conn.endTransmission(null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "EXCEPTION: ", e);
            }
        }
        freeColServer.setGameState(FreeColServer.GameState.IN_GAME);
        try {
            freeColServer.updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            // empty catch block
        }
        Element startGameElement = DOMMessage.createNewRootElement("startGame");
        freeColServer.getServer().sendToAll(startGameElement);
        freeColServer.getServer().setMessageHandlerToAllConnections(freeColServer.getInGameInputHandler());
    }
}

