/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColonyTile;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerColony
extends Colony
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerColony.class.getName());

    public ServerColony(Game game, String id) {
        super(game, id);
    }

    public ServerColony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
        Specification spec = this.getSpecification();
        this.setGoodsContainer(new GoodsContainer(game, this));
        this.sonsOfLiberty = 0;
        this.oldSonsOfLiberty = 0;
        this.established = game.getTurn();
        tile.setOwner(owner);
        if (!tile.hasRoad()) {
            TileImprovement road = new TileImprovement(game, tile, spec.getTileImprovementType("model.improvement.road"));
            road.setTurnsToComplete(0);
            road.setVirtual(true);
            tile.add(road);
        }
        ServerColonyTile colonyTile = new ServerColonyTile(game, this, tile);
        this.colonyTiles.add(colonyTile);
        for (Tile t : tile.getSurroundingTiles(this.getRadius())) {
            this.colonyTiles.add(new ServerColonyTile(game, this, t));
            if (!t.getType().isWater()) continue;
            this.landLocked = false;
        }
        if (this.landLocked) {
            this.buildQueue.add(spec.getBuildingType("model.building.warehouse"));
        } else {
            this.buildQueue.add(spec.getBuildingType("model.building.docks"));
            this.getFeatureContainer().addAbility(HAS_PORT);
        }
        for (UnitType unitType : spec.getUnitTypesWithAbility("model.ability.bornInColony")) {
            if (unitType.getGoodsRequired().isEmpty()) continue;
            this.populationQueue.add(unitType);
        }
        List<BuildingType> buildingTypes = spec.getBuildingTypeList();
        for (BuildingType buildingType : buildingTypes) {
            if (!buildingType.isAutomaticBuild() && !this.isAutomaticBuild(buildingType)) continue;
            ServerBuilding building = new ServerBuilding(this.getGame(), this, buildingType);
            this.addBuilding(building);
        }
    }

    @Override
    public void csNewTurn(Random random, ChangeSet cs) {
        logger.finest("ServerColony.csNewTurn, for " + this.toString());
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        Specification spec = this.getSpecification();
        if (this.getUnitCount() <= 0) {
            logger.warning("Cleaning up 0-unit colony: " + this.getName());
            cs.addDispose(ChangeSet.See.perhaps().always(owner), this.getTile(), this);
            return;
        }
        boolean tileDirty = false;
        boolean newUnitBorn = false;
        GoodsContainer container = this.getGoodsContainer();
        container.saveState();
        for (WorkLocation workLocation : this.getCurrentWorkLocations()) {
            ((ServerModelObject)((Object)workLocation)).csNewTurn(random, cs);
            ProductionInfo productionInfo = this.getProductionInfo(workLocation);
            if (productionInfo == null) continue;
            if (!workLocation.isEmpty()) {
                for (AbstractGoods goods : productionInfo.getProduction()) {
                    UnitType expert = spec.getExpertForProducing(goods.getType());
                    int experience = goods.getAmount() / workLocation.getUnitCount();
                    for (Unit unit : workLocation.getUnitList()) {
                        if (goods.getType() != unit.getExperienceType() || !unit.getType().canBeUpgraded(expert, UnitTypeChange.ChangeType.EXPERIENCE)) continue;
                        unit.setExperience(unit.getExperience() + experience);
                        cs.addPartial(ChangeSet.See.only(owner), unit, "experience");
                    }
                }
            }
            if (!(workLocation instanceof Building)) continue;
            this.csCheckMissingInput((Building)workLocation, productionInfo, cs);
        }
        ArrayList<BuildQueue> built = new ArrayList<BuildQueue>();
        for (BuildQueue queue : new BuildQueue[]{this.buildQueue, this.populationQueue}) {
            ProductionInfo info = this.getProductionInfo(queue);
            if (info == null) continue;
            if (info.getConsumption().isEmpty()) {
                AbstractGoods needed;
                int complete;
                Object build = queue.getCurrentlyBuilding();
                if (build == null || (complete = this.getTurnsToComplete((BuildableType)build, needed = new AbstractGoods())) != -1 || needed.getType() == null) continue;
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "model.colony.buildableNeedsGoods", this, (FreeColObject)build).addName("%colony%", this.getName()).add("%buildable%", ((FreeColGameObjectType)build).getNameKey()).addAmount("%amount%", needed.getAmount()).add("%goodsType%", needed.getType().getNameKey()));
                continue;
            }
            BuildableType buildable = this.csNextBuildable(queue, random, cs);
            if (buildable == null) continue;
            if (buildable instanceof UnitType) {
                Unit newUnit = this.csBuildUnit(queue, random, cs);
                if (newUnit.hasAbility("model.ability.bornInColony")) {
                    newUnitBorn = true;
                }
                built.add(queue);
                continue;
            }
            if (buildable instanceof BuildingType) {
                if (!this.csBuildBuilding(queue, cs)) continue;
                built.add(queue);
                tileDirty = true;
                continue;
            }
            throw new IllegalStateException("Bogus buildable: " + buildable);
        }
        TypeCountMap<GoodsType> productionMap = this.getProductionMap();
        for (GoodsType goodsType : productionMap.keySet()) {
            int turns;
            int stored;
            int net = productionMap.getCount(goodsType);
            if (net + (stored = this.getGoodsCount(goodsType)) <= 0) {
                this.removeGoods(goodsType, stored);
            } else {
                this.addGoods(goodsType, net);
            }
            if (goodsType != spec.getPrimaryFoodType()) continue;
            if (net + stored < 0) {
                if (this.getUnitCount() > 1) {
                    Unit victim = Utils.getRandomMember(logger, "Choose starver", this.getUnitList(), random);
                    cs.addDispose(ChangeSet.See.only(owner), null, victim);
                    cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.colony.colonistStarved", this).addName("%colony%", this.getName()));
                    continue;
                }
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.colony.colonyStarved", this).addName("%colony%", this.getName()));
                cs.addDispose(ChangeSet.See.perhaps().always(owner), this.getTile(), this);
                return;
            }
            if (net >= 0 || (turns = stored / -net) > 3 || newUnitBorn) continue;
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.famineFeared", this).addName("%colony%", this.getName()).addAmount("%number%", turns));
            logger.finest("Famine feared in " + this.getName() + " food=" + stored + " production=" + net + " turns=" + turns);
        }
        this.invalidateCache();
        if (!built.isEmpty()) {
            for (BuildQueue queue : built) {
                switch (queue.getCompletionAction()) {
                    case SHUFFLE: {
                        if (queue.size() <= 1) break;
                        Collections.shuffle(queue.getValues(), random);
                        break;
                    }
                    case REMOVE_EXCEPT_LAST: {
                        if (queue.size() == 1 && queue.getCurrentlyBuilding() instanceof UnitType) break;
                    }
                    default: {
                        queue.remove(0);
                    }
                }
                this.csNextBuildable(queue, random, cs);
            }
            tileDirty = true;
        }
        if (this.hasAbility("model.ability.export")) {
            boolean gold = false;
            for (Goods goods : container.getCompactGoods()) {
                int amount;
                GoodsType type = goods.getType();
                ExportData data = this.getExportData(type);
                if (!data.isExported() || !owner.canTrade(goods, Market.Access.CUSTOM_HOUSE) || (amount = goods.getAmount() - data.getExportLevel()) <= 0) continue;
                owner.sell(container, type, amount, random);
                gold = true;
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "customs.sale", this).addName("%colony%", this.getName()).addAmount("%amount%", amount).add("%goods%", type.getNameKey()));
            }
            if (gold) {
                cs.addPartial(ChangeSet.See.only(owner), owner, "gold");
            }
        }
        int limit = this.getWarehouseCapacity();
        int adjustment = limit / 100;
        for (Goods goods : container.getCompactGoods()) {
            int loss;
            GoodsType type = goods.getType();
            if (!type.isStorable()) continue;
            ExportData exportData = this.getExportData(type);
            int low = exportData.getLowLevel() * adjustment;
            int high = exportData.getHighLevel() * adjustment;
            int amount = goods.getAmount();
            int oldAmount = container.getOldGoodsCount(type);
            if (!(amount >= low || oldAmount < low || type == spec.getPrimaryFoodType() && newUnitBorn)) {
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.building.warehouseEmpty", this, type).add("%goods%", type.getNameKey()).addAmount("%level%", low).addName("%colony%", this.getName()));
                continue;
            }
            if (type.limitIgnored()) continue;
            String messageId = null;
            int waste = 0;
            if (amount > limit) {
                waste = amount - limit;
                container.removeGoods(type, waste);
                messageId = "model.building.warehouseWaste";
            } else if (amount == limit && oldAmount < limit) {
                messageId = "model.building.warehouseOverfull";
            } else if (amount > high && oldAmount <= high) {
                messageId = "model.building.warehouseFull";
            }
            if (messageId != null) {
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, messageId, this, type).add("%goods%", type.getNameKey()).addAmount("%waste%", waste).addAmount("%level%", high).addName("%colony%", this.getName()));
            }
            if (exportData.isExported() && this.hasAbility("model.ability.export") && owner.canTrade(type, Market.Access.CUSTOM_HOUSE) || amount > limit || (loss = amount + this.getNetProductionOf(type) - limit) <= 0) continue;
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.building.warehouseSoonFull", this, type).add("%goods%", goods.getNameKey()).addName("%colony%", this.getName()).addAmount("%amount%", loss));
        }
        for (BuildingType buildingType : spec.getBuildingTypeList()) {
            if (!this.isAutomaticBuild(buildingType)) continue;
            this.addBuilding(new ServerBuilding(this.getGame(), this, buildingType));
        }
        if (this.buildQueue.size() == 0) {
            for (GoodsType g : spec.getGoodsTypeList()) {
                if (!g.isBuildingMaterial() || g.isRawMaterial() || this.getAdjustedNetProductionOf(g) <= 0) continue;
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.BUILDING_COMPLETED, "model.colony.notBuildingAnything", this).addName("%colony%", this.getName()));
                break;
            }
        }
        this.updateSoL();
        if (this.sonsOfLiberty / 10 != this.oldSonsOfLiberty / 10) {
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, this.sonsOfLiberty > this.oldSonsOfLiberty ? "model.colony.SoLIncrease" : "model.colony.SoLDecrease", this, spec.getGoodsType("model.goods.bells")).addAmount("%oldSoL%", this.oldSonsOfLiberty).addAmount("%newSoL%", this.sonsOfLiberty).addName("%colony%", this.getName()));
            ModelMessage govMgtMessage = this.checkForGovMgtChangeMessage();
            if (govMgtMessage != null) {
                cs.addMessage(ChangeSet.See.only(owner), govMgtMessage);
            }
        }
        this.updateProductionBonus();
        if (tileDirty) {
            cs.add(ChangeSet.See.perhaps(), this.getTile());
        } else {
            cs.add(ChangeSet.See.only(owner), this);
        }
    }

    private void csCheckMissingInput(Building building, ProductionInfo pi, ChangeSet cs) {
        if (building.canAutoProduce() || building.isEmpty()) {
            return;
        }
        block0: for (AbstractGoods goods : pi.getProduction()) {
            if (goods.getAmount() > 0) continue;
            GoodsType type = goods.getType();
            for (AbstractGoods g : pi.getMaximumProduction()) {
                if (g.getType() != type) continue;
                if (goods.getAmount() < 0) continue block0;
                type = building.getGoodsInputType();
                cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "model.building.notEnoughInput", this, type).add("%inputGoods%", type.getNameKey()).add("%building%", building.getNameKey()).addName("%colony%", this.getName()));
                return;
            }
        }
    }

    private Unit csBuildUnit(BuildQueue<? extends BuildableType> buildQueue, Random random, ChangeSet cs) {
        ServerUnit unit = new ServerUnit(this.getGame(), this.getTile(), this.owner, (UnitType)buildQueue.getCurrentlyBuilding());
        if (unit.hasAbility("model.ability.bornInColony")) {
            cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.newColonist", this, unit).addName("%colony%", this.getName()));
        } else {
            cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.unitReady", this, unit).addName("%colony%", this.getName()).addStringTemplate("%unit%", unit.getLabel()));
        }
        logger.info("New unit created in " + this.getName() + ": " + unit);
        return unit;
    }

    private boolean csBuildBuilding(BuildQueue<? extends BuildableType> buildQueue, ChangeSet cs) {
        boolean success;
        BuildingType type = (BuildingType)buildQueue.getCurrentlyBuilding();
        BuildingType from = type.getUpgradesFrom();
        if (from == null) {
            this.addBuilding(new ServerBuilding(this.getGame(), this, type));
            success = true;
        } else {
            Building building = this.getBuilding(from);
            success = building.upgrade();
            if (!success) {
                cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.BUILDING_COMPLETED, "colonyPanel.unbuildable", this).addName("%colony%", this.getName()).add("%object%", type.getNameKey()));
            }
        }
        if (success) {
            this.tile.updatePlayerExploredTiles();
            cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.BUILDING_COMPLETED, "model.colony.buildingReady", this).addName("%colony%", this.getName()).add("%building%", type.getNameKey()));
            if (this.owner.isAI()) {
                this.firePropertyChange("rearrangeWorkers", true, false);
            }
        }
        return success;
    }

    private BuildableType csNextBuildable(BuildQueue<? extends BuildableType> queue, Random random, ChangeSet cs) {
        BuildableType buildable;
        Specification spec = this.getSpecification();
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        while ((buildable = queue.getCurrentlyBuilding()) != null) {
            switch (this.getNoBuildReason(buildable)) {
                case NONE: {
                    return buildable;
                }
                case NOT_BUILDING: {
                    for (GoodsType goodsType : spec.getGoodsTypeList()) {
                        if (!goodsType.isBuildingMaterial() || goodsType.isStorable() || this.getProductionOf(goodsType) <= 0) continue;
                        cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.cannotBuild", this).addName("%colony%", this.getName()));
                    }
                    return null;
                }
                case POPULATION_TOO_SMALL: {
                    cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.buildNeedPop", this).addName("%colony%", this.getName()).add("%building%", buildable.getNameKey()));
                    break;
                }
                default: {
                    cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "colonyPanel.unbuildable", this, buildable).addName("%colony%", this.getName()).add("%object%", buildable.getNameKey()));
                }
            }
            queue.remove(0);
        }
        return null;
    }

    public void csEvictUser(Unit enemyUnit, ChangeSet cs) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        Tile tile = enemyUnit.getTile();
        ServerColonyTile ct = (ServerColonyTile)this.getColonyTile(tile);
        if (ct == null || ct.isEmpty()) {
            return;
        }
        Tile centerTile = this.getTile();
        for (Unit unit : ct.getUnitList()) {
            unit.setLocation(centerTile);
            cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.workerEvicted", this, this).addName("%colony%", this.getName()).addStringTemplate("%unit%", unit.getLabel()).addStringTemplate("%location%", tile.getLocationName()).addStringTemplate("%enemyUnit%", enemyUnit.getLabel()));
        }
        cs.add(ChangeSet.See.only(serverPlayer), ct);
        cs.add(ChangeSet.See.perhaps(), centerTile);
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverColony";
    }
}

