/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.evt.DTD2;
import org.codehaus.stax2.ri.evt.BaseEventImpl;

public class DTDEventImpl
extends BaseEventImpl
implements DTD2 {
    final String mRootName;
    final String mSystemId;
    final String mPublicId;
    final String mInternalSubset;
    final Object mDTD;
    String mFullText = null;

    public DTDEventImpl(Location loc, String rootName, String sysId, String pubId, String intSubset, Object dtd) {
        super(loc);
        this.mRootName = rootName;
        this.mSystemId = sysId;
        this.mPublicId = pubId;
        this.mInternalSubset = intSubset;
        this.mFullText = null;
        this.mDTD = dtd;
    }

    public DTDEventImpl(Location loc, String rootName, String intSubset) {
        this(loc, rootName, null, null, intSubset, null);
    }

    public DTDEventImpl(Location loc, String fullText) {
        this(loc, null, null, null, null, null);
        this.mFullText = fullText;
    }

    public String getDocumentTypeDeclaration() {
        try {
            return this.doGetDocumentTypeDeclaration();
        }
        catch (XMLStreamException sex) {
            throw new RuntimeException("Internal error: " + sex);
        }
    }

    public List getEntities() {
        return null;
    }

    public List getNotations() {
        return null;
    }

    public Object getProcessedDTD() {
        return this.mDTD;
    }

    public int getEventType() {
        return 11;
    }

    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            if (this.mFullText != null) {
                w.write(this.mFullText);
                return;
            }
            w.write("<!DOCTYPE");
            if (this.mRootName != null) {
                w.write(32);
                w.write(this.mRootName);
            }
            if (this.mSystemId != null) {
                if (this.mPublicId != null) {
                    w.write(" PUBLIC \"");
                    w.write(this.mPublicId);
                    w.write(34);
                } else {
                    w.write(" SYSTEM");
                }
                w.write(" \"");
                w.write(this.mSystemId);
                w.write(34);
            }
            if (this.mInternalSubset != null) {
                w.write(" [");
                w.write(this.mInternalSubset);
                w.write(93);
            }
            w.write(">");
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    public void writeUsing(XMLStreamWriter2 w) throws XMLStreamException {
        if (this.mRootName != null) {
            w.writeDTD(this.mRootName, this.mSystemId, this.mPublicId, this.mInternalSubset);
            return;
        }
        w.writeDTD(this.doGetDocumentTypeDeclaration());
    }

    public String getRootName() {
        return this.mRootName;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getInternalSubset() {
        return this.mInternalSubset;
    }

    protected String doGetDocumentTypeDeclaration() throws XMLStreamException {
        if (this.mFullText == null) {
            int len = 60;
            if (this.mInternalSubset != null) {
                len += this.mInternalSubset.length() + 4;
            }
            StringWriter sw = new StringWriter(len);
            this.writeAsEncodedUnicode(sw);
            this.mFullText = sw.toString();
        }
        return this.mFullText;
    }
}

