/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.Worker;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InGameInputHandler;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.control.PreGameInputHandler;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.plaf.FreeColLookAndFeel;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.server.FreeColServer;

public final class FreeColClient {
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private ConnectController connectController;
    private PreGameController preGameController;
    private PreGameInputHandler preGameInputHandler;
    private InGameController inGameController;
    private InGameInputHandler inGameInputHandler;
    private MapEditorController mapEditorController;
    private ServerAPI serverAPI;
    private GUI gui = new GUI(this);
    private Client client;
    private Game game;
    private Player player;
    private boolean isRetired = false;
    private boolean inGame = false;
    private FreeColServer freeColServer = null;
    private boolean mapEditor;
    private boolean singleplayer;
    private final ActionManager actionManager;
    private ClientOptions clientOptions;
    public final Worker worker;
    private boolean loggedIn = false;
    private boolean headless;

    public FreeColClient(final File savedGame, Dimension size, final boolean sound, String splashFilename, final boolean showOpeningVideo, String fontName) {
        File baseDirectory = new File(FreeCol.getDataDirectory(), "base");
        if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
            System.err.println("Could not find base data directory: " + baseDirectory.getName());
            System.err.println("  The data files could not be found by FreeCol. Please make sure");
            System.err.println("  they are present. If FreeCol is looking in the wrong directory");
            System.err.println("  then run the game with a command-line parameter:\n");
            System.err.println("    --freecol-data <data-directory>\n");
            System.exit(1);
        }
        this.headless = "true".equals(System.getProperty("java.awt.headless", "false"));
        if (this.headless) {
            System.err.println("Headless operation disabled.\n");
            System.exit(1);
        }
        this.mapEditor = false;
        this.gui.displaySpashScreen(splashFilename);
        this.gui.setWindowed(size != null);
        if (size != null && size.width < 0) {
            size = this.gui.determineWindowSize();
        }
        this.connectController = new ConnectController(this, this.gui);
        this.preGameController = new PreGameController(this, this.gui);
        this.preGameInputHandler = new PreGameInputHandler(this, this.gui);
        this.inGameController = new InGameController(this, this.gui);
        this.inGameInputHandler = new InGameInputHandler(this, this.gui);
        this.mapEditorController = new MapEditorController(this, this.gui);
        this.actionManager = new ActionManager(this, this.gui);
        this.worker = new Worker();
        this.worker.start();
        FreeColDataFile baseData = new FreeColDataFile(baseDirectory);
        ResourceManager.setBaseMapping(baseData.getResourceMapping());
        try {
            FreeColTcFile tcData = new FreeColTcFile("classic");
            ResourceManager.setTcMapping(tcData.getResourceMapping());
        }
        catch (IOException e) {
            System.out.println("Failed to load resource mapping from rule set 'classic'.");
            System.exit(1);
        }
        this.actionManager.initializeActions();
        this.loadClientOptions(savedGame);
        ResourceManager.preload(size);
        Font font = null;
        if (fontName != null && (font = Font.decode(fontName)) == null) {
            System.err.println("Font not found: " + fontName);
        }
        if (font == null) {
            font = ResourceManager.getFont("NormalFont");
        }
        try {
            FreeColLookAndFeel fclaf = new FreeColLookAndFeel(FreeCol.getDataDirectory(), size);
            FreeColLookAndFeel.install(fclaf, font);
        }
        catch (FreeColException e) {
            System.err.println("Unable to install FreeCol look-and-feel.");
            e.printStackTrace();
            System.exit(1);
        }
        this.gui.hideSplashScreen();
        final Dimension windowSize = size;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FreeColClient.this.gui.startGUI(windowSize, sound, showOpeningVideo, savedGame != null);
            }
        });
        if (savedGame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FreeColClient.this.connectController.loadGame(savedGame);
                }
            });
        }
    }

    public ServerAPI askServer() {
        if (this.serverAPI == null) {
            this.serverAPI = new ServerAPI(this);
        }
        return this.serverAPI;
    }

    public void askToQuit() {
        if (this.gui.showConfirmDialog("quitDialog.areYouSure.text", "ok", "cancel")) {
            this.quit();
        }
    }

    public boolean canSaveCurrentGame() {
        if (this.getFreeColServer() == null) {
            return false;
        }
        if (this.getMyPlayer() == null) {
            return false;
        }
        return this.getFreeColServer().getGameState() != FreeColServer.GameState.IN_GAME || this.getMyPlayer().isAdmin();
    }

    public void continuePlaying() {
        this.client.send(DOMMessage.createNewRootElement("continuePlaying"));
    }

    public boolean currentPlayerIsMyPlayer() {
        return this.inGame && this.game.getCurrentPlayer().equals(this.player);
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public Client getClient() {
        return this.client;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public ConnectController getConnectController() {
        return this.connectController;
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public Game getGame() {
        return this.game;
    }

    public GUI getGUI() {
        return this.gui;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public MapEditorController getMapEditorController() {
        return this.mapEditorController;
    }

    public Player getMyPlayer() {
        return this.player;
    }

    public PreGameController getPreGameController() {
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public boolean isAdmin() {
        if (this.getMyPlayer() == null) {
            return false;
        }
        return this.getMyPlayer().isAdmin();
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isMapEditor() {
        return this.mapEditor;
    }

    public boolean isSingleplayer() {
        return this.singleplayer;
    }

    public void newGame() {
        Specification specification = null;
        if (this.getGame() != null) {
            if (this.isMapEditor()) {
                specification = this.getGame().getSpecification();
            } else if (this.gui.showConfirmDialog("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no")) {
                this.getConnectController().quitGame(true);
                FreeCol.incrementFreeColSeed();
            } else {
                return;
            }
            this.gui.removeInGameComponents();
        }
        this.gui.showNewPanel(specification);
    }

    public void quit() {
        this.getConnectController().quitGame(this.isSingleplayer());
        this.exitActions();
        this.gui.quit();
        System.exit(0);
    }

    public void retire() {
        if (this.gui.showConfirmDialog("retireDialog.areYouSure.text", "ok", "cancel")) {
            this.setIsRetired(true);
            if (this.askServer().retire()) {
                this.gui.showHighScoresPanel(null);
            }
            this.quit();
        }
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setFreeColServer(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void setHeadless(boolean newHeadless) {
        this.headless = newHeadless;
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public void setIsRetired(boolean isRetired) {
        this.isRetired = isRetired;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public void setMapEditor(boolean mapEditor) {
        this.mapEditor = mapEditor;
    }

    public void setMyPlayer(Player player) {
        this.player = player;
    }

    public void setSingleplayer(boolean singleplayer) {
        this.singleplayer = singleplayer;
    }

    public void skipTurns(int turns) {
        if (this.freeColServer == null) {
            return;
        }
        this.freeColServer.getInGameController().setSkippedTurns(turns);
        this.gui.closeMenus();
        this.askServer().startSkipping();
    }

    private void exitActions() {
        try {
            int validDays = this.getClientOptions().getInteger("model.option.autosaveValidity");
            long validPeriod = (long)validDays * 86400L * 1000L;
            long timeNow = System.currentTimeMillis();
            File autosaveDir = FreeCol.getAutosaveDirectory();
            if (validPeriod != 0L) {
                String[] flist = autosaveDir.list();
                for (int i = 0; flist != null && i < flist.length; ++i) {
                    File saveGameFile;
                    String filename = flist[i];
                    if (!filename.endsWith(".fsg") || (saveGameFile = new File(autosaveDir, filename)).lastModified() + validPeriod >= timeNow) continue;
                    saveGameFile.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadClientOptions(File savedGame) {
        File userOptions;
        this.clientOptions = new ClientOptions();
        logger.info("Loaded default client options.");
        if (this.actionManager != null) {
            this.clientOptions.add(this.actionManager);
            logger.info("Loaded client options from the action manager.");
        }
        if (savedGame != null) {
            try {
                FreeColSavegameFile save = new FreeColSavegameFile(savedGame);
                String fileName = "client-options.xml";
                this.clientOptions.loadOptions(save.getInputStream(fileName));
                logger.info("Loaded client options from saved game:" + savedGame.getPath() + "(" + fileName + ")");
            }
            catch (Exception e) {
                logger.warning("Unable to read client options from: " + savedGame.getPath());
            }
        }
        if ((userOptions = FreeCol.getClientOptionsFile()) != null && userOptions.exists()) {
            this.clientOptions.updateOptions(userOptions);
            logger.info("Updated client options from user options file: " + userOptions.getPath());
        } else {
            logger.warning("User options file not present.");
        }
        ArrayList<ResourceMapping> modMappings = new ArrayList<ResourceMapping>();
        for (FreeColModFile f : this.clientOptions.getActiveMods()) {
            modMappings.add(f.getResourceMapping());
        }
        ResourceManager.setModMappings(modMappings);
        if (this.actionManager != null) {
            this.actionManager.update();
        }
    }
}

