/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyWas;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeWas;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.NetworkConstants;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.server.FreeColServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameController
implements NetworkConstants {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private final FreeColClient freeColClient;
    private final short UNIT_LAST_MOVE_DELAY = (short)300;
    private final int MODE_NEXT_ACTIVE_UNIT = 0;
    private final int MODE_EXECUTE_GOTO_ORDERS = 1;
    private final int MODE_END_TURN = 2;
    private int moveMode = 0;
    private int turnsPlayed = 0;
    private File lastSaveGameFile;
    private static FileFilter FSG_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".fsg");
        }
    };
    private HashMap<String, Integer> messagesToIgnore = new HashMap();
    private GUI gui;

    public InGameController(FreeColClient freeColClient, GUI gui) {
        this.freeColClient = freeColClient;
        this.gui = gui;
    }

    public void setGameConnected() {
        this.turnsPlayed = 0;
    }

    public void setInDebugMode(boolean debug) {
        FreeCol.setInDebugMode(debug);
        logger.info("Debug mode set to " + debug);
        this.gui.updateMenuBar();
    }

    private ServerAPI askServer() {
        return this.freeColClient.askServer();
    }

    private Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    private boolean requireOurTurn() {
        if (!this.freeColClient.currentPlayerIsMyPlayer()) {
            this.gui.showInformationMessage("notYourTurn");
            return false;
        }
        return true;
    }

    private boolean confirmHostileAction(Unit attacker, Tile target) {
        Player enemy;
        if (attacker.hasAbility("model.ability.piracy")) {
            return true;
        }
        if (target.getSettlement() != null) {
            enemy = target.getSettlement().getOwner();
        } else if (target == attacker.getTile()) {
            enemy = target.getOwner();
            if (enemy == null) {
                return true;
            }
        } else {
            Unit defender = target.getDefendingUnit(attacker);
            if (defender == null) {
                logger.warning("Attacking, but no defender - will try!");
                return true;
            }
            if (defender.hasAbility("model.ability.piracy")) {
                return true;
            }
            enemy = defender.getOwner();
        }
        String messageID = null;
        switch (attacker.getOwner().getStance(enemy)) {
            case WAR: {
                logger.finest("Player at war, no confirmation needed");
                return true;
            }
            case UNCONTACTED: 
            case PEACE: {
                messageID = "model.diplomacy.attack.peace";
                break;
            }
            case CEASE_FIRE: {
                messageID = "model.diplomacy.attack.ceaseFire";
                break;
            }
            case ALLIANCE: {
                messageID = "model.diplomacy.attack.alliance";
            }
        }
        return this.gui.showConfirmDialog(attacker.getTile(), StringTemplate.template(messageID).addStringTemplate("%nation%", enemy.getNationName()), "model.diplomacy.attack.confirm", "cancel");
    }

    private boolean confirmPreCombat(Unit attacker, Tile tile) {
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowPreCombat")) {
            Settlement settlement = tile.getSettlement();
            Settlement defender = settlement != null ? settlement : tile.getDefendingUnit(attacker);
            return this.gui.showPreCombatDialog(attacker, defender, tile);
        }
        return true;
    }

    private Settlement getSettlementAt(Tile tile, Map.Direction direction) {
        return tile.getNeighbourOrNull(direction).getSettlement();
    }

    private StringTemplate getNationAt(Tile tile, Map.Direction direction) {
        Tile newTile = tile.getNeighbourOrNull(direction);
        Player player = null;
        player = newTile.getSettlement() != null ? newTile.getSettlement().getOwner() : (newTile.getFirstUnit() != null ? newTile.getFirstUnit().getOwner() : this.freeColClient.getGame().getUnknownEnemy());
        return player.getNationName();
    }

    private boolean doExecuteGotoOrders() {
        if (this.moveMode < 1) {
            this.moveMode = 1;
        }
        boolean result = true;
        Player player = this.freeColClient.getMyPlayer();
        while (player.hasNextGoingToUnit()) {
            Unit unit = player.getNextGoingToUnit();
            this.gui.setActiveUnit(unit);
            if (this.gui.isShowingSubPanel()) {
                this.gui.requestFocusForSubPanel();
                return false;
            }
            if (this.moveToDestination(unit)) {
                result = false;
            }
            this.nextModelMessage();
        }
        this.gui.setActiveUnit(null);
        return result;
    }

    private void doEndTurn() {
        this.gui.setActiveUnit(null);
        for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
            if (unit.getState() != Unit.UnitState.SKIPPED) continue;
            unit.setState(Unit.UnitState.ACTIVE);
        }
        this.moveMode = 0;
        ++this.turnsPlayed;
        this.askServer().endTurn();
    }

    private boolean followTradeRoute(Unit unit) {
        Player player = unit.getOwner();
        TradeRoute tr = unit.getTradeRoute();
        String name = tr.getName();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        boolean detailed = this.freeColClient.getClientOptions().getBoolean("model.option.guiShowGoodsMovement");
        List<TradeRoute.Stop> stops = tr.getStops();
        boolean result = false;
        block0: while (true) {
            PathNode path;
            boolean atStop;
            TradeRoute.Stop stop;
            if (!TradeRoute.isStopValid(unit, stop = unit.getStop())) {
                messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.broken", unit).addName("%route%", name));
                this.clearOrders(unit);
                result = true;
                break;
            }
            if (stop.getLocation() instanceof Europe) {
                atStop = unit.isInEurope();
            } else if (stop.getLocation() instanceof Colony) {
                atStop = unit.getTile() == stop.getLocation().getTile();
            } else {
                throw new IllegalStateException("Bogus stop location: " + (FreeColGameObject)((Object)stop.getLocation()));
            }
            if (atStop) {
                Location loc;
                this.unloadUnitAtStop(unit, detailed ? messages : null);
                this.loadUnitAtStop(unit, detailed ? messages : null);
                if (unit.getMovesLeft() <= 0) break;
                int index = unit.validateCurrentStop();
                this.askServer().updateCurrentStop(unit);
                int next = unit.validateCurrentStop();
                if (next == index) {
                    loc = stop.getLocation();
                    if (detailed) {
                        messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.noWork", unit).addName("%route%", name).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)));
                    }
                    unit.setState(Unit.UnitState.SKIPPED);
                    break;
                }
                if (!detailed) continue;
                while (true) {
                    if (++index >= stops.size()) {
                        index = 0;
                    }
                    if (index == next) continue block0;
                    loc = stops.get(index).getLocation();
                    messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.skipStop", unit).addName("%route%", name).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)));
                }
            }
            if (unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED) break;
            Location destination = stop.getLocation();
            PathNode pathNode = path = destination instanceof Europe ? unit.findPathToEurope() : unit.findPath(destination.getTile());
            if (path == null) {
                StringTemplate dest = destination.getLocationNameFor(player);
                messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.noPath", unit).addName("%route%", name).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", dest));
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            this.followPath(unit, path);
        }
        for (ModelMessage m : messages) {
            player.addModelMessage(m);
        }
        return result;
    }

    private boolean loadUnitAtStop(Unit unit, List<ModelMessage> messages) {
        TradeRoute.Stop stop = unit.getStop();
        ArrayList<GoodsType> goodsTypesToLoad = new ArrayList<GoodsType>(stop.getCargo());
        boolean ret = false;
        Colony colony = unit.getColony();
        Colony loc = unit.isInEurope() ? unit.getOwner().getEurope() : colony;
        Game game = this.freeColClient.getGame();
        for (Goods goods : unit.getGoodsList()) {
            int present;
            int atStop;
            int index;
            GoodsType type = goods.getType();
            int toLoad = 100 - goods.getAmount();
            if (toLoad <= 0 || (index = goodsTypesToLoad.indexOf(type)) < 0) continue;
            if (unit.isInEurope()) {
                atStop = Integer.MAX_VALUE;
                present = Integer.MAX_VALUE;
            } else {
                present = colony.getGoodsContainer().getGoodsCount(type);
                atStop = colony.getExportAmount(type);
            }
            if (atStop > 0) {
                Goods cargo = new Goods(game, loc, type, Math.min(toLoad, atStop));
                if (this.loadGoods(cargo, unit)) {
                    if (messages != null) {
                        messages.add(this.getLoadGoodsMessage(unit, type, cargo.getAmount(), present, atStop, toLoad));
                    }
                    ret = true;
                }
            } else if (present > 0 && messages != null) {
                messages.add(this.getLoadGoodsMessage(unit, type, 0, present, 0, toLoad));
            }
            goodsTypesToLoad.remove(index);
        }
        for (GoodsType type : goodsTypesToLoad) {
            int present;
            int atStop;
            if (unit.getSpaceLeft() <= 0) break;
            int toLoad = 100;
            if (unit.isInEurope()) {
                atStop = Integer.MAX_VALUE;
                present = Integer.MAX_VALUE;
            } else {
                present = colony.getGoodsContainer().getGoodsCount(type);
                atStop = colony.getExportAmount(type);
            }
            if (atStop > 0) {
                Goods cargo = new Goods(game, loc, type, Math.min(toLoad, atStop));
                if (!this.loadGoods(cargo, unit)) continue;
                if (messages != null) {
                    messages.add(this.getLoadGoodsMessage(unit, type, cargo.getAmount(), present, atStop, toLoad));
                }
                ret = true;
                continue;
            }
            if (present <= 0 || messages == null) continue;
            messages.add(this.getLoadGoodsMessage(unit, type, 0, present, 0, toLoad));
        }
        return ret;
    }

    private ModelMessage getLoadGoodsMessage(Unit unit, GoodsType type, int amount, int present, int atStop, int toLoad) {
        Player player = unit.getOwner();
        Location loc = unit.getLocation();
        String route = unit.getTradeRoute().getName();
        String key = null;
        int more = 0;
        if (toLoad < atStop) {
            key = "traderoute.loadImportLimited";
            more = atStop - toLoad;
        } else if (present > atStop && toLoad > atStop) {
            key = "traderoute.loadExportLimited";
            more = present - atStop;
        } else {
            key = "traderoute.load";
        }
        return new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, key, unit).addName("%route%", route).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)).addAmount("%amount%", amount).add("%goods%", type.getNameKey()).addAmount("%more%", more);
    }

    private boolean unloadUnitAtStop(Unit unit, List<ModelMessage> messages) {
        Colony colony = unit.getColony();
        TradeRoute.Stop stop = unit.getStop();
        List<GoodsType> goodsTypesToLoad = stop.getCargo();
        boolean ret = false;
        Game game = this.freeColClient.getGame();
        for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
            Goods cargo;
            GoodsType type = goods.getType();
            if (goodsTypesToLoad.contains(type)) continue;
            int atStop = colony == null ? Integer.MAX_VALUE : colony.getImportAmount(type);
            int toUnload = goods.getAmount();
            if (toUnload > atStop) {
                String locName = colony.getName();
                String overflow = Integer.toString(toUnload - atStop);
                int option = this.freeColClient.getClientOptions().getInteger("model.option.unloadOverflowResponse");
                switch (option) {
                    case 0: {
                        StringTemplate template = StringTemplate.template("traderoute.warehouseCapacity").addStringTemplate("%unit%", Messages.getLabel(unit)).addName("%colony%", locName).addName("%amount%", overflow).add("%goods%", goods.getNameKey());
                        if (this.gui.showConfirmDialog(colony.getTile(), template, "yes", "no")) break;
                        toUnload = atStop;
                        break;
                    }
                    case 1: {
                        toUnload = atStop;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        logger.warning("Illegal UNLOAD_OVERFLOW_RESPONSE: " + Integer.toString(option));
                    }
                }
            }
            if (!this.unloadGoods(cargo = goods.getAmount() == toUnload ? goods : new Goods(game, unit, type, toUnload), unit, colony)) continue;
            if (messages != null) {
                messages.add(this.getUnloadGoodsMessage(unit, type, cargo.getAmount(), atStop, goods.getAmount(), toUnload));
            }
            ret = true;
        }
        return ret;
    }

    private ModelMessage getUnloadGoodsMessage(Unit unit, GoodsType type, int amount, int atStop, int present, int toUnload) {
        String key = null;
        int overflow = 0;
        if (present == toUnload) {
            key = "traderoute.unload";
        } else if (toUnload > atStop) {
            key = "traderoute.overflow";
            overflow = toUnload - atStop;
        } else {
            key = "traderoute.nounload";
            overflow = present - atStop;
        }
        StringTemplate loc = unit.getLocation().getLocationNameFor(unit.getOwner());
        return new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, key, unit).addName("%route%", unit.getTradeRoute().getName()).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc).addAmount("%amount%", amount).addAmount("%overflow%", overflow).add("%goods%", type.getNameKey());
    }

    private boolean claimTile(Player player, Tile tile, Colony colony, int price, int offer) {
        Player owner = tile.getOwner();
        if (price < 0) {
            return false;
        }
        if (price > 0) {
            if (offer >= price) {
                price = offer;
            } else if (offer < 0) {
                price = -1;
            } else {
                boolean canAccept = player.checkGold(price);
                switch (this.gui.showClaimDialog(tile, player, price, owner, canAccept)) {
                    case CANCEL: {
                        return false;
                    }
                    case ACCEPT: {
                        break;
                    }
                    case STEAL: {
                        price = -1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("showClaimDialog fail");
                    }
                }
            }
        }
        if (this.askServer().claimLand(tile, colony, price) && player.owns(tile)) {
            this.gui.updateGoldLabel();
            return true;
        }
        return false;
    }

    private void emigrate(Player player, int slot) {
        Europe europe = player.getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        if (this.askServer().emigrate(slot)) {
            europeWas.fireChanges();
            this.gui.updateGoldLabel();
        }
    }

    private boolean followPath(Unit unit, PathNode path) {
        while (path != null) {
            if (unit.getDestination() instanceof Europe && unit.getTile() != null && unit.getTile().canMoveToEurope()) {
                this.moveTo(unit, unit.getDestination());
                return false;
            }
            if (!this.moveDirection(unit, path.getDirection(), false)) {
                return false;
            }
            path = path.next;
        }
        return true;
    }

    private boolean loadGoods(Goods goods, Unit carrier) {
        ColonyWas colonyWas;
        if (carrier.isInEurope() && goods.getLocation() instanceof Europe) {
            if (!carrier.getOwner().canTrade(goods)) {
                return false;
            }
            return this.buyGoods(goods.getType(), goods.getAmount(), carrier);
        }
        GoodsType type = goods.getType();
        GoodsContainer container = carrier.getGoodsContainer();
        int oldAmount = container.getGoodsCount(type);
        UnitWas unitWas = new UnitWas(carrier);
        Colony colony = carrier.getColony();
        ColonyWas colonyWas2 = colonyWas = colony == null ? null : new ColonyWas(colony);
        if (this.askServer().loadCargo(goods, carrier) && container.getGoodsCount(type) != oldAmount) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    private boolean unloadGoods(Goods goods, Unit carrier, Colony colony) {
        if (colony == null && carrier.isInEurope()) {
            return !carrier.getOwner().canTrade(goods) ? false : this.sellGoods(goods);
        }
        GoodsType type = goods.getType();
        GoodsContainer container = carrier.getGoodsContainer();
        int oldAmount = container.getGoodsCount(type);
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askServer().unloadCargo(goods) && container.getGoodsCount(type) != oldAmount) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    private void autosave_game() {
        Game game = this.freeColClient.getGame();
        if (game == null) {
            return;
        }
        String autosave_text = Messages.message("clientOptions.savegames.autosave.fileprefix");
        String filename = autosave_text + "-" + Messages.message("clientOptions.savegames.autosave.lastturn") + ".fsg";
        String beforeFilename = autosave_text + "-" + Messages.message("clientOptions.savegames.autosave.beforelastturn") + ".fsg";
        File autosaveDir = FreeCol.getAutosaveDirectory();
        File saveGameFile = new File(autosaveDir, filename);
        File beforeSaveFile = new File(autosaveDir, beforeFilename);
        if (saveGameFile.exists()) {
            beforeSaveFile.delete();
            saveGameFile.renameTo(beforeSaveFile);
        }
        this.saveGame(saveGameFile);
        ClientOptions options = this.freeColClient.getClientOptions();
        int savegamePeriod = options.getInteger("model.option.autosavePeriod");
        int turnNumber = game.getTurn().getNumber();
        if (savegamePeriod <= 1 || savegamePeriod != 0 && turnNumber % savegamePeriod == 0) {
            Player player = game.getCurrentPlayer();
            String playerNation = player == null ? "" : Messages.message(player.getNation().getNameKey());
            String gid = Integer.toHexString(game.getUUID().hashCode());
            filename = Messages.message("clientOptions.savegames.autosave.fileprefix") + '-' + gid + "_" + playerNation + "_" + this.getSaveGameString(game.getTurn()) + ".fsg";
            saveGameFile = new File(autosaveDir, filename);
            this.saveGame(saveGameFile);
        }
    }

    private String getSaveGameString(Turn turn) {
        int year = turn.getYear();
        switch (turn.getSeason()) {
            case SPRING: {
                return Integer.toString(year) + "_1_" + Messages.message("spring");
            }
            case AUTUMN: {
                return Integer.toString(year) + "_2_" + Messages.message("autumn");
            }
        }
        return Integer.toString(year);
    }

    public File getLastSaveGameFile() {
        File lastSave = null;
        for (File directory : new File[]{FreeCol.getSaveDirectory(), FreeCol.getAutosaveDirectory()}) {
            for (File savegame : directory.listFiles(FSG_FILTER)) {
                if (lastSave != null && savegame.lastModified() <= lastSave.lastModified()) continue;
                lastSave = savegame;
            }
        }
        return lastSave;
    }

    public void loadGame() {
        File file = this.gui.showLoadDialog(FreeCol.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            this.gui.errorMessage("fileNotFound");
            return;
        }
        if (this.freeColClient.isInGame() && !this.gui.showConfirmDialog("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no")) {
            return;
        }
        this.freeColClient.getConnectController().quitGame(true);
        this.gui.setActiveUnit(null);
        this.gui.removeInGameComponents();
        this.freeColClient.getConnectController().loadGame(file);
    }

    public boolean quickReload() {
        Game game = this.freeColClient.getGame();
        if (game != null) {
            boolean ok;
            String gid = Integer.toHexString(game.getUUID().hashCode());
            String filename = "quicksave-" + gid + ".fsg";
            File file = new File(FreeCol.getAutosaveDirectory(), filename);
            if (file.isFile() && (ok = true)) {
                this.freeColClient.getConnectController().quitGame(true);
                this.gui.removeInGameComponents();
                this.freeColClient.getConnectController().loadGame(file);
                return true;
            }
        }
        return false;
    }

    public boolean saveGame() {
        File file;
        Player player = this.freeColClient.getMyPlayer();
        Game game = this.freeColClient.getGame();
        String gid = Integer.toHexString(game.getUUID().hashCode());
        String fileName = gid + "_" + Messages.message(player.getNationName()) + "_" + this.getSaveGameString(game.getTurn());
        fileName = fileName.replaceAll(" ", "_");
        if (this.freeColClient.canSaveCurrentGame() && (file = this.gui.showSaveDialog(FreeCol.getSaveDirectory(), fileName)) != null) {
            FreeCol.setSaveDirectory(file.getParentFile());
            return this.saveGame(file);
        }
        return false;
    }

    public boolean saveGame(File file) {
        FreeColServer server = this.freeColClient.getFreeColServer();
        boolean result = false;
        this.gui.showStatusPanel(Messages.message("status.savingGame"));
        try {
            server.setActiveUnit(this.gui.getActiveUnit());
            server.saveGame(file, this.freeColClient.getMyPlayer().getName(), this.freeColClient.getClientOptions());
            this.lastSaveGameFile = file;
            this.gui.closeStatusPanel();
            result = true;
        }
        catch (IOException e) {
            this.gui.errorMessage("couldNotSaveGame");
        }
        this.gui.requestFocusInWindow();
        return result;
    }

    public boolean quicksaveGame() {
        Game game = this.freeColClient.getGame();
        if (game != null) {
            String gid = Integer.toHexString(game.getUUID().hashCode());
            String filename = "quicksave-" + gid + ".fsg";
            File file = new File(FreeCol.getAutosaveDirectory(), filename);
            return this.saveGame(file);
        }
        return false;
    }

    private boolean shouldAllowMessage(ModelMessage message) {
        BooleanOption option = this.freeColClient.getClientOptions().getBooleanOption(message);
        return option == null ? true : option.getValue();
    }

    private synchronized void startIgnoringMessage(String key, int turn) {
        logger.finer("Ignoring model message with key " + key);
        this.messagesToIgnore.put(key, new Integer(turn));
    }

    private synchronized void stopIgnoringMessage(String key) {
        logger.finer("Removing model message with key " + key + " from ignored messages.");
        this.messagesToIgnore.remove(key);
    }

    private synchronized Integer getTurnForMessageIgnored(String key) {
        return this.messagesToIgnore.get(key);
    }

    public synchronized void ignoreMessage(ModelMessage message, boolean flag) {
        String otherkey;
        Iterator<String> i$;
        String key = message.getSourceId();
        if (message.getTemplateType() == StringTemplate.TemplateType.TEMPLATE && (i$ = message.getKeys().iterator()).hasNext() && "%goods%".equals(otherkey = i$.next())) {
            key = key + otherkey;
        }
        if (flag) {
            this.startIgnoringMessage(key, this.freeColClient.getGame().getTurn().getNumber());
        } else {
            this.stopIgnoringMessage(key);
        }
    }

    public void displayModelMessages(boolean allMessages) {
        this.displayModelMessages(allMessages, false);
    }

    public void displayModelMessages(boolean allMessages, final boolean endOfTurn) {
        Player player = this.freeColClient.getMyPlayer();
        int thisTurn = this.freeColClient.getGame().getTurn().getNumber();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        for (ModelMessage modelMessage : allMessages ? player.getModelMessages() : player.getNewModelMessages()) {
            if (this.shouldAllowMessage(modelMessage)) {
                if (modelMessage.getMessageType() == ModelMessage.MessageType.WAREHOUSE_CAPACITY) {
                    String key = modelMessage.getSourceId();
                    block1 : switch (modelMessage.getTemplateType()) {
                        case TEMPLATE: {
                            for (String otherkey : modelMessage.getKeys()) {
                                if (!"%goods%".equals(otherkey)) continue;
                                key = key + otherkey;
                                break block1;
                            }
                            break;
                        }
                    }
                    Integer turn = this.getTurnForMessageIgnored(key);
                    if (turn != null && turn == thisTurn - 1) {
                        this.startIgnoringMessage(key, thisTurn);
                        modelMessage.setBeenDisplayed(true);
                        continue;
                    }
                }
                messages.add(modelMessage);
            }
            modelMessage.setBeenDisplayed(true);
        }
        for (Map.Entry entry : this.messagesToIgnore.entrySet()) {
            if ((Integer)entry.getValue() >= thisTurn - 1) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Removing old model message with key " + (String)entry.getKey() + " from ignored messages.");
            }
            this.stopIgnoringMessage((String)entry.getKey());
        }
        if (messages.size() > 0) {
            final ModelMessage[] a = messages.toArray(new ModelMessage[0]);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (endOfTurn) {
                        InGameController.this.gui.showReportTurnPanel(a);
                    } else {
                        InGameController.this.gui.showModelMessages(a);
                    }
                }
            };
            this.freeColClient.getActionManager().update();
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Message display", e);
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.WARNING, "Message display", e);
                }
            }
        }
    }

    public void nextModelMessage() {
        this.displayModelMessages(false);
    }

    public void abandonColony(Colony colony) {
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (colony == null || !player.owns(colony) || colony.getUnitCount() > 0) {
            throw new IllegalStateException("Abandon bogus colony");
        }
        Tile tile = colony.getTile();
        if (this.askServer().abandonColony(colony) && tile.getSettlement() == null) {
            player.invalidateCanSeeTiles();
            this.gui.setActiveUnit(null);
            this.gui.setSelectedTile(tile, false);
        }
    }

    public void assignTeacher(Unit student, Unit teacher) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(this.requireOurTurn() && student != null && player.owns(student) && student.getColony() != null && student.getLocation() instanceof WorkLocation && teacher != null && player.owns(teacher) && student.canBeStudent(teacher) && teacher.getColony() != null && student.getColony() == teacher.getColony() && teacher.getColony().canTrain(teacher))) {
            return;
        }
        this.askServer().assignTeacher(student, teacher);
    }

    public void assignTradeRoute(Unit unit) {
        TradeRoute oldRoute = unit.getTradeRoute();
        TradeRoute route = this.gui.showTradeRouteDialog(oldRoute, unit.getTile());
        if (route == null) {
            return;
        }
        route = unit.getTradeRoute();
        if (oldRoute != route) {
            this.assignTradeRoute(unit, route);
        }
    }

    public void assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (this.askServer().assignTradeRoute(unit, tradeRoute) && (tradeRoute = unit.getTradeRoute()) != null && this.freeColClient.currentPlayerIsMyPlayer()) {
            this.moveToDestination(unit);
        }
    }

    public boolean boardShip(Unit unit, Unit carrier) {
        if (!this.requireOurTurn()) {
            return false;
        }
        if (unit == null) {
            logger.warning("unit == null");
            return false;
        }
        if (carrier == null) {
            logger.warning("Trying to load onto a non-existent carrier.");
            return false;
        }
        if (unit.isNaval()) {
            logger.warning("Trying to load a ship onto another carrier.");
            return false;
        }
        if (unit.isInEurope() != carrier.isInEurope() || unit.getTile() != carrier.getTile()) {
            logger.warning("Unit and carrier are not co-located.");
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().embark(unit, carrier, null) && unit.getLocation() == carrier) {
            this.gui.playSound("sound.event.loadCargo");
            unitWas.fireChanges();
            this.nextActiveUnit();
            return true;
        }
        return false;
    }

    public void buildColony() {
        String name;
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit unit = this.gui.getActiveUnit();
        if (unit == null) {
            return;
        }
        if (!unit.canBuildColony()) {
            this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("buildColony.badUnit").addName("%unit%", unit.getName()));
            return;
        }
        Tile tile = unit.getTile();
        if (tile.getColony() != null) {
            this.askServer().joinColony(unit, tile.getColony());
            return;
        }
        Player.NoClaimReason reason = player.canClaimToFoundSettlementReason(tile);
        if (reason != Player.NoClaimReason.NONE && reason != Player.NoClaimReason.NATIVES) {
            this.gui.showInformationMessage("noClaimReason." + reason.toString().toLowerCase(Locale.US));
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowColonyWarnings") && !this.buildColonyShowWarnings(tile, unit)) {
            return;
        }
        if (tile.getOwner() != null && !player.owns(tile)) {
            if (!this.claimTile(player, tile, null, player.getLandPrice(tile), 0)) {
                return;
            }
            if (!player.canClaimToFoundSettlement(tile)) {
                return;
            }
        }
        if ("".equals(name = player.getSettlementName())) {
            player.installSettlementNames(Messages.getSettlementNames(player), null);
            name = player.getSettlementName();
        }
        if ((name = this.gui.showInputDialog(tile, StringTemplate.key("nameColony.text"), name, "nameColony.yes", "nameColony.no", true)) == null) {
            return;
        }
        if (player.getSettlement(name) != null) {
            this.gui.showInformationMessage((FreeColObject)tile, StringTemplate.template("nameColony.notUnique").addName("%name%", name));
            return;
        }
        if (this.askServer().buildColony(name, unit) && tile.getSettlement() != null) {
            player.invalidateCanSeeTiles();
            this.gui.playSound("sound.event.buildingComplete");
            this.gui.setActiveUnit(null);
            this.gui.setSelectedTile(tile, false);
            for (Unit unitInTile : tile.getUnitList()) {
                this.checkCashInTreasureTrain(unitInTile);
            }
        }
    }

    private boolean buildColonyShowWarnings(Tile tile, Unit unit) {
        boolean landLocked = true;
        boolean ownedByEuropeans = false;
        boolean ownedBySelf = false;
        boolean ownedByIndians = false;
        HashMap<GoodsType, Integer> goodsMap = new HashMap<GoodsType, Integer>();
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            int potential;
            if (goodsType.isFoodType()) {
                potential = 0;
                if (tile.getType().isPrimaryGoodsType(goodsType)) {
                    potential = tile.potential(goodsType, null);
                }
                goodsMap.put(goodsType, new Integer(potential));
                continue;
            }
            if (!goodsType.isBuildingMaterial()) continue;
            while (goodsType.isRefined()) {
                goodsType = goodsType.getRawMaterial();
            }
            potential = 0;
            if (tile.getType().isSecondaryGoodsType(goodsType)) {
                potential = tile.potential(goodsType, null);
            }
            goodsMap.put(goodsType, new Integer(potential));
        }
        block2: for (Tile newTile : tile.getSurroundingTiles(1)) {
            if (!newTile.isLand()) {
                landLocked = false;
            }
            for (Map.Entry entry : goodsMap.entrySet()) {
                entry.setValue((Integer)entry.getValue() + newTile.potential((GoodsType)entry.getKey(), null));
            }
            Player tileOwner = newTile.getOwner();
            if (unit.getOwner() == tileOwner) {
                if (newTile.getOwningSettlement() != null) {
                    ownedBySelf = true;
                    continue;
                }
                for (Tile ownTile : newTile.getSurroundingTiles(1)) {
                    Colony colony = ownTile.getColony();
                    if (colony == null || colony.getOwner() != unit.getOwner()) continue;
                    ownedBySelf = true;
                    continue block2;
                }
                continue;
            }
            if (tileOwner != null && tileOwner.isEuropean()) {
                ownedByEuropeans = true;
                continue;
            }
            if (tileOwner == null) continue;
            ownedByIndians = true;
        }
        int food = 0;
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (!((GoodsType)entry.getKey()).isFoodType()) continue;
            food += ((Integer)entry.getValue()).intValue();
        }
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        if (landLocked) {
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.landLocked", unit, this.getSpecification().getGoodsType("model.goods.fish")));
        }
        if (food < 8) {
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.noFood", unit, this.getSpecification().getPrimaryFoodType()));
        }
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (((GoodsType)entry.getKey()).isFoodType() || (Integer)entry.getValue() >= 4) continue;
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.noBuildingMaterials", unit, (FreeColObject)entry.getKey()).add("%goods%", ((GoodsType)entry.getKey()).getNameKey()));
        }
        if (ownedBySelf) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.ownLand", unit));
        }
        if (ownedByEuropeans) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.EuropeanLand", unit));
        }
        if (ownedByIndians) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.IndianLand", unit));
        }
        if (messages.isEmpty()) {
            return true;
        }
        ModelMessage[] modelMessages = messages.toArray(new ModelMessage[messages.size()]);
        return this.gui.showConfirmDialog(unit.getTile(), modelMessages, "buildColony.yes", "buildColony.no");
    }

    public boolean buyGoods(GoodsType type, int amount, Unit carrier) {
        Market market;
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (type == null) {
            throw new NullPointerException("Goods type must not be null.");
        }
        if (carrier == null) {
            throw new NullPointerException("Carrier must not be null.");
        }
        if (!player.owns(carrier)) {
            throw new IllegalArgumentException("Carrier owned by someone else.");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        if (!player.canTrade(type)) {
            throw new IllegalArgumentException("Goods are boycotted.");
        }
        int toBuy = 100;
        if (carrier.getSpaceLeft() <= 0) {
            int partial = carrier.getGoodsContainer().getGoodsCount(type) % 100;
            if (partial == 0) {
                return false;
            }
            toBuy -= partial;
        }
        if (amount < toBuy) {
            toBuy = amount;
        }
        if (!player.checkGold((market = player.getMarket()).getBidPrice(type, toBuy))) {
            this.gui.errorMessage("notEnoughGold");
            return false;
        }
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        int price = market.getCostToBuy(type);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askServer().buyGoods(carrier, type, toBuy) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            this.gui.playSound("sound.event.loadCargo");
            unitWas.fireChanges();
            for (TransactionListener l : market.getTransactionListener()) {
                l.logPurchase(type, toBuy, price);
            }
            this.gui.updateGoldLabel();
            this.nextModelMessage();
            return true;
        }
        return false;
    }

    public void changeState(Unit unit, Unit.UnitState state) {
        Player enemy;
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        if (!unit.checkSetState(state)) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (state == Unit.UnitState.FORTIFYING && unit.isOffensiveUnit() && !unit.hasAbility("model.ability.piracy") && (tile = unit.getTile()) != null && tile.getOwningSettlement() != null && player != (enemy = tile.getOwningSettlement().getOwner()) && player.getStance(enemy) != Player.Stance.ALLIANCE && !this.confirmHostileAction(unit, tile)) {
            return;
        }
        if (this.askServer().changeState(unit, state)) {
            if (!(this.gui.isShowingSubPanel() || unit.getMovesLeft() != 0 && unit.getState() != Unit.UnitState.SENTRY && unit.getState() != Unit.UnitState.SKIPPED)) {
                this.nextActiveUnit();
            } else {
                this.gui.refresh();
            }
        }
    }

    public void changeWorkImprovementType(Unit unit, TileImprovementType improvementType) {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        if (!unit.checkSetState(Unit.UnitState.IMPROVING) || improvementType.isNatural()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!(player.owns(tile = unit.getTile()) || this.claimTile(player, tile, null, player.getLandPrice(tile), 0) && player.owns(tile))) {
            return;
        }
        if (this.askServer().changeWorkImprovementType(unit, improvementType)) {
            // empty if block
        }
        this.nextActiveUnit();
    }

    public void changeWorkType(Unit unit, GoodsType workType) {
        if (!this.requireOurTurn()) {
            return;
        }
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().changeWorkType(unit, workType)) {
            unitWas.fireChanges();
        }
    }

    public boolean checkCashInTreasureTrain(Unit unit) {
        boolean cash;
        if (!(unit.canCarryTreasure() && unit.canCashInTreasureTrain() && this.requireOurTurn())) {
            return false;
        }
        Tile tile = unit.getTile();
        Europe europe = unit.getOwner().getEurope();
        if (europe == null || unit.isInEurope()) {
            cash = true;
        } else {
            StringTemplate template;
            int fee = unit.getTransportFee();
            if (fee == 0) {
                template = StringTemplate.template("cashInTreasureTrain.free");
            } else {
                int percent = this.getSpecification().getInteger("model.option.treasureTransportFee");
                template = StringTemplate.template("cashInTreasureTrain.pay").addAmount("%fee%", percent);
            }
            cash = this.gui.showConfirmDialog(unit.getTile(), template, "cashInTreasureTrain.yes", "cashInTreasureTrain.no");
        }
        UnitWas unitWas = new UnitWas(unit);
        if (cash && this.askServer().cashInTreasureTrain(unit) && unit.isDisposed()) {
            this.gui.playSound("sound.event.cashInTreasureTrain");
            unitWas.fireChanges();
            this.gui.updateGoldLabel();
            this.nextActiveUnit(tile);
            return true;
        }
        return false;
    }

    public boolean claimLand(Tile tile, Colony colony, int offer) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int price = (colony != null ? player.canClaimForSettlement(tile) : player.canClaimForImprovement(tile)) ? 0 : player.getLandPrice(tile);
        return this.claimTile(player, tile, colony, price, offer);
    }

    public void clearGotoOrders(Unit unit) {
        if (unit != null && unit.getDestination() != null) {
            this.setDestination(unit, null);
        }
    }

    public boolean clearOrders(Unit unit) {
        if (!this.requireOurTurn() || unit == null || !unit.checkSetState(Unit.UnitState.ACTIVE)) {
            return false;
        }
        if (unit.getState() == Unit.UnitState.IMPROVING && !this.gui.showConfirmDialog(unit.getTile(), StringTemplate.template("model.unit.confirmCancelWork").addAmount("%turns%", unit.getWorkTurnsLeft()), "yes", "no")) {
            return false;
        }
        if (unit.getTradeRoute() != null) {
            this.assignTradeRoute(unit, null);
        }
        this.clearGotoOrders(unit);
        return this.askServer().changeState(unit, Unit.UnitState.ACTIVE);
    }

    public void clearSpeciality(Unit unit) {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        UnitType oldType = unit.getType();
        UnitType newType = oldType.getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, unit.getOwner());
        if (newType == null) {
            this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("clearSpeciality.impossible").addStringTemplate("%unit%", Messages.getLabel(unit)));
            return;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.showConfirmDialog(tile, StringTemplate.template("clearSpeciality.areYouSure").addStringTemplate("%oldUnit%", Messages.getLabel(unit)).add("%unit%", newType.getNameKey()), "yes", "no")) {
            return;
        }
        if (!this.askServer().clearSpeciality(unit) || unit.getType() == newType) {
            // empty if block
        }
        this.nextActiveUnit();
    }

    public void declareIndependence() {
        if (!this.requireOurTurn()) {
            return;
        }
        Game game = this.freeColClient.getGame();
        Player player = this.freeColClient.getMyPlayer();
        Event event = this.getSpecification().getEvent("model.event.declareIndependence");
        for (Limit limit : event.getLimits()) {
            if (limit.evaluate(player)) continue;
            this.gui.showInformationMessage(StringTemplate.template(limit.getDescriptionKey()).addAmount("%limit%", limit.getRightHandSide().getValue(game)));
            return;
        }
        if (player.getNewLandName() == null) {
            return;
        }
        List<String> names = this.gui.showConfirmDeclarationDialog();
        if (names == null || names.get(0) == null || names.get(0).length() == 0 || names.get(1) == null || names.get(1).length() == 0) {
            return;
        }
        String nationName = names.get(0);
        String countryName = names.get(1);
        if (this.askServer().declareIndependence(nationName, countryName) && player.getPlayerType() == Player.PlayerType.REBEL) {
            this.gui.showDeclarationDialog();
            this.freeColClient.getActionManager().update();
            this.nextModelMessage();
        }
    }

    public void disbandActiveUnit() {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        Unit unit = this.gui.getActiveUnit();
        if (unit == null) {
            return;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.showConfirmDialog(tile, StringTemplate.key("disbandUnit.text"), "disbandUnit.yes", "disbandUnit.no")) {
            return;
        }
        if (this.askServer().disbandUnit(unit)) {
            this.nextActiveUnit();
        }
    }

    public void endTurn() {
        if (!this.requireOurTurn()) {
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.showEndTurnDialog")) {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
                if (!unit.couldMove()) continue;
                units.add(unit);
            }
            if (units.size() > 0 && !this.gui.showEndTurnDialog(units)) {
                return;
            }
        }
        if (this.moveMode < 2) {
            this.moveMode = 2;
        }
        if (!this.doExecuteGotoOrders()) {
            return;
        }
        this.doEndTurn();
    }

    public void equipUnit(Unit unit, EquipmentType type, int amount) {
        if (!this.requireOurTurn() || amount == 0) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        List<AbstractGoods> requiredGoods = type.getGoodsRequired();
        Colony colony = null;
        if (unit.isInEurope()) {
            for (AbstractGoods goods : requiredGoods) {
                GoodsType goodsType = goods.getType();
                if (player.canTrade(goodsType) || this.payArrears(goodsType)) continue;
                return;
            }
        } else {
            colony = unit.getColony();
            if (colony == null) {
                throw new IllegalStateException("Equip unit not in settlement/Europe");
            }
        }
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().equipUnit(unit, type, amount)) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            this.gui.updateGoldLabel();
        }
    }

    public void executeGotoOrders() {
        this.doExecuteGotoOrders();
    }

    public java.util.Map<String, String> getClientStatistics() {
        return this.freeColClient.getGame().getStatistics();
    }

    public List<HighScore> getHighScores() {
        return this.askServer().getHighScores();
    }

    public NationSummary getNationSummary(Player player) {
        return this.askServer().getNationSummary(player);
    }

    public TradeRoute getNewTradeRoute(Player player) {
        int n = player.getTradeRoutes().size();
        if (this.askServer().getNewTradeRoute() && player.getTradeRoutes().size() == n + 1) {
            return player.getTradeRoutes().get(n);
        }
        return null;
    }

    public List<AbstractUnit> getREFUnits() {
        if (!this.requireOurTurn()) {
            return Collections.emptyList();
        }
        return this.askServer().getREFUnits();
    }

    public java.util.Map<String, String> getServerStatistics() {
        return this.askServer().getStatistics();
    }

    public boolean leaveShip(Unit unit) {
        if (!this.requireOurTurn()) {
            return false;
        }
        if (!(unit.getLocation() instanceof Unit)) {
            logger.warning("Unit " + unit.getId() + " is not on a carrier.");
            return false;
        }
        Unit carrier = (Unit)unit.getLocation();
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().disembark(unit) && unit.getLocation() != carrier) {
            this.checkCashInTreasureTrain(unit);
            unitWas.fireChanges();
            this.nextActiveUnit();
            return true;
        }
        return false;
    }

    public void loadCargo(Goods goods, Unit carrier) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (goods == null) {
            throw new IllegalArgumentException("Null goods.");
        }
        if (goods.getAmount() <= 0) {
            throw new IllegalArgumentException("Empty goods.");
        }
        if (carrier == null) {
            throw new IllegalArgumentException("Null carrier.");
        }
        if (!carrier.isInEurope() && carrier.getColony() == null) {
            throw new IllegalArgumentException("Carrier not at colony or Europe.");
        }
        if (this.loadGoods(goods, carrier)) {
            this.gui.playSound("sound.event.loadCargo");
        }
    }

    public void moveTo(Unit unit, Location destination) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (unit == null || destination == null) {
            throw new IllegalArgumentException("moveTo null argument");
        }
        if (destination instanceof Europe) {
            if (unit.isInEurope()) {
                this.gui.playSound("sound.event.illegalMove");
                return;
            }
        } else if (destination instanceof Map) {
            if (unit.getTile() != null && unit.getTile().getMap() == destination) {
                this.gui.playSound("sound.event.illegalMove");
                return;
            }
        } else if (destination instanceof Settlement && unit.getTile() != null) {
            this.gui.playSound("sound.event.illegalMove");
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.autoloadEmigrants") && unit.isInEurope()) {
            int spaceLeft = unit.getSpaceLeft();
            for (Unit u : unit.getOwner().getEurope().getUnitList()) {
                if (spaceLeft <= 0) break;
                if (u.isNaval() || u.getState() != Unit.UnitState.SENTRY || u.getType().getSpaceTaken() > spaceLeft) continue;
                this.boardShip(u, unit);
                spaceLeft -= u.getType().getSpaceTaken();
            }
        }
        if (this.askServer().moveTo(unit, destination)) {
            this.nextActiveUnit();
        }
    }

    public void moveActiveUnit(Map.Direction direction) {
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && this.requireOurTurn()) {
            this.clearGotoOrders(unit);
            this.move(unit, direction);
        }
    }

    public void move(Unit unit, Map.Direction direction) {
        if (!this.requireOurTurn()) {
            return;
        }
        this.moveDirection(unit, direction, true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InGameController.this.freeColClient.getActionManager().update();
                InGameController.this.gui.updateMenuBar();
            }
        });
    }

    public boolean moveToDestination(Unit unit) {
        Location location;
        Location destination;
        if (!this.requireOurTurn()) {
            return false;
        }
        if (unit.getTradeRoute() != null) {
            return this.followTradeRoute(unit);
        }
        this.gui.setActiveUnit(unit);
        Player player = this.freeColClient.getMyPlayer();
        while (unit.getMovesLeft() > 0 && unit.getState() != Unit.UnitState.SKIPPED && (destination = unit.getDestination()) != null && !(!(destination instanceof Europe) ? destination.getTile() == null || unit.getTile() == destination.getTile() : unit.isInEurope() || unit.isAtSea())) {
            PathNode path;
            PathNode pathNode = path = destination instanceof Europe ? unit.findPathToEurope() : unit.findPath(destination.getTile());
            if (path == null) {
                StringTemplate dest = destination.getLocationNameFor(player);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("selectDestination.failed").addStringTemplate("%destination%", dest));
                break;
            }
            if (this.followPath(unit, path)) continue;
            break;
        }
        if ((location = unit.getDestination()) != null) {
            if (unit.getTile() == null) {
                if (unit.getLocation() == location) {
                    this.clearGotoOrders(unit);
                }
            } else if (unit.getTile() == location.getTile()) {
                this.clearGotoOrders(unit);
                if (!this.checkCashInTreasureTrain(unit) && unit.getMovesLeft() > 0 && unit.getState() != Unit.UnitState.SKIPPED) {
                    this.gui.setActiveUnit(unit);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean moveDirection(Unit unit, Map.Direction direction, boolean interactive) {
        Location destination = unit.getDestination();
        switch (unit.getMoveType(direction)) {
            case MOVE_HIGH_SEAS: {
                if (destination == null) {
                    return this.moveHighSeas(unit, direction);
                }
                if (destination instanceof Europe) {
                    this.moveTo(unit, destination);
                    return false;
                }
            }
            case MOVE: {
                this.moveMove(unit, direction);
                return unit.getMovesLeft() > 0;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                this.moveExplore(unit, direction);
                return false;
            }
            case ATTACK_UNIT: 
            case ATTACK_SETTLEMENT: {
                this.moveAttack(unit, direction);
                return false;
            }
            case EMBARK: {
                this.moveEmbark(unit, direction);
                return false;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: {
                this.moveLearnSkill(unit, direction);
                return false;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                this.moveScoutIndianSettlement(unit, direction);
                return false;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                this.moveUseMissionary(unit, direction);
                return false;
            }
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                this.moveScoutColony(unit, direction);
                return false;
            }
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                this.moveTrade(unit, direction);
                return false;
            }
            case MOVE_NO_ACCESS_BEACHED: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessBeached").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_CONTACT: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessContact").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_GOODS: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessGoods").addStringTemplate("%nation%", nation).addStringTemplate("%unit%", Messages.getLabel(unit)));
                }
                return false;
            }
            case MOVE_NO_ACCESS_LAND: {
                if (!this.moveDisembark(unit, direction) && interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                }
                return false;
            }
            case MOVE_NO_ACCESS_SETTLEMENT: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSettlement").addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_SKILL: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSkill").addStringTemplate("%unit%", Messages.getLabel(unit)));
                }
                return false;
            }
            case MOVE_NO_ACCESS_TRADE: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessTrade").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_WAR: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWar").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_WATER: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWater").addStringTemplate("%unit%", Messages.getLabel(unit)));
                }
                return false;
            }
            case MOVE_NO_ATTACK_MARINE: {
                if (interactive) {
                    this.gui.playSound("sound.event.illegalMove");
                    this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAttackWater").addStringTemplate("%unit%", Messages.getLabel(unit)));
                }
                return false;
            }
            case MOVE_NO_MOVES: {
                unit.setState(Unit.UnitState.SKIPPED);
                return false;
            }
        }
        if (interactive) {
            this.gui.playSound("sound.event.illegalMove");
        }
        return false;
    }

    private void moveAttack(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        IndianSettlement is = target.getIndianSettlement();
        if (is != null && unit.isArmed()) {
            switch (this.gui.showArmedUnitIndianSettlementDialog(is)) {
                case CANCEL: {
                    return;
                }
                case INDIAN_SETTLEMENT_ATTACK: {
                    break;
                }
                case INDIAN_SETTLEMENT_TRIBUTE: {
                    this.moveTribute(unit, direction);
                    return;
                }
                default: {
                    logger.warning("showArmedUnitIndianSettlementDialog failure.");
                    return;
                }
            }
        }
        if (this.confirmHostileAction(unit, target) && this.confirmPreCombat(unit, target)) {
            this.askServer().attack(unit, direction);
            this.nextModelMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDisembark(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile.getFirstUnit() != null && tile.getFirstUnit().getOwner() != unit.getOwner()) {
            return false;
        }
        ArrayList<Unit> disembarkable = new ArrayList<Unit>();
        unit.setStateToAllChildren(Unit.UnitState.ACTIVE);
        for (Unit u : unit.getUnitList()) {
            if (!u.getMoveType(tile).isProgress()) continue;
            disembarkable.add(u);
        }
        if (disembarkable.size() == 0) {
            return false;
        }
        while (disembarkable.size() > 0) {
            Unit u;
            if (disembarkable.size() == 1) {
                if (!this.gui.showConfirmDialog("disembark.text", "yes", "no")) break;
                this.move((Unit)disembarkable.get(0), direction);
                break;
            }
            ArrayList choices = new ArrayList();
            for (Unit dUnit : disembarkable) {
                choices.add(new ChoiceItem<Unit>(Messages.message(Messages.getLabel(dUnit)), dUnit));
            }
            if (disembarkable.size() > 1) {
                choices.add(new ChoiceItem<Unit>(Messages.message("all"), unit));
            }
            if ((u = (Unit)this.gui.showChoiceDialog(unit.getTile(), Messages.message("disembark.text"), Messages.message("disembark.cancel"), choices)) == null) break;
            if (u == unit) {
                for (Unit dUnit : disembarkable) {
                    try {
                        this.moveDirection(dUnit, direction, false);
                    }
                    catch (Throwable throwable) {}
                }
                return true;
            }
            this.moveDirection(u, direction, false);
            disembarkable.remove(u);
        }
        return true;
    }

    private void moveEmbark(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        Tile sourceTile = unit.getTile();
        Tile destinationTile = sourceTile.getNeighbourOrNull(direction);
        Unit carrier = null;
        ArrayList choices = new ArrayList();
        for (Unit u : destinationTile.getUnitList()) {
            if (u.getSpaceLeft() < unit.getType().getSpaceTaken()) continue;
            String m = Messages.message(Messages.getLabel(u));
            choices.add(new ChoiceItem<Unit>(m, u));
            carrier = u;
        }
        if (choices.size() == 0) {
            throw new RuntimeException("Unit " + unit.getId() + " found no carrier to embark upon.");
        }
        if (choices.size() != 1 && (carrier = (Unit)this.gui.showChoiceDialog(unit.getTile(), Messages.message("embark.text"), Messages.message("embark.cancel"), choices)) == null) {
            return;
        }
        if (this.askServer().embark(unit, carrier, direction) && unit.getLocation() == carrier) {
            if (carrier.getMovesLeft() > 0) {
                this.gui.setActiveUnit(carrier);
            } else {
                this.nextActiveUnit();
            }
        }
        this.clearGotoOrders(unit);
    }

    private void moveExplore(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (this.gui.showConfirmDialog(unit.getTile(), StringTemplate.key("exploreLostCityRumour.text"), "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            if (tile.getLostCityRumour().getType() == LostCityRumour.RumourType.MOUNDS && !this.gui.showConfirmDialog(unit.getTile(), StringTemplate.key("exploreMoundsRumour.text"), "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
                this.askServer().declineMounds(unit, direction);
            }
            this.moveMove(unit, direction);
        }
    }

    private boolean moveHighSeas(Unit unit, Map.Direction direction) {
        Tile oldTile = unit.getTile();
        Tile newTile = oldTile.getNeighbourOrNull(direction);
        if ((newTile == null || !oldTile.canMoveToEurope() && newTile.canMoveToEurope()) && this.gui.showConfirmDialog(oldTile, StringTemplate.template("highseas.text").addAmount("%number%", unit.getSailTurns()), "highseas.yes", "highseas.no")) {
            this.moveTo(unit, unit.getOwner().getEurope());
            this.nextActiveUnit();
            return false;
        }
        this.moveMove(unit, direction);
        return true;
    }

    private void moveLearnSkill(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        if (!this.askServer().askSkill(unit, direction)) {
            return;
        }
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        UnitType skill = settlement.getLearnableSkill();
        if (skill == null) {
            this.gui.showInformationMessage((FreeColObject)settlement, "indianSettlement.noMoreSkill");
        } else if (!unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("indianSettlement.cantLearnSkill").addStringTemplate("%unit%", Messages.getLabel(unit)).add("%skill%", skill.getNameKey()));
        } else if (this.gui.showConfirmDialog(unit.getTile(), StringTemplate.template("learnSkill.text").add("%skill%", skill.getNameKey()), "learnSkill.yes", "learnSkill.no") && this.askServer().learnSkill(unit, direction)) {
            if (unit.isDisposed()) {
                this.gui.showInformationMessage((FreeColObject)settlement, "learnSkill.die");
                this.nextActiveUnit(unit.getTile());
                return;
            }
            if (unit.getType() != skill) {
                this.gui.showInformationMessage((FreeColObject)settlement, "learnSkill.leave");
            }
        }
        this.nextActiveUnit();
    }

    private void moveMove(Unit unit, Map.Direction direction) {
        if (unit.canCarryUnits() && unit.getSpaceLeft() > 0 && (unit.getColony() != null || unit.isInEurope())) {
            for (Unit sentry : unit.getLocation().getUnitList()) {
                if (sentry.getState() != Unit.UnitState.SENTRY) continue;
                if (sentry.getSpaceTaken() <= unit.getSpaceLeft()) {
                    this.boardShip(sentry, unit);
                    logger.finest("Unit " + unit.toString() + " loaded sentry " + sentry.toString());
                    continue;
                }
                logger.finest("Unit " + sentry.toString() + " is too big to board " + unit.toString());
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        if (!this.askServer().move(unit, direction)) {
            return;
        }
        unitWas.fireChanges();
        Tile tile = unit.getTile();
        ClientOptions options = this.freeColClient.getClientOptions();
        if (unit.getMovesLeft() <= 0 && options.getBoolean("model.option.unitLastMoveDelay")) {
            this.gui.paintImmediatelyCanvasInItsBounds();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (unit.isDisposed() || this.checkCashInTreasureTrain(unit)) {
            this.nextActiveUnit(tile);
        } else {
            if (tile.getColony() != null && unit.isCarrier() && unit.getTradeRoute() == null && (unit.getDestination() == null || unit.getDestination().getTile() == tile.getTile())) {
                this.gui.showColonyPanel(tile.getColony());
            }
            if (unit.getMovesLeft() == 0) {
                this.nextActiveUnit();
            } else {
                this.displayModelMessages(false);
                if (!this.gui.onScreen(tile)) {
                    this.gui.setSelectedTile(tile, false);
                }
            }
        }
    }

    private void moveScoutColony(Unit unit, Map.Direction direction) {
        Colony colony = (Colony)this.getSettlementAt(unit.getTile(), direction);
        boolean canNeg = colony.getOwner() != unit.getOwner().getREFPlayer();
        this.clearGotoOrders(unit);
        switch (this.gui.showScoutForeignColonyDialog(colony, unit, canNeg)) {
            case CANCEL: {
                break;
            }
            case FOREIGN_COLONY_ATTACK: {
                this.moveAttack(unit, direction);
                break;
            }
            case FOREIGN_COLONY_NEGOTIATE: {
                this.moveTradeColony(unit, direction);
                break;
            }
            case FOREIGN_COLONY_SPY: {
                this.moveSpy(unit, direction);
                break;
            }
            default: {
                throw new IllegalArgumentException("showScoutForeignColonyDialog fail");
            }
        }
    }

    private void moveScoutIndianSettlement(Unit unit, Map.Direction direction) {
        Tile unitTile = unit.getTile();
        Tile tile = unitTile.getNeighbourOrNull(direction);
        IndianSettlement settlement = tile.getIndianSettlement();
        this.clearGotoOrders(unit);
        NationSummary ns = this.getNationSummary(settlement.getOwner());
        String number = ns == null ? "many" : ns.getNumberOfSettlements();
        switch (this.gui.showScoutIndianSettlementDialog(settlement, number)) {
            case CANCEL: {
                return;
            }
            case INDIAN_SETTLEMENT_ATTACK: {
                if (this.confirmPreCombat(unit, tile)) {
                    this.askServer().attack(unit, direction);
                }
                return;
            }
            case INDIAN_SETTLEMENT_SPEAK: {
                Player player = unit.getOwner();
                int oldGold = player.getGold();
                String result = this.askServer().scoutSpeak(unit, direction);
                if (result == null) {
                    return;
                }
                if ("die".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakDie");
                    this.nextActiveUnit(unitTile);
                    return;
                }
                if ("expert".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.expertScout").add("%unit%", unit.getType().getNameKey()));
                } else if ("tales".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakTales");
                } else if ("beads".equals(result)) {
                    this.gui.updateGoldLabel();
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.speakBeads").addAmount("%amount%", player.getGold() - oldGold));
                } else if ("nothing".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.speakNothing").addStringTemplate("%nation%", player.getNationName()));
                } else {
                    logger.warning("Invalid result from askScoutSpeak: " + result);
                }
                this.nextActiveUnit();
                break;
            }
            case INDIAN_SETTLEMENT_TRIBUTE: {
                this.moveTribute(unit, direction);
                break;
            }
            default: {
                throw new IllegalArgumentException("showScoutIndianSettlementDialog fail");
            }
        }
    }

    private void moveSpy(Unit unit, Map.Direction direction) {
        if (this.askServer().spy(unit, direction)) {
            this.nextActiveUnit();
        }
    }

    private void moveTrade(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony) {
            this.moveTradeColony(unit, direction);
        } else if (settlement instanceof IndianSettlement) {
            this.moveTradeIndianSettlement(unit, direction);
        } else {
            logger.warning("Bogus settlement: " + settlement.getId());
        }
    }

    private void moveTradeColony(Unit unit, Map.Direction direction) {
        block11: {
            Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
            if (settlement == null) {
                return;
            }
            Player player = unit.getOwner();
            if (settlement.getOwner() == player.getREFPlayer()) {
                throw new IllegalStateException("Unit tried to negotiate with REF");
            }
            ModelMessage m = null;
            String nation = Messages.message(settlement.getOwner().getNationName());
            DiplomaticTrade ourAgreement = null;
            DiplomaticTrade agreement = null;
            block5: while (true) {
                if ((ourAgreement = this.gui.showNegotiationDialog(unit, settlement, agreement)) == null) {
                    if (agreement == null) break block11;
                    agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                } else {
                    agreement = ourAgreement;
                }
                if (agreement.getStatus() != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) {
                    this.askServer().diplomacy(unit, settlement, agreement);
                    this.gui.updateMenuBar();
                    break block11;
                }
                agreement = this.askServer().diplomacy(unit, settlement, agreement);
                DiplomaticTrade.TradeStatus status = agreement == null ? DiplomaticTrade.TradeStatus.REJECT_TRADE : agreement.getStatus();
                switch (status) {
                    case PROPOSE_TRADE: {
                        continue block5;
                    }
                    case ACCEPT_TRADE: {
                        m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "negotiationDialog.offerAccepted", settlement).addName("%nation%", nation);
                        break block5;
                    }
                    case REJECT_TRADE: {
                        m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "negotiationDialog.offerRejected", settlement).addName("%nation%", nation);
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException("Bogus trade status" + (Object)((Object)status));
                    }
                }
                break;
            }
            player.addModelMessage(m);
        }
        this.nextActiveUnit();
    }

    private void moveTradeIndianSettlement(Unit unit, Map.Direction direction) {
        boolean[] results;
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        boolean done = false;
        block6: while (!done && (results = this.askServer().openTransactionSession(unit, settlement)) != null) {
            boolean gif;
            boolean buy = results[0] && unit.getSpaceLeft() > 0;
            boolean sel = results[1] && unit.getGoodsCount() > 0;
            boolean bl = gif = results[2] && unit.getGoodsCount() > 0;
            if (!buy && !sel && !gif) break;
            switch (this.gui.showIndianSettlementTradeDialog(settlement, buy, sel, gif)) {
                case CANCEL: {
                    done = true;
                    continue block6;
                }
                case BUY: {
                    this.attemptBuyFromSettlement(unit, settlement);
                    continue block6;
                }
                case SELL: {
                    this.attemptSellToSettlement(unit, settlement);
                    continue block6;
                }
                case GIFT: {
                    this.attemptGiftToSettlement(unit, settlement);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("showIndianSettlementTradeDialog fail");
        }
        this.askServer().closeTransactionSession(unit, settlement);
        if (unit.getMovesLeft() > 0) {
            this.gui.setActiveUnit(unit);
        } else {
            this.nextActiveUnit();
        }
    }

    private void showTradeFail(int fail, Settlement settlement, Goods goods) {
        switch (fail) {
            case 0: {
                this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("trade.noTradeGoods").add("%goods%", goods.getNameKey()));
                return;
            }
            case -2: {
                this.gui.showInformationMessage((FreeColObject)settlement, "trade.noTradeHaggle");
                break;
            }
            case -3: {
                this.gui.showInformationMessage((FreeColObject)settlement, "trade.noTradeHostile");
                break;
            }
            default: {
                this.gui.showInformationMessage((FreeColObject)settlement, "trade.noTrade");
            }
        }
    }

    private void attemptBuyFromSettlement(Unit unit, Settlement settlement) {
        Player player = this.freeColClient.getMyPlayer();
        Goods goods = null;
        List<Goods> forSale = this.askServer().getGoodsForSaleInSettlement(unit, settlement);
        if (forSale.isEmpty()) {
            this.gui.showInformationMessage((FreeColObject)settlement, "trade.nothingToSell");
            return;
        }
        goods = this.gui.showSimpleChoiceDialog(unit.getTile(), "buyProposition.text", "buyProposition.nothing", forSale);
        if (goods != null) {
            int gold = -1;
            block5: while (true) {
                if ((gold = this.askServer().buyProposition(unit, settlement, goods, gold)) <= 0) {
                    this.showTradeFail(gold, settlement, goods);
                    return;
                }
                boolean canBuy = player.checkGold(gold);
                switch (this.gui.showBuyDialog(unit, settlement, goods, gold, canBuy)) {
                    case CANCEL: {
                        return;
                    }
                    case BUY: {
                        if (this.askServer().buyFromSettlement(unit, settlement, goods, gold)) {
                            this.gui.updateGoldLabel();
                        }
                        return;
                    }
                    case HAGGLE: {
                        gold = gold * 9 / 10;
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalStateException("showBuyDialog fail");
        }
    }

    private void attemptSellToSettlement(Unit unit, Settlement settlement) {
        Goods goods = null;
        goods = this.gui.showSimpleChoiceDialog(unit.getTile(), "sellProposition.text", "sellProposition.nothing", unit.getGoodsList());
        if (goods != null) {
            int gold = -1;
            block6: while (true) {
                if ((gold = this.askServer().sellProposition(unit, settlement, goods, gold)) <= 0) {
                    this.showTradeFail(gold, settlement, goods);
                    return;
                }
                switch (this.gui.showSellDialog(unit, settlement, goods, gold)) {
                    case CANCEL: {
                        return;
                    }
                    case SELL: {
                        if (this.askServer().sellToSettlement(unit, settlement, goods, gold)) {
                            this.gui.updateGoldLabel();
                        }
                        return;
                    }
                    case HAGGLE: {
                        gold = gold * 11 / 10;
                        continue block6;
                    }
                    case GIFT: {
                        this.askServer().deliverGiftToSettlement(unit, settlement, goods);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("showSellDialog fail");
        }
    }

    private void attemptGiftToSettlement(Unit unit, Settlement settlement) {
        Goods goods = this.gui.showSimpleChoiceDialog(unit.getTile(), "gift.text", "cancel", unit.getGoodsList());
        if (goods != null) {
            this.askServer().deliverGiftToSettlement(unit, settlement, goods);
        }
    }

    private void moveTribute(Unit unit, Map.Direction direction) {
        if (this.askServer().demandTribute(unit, direction)) {
            this.gui.updateGoldLabel();
            this.nextActiveUnit();
        }
    }

    private void moveUseMissionary(Unit unit, Map.Direction direction) {
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        Unit missionary = settlement.getMissionary();
        boolean canEstablish = missionary == null;
        boolean canDenounce = missionary != null && missionary.getOwner() != unit.getOwner();
        this.clearGotoOrders(unit);
        switch (this.gui.showUseMissionaryDialog(unit, settlement, canEstablish, canDenounce)) {
            case CANCEL: {
                return;
            }
            case ESTABLISH_MISSION: {
                if (!this.askServer().missionary(unit, direction, false)) break;
                if (settlement.getMissionary() == unit) {
                    this.gui.playSound("sound.event.missionEstablished");
                }
                this.nextActiveUnit();
                break;
            }
            case DENOUNCE_HERESY: {
                if (!this.askServer().missionary(unit, direction, true)) break;
                if (settlement.getMissionary() == unit) {
                    this.gui.playSound("sound.event.missionEstablished");
                }
                this.nextModelMessage();
                this.nextActiveUnit();
                break;
            }
            case INCITE_INDIANS: {
                ArrayList<Player> enemies = new ArrayList<Player>(this.freeColClient.getGame().getLiveEuropeanPlayers());
                Player player = this.freeColClient.getMyPlayer();
                enemies.remove(player);
                Player enemy = this.gui.showSimpleChoiceDialog(unit.getTile(), "missionarySettlement.inciteQuestion", "missionarySettlement.cancel", enemies);
                if (enemy == null) {
                    return;
                }
                int gold = this.askServer().incite(unit, direction, enemy, -1);
                if (gold < 0) break;
                if (!player.checkGold(gold)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("missionarySettlement.inciteGoldFail").add("%player%", enemy.getName()).addAmount("%amount%", gold));
                    break;
                }
                if (this.gui.showConfirmDialog(unit.getTile(), StringTemplate.template("missionarySettlement.inciteConfirm").add("%player%", enemy.getName()).addAmount("%amount%", gold), "yes", "no") && this.askServer().incite(unit, direction, enemy, gold) >= 0) {
                    this.gui.updateGoldLabel();
                }
                this.nextActiveUnit();
                break;
            }
            default: {
                logger.warning("showUseMissionaryDialog fail");
            }
        }
    }

    public void nextActiveUnit() {
        this.nextActiveUnit(null);
    }

    public void nextActiveUnit(Tile tile) {
        if (!this.requireOurTurn()) {
            return;
        }
        this.nextModelMessage();
        if (this.moveMode >= 1 && !this.doExecuteGotoOrders()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && !unit.isDisposed() && unit.getMovesLeft() > 0 && unit.getState() != Unit.UnitState.SKIPPED) {
            return;
        }
        if (player.hasNextActiveUnit()) {
            this.gui.setActiveUnit(player.getNextActiveUnit());
            return;
        }
        if (!this.doExecuteGotoOrders()) {
            return;
        }
        this.gui.setActiveUnit(null);
        ClientOptions options = this.freeColClient.getClientOptions();
        if (this.moveMode >= 2) {
            this.endTurn();
        } else if (tile != null) {
            this.gui.setSelectedTile(tile, false);
        } else if (options.getBoolean("model.option.autoEndTurn")) {
            this.endTurn();
        }
    }

    public boolean payArrears(GoodsType type) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int arrears = player.getArrears(type);
        if (arrears <= 0) {
            return false;
        }
        if (!player.checkGold(arrears)) {
            this.gui.showInformationMessage(StringTemplate.template("model.europe.cantPayArrears").addAmount("%amount%", arrears));
            return false;
        }
        if (this.gui.showConfirmDialog(null, StringTemplate.template("model.europe.payArrears").addAmount("%amount%", arrears), "ok", "cancel") && this.askServer().payArrears(type) && player.canTrade(type)) {
            this.gui.updateGoldLabel();
            return true;
        }
        return false;
    }

    public void payForBuilding(Colony colony) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (!colony.canPayToFinishBuilding()) {
            this.gui.errorMessage("notEnoughGold");
            return;
        }
        int price = colony.getPriceForBuilding();
        if (!this.gui.showConfirmDialog(null, StringTemplate.template("payForBuilding.text").addAmount("%amount%", price), "payForBuilding.yes", "payForBuilding.no")) {
            return;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        if (this.askServer().payForBuilding(colony) && colony.getPriceForBuilding() == 0) {
            colonyWas.fireChanges();
            this.gui.updateGoldLabel();
        }
    }

    public boolean putOutsideColony(Unit unit) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Colony colony = unit.getColony();
        if (colony == null) {
            throw new IllegalStateException("Unit is not in colony.");
        }
        if (!colony.canReducePopulation()) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().putOutsideColony(unit)) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    public void recruitUnitInEurope(int index) {
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold(player.getRecruitPrice())) {
            this.gui.errorMessage("notEnoughGold");
            return;
        }
        this.emigrate(player, index + 1);
    }

    public void rename(Nameable object) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(object instanceof Ownable) || !player.owns((Ownable)((Object)object))) {
            return;
        }
        String name = null;
        if (object instanceof Colony) {
            Colony colony = (Colony)object;
            name = this.gui.showInputDialog(colony.getTile(), StringTemplate.key("renameColony.text"), colony.getName(), "renameColony.yes", "renameColony.no", true);
            if (name == null) {
                return;
            }
            if (colony.getName().equals(name)) {
                return;
            }
            if (player.getSettlement(name) != null) {
                this.gui.showInformationMessage((FreeColObject)((Colony)object), StringTemplate.template("nameColony.notUnique").addName("%name%", name));
                return;
            }
        } else if (object instanceof Unit) {
            Unit unit = (Unit)object;
            name = this.gui.showInputDialog(unit.getTile(), StringTemplate.key("renameUnit.text"), unit.getName(), "renameUnit.yes", "renameUnit.no", false);
            if (name == null) {
                return;
            }
        } else {
            logger.warning("Tried to rename an unsupported Nameable: " + object.toString());
            return;
        }
        this.askServer().rename((FreeColGameObject)((Object)object), name);
    }

    public void selectDestination(Unit unit) {
        Location destination = this.gui.showSelectDestinationDialog(unit);
        if (destination == null) {
            return;
        }
        if (this.setDestination(unit, destination) && this.freeColClient.currentPlayerIsMyPlayer()) {
            if (destination instanceof Europe) {
                if (unit.getTile() != null && unit.getTile().canMoveToEurope()) {
                    this.moveTo(unit, destination);
                } else {
                    this.moveToDestination(unit);
                }
            } else if (unit.isInEurope()) {
                this.moveTo(unit, destination);
            } else {
                this.moveToDestination(unit);
            }
        }
    }

    public boolean sellGoods(Goods goods) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (goods == null) {
            throw new NullPointerException("Goods must not be null.");
        }
        Unit carrier = null;
        if (goods.getLocation() instanceof Unit) {
            carrier = (Unit)goods.getLocation();
        }
        if (carrier == null) {
            throw new IllegalStateException("Goods not on carrier.");
        }
        if (!carrier.isInEurope()) {
            throw new IllegalStateException("Goods not on carrier in Europe.");
        }
        if (!player.canTrade(goods)) {
            throw new IllegalStateException("Goods are boycotted.");
        }
        Market market = player.getMarket();
        GoodsType type = goods.getType();
        int amount = goods.getAmount();
        int price = market.getPaidForSale(type);
        int tax = player.getTax();
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askServer().sellGoods(goods, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            this.gui.playSound("sound.event.sellCargo");
            unitWas.fireChanges();
            for (TransactionListener l : market.getTransactionListener()) {
                l.logSale(type, amount, price, tax);
            }
            this.gui.updateGoldLabel();
            this.nextModelMessage();
            return true;
        }
        return false;
    }

    public void sendChat(String chat) {
        this.askServer().chat(chat);
    }

    public void setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        if (!this.requireOurTurn()) {
            return;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        if (this.askServer().setBuildQueue(colony, buildQueue)) {
            colonyWas.fireChanges();
        }
    }

    public void setCurrentPlayer(Player player) {
        logger.finest("Entering client setCurrentPlayer: " + player.getName());
        Game game = this.freeColClient.getGame();
        game.setCurrentPlayer(player);
        if (this.freeColClient.getMyPlayer().equals(player) && this.freeColClient.getFreeColServer() != null) {
            if (this.turnsPlayed > 0) {
                this.autosave_game();
            }
            player.invalidateCanSeeTiles();
            while (player.checkEmigrate()) {
                if (player.hasAbility("model.ability.selectRecruit") && player.getEurope().recruitablesDiffer()) {
                    int index = this.gui.showEmigrationPanel(false);
                    this.emigrate(player, index + 1);
                    continue;
                }
                this.emigrate(player, 0);
            }
            if (!this.freeColClient.isSingleplayer()) {
                this.gui.playSound("sound.anthem." + player.getNationID());
            }
            this.displayModelMessages(true, true);
        }
        logger.finest("Exiting client setCurrentPlayer: " + player.getName());
    }

    public boolean setDestination(Unit unit, Location destination) {
        if (unit.getTradeRoute() != null) {
            StringTemplate template = StringTemplate.template("traderoute.reassignRoute").addStringTemplate("%unit%", Messages.getLabel(unit)).addName("%route%", unit.getTradeRoute().getName());
            if (!this.gui.showConfirmDialog(unit.getTile(), template, "yes", "no")) {
                return false;
            }
        }
        return this.askServer().setDestination(unit, destination) && unit.getDestination() == destination;
    }

    public void setGoodsLevels(Colony colony, GoodsType goodsType) {
        this.askServer().setGoodsLevels(colony, colony.getExportData(goodsType));
    }

    public void setTradeRoutes(List<TradeRoute> routes) {
        this.askServer().setTradeRoutes(routes);
    }

    public void skipActiveUnit() {
        this.changeState(this.gui.getActiveUnit(), Unit.UnitState.SKIPPED);
    }

    public void trainUnitInEurope(UnitType unitType) {
        Europe europe;
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold((europe = player.getEurope()).getUnitPrice(unitType))) {
            this.gui.errorMessage("notEnoughGold");
            return;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        if (this.askServer().trainUnitInEurope(unitType)) {
            this.gui.updateGoldLabel();
            europeWas.fireChanges();
        }
    }

    public void unload(Unit unit) {
        block9: {
            List<Goods> goodsList;
            boolean inEurope;
            Player player;
            block8: {
                if (!this.requireOurTurn()) {
                    return;
                }
                if (unit == null) {
                    throw new IllegalArgumentException("Null unit.");
                }
                if (!unit.isCarrier()) {
                    throw new IllegalArgumentException("Unit is not a carrier.");
                }
                player = this.freeColClient.getMyPlayer();
                inEurope = unit.isInEurope();
                if (unit.getColony() == null) break block8;
                for (Unit u : unit.getUnitList()) {
                    this.leaveShip(u);
                }
                for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
                    this.unloadCargo(goods, false);
                }
                break block9;
            }
            if (inEurope) {
                for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
                    if (!player.canTrade(goods)) continue;
                    this.unloadCargo(goods, false);
                }
            }
            if (unit.getGoodsCount() <= 0 || (goodsList = this.gui.showDumpCargoDialog(unit)) == null) break block9;
            for (Goods goods : goodsList) {
                this.unloadCargo(goods, true);
            }
        }
    }

    public void unloadCargo(Goods goods, boolean dump) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (goods == null) {
            throw new IllegalArgumentException("Null goods.");
        }
        if (goods.getAmount() <= 0) {
            throw new IllegalArgumentException("Empty goods.");
        }
        Unit carrier = null;
        if (!(goods.getLocation() instanceof Unit)) {
            throw new IllegalArgumentException("Unload from non-unit.");
        }
        carrier = (Unit)goods.getLocation();
        Colony colony = null;
        if (!carrier.isInEurope()) {
            if (carrier.getTile() == null) {
                throw new IllegalArgumentException("Carrier with null location.");
            }
            colony = carrier.getColony();
            if (!dump && colony == null) {
                throw new IllegalArgumentException("Unload is really a dump.");
            }
        }
        this.unloadGoods(goods, carrier, colony);
    }

    public void updateTradeRoute(TradeRoute route) {
        this.askServer().updateTradeRoute(route);
    }

    public void waitActiveUnit() {
        this.gui.setActiveUnit(null);
        this.nextActiveUnit();
    }

    public void work(Unit unit, WorkLocation workLocation) {
        if (!this.requireOurTurn()) {
            return;
        }
        Colony colony = workLocation.getColony();
        if (workLocation instanceof ColonyTile) {
            Tile tile = ((ColonyTile)workLocation).getWorkTile();
            if (tile.hasLostCityRumour()) {
                this.gui.showInformationMessage("tileHasRumour");
                return;
            }
            if (tile.getOwner() != unit.getOwner() && !this.claimLand(tile, colony, 0)) {
                return;
            }
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().work(unit, workLocation) && unit.getLocation() == workLocation) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
        }
    }
}

